/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.attribute.ANumber;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.IWheelSwitchListener;
import fr.esrf.tangoatk.widget.util.WheelSwitch;
import fr.esrf.tangoatk.widget.util.WheelSwitchEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class NumberScalarWheelEditor
extends WheelSwitch
implements INumberScalarListener,
IWheelSwitchListener,
PropertyChangeListener,
JDrawable {
    static String[] exts = new String[]{"arrowColor", "arrowSelColor"};
    private INumberScalar model = null;

    public NumberScalarWheelEditor() {
        this.addWheelSwitchListener(this);
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public void setModel(INumberScalar iNumberScalar) {
        if (this.model != null) {
            this.model.removeNumberScalarListener((INumberScalarListener)this);
            this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.model = null;
        }
        if (iNumberScalar == null) {
            return;
        }
        if (!iNumberScalar.isWritable()) {
            throw new IllegalArgumentException("NumberScalarWheelEditor: Only accept writeable attribute.");
        }
        this.model = iNumberScalar;
        this.model.addNumberScalarListener((INumberScalarListener)this);
        this.model.getProperty("format").addPresentationListener((PropertyChangeListener)this);
        NumberScalar numberScalar = (NumberScalar)this.model;
        if (!Double.isNaN(numberScalar.getMinimumIncrement())) {
            this.setMinimumIncrement(numberScalar.getMinimumIncrement());
        }
        this.setFormat(this.model.getProperty("format").getPresentation(), this.model.getName());
        ANumber aNumber = null;
        if (this.model instanceof ANumber) {
            aNumber = (ANumber)this.model;
        }
        double d = this.model.getMaxValue();
        if (aNumber != null) {
            d = aNumber.getValueInDisplayUnit(d);
        }
        if (!Double.isNaN(d)) {
            this.setMaxValue(d);
        }
        double d2 = this.model.getMinValue();
        if (aNumber != null) {
            d2 = aNumber.getValueInDisplayUnit(d2);
        }
        if (!Double.isNaN(d2)) {
            this.setMinValue(d2);
        }
        this.model.refresh();
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String string) {
        if (string.equalsIgnoreCase("arrowColor")) {
            return "Sets the arrow button color (r,g,b).";
        }
        if (string.equalsIgnoreCase("arrowSelColor")) {
            return "Sets the color of selected arrow buttons.(r,g,b).";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("arrowColor")) {
            String[] stringArray = string2.split(",");
            if (stringArray.length != 3) {
                this.showJdrawError(bl, "arrowColor", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
                    this.showJdrawError(bl, "arrowColor", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setButtonColor(new Color(n, n2, n3));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showJdrawError(bl, "arrowColor", "Wrong integer syntax.");
                return false;
            }
        }
        if (string.equalsIgnoreCase("arrowSelColor")) {
            String[] stringArray = string2.split(",");
            if (stringArray.length != 3) {
                this.showJdrawError(bl, "arrowSelColor", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n4 = Integer.parseInt(stringArray[1]);
                int n5 = Integer.parseInt(stringArray[2]);
                if (n < 0 || n > 255 || n4 < 0 || n4 > 255 || n5 < 0 || n5 > 255) {
                    this.showJdrawError(bl, "arrowSelColor", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setSelButtonColor(new Color(n, n4, n5));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showJdrawError(bl, "arrowSelColor", "Wrong integer syntax.");
                return false;
            }
        }
        return false;
    }

    @Override
    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("arrowColor")) {
            Color color = this.getButtonColor();
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        if (string.equalsIgnoreCase("arrowSelColor")) {
            Color color = this.getSelButtonColor();
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        return "";
    }

    private void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "NumberScalarWheelEditor: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double d = Double.NaN;
        d = this.hasFocus() ? this.model.getNumberScalarSetPointFromDevice() : this.model.getNumberScalarSetPoint();
        if (this.getValue() != d) {
            this.setValue(d);
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setValue(Double.NaN);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    @Override
    public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
        if (this.model != null) {
            this.model.setValue(wheelSwitchEvent.getValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        if (this.model != null && property.getName().equalsIgnoreCase("format")) {
            this.setFormat(property.getValue().toString(), this.model.getName());
            this.model.refresh();
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        NumberScalarWheelEditor numberScalarWheelEditor = new NumberScalarWheelEditor();
        NumberScalarWheelEditor numberScalarWheelEditor2 = new NumberScalarWheelEditor();
        JFrame jFrame = new JFrame();
        try {
            numberScalarWheelEditor.setFont(new Font("Lucida Bright", 1, 22));
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("sy/rfssa-pinatt/tra0/Attenuation1");
            numberScalarWheelEditor.setModel(iNumberScalar);
            numberScalarWheelEditor2.setModel(iNumberScalar);
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
        }
        catch (ConnectionException connectionException) {
            ErrorPane.showErrorMessage((Component)jFrame, "test/universal/1", (ATKException)connectionException);
        }
        jFrame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        jFrame.getContentPane().add((Component)numberScalarWheelEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        jFrame.getContentPane().add((Component)numberScalarWheelEditor2, gridBagConstraints);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }
}

