/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class DevStateScalarComboEditor
extends JComboBox
implements ActionListener,
IDevStateScalarListener {
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "setAttActionCmd";
    private IDevStateScalar stateModel = null;
    private String[] defOptionList = new String[]{"ON", "OFF", "CLOSE", "OPEN", "INSERT", "EXTRACT", "MOVING", "STANDBY", "FAULT", "INIT", "RUNNING", "ALARM", "DISABLE", "UNKNOWN"};
    private String[] optionList = new String[]{"None"};

    public DevStateScalarComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    public IDevStateScalar getStateModel() {
        return this.stateModel;
    }

    public void setStateModel(IDevStateScalar iDevStateScalar) {
        this.clearModel();
        if (iDevStateScalar == null) {
            return;
        }
        if (!iDevStateScalar.isWritable()) {
            throw new IllegalArgumentException("DevStateScalarComboEditor: Only accept writable attribute.");
        }
        this.stateModel = iDevStateScalar;
        this.optionList = this.defOptionList;
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.changeCurrentSelection(-1);
        this.stateModel.addDevStateScalarListener((IDevStateScalarListener)this);
        this.stateModel.refresh();
    }

    public void clearModel() {
        if (this.stateModel != null) {
            this.stateModel.removeDevStateScalarListener((IDevStateScalarListener)this);
            this.stateModel = null;
            this.optionList = this.defOptionList;
            this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
            this.setModel(this.comboModel);
        }
    }

    public void devStateScalarChange(DevStateScalarEvent devStateScalarEvent) {
        String string = null;
        int n = this.getSelectedIndex();
        string = this.hasFocus() ? this.stateModel.getDeviceSetPoint() : this.stateModel.getSetPoint();
        if (string == null) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("caught exception : " + illegalArgumentException.getMessage());
            }
            return;
        }
        if (this.optionList == null) {
            return;
        }
        for (int i = 0; i < this.optionList.length; ++i) {
            if (!string.equals(this.optionList[i])) continue;
            if (n != i) {
                this.changeCurrentSelection(i);
            }
            return;
        }
        try {
            this.changeCurrentSelection(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("caught exception : " + illegalArgumentException.getMessage());
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.stateModel == null) {
            return;
        }
        int n = this.getSelectedIndex();
        if (n != -1) {
            try {
                this.changeCurrentSelection(-1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("caught exception : " + illegalArgumentException.getMessage());
            }
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = null;
        String string = null;
        if (!actionEvent.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.stateModel == null) {
            return;
        }
        jComboBox = (JComboBox)actionEvent.getSource();
        string = (String)jComboBox.getSelectedItem();
        if (string == null) {
            return;
        }
        this.stateModel.setValue(string);
    }

    private void changeCurrentSelection(int n) {
        this.disableExecution();
        this.setSelectedIndex(n);
        this.repaint();
        this.enableExecution();
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        DevStateScalarComboEditor devStateScalarComboEditor = new DevStateScalarComboEditor();
        JFrame jFrame = null;
        try {
            IDevStateScalar iDevStateScalar;
            IEntity iEntity = attributeList.add("dev/test/10/State_attr_rw");
            if (iEntity instanceof IDevStateScalar) {
                iDevStateScalar = (IDevStateScalar)iEntity;
                System.out.println("Is an IDevStateScalar!");
            } else {
                iDevStateScalar = null;
            }
            if (iDevStateScalar == null) {
                System.exit(-1);
            }
            devStateScalarComboEditor.setStateModel(iDevStateScalar);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        attributeList.startRefresher();
        jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(devStateScalarComboEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

