/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.EventDetails;
import fr.esrf.logviewer.MyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DetailPanel
extends JPanel
implements ListSelectionListener {
    private static final MessageFormat FORMATTER = new MessageFormat("<b>Time:</b> <code>{0}</code>&nbsp;&nbsp;<b>Level:</b> <code>{1}</code>&nbsp;&nbsp;<b>Device:</b> <code>{3}</code>&nbsp;&nbsp;<b>Thread:</b> <code>{2}</code><pre>{4}</pre>");
    private final MyTableModel mModel;
    private final JEditorPane mDetails;

    public DetailPanel(JTable jTable, MyTableModel myTableModel) {
        this.mModel = myTableModel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Log Details"));
        this.mDetails = new JEditorPane();
        this.mDetails.setEditable(false);
        this.mDetails.setContentType("text/html");
        this.add((Component)new JScrollPane(this.mDetails), "Center");
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            this.mDetails.setText("Nothing selected");
        } else {
            int n = listSelectionModel.getMinSelectionIndex();
            EventDetails eventDetails = this.mModel.getEventDetails(n);
            Object[] objectArray = new Object[]{eventDetails.getRenderedTimeStamp(), eventDetails.getLevel(), this.escape(eventDetails.getThreadName()), this.escape(eventDetails.getCategoryName()), this.escape(eventDetails.getMessage())};
            this.mDetails.setText(FORMATTER.format(objectArray));
            this.mDetails.setCaretPosition(0);
        }
    }

    private static String getThrowableStrRep(EventDetails eventDetails) {
        String[] stringArray = eventDetails.getThrowableStrRep();
        if (stringArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    private String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

