/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import atkpanel.MainPanel;
import explorer.ui.DTMenuBar;
import explorer.ui.UIBit;
import fr.esrf.tangoatk.core.IDevice;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JToolBar;

public class RunUI {
    protected static boolean jive = false;
    protected static boolean atkpanel = false;
    public static String JIVE = "jive3.MainPanel";
    public static String ATKPANEL = "atkpanel.MainPanel";

    public RunUI(JToolBar toolbar, DTMenuBar menubar) {
        JMenu menu = new JMenu("Run");
        UIBit jiveBit = new UIBit("Run jive...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunUI.runJive();
            }
        });
        UIBit atkPanelBit = new UIBit("Run atkpanel...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunUI.runAtkPanel();
            }
        });
        jiveBit.setEnabled(jive);
        atkPanelBit.setEnabled(atkpanel);
        menu.setMnemonic('U');
        menu.add(jiveBit.getItem());
        menubar.addMenu(menu);
    }

    public static void runAtkPanel() {
        if (atkpanel) {
            String[] args = new String[]{};
            new MainPanel(args);
        }
    }

    public static void runAtkPanel(IDevice device) {
        if (atkpanel) {
            final String[] args = new String[]{device.getName()};
            new Thread(){

                @Override
                public void run() {
                    new MainPanel(args);
                }
            }.start();
        }
    }

    public static void runJive() {
        if (jive) {
            new jive3.MainPanel();
        }
    }

    public static boolean isJiveAvailable() {
        return jive;
    }

    public static boolean isATKPanelAvailable() {
        return atkpanel;
    }

    protected static void jiveCheck() {
        try {
            Class.forName(JIVE);
            jive = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void atkCheck() {
        try {
            Class.forName(ATKPANEL);
            atkpanel = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        RunUI.jiveCheck();
        RunUI.atkCheck();
    }
}

