/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import explorer.ui.RefreshUI;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import fr.esrf.tangoatk.widget.util.IApplicable;
import fr.esrf.tangoatk.widget.util.IHelpful;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class RefreshDialog
extends JPanel
implements IApplicable,
IHelpful {
    protected JTextField value;
    protected InputVerifier fmt;
    protected JLabel label;
    protected RefreshUI ui;
    protected String helpUrl = "/explorer/html/RefreshDialogHelp.html";

    RefreshDialog(RefreshUI ui) {
        this.ui = ui;
        this.initComponents();
    }

    protected void initComponents() {
        this.value = new JTextField();
        this.value.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                for (int i = 0; i < str.length(); ++i) {
                    if (Character.isDigit(str.charAt(i))) continue;
                    return;
                }
                super.insertString(offs, str, a);
            }
        });
        this.value.setText(Integer.toString(this.ui.getRefreshInterval()));
        this.label = new JLabel("Refresh interval: ");
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(10, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        this.add((Component)this.label, c);
        c.insets = new Insets(10, 0, 0, 10);
        c.gridx = 1;
        this.add((Component)this.value, c);
        HelpWindow.getInstance().addCategory("Dialogs", "Refresh dialog", this.getClass().getResource(this.helpUrl));
    }

    public void ok() {
        this.cancel();
        this.apply();
    }

    public void cancel() {
        this.getRootPane().getParent().setVisible(false);
    }

    public void apply() {
        this.ui.setRefreshInterval(Integer.parseInt(this.value.getText()));
    }

    public URL getHelpUrl() {
        return this.getClass().getResource(this.helpUrl);
    }
}

