/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IRefreshee;
import fr.esrf.tangoatk.core.Refresher;
import java.util.Hashtable;
import java.util.Set;

public class DeviceList
extends Hashtable<IDevice, Integer>
implements IRefreshee {
    protected Refresher refresher = new Refresher();
    protected boolean refresherStarted;

    public DeviceList() {
        this.refresher.stopRunning();
        this.refresher.addRefreshee((IRefreshee)this);
        this.refresher.setRefreshInterval(1000L);
        this.refresherStarted = false;
    }

    public void add(IDevice device) {
        Object associated = this.get(device);
        Integer count = associated == null ? new Integer(1) : new Integer((Integer)associated + 1);
        this.put(device, count);
    }

    @Override
    public Integer remove(Object key) {
        Integer associated = (Integer)this.get(key);
        if (key instanceof IDevice) {
            Integer count;
            Integer n = count = associated == null ? new Integer(0) : new Integer(associated - 1);
            if (count <= 0) {
                super.remove(key);
            } else {
                this.put((IDevice)key, count);
            }
        }
        return associated;
    }

    public void refresh() {
        Set deviceSet = this.keySet();
        for (IDevice device : deviceSet) {
            device.refresh();
        }
    }

    public void setRefreshInterval(long milliseconds) {
        this.refresher.setRefreshInterval(milliseconds);
    }

    public void setSynchronizedPeriod(boolean synchro) {
        this.refresher.setSynchronizedPeriod(synchro);
    }

    public void setTraceUnexpected(boolean trace) {
        this.refresher.setTraceUnexpected(trace);
    }

    public void start() {
        if (!this.isRefresherStarted()) {
            this.refresher.start();
        }
        this.refresherStarted = true;
    }

    public void stop() {
        this.refresher.stopRunning();
        this.refresherStarted = false;
    }

    public boolean isRefresherStarted() {
        return this.refresherStarted;
    }
}

