/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.values;

import org.lsmp.djep.groupJep.GroupJep;
import org.lsmp.djep.groupJep.interfaces.HasDivI;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.nfunk.jep.type.Complex;

public class Polynomial
extends Number {
    private RingI baseRing;
    private String symbol;
    private Number[] coeffs;
    private int degree;

    public Polynomial(RingI ringI, String string, Number[] numberArray) {
        this.baseRing = ringI;
        this.symbol = string;
        int n = 0;
        for (int i = numberArray.length - 1; i > 0; --i) {
            if (ringI.equals(numberArray[i], ringI.getZERO())) continue;
            n = i;
            break;
        }
        if (n == numberArray.length - 1) {
            this.coeffs = numberArray;
        } else {
            this.coeffs = new Number[n + 1];
            System.arraycopy(numberArray, 0, this.coeffs, 0, n + 1);
        }
        this.degree = n;
    }

    protected void setCoeffs(Number[] numberArray) {
        this.coeffs = numberArray;
        this.degree = numberArray.length - 1;
    }

    protected Polynomial valueOf(Number[] numberArray) {
        Polynomial polynomial = new Polynomial(this.baseRing, this.symbol, numberArray);
        return polynomial;
    }

    public Polynomial add(Polynomial polynomial) {
        int n = this.degree > polynomial.degree ? this.degree : polynomial.degree;
        Number[] numberArray = new Number[n + 1];
        for (int i = 0; i <= n; ++i) {
            numberArray[i] = i <= this.degree && i <= polynomial.degree ? (Number)this.baseRing.add(this.coeffs[i], polynomial.coeffs[i]) : (Number)(i <= this.degree ? (Number)this.coeffs[i] : (Number)polynomial.coeffs[i]);
        }
        return this.valueOf(numberArray);
    }

    public Polynomial sub(Polynomial polynomial) {
        int n = this.degree > polynomial.degree ? this.degree : polynomial.degree;
        Number[] numberArray = new Number[n + 1];
        for (int i = 0; i <= n; ++i) {
            numberArray[i] = i <= this.degree && i <= polynomial.degree ? (Number)this.baseRing.sub(this.coeffs[i], polynomial.coeffs[i]) : (Number)(i <= this.degree ? (Number)this.coeffs[i] : (Number)this.baseRing.getInverse(polynomial.coeffs[i]));
        }
        return this.valueOf(numberArray);
    }

    public Polynomial mul(Polynomial polynomial) {
        int n;
        int n2 = this.degree + polynomial.degree;
        Number[] numberArray = new Number[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            numberArray[n] = this.baseRing.getZERO();
        }
        for (n = 0; n <= this.degree; ++n) {
            for (int i = 0; i <= polynomial.degree; ++i) {
                numberArray[n + i] = this.baseRing.add(numberArray[n + i], this.baseRing.mul(this.coeffs[n], polynomial.coeffs[i]));
            }
        }
        return this.valueOf(numberArray);
    }

    public Polynomial div(Polynomial polynomial) {
        if (!polynomial.isConstantPoly()) {
            throw new IllegalArgumentException("Can currently only divide by numbers and not polynomials");
        }
        int n = this.coeffs.length - 1;
        Number[] numberArray = new Number[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            numberArray[i] = ((HasDivI)((Object)this.baseRing)).div(this.coeffs[i], polynomial.getCoeff(0));
        }
        return this.valueOf(numberArray);
    }

    public Polynomial pow(int n) {
        if (n == 0) {
            return this.valueOf(new Number[]{this.baseRing.getONE()});
        }
        if (n == 1) {
            return this.valueOf(this.getCoeffs());
        }
        if (n < 0) {
            throw new IllegalArgumentException("Tried to raise a Polynomial to a negative power");
        }
        Polynomial polynomial = this.valueOf(new Number[]{this.baseRing.getONE()});
        Polynomial polynomial2 = this;
        while (n != 0) {
            if ((n & 1) == 1) {
                polynomial = polynomial.mul(polynomial2);
            }
            if ((n >>= 1) == 0) break;
            polynomial2 = polynomial2.mul(polynomial2);
        }
        return polynomial;
    }

    private boolean needsBrackets(String string) {
        int n = string.indexOf(43);
        int n2 = string.lastIndexOf(45);
        return n != -1 || n2 > 0;
    }

    public String toString() {
        if (this.degree == 0) {
            return this.coeffs[0].toString();
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = this.degree; i >= 0; --i) {
            String string = this.coeffs[i].toString();
            if (string.equals("0") || this.baseRing.equals(this.coeffs[i], this.baseRing.getZERO())) continue;
            if (i != this.degree && !string.startsWith("-")) {
                stringBuffer.append("+");
            }
            if (i == 0) {
                String string2 = this.coeffs[i].toString();
                stringBuffer.append(string2);
                break;
            }
            if (string.equals("-1")) {
                stringBuffer.append("-");
            } else if (!string.equals("1") && !this.baseRing.equals(this.coeffs[i], this.baseRing.getONE())) {
                if (this.needsBrackets(this.coeffs[i].toString())) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.coeffs[i].toString());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(this.coeffs[i].toString());
                }
                stringBuffer.append(" ");
            }
            if (i >= 2) {
                stringBuffer.append(this.symbol + "^" + i);
                continue;
            }
            if (i != 1) continue;
            stringBuffer.append(this.symbol);
        }
        stringBuffer.append("");
        return stringBuffer.toString();
    }

    public int getDegree() {
        return this.degree;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Number[] getCoeffs() {
        return this.coeffs;
    }

    public Number getCoeff(int n) {
        return this.coeffs[n];
    }

    public RingI getBaseRing() {
        return this.baseRing;
    }

    public int intValue() {
        return this.coeffs[0].intValue();
    }

    public long longValue() {
        return this.coeffs[0].longValue();
    }

    public float floatValue() {
        return this.coeffs[0].floatValue();
    }

    public double doubleValue() {
        return this.coeffs[0].doubleValue();
    }

    public boolean isConstantPoly() {
        if (this.coeffs.length > 1) {
            return false;
        }
        return this.baseRing.isConstantPoly(this.coeffs[0]);
    }

    public boolean equals(Polynomial polynomial) {
        if (this.getDegree() != polynomial.getDegree()) {
            return false;
        }
        for (int i = 0; i <= this.getDegree(); ++i) {
            if (this.baseRing.equals(this.getCoeff(i), polynomial.getCoeff(i))) continue;
            return false;
        }
        return true;
    }

    public Complex calculateComplexValue(Complex complex) {
        Number number = this.coeffs[this.getDegree()];
        Complex complex2 = GroupJep.complexValueOf(number);
        for (int i = this.getDegree() - 1; i >= 0; --i) {
            Number number2 = this.coeffs[i];
            Complex complex3 = GroupJep.complexValueOf(number2);
            Complex complex4 = complex2.mul(complex);
            complex2 = complex4.add(complex3);
        }
        return complex2;
    }

    public Number calculateValue(Number number) {
        Number number2 = this.coeffs[this.getDegree()];
        for (int i = this.getDegree() - 1; i >= 0; --i) {
            Number number3 = this.coeffs[i];
            Number number4 = this.baseRing.mul(number2, number);
            number2 = this.baseRing.add(number4, number3);
        }
        return number2;
    }
}

