/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.DVariable;
import org.lsmp.djep.djep.DiffRulesI;
import org.lsmp.djep.djep.PartialDerivative;
import org.lsmp.djep.xjep.DeepCopyVisitor;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.TreeUtils;
import org.lsmp.djep.xjep.XVariable;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DifferentiationVisitor
extends DeepCopyVisitor {
    private static final boolean DEBUG = false;
    private DJep localDJep;
    private DJep globalDJep;
    private NodeFactory nf;
    private TreeUtils tu;
    Hashtable diffRules = new Hashtable();

    public DifferentiationVisitor(DJep dJep) {
        this.globalDJep = dJep;
    }

    void addDiffRule(DiffRulesI diffRulesI) {
        this.diffRules.put(diffRulesI.getName(), diffRulesI);
    }

    DiffRulesI getDiffRule(String string) {
        return (DiffRulesI)this.diffRules.get(string);
    }

    public void printDiffRules() {
        this.printDiffRules(System.out);
    }

    public void printDiffRules(PrintStream printStream) {
        Object object;
        String string;
        printStream.println("Standard Functions and their derivatives");
        Enumeration enumeration = this.globalDJep.getFunctionTable().keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.globalDJep.getFunctionTable().get(string);
            DiffRulesI diffRulesI = (DiffRulesI)this.diffRules.get(string);
            if (diffRulesI == null) {
                printStream.print(string + " No diff rules specified (" + object.getNumberOfParameters() + " arguments).");
            } else {
                printStream.print(((Object)diffRulesI).toString());
            }
            printStream.println();
        }
        enumeration = this.diffRules.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = (DiffRulesI)this.diffRules.get(string);
            if (this.globalDJep.getFunctionTable().containsKey(string)) continue;
            printStream.print(object.toString());
            printStream.println("\tnot in JEP function list");
        }
    }

    public Node differentiate(Node node, String string, DJep dJep) throws ParseException, IllegalArgumentException {
        this.localDJep = dJep;
        this.nf = dJep.getNodeFactory();
        this.tu = dJep.getTreeUtils();
        if (node == null) {
            throw new IllegalArgumentException("node parameter is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("var parameter is null");
        }
        Node node2 = (Node)node.jjtAccept(this, string);
        return node2;
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        String string = aSTFunNode.getName();
        Node[] nodeArray = TreeUtils.getChildrenAsArray(aSTFunNode);
        Node[] nodeArray2 = this.acceptChildrenAsArray(aSTFunNode, object);
        if (aSTFunNode.getPFMC() instanceof DiffRulesI) {
            return ((DiffRulesI)((Object)aSTFunNode.getPFMC())).differentiate(aSTFunNode, (String)object, nodeArray, nodeArray2, this.localDJep);
        }
        DiffRulesI diffRulesI = (DiffRulesI)this.diffRules.get(string);
        if (diffRulesI != null) {
            return diffRulesI.differentiate(aSTFunNode, (String)object, nodeArray, nodeArray2, this.localDJep);
        }
        throw new ParseException("Sorry I don't know how to differentiate " + aSTFunNode + "\n");
    }

    public boolean isConstantVar(XVariable xVariable) {
        if (!xVariable.hasEquation()) {
            return true;
        }
        Node node = xVariable.getEquation();
        return node instanceof ASTConstant;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        Object object2;
        String string = (String)object;
        XVariable xVariable = (XVariable)aSTVarNode.getVar();
        PartialDerivative partialDerivative = null;
        if (xVariable instanceof DVariable) {
            object2 = (DVariable)xVariable;
            if (string.equals(xVariable.getName())) {
                return this.nf.buildConstantNode(this.tu.getONE());
            }
            if (this.isConstantVar(xVariable)) {
                return this.nf.buildConstantNode(this.tu.getZERO());
            }
            partialDerivative = ((DVariable)object2).findDerivative(string, this.localDJep);
        } else if (xVariable instanceof PartialDerivative) {
            if (this.isConstantVar(xVariable)) {
                return this.nf.buildConstantNode(this.tu.getZERO());
            }
            object2 = (PartialDerivative)xVariable;
            DVariable dVariable = ((PartialDerivative)object2).getRoot();
            partialDerivative = dVariable.findDerivative((PartialDerivative)object2, string, this.localDJep);
        } else {
            throw new ParseException("Encountered non differentiable variable");
        }
        object2 = partialDerivative.getEquation();
        if (object2 instanceof ASTVarNode) {
            return this.nf.buildVariableNode(((ASTVarNode)object2).getVar());
        }
        if (object2 instanceof ASTConstant) {
            return this.nf.buildConstantNode(((ASTConstant)object2).getValue());
        }
        return this.nf.buildVariableNode(partialDerivative);
    }

    public Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        return this.nf.buildConstantNode(this.tu.getZERO());
    }
}

