/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.text.TextWindow;
import ij.util.Tools;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;

public class MacroRunner
implements Runnable {
    private String macro;
    private Program pgm;
    private int address;
    private String name;
    private Thread thread;
    private String argument;

    public MacroRunner() {
    }

    public MacroRunner(String macro) {
        this.macro = macro;
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(String macro, String argument) {
        this.macro = macro;
        this.argument = argument;
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(File file) {
        int size = (int)file.length();
        if (size <= 0) {
            return;
        }
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            this.macro = new String(sb);
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return;
        }
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(Program pgm, int address, String name) {
        this(pgm, address, name, null);
    }

    public MacroRunner(Program pgm, int address, String name, String argument) {
        this.pgm = pgm;
        this.address = address;
        this.name = name;
        this.argument = argument;
        this.thread = new Thread((Runnable)this, name + "_Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void runShortcut(Program pgm, int address, String name) {
        this.pgm = pgm;
        this.address = address;
        this.name = name;
        if (pgm.queueCommands) {
            this.run();
        } else {
            this.thread = new Thread((Runnable)this, name + "_Macro$");
            this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
            this.thread.start();
        }
    }

    public void run() {
        block7: {
            try {
                Interpreter interp = new Interpreter();
                interp.argument = this.argument;
                if (this.pgm == null) {
                    interp.run(this.macro);
                } else {
                    interp.runMacro(this.pgm, this.address, this.name);
                }
            }
            catch (Throwable e) {
                Interpreter.abort();
                IJ.showStatus("");
                IJ.showProgress(1.0);
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null) {
                    imp.unlock();
                }
                String msg = e.getMessage();
                if (e instanceof RuntimeException && msg != null && e.getMessage().equals("Macro canceled")) {
                    return;
                }
                CharArrayWriter caw = new CharArrayWriter();
                PrintWriter pw = new PrintWriter(caw);
                e.printStackTrace(pw);
                String s = caw.toString();
                if (IJ.isMacintosh()) {
                    s = Tools.fixNewLines(s);
                }
                if (s.indexOf("NullPointerException") >= 0 && s.indexOf("ij.process") >= 0) break block7;
                new TextWindow("Exception", s, 350, 250);
            }
        }
    }
}

