/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.util;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.core.util.NonAttrNumberSpectrum;

public class TimeAndValueDualSpectrum
extends NonAttrNumberSpectrum
implements IRefresherListener {
    protected AttributeList list = new AttributePolledList();
    protected INumberSpectrum timeModel;
    protected INumberSpectrum yModel;

    public TimeAndValueDualSpectrum() {
        this.list.addRefresherListener(this);
    }

    @Override
    public void refreshStep() {
        double[] dArray = new double[]{};
        double[] dArray2 = new double[]{};
        if (this.timeModel != null && this.yModel != null) {
            try {
                dArray = this.timeModel.getSpectrumValue();
            }
            catch (Exception exception) {
                dArray = new double[]{};
            }
            try {
                dArray2 = this.yModel.getSpectrumValue();
            }
            catch (Exception exception) {
                dArray2 = new double[]{};
            }
            this.setXYValue(dArray, dArray2);
        }
    }

    public AttributeList getList() {
        return this.list;
    }

    public void setList(AttributeList attributeList) {
        if (this.list != null && this.timeModel != null) {
            this.list.remove(this.timeModel.getName());
        }
        if (this.list != null && this.yModel != null) {
            this.list.remove(this.yModel.getName());
        }
        this.list = attributeList;
        if (attributeList != null && this.timeModel != null) {
            attributeList.add(this.timeModel);
        }
        if (attributeList != null && this.timeModel != null) {
            attributeList.add(this.yModel);
        }
        attributeList.addRefresherListener(this);
    }

    public INumberSpectrum getTimeModel() {
        return this.timeModel;
    }

    public void setTimeModel(INumberSpectrum iNumberSpectrum) {
        if (this.list != null && this.timeModel != null) {
            this.list.remove(this.timeModel.getName());
        }
        this.timeModel = iNumberSpectrum;
        if (this.list != null && this.timeModel != null) {
            this.list.add(this.timeModel);
        }
    }

    public INumberSpectrum getYModel() {
        return this.yModel;
    }

    public void setYModel(INumberSpectrum iNumberSpectrum) {
        if (this.list != null && this.yModel != null) {
            this.list.remove(this.yModel.getName());
        }
        this.yModel = iNumberSpectrum;
        if (this.list != null && this.yModel != null) {
            this.list.add(this.yModel);
        }
    }

    public static void main(String[] stringArray) throws ConnectionException {
    }
}

