/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.DevStateSpectrumHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

public class DevStateSpectrum
extends AAttribute
implements IDevStateSpectrum {
    DevStateSpectrumHelper dsSpectrumHelper = new DevStateSpectrumHelper(this);
    String[] dsSpectrumValue = null;
    String[] dsSpectrumSetPointValue = null;
    String[] stateLabels = null;
    boolean[] invertOpenClose = null;
    boolean[] invertInsertExtract = null;

    @Override
    public int getXDimension() {
        return 1;
    }

    @Override
    public int getMaxXDimension() {
        return 1;
    }

    @Override
    public String[] getValue() {
        return this.dsSpectrumValue;
    }

    @Override
    public String[] getSetPoint() {
        return this.dsSpectrumSetPointValue;
    }

    @Override
    public String[] getDeviceValue() {
        try {
            DeviceAttribute deviceAttribute = this.readValueFromNetwork();
            this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(deviceAttribute);
            this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(deviceAttribute);
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
        }
        catch (Exception exception) {
            System.out.println("DevStateSpectrum.getDeviceValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateSpectrum.getDeviceValue()------------------------------------------------");
        }
        return this.dsSpectrumValue;
    }

    @Override
    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        ++this.refreshCount;
        this.trace(4, "DevStateSpectrum.refresh() method called for " + this.getName(), l);
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                this.trace(4, "DevStateSpectrum.refresh(" + this.getName() + ") readValueFromNetwork success", l);
                if (deviceAttribute == null) {
                    return;
                }
                this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(deviceAttribute);
                this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(deviceAttribute);
                this.fireValueChanged(this.dsSpectrumValue);
                this.trace(4, "DevStateSpectrum.refresh(" + this.getName() + ") fireValueChanged(devStateValue) success", l);
            }
            catch (DevFailed devFailed) {
                this.trace(4, "DevStateSpectrum.refresh(" + this.getName() + ") failed, caught DevFailed; will call readAttError", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.trace(4, "DevStateSpectrum.refresh(" + this.getName() + ") Code failure, caught other Exception", l);
            System.out.println("DevStateSpectrum.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateSpectrum.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute deviceAttribute) {
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(deviceAttribute);
                this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(deviceAttribute);
                this.fireValueChanged(this.dsSpectrumValue);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            System.out.println("DevStateSpectrum.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateSpectrum.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed devFailed) {
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String[] stringArray) {
        this.dsSpectrumHelper.fireDevStateSpectrumValueChanged(stringArray, this.timeStamp);
    }

    @Override
    public void addDevStateSpectrumListener(IDevStateSpectrumListener iDevStateSpectrumListener) {
        this.dsSpectrumHelper.addDevStateSpectrumListener(iDevStateSpectrumListener);
        this.addStateListener(iDevStateSpectrumListener);
    }

    @Override
    public void removeDevStateSpectrumListener(IDevStateSpectrumListener iDevStateSpectrumListener) {
        this.dsSpectrumHelper.removeDevStateSpectrumListener(iDevStateSpectrumListener);
        this.removeStateListener(iDevStateSpectrumListener);
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        this.eventType = tangoPeriodicEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "DevStateSpectrum.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "DevStateSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("DevStateSpectrum.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.trace(128, "DevStateSpectrum.periodic(" + this.getName() + ") setState(da) called", l);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(deviceAttribute);
                this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(deviceAttribute);
                this.fireValueChanged(this.dsSpectrumValue);
                this.trace(128, "DevStateSpectrum.periodic(" + this.getName() + ") fireValueChanged(devStateValue) called", l);
            }
            catch (DevFailed devFailed) {
                this.trace(128, "DevStateSpectrum.periodic(" + this.getName() + ") failed, got DevFailed when called fireValueChanged(devStateValue)", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.trace(128, "DevStateSpectrum.periodic(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", l);
                System.out.println("DevStateSpectrum.periodic: Device.toString(extractState()) Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("DevStateSpectrum.periodic: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        this.eventType = tangoChangeEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "DevStateSpectrum.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "DevStateSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("DevStateSpectrum.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("DevStateSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.trace(32, "DevStateSpectrum.change(" + this.getName() + ") setState(da) called", l);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.dsSpectrumValue = this.dsSpectrumHelper.getStateSpectrumValue(deviceAttribute);
                this.dsSpectrumSetPointValue = this.dsSpectrumHelper.getStateSpectrumSetPoint(deviceAttribute);
                this.fireValueChanged(this.dsSpectrumValue);
                this.trace(32, "DevStateSpectrum.change(" + this.getName() + ") fireValueChanged(devStateValue) called", l);
            }
            catch (DevFailed devFailed) {
                this.trace(32, "DevStateSpectrum.change(" + this.getName() + ") failed, got DevFailed when called fireValueChanged(devStateValue)", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.trace(32, "DevStateSpectrum.change(" + this.getName() + ") failed, got other Exception when called fireValueChanged(devStateValue)", l);
                System.out.println("DevStateSpectrum.change: Device.toString(extractState()) Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("DevStateSpectrum.change: Device.toString(extractState())------------------------------------------------");
            }
        }
    }

    @Override
    public void setValue(String[] stringArray) throws AttributeSetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getStateLabels() {
        return this.stateLabels;
    }

    @Override
    public boolean getInvertedOpenCloseForElement(int n) {
        if (this.invertOpenClose == null) {
            return false;
        }
        if (n < 0 || n >= this.invertOpenClose.length) {
            return false;
        }
        return this.invertOpenClose[n];
    }

    @Override
    public boolean getInvertedInsertExtractForElement(int n) {
        if (this.invertInsertExtract == null) {
            return false;
        }
        if (n < 0 || n >= this.invertInsertExtract.length) {
            return false;
        }
        return this.invertInsertExtract[n];
    }

    void setInvertedOpenClose(String[] stringArray) {
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.parseElemLogic(string, hashMap);
        }
        Set set = hashMap.keySet();
        if (set == null) {
            return;
        }
        if (set.isEmpty()) {
            return;
        }
        TreeSet treeSet = new TreeSet(set);
        Integer n = (Integer)treeSet.last();
        int n2 = n + 1;
        this.invertOpenClose = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            this.invertOpenClose[i] = false;
        }
        for (Integer n3 : set) {
            int n4 = n3;
            if (n4 <= 0 || n4 >= this.invertOpenClose.length) continue;
            this.invertOpenClose[n4] = hashMap.get(n3);
        }
    }

    void setInvertedInsertExtract(String[] stringArray) {
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.parseElemLogic(string, hashMap);
        }
        Set set = hashMap.keySet();
        if (set == null) {
            return;
        }
        if (set.isEmpty()) {
            return;
        }
        TreeSet treeSet = new TreeSet(set);
        Integer n = (Integer)treeSet.last();
        int n2 = n + 1;
        this.invertInsertExtract = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            this.invertInsertExtract[i] = false;
        }
        for (Integer n3 : set) {
            int n4 = n3;
            if (n4 <= 0 || n4 >= this.invertInsertExtract.length) continue;
            this.invertInsertExtract[n4] = hashMap.get(n3);
        }
    }

    private void parseElemLogic(String string, HashMap<Integer, Boolean> hashMap) {
        int n = -1;
        String string2 = null;
        String string3 = null;
        Integer n2 = null;
        Boolean bl = null;
        if (string == null) {
            return;
        }
        if (string.length() < 3) {
            return;
        }
        n = string.indexOf(":");
        if (n < 1) {
            return;
        }
        if (n >= string.length() - 1) {
            return;
        }
        try {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
        try {
            n2 = Integer.valueOf(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        bl = Boolean.valueOf(string3.trim());
        if (hashMap.containsKey(n2)) {
            hashMap.remove(n2);
        }
        hashMap.put(n2, bl);
    }

    @Override
    public void loadAttProperties() {
        DbAttribute dbAttribute = null;
        DbDatum dbDatum = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        try {
            this.attPropertiesLoaded = true;
            dbAttribute = this.getDevice().get_attribute_property(this.getNameSansDevice());
            if (dbAttribute == null) {
                return;
            }
            if (!dbAttribute.is_empty("StateLabels")) {
                dbDatum = dbAttribute.datum("StateLabels");
                if (dbDatum != null && !dbDatum.is_empty()) {
                    stringArray3 = dbDatum.extractStringArray();
                }
                if (stringArray3 != null && stringArray3.length > 0) {
                    this.stateLabels = stringArray3;
                }
            }
            if (!dbAttribute.is_empty("OpenCloseInverted")) {
                dbDatum = dbAttribute.datum("OpenCloseInverted");
                if (dbDatum != null && !dbDatum.is_empty()) {
                    stringArray = dbDatum.extractStringArray();
                }
                if (stringArray != null && stringArray.length > 0) {
                    this.setInvertedOpenClose(stringArray);
                }
            }
            if (!dbAttribute.is_empty("InsertExtractInverted")) {
                dbDatum = dbAttribute.datum("InsertExtractInverted");
                if (dbDatum != null && !dbDatum.is_empty()) {
                    stringArray2 = dbDatum.extractStringArray();
                }
                if (stringArray2 != null && stringArray2.length > 0) {
                    this.setInvertedInsertExtract(stringArray2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("get_attribute_property(" + this.getName() + ") thrown exception");
            exception.printStackTrace();
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    @Override
    public String getVersion() {
        return "$Id: DevStateSpectrum.java 28694 2015-11-09 16:19:57Z poncet $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

