/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.PingHosts;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class UnAvailableHostsDialog
extends JDialog {
    private JFrame parent;
    private List<StoppedHost> stoppedHosts;
    private String[] lastCollections;
    private JPanel centerPanel;
    private JButton criticalBtn;
    private JButton notCriticalBtn;
    private JLabel titleLabel;

    public UnAvailableHostsDialog(JFrame jFrame) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initComponents();
        this.notCriticalBtn.setBackground(Color.orange);
        this.criticalBtn.setBackground(Color.red);
        this.criticalBtn.setForeground(Color.white);
        AstorUtil.startSplash("Pinging crates.....");
        AstorUtil.increaseSplashProgress(0.3, "Get host list from database");
        String[] stringArray = AstorUtil.getInstance().getHostControlledList();
        this.lastCollections = AstorUtil.getInstance().getLastCollectionList();
        AstorUtil.increaseSplashProgress(0.6, "Checking " + stringArray.length + " hosts");
        PingHosts pingHosts = new PingHosts(stringArray);
        AstorUtil.increaseSplashProgress(0.8, "Building stopped host list");
        this.stoppedHosts = this.buildStoppedHosts(pingHosts.getStoppedList());
        int n = 0;
        int n2 = 0;
        int n3 = (int)Math.sqrt(this.stoppedHosts.size());
        for (StoppedHost stoppedHost : this.stoppedHosts) {
            JButton jButton = new JButton(stoppedHost.name);
            if (stoppedHost.inLastCollections) {
                jButton.setBackground(Color.orange);
                jButton.setForeground(Color.black);
            } else {
                jButton.setBackground(Color.red);
                jButton.setForeground(Color.white);
            }
            jButton.setToolTipText(stoppedHost.collection);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UnAvailableHostsDialog.this.hostBtnActionPerformed(actionEvent);
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.centerPanel.add((Component)jButton, gridBagConstraints);
            if (n != n3) continue;
            n = 0;
        }
        this.titleLabel.setText(this.stoppedHosts.size() + " Unreachable Hosts");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        AstorUtil.stopSplash();
    }

    private List<StoppedHost> buildStoppedHosts(List<String> list) {
        ArrayList<StoppedHost> arrayList = new ArrayList<StoppedHost>();
        for (String string : list) {
            arrayList.add(new StoppedHost(string));
        }
        return arrayList;
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.criticalBtn = new JButton();
        JLabel jLabel = new JLabel();
        this.titleLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.notCriticalBtn = new JButton();
        JSeparator jSeparator = new JSeparator();
        JLabel jLabel3 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                UnAvailableHostsDialog.this.closeDialog(windowEvent);
            }
        });
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        jPanel.setLayout(new FlowLayout(1, 50, 5));
        jButton.setText("Update List");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnAvailableHostsDialog.this.updateBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Unexport All ");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnAvailableHostsDialog.this.unExportAllBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        jButton3.setText("Cancel");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnAvailableHostsDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton3);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel2.setLayout(new BorderLayout());
        this.criticalBtn.setFont(new Font("Tahoma", 0, 10));
        this.criticalBtn.setText("   Critical   ");
        jPanel3.add(this.criticalBtn);
        jLabel.setText("           ");
        jPanel3.add(jLabel);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Unreachable Hosts");
        jPanel3.add(this.titleLabel);
        jLabel2.setText("           ");
        jPanel3.add(jLabel2);
        this.notCriticalBtn.setFont(new Font("Tahoma", 0, 10));
        this.notCriticalBtn.setText(" Not Critical ");
        jPanel3.add(this.notCriticalBtn);
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jSeparator, "Center");
        jLabel3.setFont(new Font("Tahoma", 0, 18));
        jLabel3.setText("           ");
        jPanel2.add((Component)jLabel3, "Last");
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void hostBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        try {
            this.setCursor(new Cursor(3));
            OneHost oneHost = new OneHost(string);
            new PopupText(this, oneHost).setVisible(true);
            this.setCursor(new Cursor(0));
        }
        catch (DevFailed devFailed) {
            this.setCursor(new Cursor(0));
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void unExportAllBtnActionPerformed(ActionEvent actionEvent) {
        if (this.stoppedHosts.size() > 0 && JOptionPane.showConfirmDialog(this.parent, "Unexport all devices registered on " + this.stoppedHosts.size() + " hosts ?", "Confirm Dialog", 0) == 0) {
            AstorUtil.startSplash("Un export");
            int n = 100 / this.stoppedHosts.size();
            for (StoppedHost stoppedHost : this.stoppedHosts) {
                AstorUtil.increaseSplashProgress(n, "un export devices for " + stoppedHost.name);
                try {
                    this.setCursor(new Cursor(3));
                    OneHost oneHost = new OneHost(stoppedHost.name);
                    oneHost.unExportDevices();
                    this.setCursor(new Cursor(0));
                }
                catch (DevFailed devFailed) {
                    AstorUtil.stopSplash();
                    this.setCursor(new Cursor(0));
                    ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
                }
            }
            AstorUtil.stopSplash();
        }
    }

    private void updateBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
        try {
            new UnAvailableHostsDialog(this.parent).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            this.doClose();
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.parent == null) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        try {
            new UnAvailableHostsDialog(null).setVisible(true);
        }
        catch (DevFailed devFailed) {
            AstorUtil.stopSplash();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)devFailed);
        }
    }

    public class PopupText
    extends JDialog {
        private OneHost host;
        private JScrollPane jScrollPane1;
        private JTextArea textArea;

        public PopupText(JDialog jDialog, OneHost oneHost) {
            super((Dialog)jDialog, true);
            this.host = oneHost;
            this.initComponents();
            this.textArea.setText(oneHost.toString());
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        private void initComponents() {
            this.jScrollPane1 = new JScrollPane();
            this.textArea = new JTextArea();
            this.textArea.setFont(new Font("monospaced", 1, 12));
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    PopupText.this.closeDialog(windowEvent);
                }
            });
            JButton jButton = new JButton("UnExport devices");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PopupText.this.unexportButtonActionPerformed(actionEvent);
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PopupText.this.cancelButtonActionPerformed(actionEvent);
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(2, 5, 5));
            jPanel.add(jButton);
            jPanel.add(jButton2);
            this.getContentPane().add((Component)jPanel, "South");
            this.jScrollPane1.setViewportView(this.textArea);
            this.getContentPane().add((Component)this.jScrollPane1, "Center");
        }

        @Override
        public void setFont(Font font) {
            this.textArea.setFont(font);
        }

        private void unexportButtonActionPerformed(ActionEvent actionEvent) {
            System.out.println("UnExport devices for " + this.host.name);
            try {
                this.setCursor(new Cursor(3));
                this.host.unExportDevices();
                this.setCursor(new Cursor(0));
            }
            catch (DevFailed devFailed) {
                this.setCursor(new Cursor(0));
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
            this.doClose();
        }

        private void cancelButtonActionPerformed(ActionEvent actionEvent) {
            this.doClose();
        }

        private void closeDialog(WindowEvent windowEvent) {
            this.doClose();
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }
    }

    private class OneServer
    extends ArrayList<DeviceProxy> {
        private String name;

        private OneServer(String string) throws DevFailed {
            this.name = string;
            DbServer dbServer = new DbServer(string);
            String[] stringArray = dbServer.get_device_class_list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i % 2 != 0) continue;
                this.add(new DeviceProxy(stringArray[i]));
            }
        }

        private void unExportDeices() throws DevFailed {
            for (DeviceProxy deviceProxy : this) {
                deviceProxy.unexport_device();
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.name + ":\n");
            for (DeviceProxy deviceProxy : this) {
                stringBuilder.append("\t").append(deviceProxy.name()).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    private class OneHost
    extends ArrayList<OneServer> {
        private String name;

        private OneHost(String string) throws DevFailed {
            this.name = string;
            DeviceProxy deviceProxy = new DeviceProxy(ApiUtil.get_db_obj().get_name());
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = deviceProxy.command_inout("DbGetHostServersInfo", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i % 3 != 0) continue;
                this.add(new OneServer(stringArray[i]));
            }
        }

        private void unExportDevices() throws DevFailed {
            for (OneServer oneServer : this) {
                oneServer.unExportDeices();
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.name + ":\n");
            for (OneServer oneServer : this) {
                stringBuilder.append(oneServer).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    private class StoppedHost {
        String name;
        String collection = "Not Defined";
        boolean inLastCollections = true;

        private StoppedHost(String string) {
            this.name = string;
            try {
                DbDatum dbDatum = new DeviceProxy(AstorUtil.getStarterDeviceHeader() + string).get_property("HostCollection");
                if (!dbDatum.is_empty()) {
                    this.collection = dbDatum.extractString();
                    boolean bl = false;
                    for (String string2 : UnAvailableHostsDialog.this.lastCollections) {
                        if (!string2.equals(this.collection)) continue;
                        bl = true;
                    }
                    this.inLastCollections = bl;
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }
}

