/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.BlackBoxTable;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class TopDialog
extends JDialog {
    private BlackBoxTable.BlackBox blackBox;
    private List<JTextArea> textAreaList;
    private String deviceName;
    private JTextArea hostTxt;
    private JTextArea nameTxt;
    private JTextArea operationTxt;
    private JTextArea processTxt;
    private JTextArea sourceTxt;
    private JTabbedPane tabbedPane;
    private JLabel titleLabel;

    public TopDialog(JDialog jDialog, String string, BlackBoxTable.BlackBox blackBox) {
        super((Dialog)jDialog, false);
        this.blackBox = blackBox;
        this.deviceName = string;
        this.initComponents();
        this.textAreaList = new ArrayList<JTextArea>();
        this.textAreaList.add(null);
        this.textAreaList.add(this.operationTxt);
        this.textAreaList.add(this.nameTxt);
        this.textAreaList.add(this.sourceTxt);
        this.textAreaList.add(this.hostTxt);
        this.textAreaList.add(this.processTxt);
        for (int i = 1; i <= 5; ++i) {
            this.textAreaList.get(i).getParent().setPreferredSize(new Dimension(500, 350));
            this.textAreaList.get(i).setFont(new Font("dialog", 1, 12));
        }
        this.tabbedPane.setSelectedIndex(4);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    void displayTop() {
        if (this.blackBox == null) {
            return;
        }
        for (int i = 1; i <= 5; ++i) {
            this.textAreaList.get(i).setText(this.computeTop(i).toString());
        }
        this.titleLabel.setText("Top on  " + this.deviceName + " during " + this.blackBox.getDeltaTimeStr());
    }

    private TopObject computeTop(int n) {
        TopObject topObject = new TopObject();
        for (int i = 0; i < this.blackBox.nbRecords(); ++i) {
            ArrayList<String> arrayList = this.blackBox.getLine(i);
            String string = arrayList.get(n);
            if (n == 5) {
                if (string.isEmpty()) {
                    string = "? ?";
                }
                string = string + "  (" + arrayList.get(4) + ")";
            }
            boolean bl = false;
            for (ArrayList arrayList2 : topObject) {
                if (!((String)arrayList2.get(0)).equals(string)) continue;
                arrayList2.add(string);
                bl = true;
            }
            if (bl) continue;
            ArrayList arrayList3 = new ArrayList();
            arrayList3.add(string);
            topObject.add(arrayList3);
        }
        Collections.sort(topObject, new StringListComparator());
        return topObject;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.operationTxt = new JTextArea();
        JPanel jPanel4 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.nameTxt = new JTextArea();
        JPanel jPanel5 = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.sourceTxt = new JTextArea();
        JPanel jPanel6 = new JPanel();
        JScrollPane jScrollPane4 = new JScrollPane();
        this.hostTxt = new JTextArea();
        JPanel jPanel7 = new JPanel();
        JScrollPane jScrollPane5 = new JScrollPane();
        this.processTxt = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TopDialog.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("Dismiss");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TopDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        jPanel3.setLayout(new BorderLayout());
        this.operationTxt.setColumns(20);
        this.operationTxt.setEditable(false);
        this.operationTxt.setRows(5);
        jScrollPane.setViewportView(this.operationTxt);
        jPanel3.add((Component)jScrollPane, "Center");
        this.tabbedPane.addTab("Operation", jPanel3);
        jPanel4.setLayout(new BorderLayout());
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setRows(5);
        jScrollPane2.setViewportView(this.nameTxt);
        jPanel4.add((Component)jScrollPane2, "Center");
        this.tabbedPane.addTab("Name", jPanel4);
        jPanel5.setLayout(new BorderLayout());
        this.sourceTxt.setColumns(20);
        this.sourceTxt.setEditable(false);
        this.sourceTxt.setRows(5);
        jScrollPane3.setViewportView(this.sourceTxt);
        jPanel5.add((Component)jScrollPane3, "Center");
        this.tabbedPane.addTab("Source", jPanel5);
        jPanel6.setLayout(new BorderLayout());
        this.hostTxt.setColumns(20);
        this.hostTxt.setEditable(false);
        this.hostTxt.setRows(5);
        jScrollPane4.setViewportView(this.hostTxt);
        jPanel6.add((Component)jScrollPane4, "Center");
        this.tabbedPane.addTab("Host", jPanel6);
        jPanel7.setLayout(new BorderLayout());
        this.processTxt.setColumns(20);
        this.processTxt.setEditable(false);
        this.processTxt.setRows(5);
        jScrollPane5.setViewportView(this.processTxt);
        jPanel7.add((Component)jScrollPane5, "Center");
        this.tabbedPane.addTab("Process", jPanel7);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        this.displayTop();
        this.setVisible(true);
    }

    class StringListComparator
    implements Comparator<ArrayList<String>> {
        StringListComparator() {
        }

        @Override
        public int compare(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
            if (arrayList.size() == arrayList2.size()) {
                return 0;
            }
            return arrayList.size() < arrayList2.size() ? 1 : -1;
        }
    }

    private class TopObject
    extends ArrayList<ArrayList<String>> {
        private TopObject() {
        }

        private double[] computeRatios() {
            int n = 0;
            double[] dArray = new double[this.size()];
            for (Object object : this) {
                n += object.size();
            }
            int n2 = 0;
            for (List list : this) {
                dArray[n2++] = 100.0 * (double)list.size() / (double)n;
            }
            return dArray;
        }

        @Override
        public String toString() {
            double[] dArray = this.computeRatios();
            int n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (List list : this) {
                stringBuilder.append(String.format("%3d", list.size())).append(" calls(").append(String.format("%5.1f", dArray[n++])).append(" %):\t").append((String)list.get(0)).append('\n');
            }
            return stringBuilder.toString();
        }
    }
}

