/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.ListDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ServerUsageDialog
extends JDialog {
    private JFrame parent;
    private List<TangoClass> tangoClasses = new ArrayList<TangoClass>();
    private List<Domain> domains = new ArrayList<Domain>();
    private int nbServers;
    private String wildcard;
    private String urlFile;
    private int serversCounter = 0;
    private static final String header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> title </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n";
    private static final String footer = "</Body>\n</Html>\n";
    private JTabbedPane tabbedPane;
    private JLabel titleLabel;

    public ServerUsageDialog(JFrame jFrame) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initComponents(null);
    }

    public ServerUsageDialog(JFrame jFrame, String string) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initComponents(string);
    }

    private void initComponents(String string) throws DevFailed {
        this.initComponents();
        this.displayServerUsage(string);
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void displayServerUsage(String string) throws DevFailed {
        Object object;
        Object object2;
        List<Object> list;
        if (string != null) {
            list = new ArrayList<String>();
            list.add(string);
        } else {
            object2 = ApiUtil.get_db_obj().get_server_name_list();
            object = new ListDialog(this.parent, "Servers in " + ApiUtil.getTangoHost(), (String[])object2);
            list = ((ListDialog)object).showDialog();
            if (list == null || list.isEmpty()) {
                this.doClose();
                return;
            }
        }
        try {
            AstorUtil.startSplash((String)list.get(0));
            object2 = list.iterator();
            while (object2.hasNext()) {
                this.wildcard = object = (String)object2.next();
                this.wildcard = this.wildcard + "/*";
                this.titleLabel.setText(this.wildcard);
                this.tangoClasses.clear();
                this.domains.clear();
                String[] stringArray = ApiUtil.get_db_obj().get_server_list(this.wildcard);
                this.nbServers = stringArray.length;
                for (String string2 : stringArray) {
                    AstorUtil.increaseSplashProgress(1, string2);
                    this.fillTangoClasses(string2);
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                URL object3 = new URL(this.buildTmpFile(this.toHtml()));
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setEditable(false);
                jEditorPane.setPage(object3);
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                jScrollPane.setPreferredSize(new Dimension(480, 440));
                this.tabbedPane.add(jScrollPane);
                this.tabbedPane.setTitleAt(this.serversCounter++, (String)object);
                this.tabbedPane.setSelectedComponent(jScrollPane);
            }
            AstorUtil.stopSplash();
        }
        catch (IOException iOException) {
            Except.throw_exception((String)"URL failed", (String)iOException.getMessage());
        }
    }

    private String buildTmpFile(String string) {
        String string2 = null;
        try {
            int n = new Random().nextInt(30000);
            String string3 = System.getProperty("java.io.tmpdir");
            this.urlFile = string3 + "/html." + n;
            FileOutputStream fileOutputStream = new FileOutputStream(this.urlFile);
            fileOutputStream.write((header + string + footer).getBytes());
            fileOutputStream.close();
            string2 = "file:" + this.urlFile;
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (Exception)exception);
            exception.printStackTrace();
        }
        return string2;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel();
        JButton jButton2 = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ServerUsageDialog.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jButton.setText("Another Server");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerUsageDialog.this.anotherBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jLabel.setText("                              ");
        jPanel2.add(jLabel);
        jButton2.setText("Dismiss");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerUsageDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void anotherBtnActionPerformed(ActionEvent actionEvent) {
        try {
            this.displayServerUsage(null);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    private void doClose() {
        try {
            if (this.urlFile != null && !new File(this.urlFile).delete()) {
                System.err.println("Cannot delete " + this.urlFile);
            }
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (Exception)exception);
        }
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private void fillTangoClasses(String string) throws DevFailed {
        DbServer dbServer = new DbServer(string);
        String[] stringArray = dbServer.get_device_class_list();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            if (string3.equals("DServer")) continue;
            ArrayList arrayList = null;
            for (TangoClass tangoClass : this.tangoClasses) {
                if (!tangoClass.name.toLowerCase().equals(string3.toLowerCase())) continue;
                arrayList = tangoClass;
            }
            if (arrayList == null) {
                arrayList = new TangoClass(string3);
                this.tangoClasses.add((TangoClass)arrayList);
            }
            arrayList.add(string2);
            Domain domain = this.getDomain(string2);
            domain.add(string2);
            if (bl) continue;
            domain.addServer();
            bl = true;
        }
    }

    private Domain getDomain(String string) throws DevFailed {
        Domain domain = null;
        String string2 = string.substring(0, string.indexOf("/")).toLowerCase();
        for (Domain domain2 : this.domains) {
            if (!domain2.name.equalsIgnoreCase(string2)) continue;
            domain = domain2;
        }
        if (domain == null) {
            domain = new Domain(string2);
            this.domains.add(domain);
        }
        return domain;
    }

    private String toHtml() {
        int n = 0;
        for (TangoClass iterator : this.tangoClasses) {
            n += iterator.size();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<font size+=1><b>").append(n).append(" devices for ").append(this.nbServers).append(" server instances </u></b></font>\n");
        stringBuilder.append("<br><br>\n");
        stringBuilder.append("<table border=0> <td>\n");
        stringBuilder.append("<font size+=1><b><u>By Domain:</u></b></font>\n");
        stringBuilder.append("<table border=1 cellSpacing=0>\n");
        stringBuilder.append("<td><b>Domain</b></td> <td><b>Instances</b></td> <td><b>Devices</b></td>\n");
        for (Domain domain : this.domains) {
            stringBuilder.append("<tr> <td> ").append(domain.name).append(" </td> <td>").append(domain.nbServers).append(" </td> <td>").append(domain.size()).append(" </td> </tr>\n");
        }
        stringBuilder.append("</table>\n");
        stringBuilder.append("</td> <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td> <td>\n");
        stringBuilder.append("<font size+=1><b><u>Devices by Class:</u></b></font>\n");
        stringBuilder.append("<table border=1 cellSpacing=0>\n");
        stringBuilder.append("<td><b>Class name</b></td> <td><b>Devices</b></td>\n");
        for (TangoClass tangoClass : this.tangoClasses) {
            stringBuilder.append("<tr> <td> ").append(tangoClass.name).append(" </td> <td>").append(tangoClass.size()).append(" </td> </tr>\n");
        }
        stringBuilder.append("</table>\n");
        stringBuilder.append("</td></table>\n");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.wildcard).append("\n");
        stringBuilder.append("\n=====================================\n");
        for (TangoClass arrayList : this.tangoClasses) {
            stringBuilder.append(arrayList);
            n += arrayList.size();
        }
        stringBuilder.append("\n=====================================\n");
        for (Domain domain : this.domains) {
            stringBuilder.append("Domain ").append(domain.name).append(":\t");
            stringBuilder.append(domain.size()).append(" devices\t");
            stringBuilder.append(domain.nbServers).append(" servers\n");
        }
        stringBuilder.append("\n=====================================\n");
        stringBuilder.append(this.nbServers).append("\tservers\n");
        stringBuilder.append(n).append("\tdevices\n");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        try {
            new ServerUsageDialog(null, null).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
        }
    }

    private class TangoClass
    extends ArrayList<String> {
        private String name;

        private TangoClass(String string) {
            this.name = string;
        }

        @Override
        public String toString() {
            return "Class " + this.name + ":\t" + this.size() + " devices\n";
        }
    }

    private class Domain
    extends ArrayList<String> {
        private String name;
        private int nbServers = 0;

        private Domain(String string) {
            this.name = string;
        }

        private void addServer() {
            ++this.nbServers;
        }

        @Override
        public String toString() {
            return "Domain " + this.name + ":\t" + this.size() + " devices\n";
        }
    }
}

