/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.Utils;
import fr.esrf.TangoDs.TangoConst;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PopupHtml
extends JDialog
implements TangoConst {
    protected JFrame parent;
    protected List<URL> history;
    protected JEditorPane pane;
    private boolean deleteFileAtExit = false;
    private JButton backBtn;
    private JTextArea urlText;
    protected static final boolean back = false;
    protected static final boolean forward = true;
    private String header = "http://www";

    public PopupHtml(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.initComponents();
        this.parent = jFrame;
        this.history = new ArrayList<URL>();
        this.pack();
        if (jFrame != null && jFrame.isVisible() && jFrame.getWidth() > 0) {
            Point point = jFrame.getLocationOnScreen();
            point.x += 10;
            point.y += 10;
            this.setLocation(point);
        }
    }

    public PopupHtml(JFrame jFrame, boolean bl) {
        this(jFrame);
        this.deleteFileAtExit = bl;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        JButton jButton = new JButton();
        this.backBtn = new JButton();
        this.urlText = new JTextArea();
        this.setBackground(new Color(198, 178, 168));
        this.setTitle("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PopupHtml.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new FlowLayout(2, 5, 5));
        jLabel.setText("                     ");
        jPanel.add(jLabel);
        jButton.setText("Dismiss");
        jButton.setHorizontalAlignment(2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupHtml.this.dismissBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.backBtn.setText("<<  Back");
        this.backBtn.setForeground(Color.black);
        this.backBtn.setHorizontalAlignment(0);
        this.backBtn.setEnabled(false);
        this.backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupHtml.this.backBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(this.backBtn);
        jPanel2.add(new JLabel("  "));
        this.urlText.setText("");
        this.urlText.setForeground(Color.black);
        this.urlText.setEditable(false);
        jPanel2.add(this.urlText);
        jPanel2.setLayout(new FlowLayout(0));
        this.getContentPane().add((Component)jPanel2, "North");
    }

    private void backBtnActionPerformed(ActionEvent actionEvent) {
        if (this.history.size() > 1) {
            int n = this.history.size() - 2;
            URL uRL = this.history.get(n);
            this.setPage(uRL, false);
        }
    }

    public void hyperlinkUpdateClicked(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            this.setPage(uRL, true);
        }
    }

    private void arm_timeout(long l) {
        new Timeout(Thread.currentThread(), l).start();
    }

    private boolean isTheSameWebServer(String string, String string2) {
        int n = this.header.length();
        int n2 = string2.indexOf("/", n = string2.indexOf(".", n));
        String string3 = n2 < 0 ? string2.substring(n) : string2.substring(n, n2);
        return string.indexOf(string3) > 0;
    }

    protected synchronized void setPage(URL uRL, boolean bl) {
        block10: {
            URL uRL2 = null;
            try {
                this.arm_timeout(5000L);
                uRL2 = this.pane.getPage();
                if (uRL2 != null && uRL.toString().startsWith(this.header) && uRL2.toString().startsWith(this.header) && !this.isTheSameWebServer(uRL.toString(), uRL2.toString())) {
                    Utils.popupError(this.parent, "This application does not manage proxies.\nPlease use a web browser to read this url.\n" + uRL.toString());
                    return;
                }
                this.pane.setCursor(new Cursor(3));
                this.pane.setPage(uRL);
                if (uRL.toString().startsWith(this.header)) {
                    this.urlText.setText(uRL.toString());
                } else {
                    this.urlText.setText("");
                }
                if (!bl) {
                    URL uRL3 = this.history.get(this.history.size() - 1);
                    if (uRL3 != uRL) {
                        this.history.remove(this.history.size() - 1);
                    }
                } else {
                    this.history.add(uRL);
                }
                if (this.history.size() > 1) {
                    this.backBtn.setEnabled(true);
                } else {
                    this.backBtn.setEnabled(false);
                }
            }
            catch (IOException iOException) {
                String string = "Cannot read:\n" + uRL.toString() + "\n\n";
                string = uRL.toString().startsWith("file:") ? string + iOException.toString() : string + "If it is a remote web site, the proxies are not set...\n";
                System.out.println(string);
                Utils.popupError(this.parent, string);
                if (uRL2 == null) break block10;
                this.setPage(uRL2, false);
            }
        }
        this.pane.setCursor(new Cursor(0));
    }

    public void show(URL uRL) {
        this.show(uRL.toString(), 700, 750);
    }

    public void show(URL uRL, int n, int n2) {
        this.show(uRL.toString(), n, n2);
    }

    public void show(String string) {
        this.show(string, 700, 750);
    }

    public void show(String string, int n, int n2) {
        try {
            this.pane = new JEditorPane();
            this.pane.setEditable(false);
            this.pane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    PopupHtml.this.hyperlinkUpdateClicked(hyperlinkEvent);
                }
            });
            this.getContentPane().add((Component)new JScrollPane(this.pane), "Center");
            this.setSize(n, n2);
            URL uRL = new URL(string);
            this.setPage(uRL, true);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                URL uRL = new URL(this.buildTmpFile(string));
                this.setPage(uRL, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                return;
            }
        }
        this.setVisible(true);
    }

    private String buildTmpFile(String string) {
        String string2 = null;
        try {
            int n = new Random().nextInt(30000);
            String string3 = System.getProperty("java.io.tmpdir");
            String string4 = string3 + "/html." + n;
            FileOutputStream fileOutputStream = new FileOutputStream(string4);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
            string2 = "file:" + string4;
            this.deleteFileAtExit = true;
        }
        catch (Exception exception) {
            Utils.popupError(this.parent, null, exception);
            exception.printStackTrace();
        }
        return string2;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void dismissBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.deleteFileAtExit) {
            try {
                URL uRL = this.history.get(0);
                String string = uRL.toString();
                if (string.startsWith("file:")) {
                    string = string.substring("file:".length());
                }
                if (!new File(string).delete()) {
                    System.err.println("Cannot delete " + string);
                }
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        }
        this.dispose();
    }

    public static void main(String[] stringArray) {
        String string = "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/index.html";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        new PopupHtml(null).show(string);
    }

    private class Timeout
    extends Thread {
        Thread parent;
        long millis;

        public Timeout(Thread thread, long l) {
            this.parent = thread;
            this.millis = l;
        }

        @Override
        public synchronized void run() {
            try {
                this.wait(this.millis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

