/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.PoolThreadsTree;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class PoolThreadsManager
extends JDialog {
    private Component parent;
    private TangoHost host;
    private TangoServer server;
    private PoolThreadsTree tree;
    private JScrollPane scrollPane = null;
    private JPanel centerPanel;
    private JMenu editMenu;
    private JMenuItem newThreadItem;
    private JMenuItem removeThreadItem;
    private JTextArea warningTextArea;

    public PoolThreadsManager(JFrame jFrame, TangoHost tangoHost, TangoServer tangoServer) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.host = tangoHost;
        this.server = tangoServer;
        this.createForm();
    }

    public PoolThreadsManager(JFrame jFrame, TangoServer tangoServer) throws DevFailed {
        this(jFrame, null, tangoServer);
    }

    public PoolThreadsManager(JDialog jDialog, TangoHost tangoHost, TangoServer tangoServer) throws DevFailed {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.host = tangoHost;
        this.server = tangoServer;
        this.createForm();
    }

    public PoolThreadsManager(JDialog jDialog, TangoServer tangoServer) throws DevFailed {
        this(jDialog, null, tangoServer);
    }

    public PoolThreadsManager(JFrame jFrame, TangoHost tangoHost, String string) throws DevFailed {
        this(jFrame, tangoHost, new TangoServer(string.startsWith("dserver/") ? string : "dserver/" + string));
    }

    public PoolThreadsManager(JDialog jDialog, TangoHost tangoHost, String string) throws DevFailed {
        this(jDialog, tangoHost, new TangoServer(string.startsWith("dserver/") ? string : "dserver/" + string));
    }

    public PoolThreadsManager(JFrame jFrame, String string) throws DevFailed {
        this(jFrame, null, string);
    }

    public PoolThreadsManager(JDialog jDialog, String string) throws DevFailed {
        this(jDialog, null, string);
    }

    private void createForm() throws DevFailed {
        int n;
        this.initComponents();
        try {
            n = this.server.get_idl_version();
        }
        catch (DevFailed devFailed) {
            n = 0;
        }
        if (n > 0 && n < 4) {
            Except.throw_non_supported_exception((String)"BAD_IDL_VERSION", (String)("The server is compiled with IDL " + n + "\nThis feature is allowed only with IDL 4 (TANGO 7) and above"), (String)"PoolThreadsManager.PoolThreadsManager()");
        }
        this.warningTextArea.setVisible(n == 0);
        this.initializeTree();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public void initializeTree() throws DevFailed {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setPreferredSize(new Dimension(350, 400));
            this.centerPanel.add((Component)this.scrollPane, "Center");
        } else if (this.tree != null) {
            this.scrollPane.remove(this.tree);
        }
        this.tree = new PoolThreadsTree(this, this.server);
        this.scrollPane.setViewportView(this.tree);
        this.editMenu.setMnemonic('E');
        this.newThreadItem.setMnemonic('N');
        this.removeThreadItem.setMnemonic('R');
        this.newThreadItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.removeThreadItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.centerPanel = new JPanel();
        this.warningTextArea = new JTextArea();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        JMenuBar jMenuBar = new JMenuBar();
        this.editMenu = new JMenu();
        this.newThreadItem = new JMenuItem();
        this.removeThreadItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PoolThreadsManager.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("Apply");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoolThreadsManager.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Dismiss");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoolThreadsManager.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.centerPanel.setLayout(new BorderLayout());
        this.warningTextArea.setColumns(20);
        this.warningTextArea.setEditable(false);
        this.warningTextArea.setFont(new Font("Dialog", 1, 12));
        this.warningTextArea.setRows(3);
        this.warningTextArea.setText("Warning:\nIDL server cannot be checked.\nThis feature is avalable only for TANGO-7 (or above) servers.");
        this.centerPanel.add((Component)this.warningTextArea, "South");
        jLabel.setFont(new Font("Dialog", 1, 14));
        jLabel.setText("Polling Threads Mangement");
        jPanel2.add(jLabel);
        this.centerPanel.add((Component)jPanel2, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.editMenu.setText("Edit");
        this.newThreadItem.setText("New Thread");
        this.newThreadItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoolThreadsManager.this.newThreadItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.newThreadItem);
        this.removeThreadItem.setText("Remove Thread");
        this.removeThreadItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoolThreadsManager.this.removeThreadItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.removeThreadItem);
        jMenuBar.add(this.editMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void removeThreadItemActionPerformed(ActionEvent actionEvent) {
        if (this.tree.selectedObjectIsThread()) {
            this.tree.removeThread();
        }
    }

    private void newThreadItemActionPerformed(ActionEvent actionEvent) {
        this.tree.addThreadNode();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (JOptionPane.showConfirmDialog(this.parent, "Apply pool thread configuration to database ?", "Confirm Dialog", 0) == 0) {
            this.tree.putPoolThreadInfo();
            if (this.host != null) {
                this.server.restart(this.parent, this.host, false);
            } else {
                JOptionPane.showMessageDialog(this, "Database has been updated.\nRestart the server now.", "Command Done", 1);
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent != null) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                Except.throw_exception((String)"BAD_SYNTAX", (String)"Server name ?", (String)"admin.astor.tools.PoolThreadsManager.main()");
            }
            new PoolThreadsManager((JFrame)null, stringArray[0]).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new Frame(), (String)"", (DevFailed)devFailed);
            System.exit(0);
        }
    }
}

