/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.DevPollStatus;
import admin.astor.tools.PolledElement;
import admin.astor.tools.PoolThreadsTree;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class PollingProfiler
extends JDialog
implements IJLChartListener,
ComponentListener {
    private JLChart chart = new JLChart();
    private JLAxis y_axis;
    private JLAxis x_axis;
    private JLDataView[] data = null;
    private long now;
    private String[] deviceNames;
    private DevPollStatus poll_status;
    private Component parent = null;
    private Timer timer = null;
    private int timer_period = 2;
    private boolean update_chart = true;
    private JLabel late_label;
    private JLabel early_label;
    private PollingInfo poll_info;
    private String title;
    private int display_mode = 2;
    private JCheckBoxMenuItem[] check_box;
    private static final int HISTORY = 0;
    private static final int POLL_DRIFT = 1;
    private static final int DURATION = 2;
    private static final int NB_CHECK_BOX = 3;
    private static final Dimension preferredDimension = new Dimension(1024, 500);
    private boolean titleDisplayed = false;
    private JRadioButton autoBtn;
    private JLabel titleLabel;
    private JButton updateBtn;
    private JButton warningBtn;

    public PollingProfiler(JDialog jDialog, String string) {
        super((Dialog)jDialog, false);
        this.parent = jDialog;
        this.realConstructor(new String[]{string});
    }

    public PollingProfiler(JFrame jFrame, String string) {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.realConstructor(new String[]{string});
    }

    public PollingProfiler(JDialog jDialog, String[] stringArray) {
        super((Dialog)jDialog, false);
        this.parent = jDialog;
        this.realConstructor(stringArray);
    }

    public PollingProfiler(JFrame jFrame, String[] stringArray) {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.realConstructor(stringArray);
    }

    private void realConstructor(String[] stringArray) {
        this.deviceNames = stringArray;
        this.initComponents();
        this.initOwnComponents();
        this.buildPopupMenu();
        this.customizeAxis();
        this.updateData();
        this.checkTangoRelease();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void checkTangoRelease() {
        try {
            boolean bl;
            if (this.deviceNames.length == 0) {
                return;
            }
            DeviceProxy deviceProxy = new DeviceProxy(this.deviceNames[0]);
            DeviceProxy deviceProxy2 = deviceProxy.get_adm_dev();
            int n = deviceProxy2.getTangoVersion();
            DbDatum dbDatum = deviceProxy2.get_property("polling_before_9");
            boolean bl2 = bl = !dbDatum.is_empty() && dbDatum.extractBoolean();
            if (n < 910 || bl) {
                this.warningBtn.setVisible(false);
            } else if (this.poll_status.isPollingSeveralAttributes()) {
                this.warningBtn.setIcon(Utils.getInstance().getIcon("clock.gif"));
                this.warningBtn.setText("");
            } else {
                this.warningBtn.setVisible(false);
            }
        }
        catch (DevFailed devFailed) {
            System.err.println("Cannot check Tango release: " + devFailed.errors[0].desc);
        }
    }

    private void buildPopupMenu() {
        this.chart.addMenuItem(new JMenuItem("-------------------------"));
        this.check_box = new JCheckBoxMenuItem[3];
        this.check_box[0] = new JCheckBoxMenuItem("History");
        this.check_box[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PollingProfiler.this.menuActionPerformed(actionEvent);
            }
        });
        this.chart.addMenuItem((JMenuItem)this.check_box[0]);
        this.check_box[1] = new JCheckBoxMenuItem("Polling Drift");
        this.check_box[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PollingProfiler.this.menuActionPerformed(actionEvent);
            }
        });
        this.chart.addMenuItem((JMenuItem)this.check_box[1]);
        this.check_box[2] = new JCheckBoxMenuItem("Duration");
        this.check_box[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PollingProfiler.this.menuActionPerformed(actionEvent);
            }
        });
        this.chart.addMenuItem((JMenuItem)this.check_box[2]);
        JMenuItem jMenuItem = new JMenuItem("Polling Info");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PollingProfiler.this.menuActionPerformed(actionEvent);
            }
        });
        this.chart.addMenuItem(jMenuItem);
        this.check_box[this.display_mode].setSelected(true);
    }

    private void menuActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 0;
        if (object instanceof JCheckBoxMenuItem) {
            for (int i = 0; i < this.check_box.length; ++i) {
                if (this.check_box[i] == object) {
                    n = i;
                    this.check_box[i].setSelected(true);
                    continue;
                }
                this.check_box[i].setSelected(false);
            }
            this.display_mode = n;
            this.customizeAxis();
            this.updateCurves();
            this.manageLabels();
        } else {
            this.poll_info.setVisible(true);
        }
    }

    private void customizeAxis() {
        this.x_axis.setPosition(4);
        if (this.display_mode == 0) {
            this.titleLabel.setText(this.title + " (History)");
            this.x_axis.setAutoScale(false);
            this.x_axis.setName("Time");
            this.x_axis.setAnnotation(1);
            this.x_axis.setLabelFormat(0);
            this.y_axis.setAutoScale(false);
            this.y_axis.setName("T0");
            this.late_label.setVisible(false);
            this.early_label.setVisible(false);
        } else {
            this.x_axis.setAutoScale(false);
            this.x_axis.setName("Attributes");
            this.x_axis.setAnnotation(2);
            this.x_axis.setLabelFormat(3);
            if (this.display_mode == 1) {
                this.titleLabel.setText(this.title + " (Drift)");
                this.y_axis.setName("Polling Drift (ms)");
                this.late_label.setVisible(true);
                this.early_label.setVisible(true);
            } else if (this.display_mode == 2) {
                this.titleLabel.setText(this.title + " (Duration)");
                this.y_axis.setName("Duration (ms)");
                this.late_label.setVisible(false);
                this.early_label.setVisible(false);
                this.y_axis.setAutoScale(true);
            }
        }
    }

    private void manageLabels() {
        switch (this.display_mode) {
            case 0: {
                this.late_label.setVisible(false);
                this.early_label.setVisible(false);
                break;
            }
            case 1: {
                int n = this.early_label.getPreferredSize().width;
                int n2 = this.early_label.getPreferredSize().height;
                int n3 = this.chart.getHeight();
                this.early_label.setBounds(24, n3 - 20, n, n2);
                this.late_label.setVisible(true);
                this.early_label.setVisible(true);
                break;
            }
            case 2: {
                this.late_label.setVisible(false);
                this.early_label.setVisible(false);
            }
        }
    }

    private void initOwnComponents() {
        this.y_axis = this.chart.getY2Axis();
        this.x_axis = this.chart.getXAxis();
        this.chart.setBackground(Color.white);
        this.chart.setChartBackground(Color.lightGray);
        this.chart.setLabelVisible(true);
        this.chart.setLabelFont(new Font("Dialog", 1, 12));
        this.x_axis.setGridVisible(true);
        this.chart.setPreferredSize(preferredDimension);
        this.chart.setJLChartListener((IJLChartListener)this);
        this.chart.setLabelPlacement(2);
        this.getContentPane().add((Component)this.chart, "Center");
        this.chart.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PollingProfiler.this.myMouseReleased(mouseEvent);
            }
        });
        this.title = "Polling on:  ";
        if (this.deviceNames.length == 1) {
            this.title = this.title + this.deviceNames[0];
        } else {
            try {
                String string = new DeviceProxy(this.deviceNames[0]).adm_name();
                this.title = this.title + string.substring(string.indexOf(47) + 1);
            }
            catch (DevFailed devFailed) {
                this.title = this.title + this.deviceNames[0];
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
        this.titleLabel.setText(this.title);
        this.late_label = new JLabel("Polling Late");
        this.late_label.setFont(new Font("Dialog", 1, 14));
        this.late_label.setIcon(Utils.getInstance().getIcon("up.gif"));
        this.late_label.setVisible(false);
        this.chart.add((Component)this.late_label);
        int n = this.late_label.getPreferredSize().width;
        int n2 = this.late_label.getPreferredSize().height;
        this.late_label.setBounds(24, 10, n, n2);
        this.early_label = new JLabel("Polling Early");
        this.early_label.setFont(new Font("Dialog", 1, 14));
        this.early_label.setIcon(Utils.getInstance().getIcon("down.gif"));
        this.early_label.setVisible(false);
        this.chart.add((Component)this.early_label);
        this.poll_info = new PollingInfo(this);
        this.chart.addComponentListener((ComponentListener)this);
    }

    private void myMouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.update_chart = true;
            this.doRepaint();
        }
    }

    private void displayTitle(int n) throws DevFailed {
        String string = new DeviceProxy(this.deviceNames[0]).adm_name();
        int n2 = new PoolThreadsTree(string).getNbThreads();
        this.setTitle(Integer.toString(n) + " elements polled by " + n2 + " threads");
        this.titleDisplayed = true;
    }

    private void updateData() {
        this.now = System.currentTimeMillis();
        try {
            this.poll_status = new DevPollStatus(this.deviceNames);
            if (!this.titleDisplayed) {
                this.displayTitle(this.poll_status.size());
            }
            this.updateCurves();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void manageDataViews(int n) {
        if (this.data != null && n != this.data.length) {
            for (JLDataView object : this.data) {
                object.reset();
                this.y_axis.removeDataView(object);
            }
            this.data = null;
            this.initOwnComponents();
        }
        if (this.data != null) {
            for (JLDataView jLDataView : this.data) {
                jLDataView.reset();
            }
        } else {
            this.data = new JLDataView[n];
            AstorUtil astorUtil = AstorUtil.getInstance();
            astorUtil.initColors(n);
            for (int i = 0; i < n; ++i) {
                this.data[i] = new JLDataView();
                this.data[i].setColor(astorUtil.getNewColor());
                this.data[i].setName(((PolledElement)this.poll_status.get((int)i)).name);
                this.data[i].setLabelVisible(true);
                this.y_axis.addDataView(this.data[i]);
            }
        }
        if (this.display_mode == 0) {
            for (int i = 0; i < n; ++i) {
                this.data[i].setViewType(0);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.data[i].setViewType(1);
                this.data[i].setFillMethod(1);
                this.data[i].setFill(true);
                this.data[i].setFillStyle(1);
                this.data[i].setFillColor(this.data[i].getColor());
            }
        }
    }

    private void updateCurves() {
        int n = this.poll_status.size();
        if (n == 0) {
            return;
        }
        this.manageDataViews(n);
        double d = this.now;
        double[] dArray = new double[]{0.0, 0.0};
        int n2 = 0;
        for (PolledElement polledElement : this.poll_status) {
            switch (this.display_mode) {
                case 0: {
                    d = this.updateHistory(polledElement, n2, d);
                    break;
                }
                case 1: {
                    dArray = this.updateDrift(polledElement, n2, dArray);
                    break;
                }
                case 2: {
                    double d2 = polledElement.polled ? polledElement.reading_time : 0.0;
                    this.data[n2].add((double)n2, d2);
                }
            }
            ++n2;
        }
        this.manageMinMax(dArray);
        this.poll_info.display();
        this.doRepaint();
    }

    private double[] updateDrift(PolledElement polledElement, int n, double[] dArray) {
        double d;
        if (polledElement.polled) {
            if (polledElement.realPeriods.length == 0) {
                System.out.println("pe.realPeriods.length=0");
                d = 0.0;
            } else {
                d = polledElement.realPeriods[0] - polledElement.period;
            }
        } else {
            d = 0.0;
        }
        this.data[n].add((double)n, d);
        if (d < dArray[0]) {
            dArray[0] = d;
        }
        if (d > dArray[1]) {
            dArray[1] = d;
        }
        return dArray;
    }

    private double updateHistory(PolledElement polledElement, int n, double d) {
        double d2 = this.now - (long)polledElement.last_update;
        double d3 = 1.0 + 0.1 * (double)n;
        this.data[n].add(d2, 0.0);
        this.data[n].add(d2, d3);
        this.data[n].add(d2 - polledElement.reading_time, d3);
        this.data[n].add(d2 - polledElement.reading_time, 0.0);
        if (d2 < d) {
            d = d2;
        }
        for (int n2 : polledElement.realPeriods) {
            this.data[n].add(d2 -= (double)n2, 0.0);
            this.data[n].add(d2, d3);
            this.data[n].add(d2 - polledElement.reading_time, d3);
            this.data[n].add(d2 - polledElement.reading_time, 0.0);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    private void manageMinMax(double[] dArray) {
        int n = this.poll_status.size();
        double d = this.now;
        switch (this.display_mode) {
            case 0: {
                this.x_axis.setMinimum(d -= 1000.0);
                this.x_axis.setMaximum((double)this.now);
                this.y_axis.setMinimum(0.0);
                this.y_axis.setMaximum(0.1 * (double)n + 1.5);
                break;
            }
            case 1: {
                this.x_axis.setMinimum(-0.05);
                this.x_axis.setMaximum((double)n - 0.5);
                if (dArray[0] > -10.0 && dArray[1] < 10.0) {
                    this.y_axis.setAutoScale(false);
                    this.y_axis.setMinimum(-10.0);
                    this.y_axis.setMaximum(10.0);
                    break;
                }
                this.y_axis.setAutoScale(true);
                break;
            }
            case 2: {
                this.x_axis.setMinimum(-0.05);
                this.x_axis.setMaximum((double)n - 0.5);
            }
        }
    }

    private void doRepaint() {
        if (this.update_chart) {
            this.chart.repaint();
        }
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        String[] stringArray;
        int n;
        this.update_chart = false;
        JLDataView jLDataView = jLChartEvent.getDataView();
        PolledElement polledElement = null;
        for (n = 0; polledElement == null && n < this.poll_status.size(); ++n) {
            if (!jLDataView.getName().equals(((PolledElement)this.poll_status.get((int)n)).name)) continue;
            polledElement = (PolledElement)this.poll_status.get(n);
        }
        n = jLChartEvent.getDataViewIndex();
        DataList dataList = jLDataView.getData();
        for (int i = 0; i < n; ++i) {
            dataList = dataList.next;
        }
        if (polledElement == null) {
            return new String[0];
        }
        String[] stringArray2 = polledElement.getInfo();
        int n2 = stringArray2.length;
        if (this.display_mode == 0) {
            stringArray = new String[n2 + 2];
            System.arraycopy(stringArray2, 0, stringArray, 0, n2);
            stringArray[n2] = "";
            stringArray[n2 + 1] = "T0 - " + (int)((double)this.now - dataList.x) + " ms";
        } else {
            stringArray = stringArray2;
        }
        return stringArray;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.warningBtn = new JButton();
        JLabel jLabel = new JLabel();
        this.autoBtn = new JRadioButton();
        this.updateBtn = new JButton();
        JButton jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PollingProfiler.this.closeDialog(windowEvent);
            }
        });
        this.warningBtn.setText("...");
        this.warningBtn.setBorder(BorderFactory.createEtchedBorder());
        this.warningBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PollingProfiler.this.warningBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.warningBtn);
        jLabel.setText("                 ");
        jPanel.add(jLabel);
        this.autoBtn.setText("Auto Update");
        this.autoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PollingProfiler.this.autoBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.autoBtn);
        this.updateBtn.setText("Update");
        this.updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PollingProfiler.this.updateBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.updateBtn);
        jButton.setText("Dismiss");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PollingProfiler.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void autoBtnActionPerformed(ActionEvent actionEvent) {
        if (this.autoBtn.getSelectedObjects() != null) {
            String string = "" + this.timer_period;
            if ((string = (String)JOptionPane.showInputDialog(this, "Reading period (seconds)  ?", "Reading period", 1, null, null, string)) == null) {
                this.autoBtn.setSelected(false);
                return;
            }
            try {
                this.timer_period = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)numberFormatException);
                ErrorPane.showErrorMessage((Component)this, null, (Exception)numberFormatException);
                this.autoBtn.setSelected(false);
                return;
            }
            this.updateData();
            if (this.timer == null) {
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PollingProfiler.this.updateData();
                    }
                };
                this.timer = new Timer(1000 * this.timer_period, actionListener);
            } else {
                this.timer.setDelay(1000 * this.timer_period);
            }
            this.timer.start();
            this.updateBtn.setEnabled(false);
        } else if (this.timer != null) {
            this.timer.stop();
            this.updateBtn.setEnabled(true);
        }
    }

    private void updateBtnActionPerformed(ActionEvent actionEvent) {
        this.updateData();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void warningBtnActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "WARNING:\n  Since Tango-9, the polling duration\n  could be a sum of several attribute polling durations.\n\n  To have previous behaviour, add an admin device property:\n       polling_before_9:  true");
    }

    private void doClose() {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.parent != null && this.parent.isVisible()) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.manageLabels();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.manageLabels();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.manageLabels();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    static int getNbFields(String[] stringArray) {
        if (stringArray.length == 0) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], "/");
        return stringTokenizer.countTokens();
    }

    private static String[] getDeviceNames(String string) throws DevFailed {
        DeviceProxy deviceProxy = new DeviceProxy("dserver/" + string);
        DeviceData deviceData = deviceProxy.command_inout("QueryDevice");
        String[] stringArray = deviceData.extractStringArray();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].substring(stringArray[i].indexOf("::") + 2);
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        try {
            switch (PollingProfiler.getNbFields(stringArray)) {
                case 3: {
                    new PollingProfiler(new JDialog(), stringArray[0]).setVisible(true);
                    break;
                }
                case 2: {
                    String[] stringArray2 = PollingProfiler.getDeviceNames(stringArray[0]);
                    new PollingProfiler(new JDialog(), stringArray2).setVisible(true);
                    break;
                }
                default: {
                    Except.throw_exception((String)"BAD_ARGUMENT", (String)"Server or Device name  ?", (String)"PollingProfiler.main()");
                    break;
                }
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
    }

    public class PollingInfo
    extends JDialog {
        private JTextArea textArea;

        public PollingInfo(JDialog jDialog) {
            super((Dialog)jDialog, false);
            JScrollPane jScrollPane = new JScrollPane();
            this.textArea = new JTextArea();
            this.textArea.setFont(new Font("Dialog", 1, 14));
            this.textArea.setEditable(false);
            jScrollPane.setViewportView(this.textArea);
            jScrollPane.setPreferredSize(new Dimension(500, 250));
            this.getContentPane().add((Component)jScrollPane, "Center");
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        private String formatValue(double d, int n) {
            String string = "" + d;
            int n2 = string.indexOf(46);
            if (n2 > 0 && string.substring(n2 + 1).length() > n) {
                string = string.substring(0, n + n2 + 1);
            }
            return string;
        }

        private void display() {
            int n = PollingProfiler.this.poll_status.polledCount();
            int n2 = PollingProfiler.this.poll_status.triggeredCount();
            StringBuilder stringBuilder = new StringBuilder("  ");
            if (n2 == 0) {
                stringBuilder.append(n).append(" polled attributes.\n\n");
            } else if (n == 0) {
                stringBuilder.append(n2).append(" triggered attributes.\n\n");
            } else {
                stringBuilder.append(n).append(" polled attributes  and  ");
                stringBuilder.append(n2).append(" triggered attributes.\n\n");
            }
            stringBuilder.append(this.getDriftStatus());
            stringBuilder.append(this.getDurationStatus());
            stringBuilder.append(this.getLastUpdate());
            this.textArea.setText(stringBuilder.toString());
        }

        private String getDurationStatus() {
            double d = 0.0;
            double d2 = 0.0;
            String string = null;
            for (PolledElement polledElement : PollingProfiler.this.poll_status) {
                if (polledElement.realPeriods.length <= 0 || !polledElement.polled) continue;
                if (polledElement.reading_time > d2) {
                    d2 = polledElement.reading_time;
                    string = polledElement.name;
                }
                d += polledElement.reading_time;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            stringBuilder.append("Duration :\n");
            stringBuilder.append("    Maxi : ").append(this.formatValue(d2, 2)).append(" ms");
            if (string != null) {
                stringBuilder.append("\ton ").append(string);
            }
            stringBuilder.append("\n");
            stringBuilder.append("    Total: ").append(this.formatValue(d, 2)).append(" ms \n");
            return stringBuilder.toString();
        }

        private String getDriftStatus() {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            String string = null;
            String string2 = null;
            for (PolledElement polledElement : PollingProfiler.this.poll_status) {
                if (polledElement.realPeriods.length <= 0 || !polledElement.polled) continue;
                int n3 = polledElement.realPeriods[0] - polledElement.period;
                if (n3 > 0) {
                    if (n3 > n) {
                        n = n3;
                        string = polledElement.name;
                    }
                } else if (n3 < n2) {
                    n2 = n3;
                    string2 = polledElement.name;
                }
                bl = true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append("Drift maxi :\n");
                stringBuilder.append("    - Late : ").append(n).append(" ms ");
                if (string != null) {
                    stringBuilder.append("\ton ").append(string);
                }
                stringBuilder.append("\n");
                stringBuilder.append("    - Early: ").append(n2).append(" ms ");
                if (string2 != null) {
                    stringBuilder.append("\ton ").append(string2);
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        private String getLastUpdate() {
            int n = 0;
            String string = "";
            String string2 = null;
            for (PolledElement polledElement : PollingProfiler.this.poll_status) {
                if (polledElement.realPeriods.length <= 0 || polledElement.last_update <= n) continue;
                n = polledElement.last_update;
                string = polledElement.last_update_str;
                string2 = polledElement.name;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (string2 != null) {
                stringBuilder.append("\n");
                stringBuilder.append("Last update max\ton ").append(string2);
                stringBuilder.append("\n    since ").append(string);
            }
            return stringBuilder.toString();
        }
    }
}

