/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PolledElement {
    String deviceName = "unknown";
    String name = "unknown";
    String type;
    int period = -1;
    int buffer_depth = -1;
    double reading_time = -1.0;
    int last_update = -1;
    int[] realPeriods = new int[0];
    DevState state;
    String status;
    String last_update_str = "";
    private static final String equal = " = ";
    private static final String since = " since ";
    private static final String externalyStr = "Polling externally triggered";
    boolean polled = true;
    private String[] info;

    public PolledElement(String string, String string2) {
        this.deviceName = string;
        this.status = string2;
        this.parsePollingStatus(string2);
        this.state = this.period < 0 || this.buffer_depth < 0 || this.reading_time < 0.0 || this.realPeriods.length == 0 ? DevState.FAULT : ((double)this.realPeriods[0] > 1.5 * (double)this.period || this.reading_time > (double)this.period ? DevState.FAULT : DevState.ON);
    }

    private void parsePeriod(String string) {
        if (string.startsWith(externalyStr)) {
            this.polled = false;
            return;
        }
        int n = string.indexOf(equal);
        if (n > 0) {
            String string2 = string.substring(n + equal.length());
            try {
                this.period = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void parseBufferDepth(String string) {
        int n = string.indexOf(equal);
        if (n > 0) {
            String string2 = string.substring(n + equal.length());
            try {
                this.buffer_depth = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void parseName(String string) {
        int n = string.indexOf(equal);
        if (n > 0) {
            this.name = string.substring(n + equal.length());
        }
        this.type = string.indexOf("attribute") > 0 ? "attribute" : "command";
    }

    private void parseDuration(String string) {
        int n = string.indexOf(equal);
        if (n > 0) {
            String string2 = string.substring(n + equal.length());
            try {
                this.reading_time = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.reading_time = 0.0;
        }
    }

    private void parseRealPeriod(String string) {
        int n = string.indexOf(equal);
        if (n > 0) {
            String string2 = string.substring(n + equal.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            this.realPeriods = new int[arrayList.size()];
            int n2 = 0;
            for (String string3 : arrayList) {
                try {
                    this.realPeriods[n2++] = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    private void parseLastUpdate(String string) {
        int n = string.indexOf(since);
        if (n > 0) {
            String string2;
            this.last_update_str = string2 = string.substring(n + since.length());
            string2 = string2.substring(0, string2.indexOf("mS"));
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " S and ");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            switch (arrayList.size()) {
                case 1: {
                    try {
                        this.last_update = Integer.parseInt((String)arrayList.get(0));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.last_update = 1000;
                    }
                    break;
                }
                case 2: {
                    try {
                        this.last_update = Integer.parseInt((String)arrayList.get(1));
                        this.last_update += 1000 * Integer.parseInt((String)arrayList.get(0));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.last_update += 60000;
                    }
                    break;
                }
                default: {
                    if (arrayList.size() <= 1) break;
                    try {
                        this.last_update = 60000 * Integer.parseInt((String)arrayList.get(0));
                        this.last_update += Integer.parseInt((String)arrayList.get(3));
                        this.last_update += 1000 * Integer.parseInt((String)arrayList.get(2));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.last_update += 60000;
                    }
                }
            }
        }
    }

    private void parsePollingStatus(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
            switch (n) {
                case 0: {
                    this.parseName(string2);
                    break;
                }
                case 1: {
                    this.parsePeriod(string2);
                    break;
                }
                case 2: {
                    this.parseBufferDepth(string2);
                    break;
                }
                case 3: {
                    this.parseDuration(string2);
                    break;
                }
                case 4: {
                    this.parseLastUpdate(string2);
                    break;
                }
                case 5: {
                    this.parseRealPeriod(string2);
                }
            }
            ++n;
        }
        this.info = new String[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.info[n] = (String)arrayList.get(n);
        }
    }

    public String toString() {
        return this.name;
    }

    public String info() {
        String string = this.type + " " + this.name + ":\t" + this.period + " -> " + this.reading_time;
        string = string + "  (since " + this.last_update + ")\t";
        for (int n : this.realPeriods) {
            string = string + n + ", ";
        }
        string = string + "\t" + ApiUtil.stateName((DevState)this.state);
        return string;
    }

    public String[] getInfo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.polled) {
            arrayList.add(this.type + "  " + this.name);
            arrayList.add("Polling period = " + this.period + "ms");
            arrayList.add("Last record takes " + this.reading_time + " ms");
            if (this.info.length > 4) {
                arrayList.add(this.info[4]);
            }
            if (this.info.length > 5) {
                arrayList.add(this.info[5]);
            }
            arrayList.add("");
            String string = "Drifts (ms):   ";
            for (int n : this.realPeriods) {
                string = string + "" + (n - this.period) + ", ";
            }
            arrayList.add(string);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.status, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

