/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

class PingHosts {
    private List<String> aliveList = new ArrayList<String>();
    private List<String> stoppedList = new ArrayList<String>();
    private static final String PingCommand = AstorUtil.osIsUnix() ? "ping  -c 1 -W 1 " : "ping  -n 1 -w 1 ";
    private static final String AliveResponse = AstorUtil.osIsUnix() ? "1 received" : "Received = 1";

    public PingHosts(String string) {
        this(new String[]{string});
    }

    PingHosts(String[] stringArray) {
        ArrayList<PingThread> arrayList = new ArrayList<PingThread>();
        for (String string : stringArray) {
            PingThread pingThread = new PingThread(string);
            pingThread.start();
            arrayList.add(pingThread);
        }
        for (PingThread pingThread : arrayList) {
            try {
                pingThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (pingThread.hostAlive()) {
                this.aliveList.add(pingThread.hostName);
            } else {
                this.stoppedList.add(pingThread.hostName);
            }
            pingThread.interrupt();
        }
    }

    public boolean noStopped() throws DevFailed {
        return this.stoppedList.isEmpty();
    }

    public List<String> getAliveList() throws DevFailed {
        return this.aliveList;
    }

    List<String> getStoppedList() throws DevFailed {
        return this.stoppedList;
    }

    private class PingThread
    extends Thread {
        private String hostName;
        private boolean alive = false;

        private PingThread(String string) {
            this.hostName = string;
        }

        private boolean hostAlive() {
            return this.alive;
        }

        @Override
        public void run() {
            try {
                String string = this.executeShellCmdOneLine(PingCommand + this.hostName);
                this.alive = string.contains(AliveResponse);
                if (!this.alive) {
                    System.out.println(string);
                }
            }
            catch (DevFailed devFailed) {
                Except.print_exception((Exception)((Object)devFailed));
            }
        }

        String executeShellCmdOneLine(String string) throws DevFailed {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                String string2;
                Process process = Runtime.getRuntime().exec(string);
                InputStream inputStream = process.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2).append("\n");
                }
            }
            catch (Exception exception) {
                Except.throw_exception((String)exception.toString(), (String)("The shell command\n" + string + "\nHas failed"));
            }
            return stringBuilder.toString();
        }
    }
}

