/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LastBranchesListDialog
extends JDialog {
    private JFrame parent;
    private List<String> branches;
    private int returnValue = 0;
    private JList<String> branchList;
    private JButton downBtn;
    private JButton removeBtn;
    private JButton upBtn;

    public LastBranchesListDialog(JFrame jFrame, List<String> list, String[] stringArray) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.branches = list;
        this.initComponents();
        this.branchList.removeAll();
        this.branchList.setListData((String[])stringArray);
        this.removeBtn.setEnabled(false);
        this.upBtn.setEnabled(false);
        this.downBtn.setEnabled(false);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.branchList = new JList();
        JPanel jPanel3 = new JPanel();
        this.removeBtn = new JButton();
        JButton jButton3 = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LastBranchesListDialog.this.closeDialog(windowEvent);
            }
        });
        jLabel.setFont(new Font("Dialog", 1, 14));
        jLabel.setText("Branch(es) to be displayed at bottom");
        jLabel.setToolTipText("");
        jPanel.add(jLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LastBranchesListDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LastBranchesListDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.branchList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LastBranchesListDialog.this.branchListValueChanged(listSelectionEvent);
            }
        });
        jScrollPane.setViewportView(this.branchList);
        this.getContentPane().add((Component)jScrollPane, "Center");
        jPanel3.setLayout(new GridBagLayout());
        this.removeBtn.setText("Remove");
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LastBranchesListDialog.this.removeBtnActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this.removeBtn, gridBagConstraints);
        jButton3.setText("Add");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LastBranchesListDialog.this.addBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jButton3, gridBagConstraints);
        this.upBtn.setText("Up");
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LastBranchesListDialog.this.upBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel3.add((Component)this.upBtn, gridBagConstraints);
        this.downBtn.setText("Down");
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LastBranchesListDialog.this.downBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this.downBtn, gridBagConstraints);
        this.getContentPane().add((Component)jPanel3, "East");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.returnValue = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    private void removeBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.branchList.getSelectedValue();
        ListModel<String> listModel = this.branchList.getModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < listModel.getSize(); ++i) {
            String string2 = listModel.getElementAt(i);
            if (string2.equals(string)) continue;
            arrayList.add(string2);
        }
        this.branchList.setListData((String[])arrayList.toArray(new String[arrayList.size()]));
        this.removeBtn.setEnabled(false);
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        ListModel<String> listModel = this.branchList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            objectArray = listModel.getElementAt(i);
            arrayList.add((String)objectArray);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : this.branches) {
            if (string.equals("Tango Database")) continue;
            boolean bl = false;
            for (String string2 : arrayList) {
                if (!string.equals(string2)) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList2.add(string);
        }
        if (arrayList2.size() == 0) {
            Utils.popupError(this.parent, "No branch available !");
            return;
        }
        objectArray = new String[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            objectArray[i] = (String)arrayList2.get(i);
        }
        String string = (String)JOptionPane.showInputDialog(this, "Add branch", "", 1, null, objectArray, objectArray[0]);
        if (string != null) {
            arrayList.add(string);
            this.branchList.setListData((String[])arrayList.toArray(new String[arrayList.size()]));
        }
    }

    private void branchListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.removeBtn.setEnabled(true);
        this.upBtn.setEnabled(true);
        this.downBtn.setEnabled(true);
    }

    private void upBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.branchList.getSelectedValue();
        ArrayList<String> arrayList = new ArrayList<String>();
        ListModel<String> listModel = this.branchList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            String string2 = listModel.getElementAt(i);
            if (string2.equals(string)) {
                if (i == 0) {
                    return;
                }
                arrayList.add(i - 1, string2);
                continue;
            }
            arrayList.add(string2);
        }
        this.branchList.setListData((String[])arrayList.toArray(new String[arrayList.size()]));
        this.branchList.setSelectedValue(string, true);
    }

    private void downBtnActionPerformed(ActionEvent actionEvent) {
        int n;
        String string = this.branchList.getSelectedValue();
        ArrayList<String> arrayList = new ArrayList<String>();
        ListModel<String> listModel = this.branchList.getModel();
        for (n = 0; n < listModel.getSize(); ++n) {
            String string2 = listModel.getElementAt(n);
            arrayList.add(string2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (!((String)arrayList.get(n)).equals(string)) continue;
            if (n >= arrayList.size() - 1) {
                return;
            }
            arrayList.remove(n);
            arrayList.add(n + 1, string);
            ++n;
        }
        this.branchList.setListData((String[])arrayList.toArray(new String[arrayList.size()]));
        this.branchList.setSelectedValue(string, true);
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public String[] getLastBranches() {
        ListModel<String> listModel = this.branchList.getModel();
        String[] stringArray = new String[listModel.getSize()];
        for (int i = 0; i < listModel.getSize(); ++i) {
            stringArray[i] = listModel.getElementAt(i);
        }
        return stringArray;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"Miscellaneous", "Insertion Devices"};
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("AAAA");
            arrayList.add("In Test");
            arrayList.add("Miscellaneous");
            arrayList.add("Insertion Devices");
            arrayList.add("Development");
            new LastBranchesListDialog(null, arrayList, stringArray2).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)devFailed);
            System.exit(0);
        }
    }
}

