/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.tools.DeviceHierarchy;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class DeviceHierarchyDialog
extends JDialog {
    private Component parent;
    private DeviceHierarchy tree = null;
    private String name;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;
    private JTextArea textArea;
    private JLabel titleLabel;

    public DeviceHierarchyDialog(JFrame jFrame, String string) throws DevFailed {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.name = string;
        this.init();
    }

    public DeviceHierarchyDialog(JDialog jDialog, String string) throws DevFailed {
        super((Dialog)jDialog, false);
        this.parent = jDialog;
        this.name = string;
        this.init();
    }

    private void init() throws DevFailed {
        try {
            AstorUtil.startSplash("Device Hierarchy");
            this.initComponents();
            this.initOwnComponents();
            this.titleLabel.setText("Device hierarchy for  " + this.name);
            this.pack();
            if (this.parent != null) {
                Point point = this.parent.getLocation();
                point.translate(40, 30);
                this.setLocation(point);
            }
            AstorUtil.stopSplash();
        }
        catch (DevFailed devFailed) {
            AstorUtil.stopSplash();
            throw devFailed;
        }
    }

    private void initOwnComponents() throws DevFailed {
        if (this.tree != null) {
            this.tree.stopThread();
        }
        Astor astor = null;
        if (this.parent instanceof HostInfoDialog) {
            astor = ((HostInfoDialog)this.parent).getAstorObject();
        }
        this.tree = new DeviceHierarchy(this, astor, this.name);
        this.scrollPane1.setViewportView(this.tree);
        this.scrollPane1.setPreferredSize(new Dimension(400, 400));
        this.scrollPane2.setPreferredSize(new Dimension(400, 400));
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        JSplitPane jSplitPane = new JSplitPane();
        this.scrollPane1 = new JScrollPane();
        this.scrollPane2 = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DeviceHierarchyDialog.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("Dismiss");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceHierarchyDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        jSplitPane.setLeftComponent(this.scrollPane1);
        this.textArea.setColumns(20);
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 1, 12));
        this.textArea.setRows(5);
        this.scrollPane2.setViewportView(this.textArea);
        jSplitPane.setRightComponent(this.scrollPane2);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.pack();
    }

    void setText(String string) {
        this.textArea.setText(string);
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    void update() {
        try {
            AstorUtil.startSplash("Device Hierarchy");
            this.initOwnComponents();
            AstorUtil.stopSplash();
        }
        catch (DevFailed devFailed) {
            AstorUtil.stopSplash();
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void doClose() {
        if (this.parent != null) {
            this.setVisible(false);
            this.tree.stopThread();
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        String string = "VacGaugeServer/sr_c27-ip";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            AstorUtil.getInstance().initIcons();
            DeviceHierarchyDialog deviceHierarchyDialog = new DeviceHierarchyDialog((JFrame)null, string);
            deviceHierarchyDialog.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)devFailed);
        }
    }
}

