/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.PolledElement;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;

public class DevPollStatus
extends ArrayList<PolledElement> {
    private DeviceProxy deviceProxy;
    private boolean pollSeveralAttributes = false;
    private static final boolean FULL_NAME = true;
    private static final boolean ATTR_NAME = false;

    public DevPollStatus(String string) throws DevFailed {
        this.deviceProxy = new DeviceProxy(string).get_adm_dev();
        this.readData(string, false);
    }

    public DevPollStatus(String[] stringArray) throws DevFailed {
        boolean bl = true;
        if (stringArray.length < 2) {
            bl = false;
        }
        for (String string : stringArray) {
            this.deviceProxy = new DeviceProxy(string).get_adm_dev();
            this.readData(this.removeTangoHostIfAny(string), bl);
        }
    }

    public boolean isPollingSeveralAttributes() {
        return this.pollSeveralAttributes;
    }

    private String removeTangoHostIfAny(String string) {
        String string2 = "tango://";
        if (string.startsWith(string2)) {
            string = string.substring(string2.length());
            string = string.substring(string.indexOf(47) + 1);
        }
        return string;
    }

    private void readData(String string, boolean bl) throws DevFailed {
        String[] stringArray;
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.deviceProxy.command_inout("DevPollStatus", deviceData);
        for (String string2 : stringArray = deviceData2.extractStringArray()) {
            if (string2.contains("Time needed for the last attribute") && string2.contains("Time needed for the last attributes")) {
                this.pollSeveralAttributes = true;
            }
            PolledElement polledElement = new PolledElement(string, string2);
            boolean bl2 = false;
            for (int i = 0; !bl2 && i < this.size(); ++i) {
                bl2 = bl ? ((PolledElement)this.get((int)i)).name.toLowerCase().equals(string + "/" + polledElement.name.toLowerCase()) : ((PolledElement)this.get((int)i)).name.toLowerCase().equals(polledElement.name.toLowerCase());
            }
            if (bl2) continue;
            if (bl) {
                polledElement.name = string + "/" + polledElement.name;
            }
            this.add(polledElement);
        }
    }

    public int polledCount() {
        int n = 0;
        for (PolledElement polledElement : this) {
            if (!polledElement.polled) continue;
            ++n;
        }
        return n;
    }

    public int triggeredCount() {
        int n = 0;
        for (PolledElement polledElement : this) {
            if (polledElement.polled) continue;
            ++n;
        }
        return n;
    }

    static void displaySyntax() {
        System.out.println("device name ?");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        } else {
            DevPollStatus.displaySyntax();
        }
        try {
            DevPollStatus devPollStatus = new DevPollStatus(string);
            for (PolledElement polledElement : devPollStatus) {
                String[] stringArray2;
                for (String string2 : stringArray2 = polledElement.getInfo()) {
                    System.out.println(string2);
                }
                System.out.println();
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
            System.exit(1);
        }
        System.exit(0);
    }
}

