/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.ManagePollingDialog;
import admin.astor.tools.DevBrowserTree;
import admin.astor.tools.EventsTable;
import admin.astor.tools.SubscribedSignal;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import jive.MultiLineToolTipUI;

public class DevBrowser
extends JFrame {
    private JFrame parent;
    private DevBrowserTree tree;
    private static EventsTable eventsTable;
    private JMenuItem eventsDlgBtn;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JTextArea textArea;
    private JScrollPane treeScrollPane;
    private JMenu viewMenu;

    public DevBrowser(JFrame jFrame) {
        this.parent = jFrame;
        this.initComponents();
        try {
            this.tree = new DevBrowserTree(this);
            this.treeScrollPane.setViewportView(this.tree);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)jFrame, null, (DevFailed)devFailed);
        }
        this.customizeMenu();
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        MultiLineToolTipUI.initialize();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.viewMenu.setMnemonic('V');
        this.eventsDlgBtn.setMnemonic('E');
        this.eventsDlgBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
    }

    void displayEventProperties(String string) {
        this.tree.displayEventProperties(string);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.treeScrollPane = new JScrollPane();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.eventsDlgBtn = new JMenuItem();
        JMenuItem jMenuItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DevBrowser.this.exitForm(windowEvent);
            }
        });
        jPanel.setLayout(new BorderLayout());
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier New", 1, 12));
        jScrollPane.setViewportView(this.textArea);
        jPanel.add((Component)jScrollPane, "Center");
        this.treeScrollPane.setPreferredSize(new Dimension(350, 400));
        jPanel.add((Component)this.treeScrollPane, "West");
        this.getContentPane().add((Component)jPanel, "Center");
        this.fileMenu.setText("File");
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevBrowser.this.exitBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.eventsDlgBtn.setText("Events Panel");
        this.eventsDlgBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevBrowser.this.eventsDlgBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.eventsDlgBtn);
        jMenuItem.setText("Astor Panel");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevBrowser.this.astorBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(jMenuItem);
        jMenuBar.add(this.viewMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void astorBtnActionPerformed(ActionEvent actionEvent) {
        if (this.parent instanceof Astor) {
            Astor astor = (Astor)this.parent;
            astor.setVisible(true);
        }
    }

    private void eventsDlgBtnActionPerformed(ActionEvent actionEvent) {
        try {
            if (eventsTable == null) {
                eventsTable = new EventsTable(this);
            }
            eventsTable.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.parent instanceof Astor) {
            if (this.parent.isVisible()) {
                this.dispose();
            } else {
                ((Astor)this.parent).doExit();
            }
        } else {
            this.dispose();
        }
    }

    void setText(String string) {
        this.textArea.setText(string);
        this.textArea.setCaretPosition(0);
    }

    public void add(String string, int n) {
        if (eventsTable == null) {
            try {
                eventsTable = new EventsTable(this);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
                return;
            }
        }
        eventsTable.add(string, n);
    }

    void displayHostPanel(String string) {
        if (this.parent instanceof Astor) {
            Astor astor = (Astor)this.parent;
            astor.tree.displayHostInfo(string);
        }
    }

    void managePolling(SubscribedSignal subscribedSignal) {
        try {
            new ManagePollingDialog(this, subscribedSignal.deviceName, subscribedSignal.attributeName).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    void managePolling(String string) {
        try {
            new ManagePollingDialog(this, string, "").setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    void managePolling(DeviceProxy deviceProxy, String string) {
        try {
            new ManagePollingDialog(this, deviceProxy.name(), string).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Astor astor = new Astor();
            DevBrowser devBrowser = new DevBrowser(astor);
            devBrowser.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
        }
    }
}

