/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.RemoteLoginThread;
import admin.astor.tools.TopDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.DeviceProxyFactory;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class BlackBoxTable
extends JDialog {
    private String deviceName;
    private Component parent;
    private DataTableModel model;
    private BlackBox blackbox = null;
    private UpdateThread thread;
    private JDialog table_dialog;
    private FilterDialog filter_dlg = null;
    private TopDialog top_dialog = null;
    private boolean auto_update = false;
    private boolean clearBlackBox = false;
    private int upd_period = 1000;
    private TablePopupMenu menu;
    private final Column[] columns = new Column[]{new Column("Date", 170), new Column("Operation", 150), new Column("Name", 130), new Column("Source", 100), new Column("Host", 130), new Column("Process", 220)};
    static final int DATES = 0;
    static final int OPERATION = 1;
    static final int HOST = 4;
    static final int PROCESS = 5;
    private static final int height = 400;
    private JRadioButton autoUpdateBtn;
    private JLabel filterLabel;
    private JLabel titleLabel;
    private JTextField updPeriodTxt;
    private JLabel warningLbl;

    public BlackBoxTable(JFrame jFrame, String string) throws DevFailed {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.initDialog(string);
    }

    public BlackBoxTable(JDialog jDialog, String string) throws DevFailed {
        super((Dialog)jDialog, false);
        this.parent = jDialog;
        this.initDialog(string);
    }

    private void initDialog(String string) throws DevFailed {
        this.deviceName = string;
        this.table_dialog = this;
        this.blackbox = new BlackBox();
        this.initComponents();
        int n = 0;
        for (Column column : this.columns) {
            n += column.width;
        }
        try {
            this.model = new DataTableModel();
            JTable jTable = new JTable(this.model){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    String string = null;
                    if (this.isVisible()) {
                        Point point = mouseEvent.getPoint();
                        int n = this.rowAtPoint(point);
                        if (BlackBoxTable.this.blackbox != null) {
                            string = BlackBoxTable.this.blackbox.getCodeLine(n);
                        }
                    }
                    return string;
                }
            };
            jTable.setRowSelectionAllowed(true);
            jTable.setColumnSelectionAllowed(true);
            jTable.setDragEnabled(false);
            jTable.setSelectionMode(0);
            jTable.getTableHeader().setFont(new Font("Dialog", 1, 14));
            jTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    BlackBoxTable.this.tableActionPerformed(mouseEvent);
                }
            });
            this.menu = new TablePopupMenu(jTable);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jScrollPane.setPreferredSize(new Dimension(n, 400));
            this.setColumnWidth(jTable);
            this.getContentPane().add((Component)jScrollPane, "Center");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)exception.toString(), (String)"PopupTable.initMyComponents()");
        }
        this.thread = new UpdateThread();
        this.thread.start();
        this.titleLabel.setText("Black box on  " + string);
        this.updPeriodTxt.setText(Integer.toString(this.upd_period));
        this.warningLbl.setVisible(false);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void tableActionPerformed(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        int n = jTable.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        int n2 = jTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        if (n != 4) {
            return;
        }
        String string = this.blackbox.toString(n2, n);
        if (!string.equals("polling")) {
            this.menu.showMenu(mouseEvent, string);
        }
    }

    private void setColumnWidth(JTable jTable) {
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        for (int i = 0; i < this.columns.length && enumeration.hasMoreElements(); ++i) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(this.columns[i].width);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.autoUpdateBtn = new JRadioButton();
        JLabel jLabel = new JLabel();
        this.updPeriodTxt = new JTextField();
        JButton jButton2 = new JButton();
        JSeparator jSeparator = new JSeparator();
        this.filterLabel = new JLabel();
        JButton jButton3 = new JButton();
        JButton jButton4 = new JButton();
        this.warningLbl = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BlackBoxTable.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("Dismiss");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlackBoxTable.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        jPanel3.setLayout(new GridBagLayout());
        this.autoUpdateBtn.setText("Update");
        this.autoUpdateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlackBoxTable.this.autoUpdateBtnActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this.autoUpdateBtn, gridBagConstraints);
        jLabel.setText("Period (milli sec):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        this.updPeriodTxt.setColumns(8);
        this.updPeriodTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlackBoxTable.this.updPeriodTxtActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel3.add((Component)this.updPeriodTxt, gridBagConstraints);
        jButton2.setText("Filter");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlackBoxTable.this.filterBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        jPanel3.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        jPanel3.add((Component)jSeparator, gridBagConstraints);
        this.filterLabel.setText("none");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this.filterLabel, gridBagConstraints);
        jButton3.setText("Top");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlackBoxTable.this.topBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 10, 0);
        jPanel3.add((Component)jButton3, gridBagConstraints);
        jButton4.setText("Clear");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BlackBoxTable.this.clearBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel3.add((Component)jButton4, gridBagConstraints);
        this.warningLbl.setForeground(new Color(255, 51, 0));
        this.warningLbl.setText("!!!  Warning  !!!");
        this.warningLbl.setToolTipText("Lines could have been lost !!!  Check update period.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        jPanel3.add((Component)this.warningLbl, gridBagConstraints);
        this.getContentPane().add((Component)jPanel3, "West");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void autoUpdateBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.auto_update = this.autoUpdateBtn.getSelectedObjects() != null;
        if (this.auto_update) {
            this.checkUpdatePeriode();
        }
    }

    private void manageWarningButton(boolean bl) {
        if (this.blackbox.size() > 0) {
            this.warningLbl.setVisible(!bl);
        } else {
            this.warningLbl.setVisible(false);
        }
    }

    private void checkUpdatePeriode() {
        String string = this.updPeriodTxt.getText().trim();
        try {
            int n = Integer.parseInt(string);
            if (n < 100) {
                n = 100;
            }
            this.updPeriodTxt.setText(Integer.toString(n));
            if (n != this.upd_period) {
                this.upd_period = n;
                this.thread.wakeUp();
            }
        }
        catch (NumberFormatException numberFormatException) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)numberFormatException);
        }
    }

    private void updPeriodTxtActionPerformed(ActionEvent actionEvent) {
        this.checkUpdatePeriode();
    }

    private void filterBtnActionPerformed(ActionEvent actionEvent) {
        if (this.filter_dlg == null) {
            this.filter_dlg = new FilterDialog(this);
        }
        if (this.filter_dlg.showDialog() == 0) {
            Filter filter = this.filter_dlg.getFilter();
            this.blackbox.setFilter(filter);
            if (filter != null) {
                this.filterLabel.setText(filter.toString());
            } else {
                this.filterLabel.setText("none");
            }
            if (this.top_dialog != null && this.top_dialog.isVisible()) {
                this.top_dialog.displayTop();
            }
        }
    }

    private void topBtnActionPerformed(ActionEvent actionEvent) {
        if (this.top_dialog == null) {
            this.top_dialog = new TopDialog(this, this.deviceName, this.blackbox);
        }
        this.top_dialog.showDialog();
    }

    private void clearBtnActionPerformed(ActionEvent actionEvent) {
        this.clearBlackBox = true;
        this.thread.wakeUp();
    }

    private void doClose() {
        this.thread.stopThread();
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.auto_update = false;
            this.autoUpdateBtn.setSelected(false);
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] stringArray) {
        String string = "sys/database/3";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            new BlackBoxTable((JFrame)null, string).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new Frame(), (String)"", (DevFailed)devFailed);
        }
    }

    public class FilterDialog
    extends JDialog {
        private List<JRadioButton> buttons;
        private JPanel txtPanel;
        private JTextField strFilterTxt;
        private JLabel titleLabel;
        private int retVal;

        public FilterDialog(JDialog jDialog) {
            GridBagConstraints gridBagConstraints;
            super((Dialog)jDialog, true);
            this.buttons = new ArrayList<JRadioButton>();
            this.retVal = 0;
            this.initComponents();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.getContentPane().add((Component)jPanel, "Center");
            int n = 0;
            for (int i = 1; i < BlackBoxTable.this.columns.length; ++i) {
                JRadioButton jRadioButton = new JRadioButton(((BlackBoxTable)BlackBoxTable.this).columns[i].name);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 2;
                jPanel.add((Component)jRadioButton, gridBagConstraints);
                jRadioButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FilterDialog.this.btnActionPerformed(actionEvent);
                    }
                });
                this.buttons.add(jRadioButton);
            }
            this.txtPanel = new JPanel();
            this.txtPanel.add(new JLabel("Filter: "));
            this.strFilterTxt = new JTextField();
            this.strFilterTxt.setColumns(15);
            this.txtPanel.add(this.strFilterTxt);
            this.strFilterTxt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FilterDialog.this.strFilterTxtActionPerformed(actionEvent);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.txtPanel, gridBagConstraints);
            this.txtPanel.setVisible(false);
            this.titleLabel.setText("Filtering  Black  Box Content ");
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        private void initComponents() {
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton();
            JButton jButton2 = new JButton();
            JPanel jPanel2 = new JPanel();
            this.titleLabel = new JLabel();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    FilterDialog.this.closeDialog(windowEvent);
                }
            });
            jButton2.setText("OK");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FilterDialog.this.okBtnActionPerformed(actionEvent);
                }
            });
            jPanel.add(jButton2);
            jButton.setText("Dismiss");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FilterDialog.this.cancelBtnActionPerformed(actionEvent);
                }
            });
            jPanel.add(jButton);
            this.getContentPane().add((Component)jPanel, "South");
            this.titleLabel.setFont(new Font("Dialog", 1, 18));
            this.titleLabel.setText("Dialog Title");
            jPanel2.add(this.titleLabel);
            this.getContentPane().add((Component)jPanel2, "North");
        }

        private void strFilterTxtActionPerformed(ActionEvent actionEvent) {
            this.okBtnActionPerformed(actionEvent);
        }

        Filter getFilter() {
            int n = -1;
            for (int i = 0; i < this.buttons.size(); ++i) {
                if (this.buttons.get(i).getSelectedObjects() == null) continue;
                n = i;
            }
            if (n == -1) {
                return null;
            }
            String string = this.strFilterTxt.getText().trim();
            if (string.length() > 0) {
                return new Filter(n + 1, string);
            }
            return null;
        }

        private void btnActionPerformed(ActionEvent actionEvent) {
            boolean bl;
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            boolean bl2 = bl = jRadioButton.getSelectedObjects() != null;
            if (bl) {
                for (JRadioButton jRadioButton2 : this.buttons) {
                    if (jRadioButton2 == jRadioButton) continue;
                    jRadioButton2.setSelected(false);
                }
            }
            bl = false;
            for (JRadioButton jRadioButton2 : this.buttons) {
                if (jRadioButton2.getSelectedObjects() == null) continue;
                bl = true;
            }
            this.txtPanel.setVisible(bl);
            if (bl) {
                this.strFilterTxt.requestFocus();
                this.strFilterTxt.selectAll();
            }
            this.pack();
        }

        private void okBtnActionPerformed(ActionEvent actionEvent) {
            this.retVal = 0;
            this.doClose();
        }

        private void cancelBtnActionPerformed(ActionEvent actionEvent) {
            this.retVal = 2;
            this.doClose();
        }

        private void closeDialog(WindowEvent windowEvent) {
            this.retVal = 2;
            this.doClose();
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }

        public int showDialog() {
            this.strFilterTxt.requestFocus();
            this.strFilterTxt.selectAll();
            this.setVisible(true);
            return this.retVal;
        }
    }

    class TablePopupMenu
    extends JPopupMenu {
        private JTable table;
        private String hostname = null;
        private final String[] menuLabels = new String[]{"Host Panel", "Remote Login"};
        private final int OFFSET = 2;
        private final int HOST_PANEL = 0;
        private final int REMOTE_LOG = 1;

        private TablePopupMenu(JTable jTable) {
            this.table = jTable;
            JLabel jLabel = new JLabel("Datbase Server :");
            jLabel.setFont(new Font("Dialog", 1, 16));
            this.add(jLabel);
            this.add(new JPopupMenu.Separator());
            for (String string : this.menuLabels) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TablePopupMenu.this.popupActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
            this.getComponent(3).setEnabled(AstorUtil.osIsUnix());
        }

        public void showMenu(MouseEvent mouseEvent, String string) {
            this.hostname = string;
            JLabel jLabel = (JLabel)this.getComponent(0);
            jLabel.setText(string + "  :");
            this.show(this.table, mouseEvent.getX(), mouseEvent.getY());
        }

        private void popupActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    if (BlackBoxTable.this.parent instanceof Astor) {
                        ((Astor)((BlackBoxTable)BlackBoxTable.this).parent).tree.displayHostInfoDialog(this.hostname);
                        break;
                    }
                    if (!(BlackBoxTable.this.parent instanceof HostInfoDialog)) break;
                    ((HostInfoDialog)BlackBoxTable.this.parent).displayHostInfoDialog(this.hostname);
                    break;
                }
                case 1: {
                    new RemoteLoginThread(this.hostname, BlackBoxTable.this.parent).start();
                }
            }
        }
    }

    private class UpdateThread
    extends Thread {
        private boolean stop = false;

        private UpdateThread() {
        }

        private void stopThread() {
            this.stop = true;
            this.wakeUp();
        }

        private synchronized void wakeUp() {
            this.notify();
        }

        private synchronized void waitNextLoop(long l) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            DeviceProxy deviceProxy = null;
            boolean bl = true;
            while (!this.stop) {
                block5: {
                    if (bl || BlackBoxTable.this.auto_update) {
                        bl = false;
                        try {
                            if (deviceProxy == null) {
                                deviceProxy = DeviceProxyFactory.get((String)BlackBoxTable.this.deviceName);
                            }
                            String[] stringArray = deviceProxy.black_box(100);
                            BlackBoxTable.this.blackbox.update(stringArray);
                            BlackBoxTable.this.model.fireTableDataChanged();
                            BlackBoxTable.this.titleLabel.setText(BlackBoxTable.this.deviceName + " - " + BlackBoxTable.this.blackbox.getDeltaTimeStr());
                        }
                        catch (DevFailed devFailed) {
                            if (devFailed.errors[0].reason.equals("API_BlackBoxEmpty")) break block5;
                            ErrorPane.showErrorMessage((Component)BlackBoxTable.this.table_dialog, (String)"", (DevFailed)devFailed);
                        }
                    }
                }
                this.waitNextLoop(BlackBoxTable.this.upd_period);
                if (!BlackBoxTable.this.isVisible() || !BlackBoxTable.this.clearBlackBox) continue;
                BlackBoxTable.this.blackbox.clear();
                BlackBoxTable.this.clearBlackBox = false;
                BlackBoxTable.this.blackbox.update(new String[0]);
                BlackBoxTable.this.model.fireTableDataChanged();
                BlackBoxTable.this.titleLabel.setText("Black box on  " + BlackBoxTable.this.deviceName);
            }
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return BlackBoxTable.this.columns.length;
        }

        @Override
        public String getColumnName(int n) {
            if (n >= this.getColumnCount()) {
                return ((BlackBoxTable)BlackBoxTable.this).columns[this.getColumnCount() - 1].name;
            }
            return ((BlackBoxTable)BlackBoxTable.this).columns[n].name;
        }

        @Override
        public int getRowCount() {
            if (BlackBoxTable.this.blackbox == null) {
                return 0;
            }
            return BlackBoxTable.this.blackbox.nbRecords();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return BlackBoxTable.this.blackbox.toString(n, n2);
        }
    }

    private class Filter {
        private int col_idx;
        private String str;

        private Filter(int n, String string) {
            this.col_idx = n;
            this.str = string;
        }

        public String toString() {
            return ((BlackBoxTable)BlackBoxTable.this).columns[this.col_idx].name + ":  " + this.str;
        }
    }

    class BlackBox
    extends ArrayList<ArrayList<String>> {
        private List<ArrayList<String>> filtered;
        private Filter filter = null;
        private List<String> code = new ArrayList<String>();
        private List<String> filtered_code;
        private double delta_time = 0.0;

        private BlackBox() {
            this.filtered = new ArrayList<ArrayList<String>>();
            this.filtered_code = new ArrayList<String>();
        }

        private void setFilter(Filter filter) {
            this.filter = filter;
            if (filter != null) {
                this.filterContent();
            }
            BlackBoxTable.this.model.fireTableDataChanged();
        }

        private void filterContent() {
            this.filtered.clear();
            this.filtered_code.clear();
            for (int i = 0; i < this.size(); ++i) {
                ArrayList arrayList = (ArrayList)this.get(i);
                String string = (String)arrayList.get(this.filter.col_idx);
                if (!string.contains(this.filter.str)) continue;
                this.filtered.add(arrayList);
                this.filtered_code.add(this.code.get(i));
            }
        }

        ArrayList<String> getLine(int n) {
            if (this.filter == null) {
                return (ArrayList)this.get(n);
            }
            return this.filtered.get(n);
        }

        int nbRecords() {
            if (this.filter == null) {
                return this.size();
            }
            return this.filtered.size();
        }

        String getDeltaTimeStr() {
            int n = (int)this.delta_time;
            StringBuilder stringBuilder = new StringBuilder("");
            int n2 = 0;
            int n3 = 0;
            int n4 = (int)(1000.0 * (this.delta_time - (double)n));
            if (n > 3600) {
                n2 = n / 3600;
                if (n2 < 10) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(Integer.toString(n2)).append(":");
                n -= 3600 * n2;
            }
            if (n >= 60) {
                n3 = n / 60;
                if (n3 < 10) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(Integer.toString(n3)).append(":");
                n -= 60 * n3;
            } else if (n2 > 0) {
                stringBuilder.append("00:");
            }
            if (n > 0) {
                int n5 = n;
                if (n5 < 10) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(Integer.toString(n5)).append(".");
            } else {
                stringBuilder.append("00.");
            }
            stringBuilder.append(Integer.toString(n4));
            if (n2 == 0 && n3 == 0) {
                stringBuilder.append(" sec.");
            }
            return stringBuilder.toString();
        }

        double getDeltaTime() {
            double d;
            String[] stringArray = this.getDates();
            double d2 = this.parseTime(stringArray[0]);
            for (d = this.parseTime(stringArray[1]); d < d2; d += 86400.0) {
            }
            return d - d2;
        }

        private double parseTime(String string) {
            if (string.length() == 0) {
                return 0.0;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            if (arrayList.size() < 4) {
                return 0.0;
            }
            double d = 0.0;
            try {
                d = 3600.0 * (double)Integer.parseInt((String)arrayList.get(0));
                d += 60.0 * (double)Integer.parseInt((String)arrayList.get(1));
                d += 1.0 * (double)Integer.parseInt((String)arrayList.get(2));
                d += 1.0 * (double)Integer.parseInt((String)arrayList.get(3)) / 100.0;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(numberFormatException.toString());
            }
            return d;
        }

        String[] getDates() {
            if (this.size() == 0) {
                return new String[]{"", ""};
            }
            String string = (String)((ArrayList)this.get(this.size() - 1)).get(0);
            String string2 = (String)((ArrayList)this.get(0)).get(0);
            int n = string.indexOf(32);
            if (n > 0) {
                string = string.substring(n).trim();
            }
            if ((n = string2.indexOf(32)) > 0) {
                string2 = string2.substring(n).trim();
            }
            return new String[]{string, string2};
        }

        private void update(String[] stringArray) {
            ArrayList<ArrayList<String>> arrayList = this.parseContent(stringArray);
            boolean bl = false;
            if (this.size() > 0) {
                ArrayList arrayList2 = (ArrayList)this.get(0);
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    ArrayList arrayList3 = (ArrayList)arrayList.get(i);
                    if (bl) {
                        this.add(0, arrayList3);
                        this.code.add(0, stringArray[i]);
                        continue;
                    }
                    boolean bl2 = false;
                    for (int j = 0; !bl2 && j < arrayList3.size() && j < arrayList2.size(); ++j) {
                        bl2 = !((String)arrayList3.get(j)).equals(arrayList2.get(j));
                    }
                    bl = !bl2;
                }
            } else {
                bl = true;
            }
            if (!bl || this.size() == 0) {
                this.addRecords(arrayList, stringArray);
            }
            BlackBoxTable.this.manageWarningButton(bl);
            if (this.filter != null) {
                this.filterContent();
            }
            if (BlackBoxTable.this.top_dialog != null && BlackBoxTable.this.top_dialog.isVisible()) {
                BlackBoxTable.this.top_dialog.displayTop();
            }
            this.delta_time = this.getDeltaTime();
        }

        private void addRecords(List<ArrayList<String>> list, String[] stringArray) {
            int n = stringArray.length - 1;
            if (list.size() > 0) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    this.add(0, list.get(i));
                    while (n >= 0 && stringArray[n].indexOf("Operation blackbox") > 0) {
                        --n;
                    }
                    this.code.add(0, stringArray[n--]);
                }
            }
        }

        private ArrayList<ArrayList<String>> parseContent(String[] stringArray) {
            ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
            for (String string : stringArray) {
                String string2;
                String string3;
                ArrayList<String> arrayList2 = new ArrayList<String>(BlackBoxTable.this.columns.length);
                String string4 = this.getDate(string);
                int n = string4.length() + 3;
                String string5 = this.getNextWord(string, n);
                n += string5.length() + 1;
                if (string5.equals("Attribute")) {
                    string5 = "CORBA " + string5;
                }
                if (string5.equals("Operation")) {
                    string3 = this.getNextWord(string, n);
                    n += string3.length() + 1;
                } else {
                    string3 = string5;
                }
                String string6 = "";
                if (!(string3.startsWith("command_list_query") || string3.startsWith("get_attribute_config") || string3.startsWith("ping") || string3.startsWith("adm_name"))) {
                    do {
                        string2 = this.getNextWord(string, n);
                        n += string2.length() + 1;
                        string6 = string6 + " " + string2;
                    } while (string2.endsWith(","));
                    if ((string6 = string6.trim()).equals("cmd")) {
                        for (int i = 0; i < 2; ++i) {
                            string6 = this.getNextWord(string, n);
                            n += string6.length() + 1;
                        }
                    }
                }
                string2 = "device";
                if (string.indexOf("from cache_device") > 0) {
                    string2 = "cache_device";
                } else if (string.indexOf("from cache") > 0) {
                    string2 = "cache ";
                }
                String string7 = "";
                n = string.indexOf("requested from ");
                if (n > 0) {
                    if (string.indexOf("requested form polling") > 0) {
                        string7 = "polling";
                    } else {
                        string7 = this.getNextWord(string, n + "requested from ".length());
                        int n2 = string7.indexOf(46);
                        if (n2 > 0) {
                            string7 = string7.substring(0, n2);
                        }
                    }
                }
                String string8 = this.getProcess(string);
                if (string3.equals("blackbox")) continue;
                arrayList2.add(string4);
                arrayList2.add(string3);
                arrayList2.add(string6);
                arrayList2.add(string2);
                arrayList2.add(string7);
                arrayList2.add(string8);
                arrayList.add(arrayList2);
            }
            return arrayList;
        }

        private String getProcess(String string) {
            String string2 = "";
            String string3 = "java client with main class";
            String string4 = "cpp/python client with pid";
            int n = string.toLowerCase().indexOf(string3);
            if (n > 0) {
                string2 = string.substring(n + string3.length());
                if ((n = string2.indexOf(41)) > 0) {
                    string2 = string2.substring(0, n);
                }
            } else {
                n = string.toLowerCase().indexOf(string4);
                if (n > 0) {
                    string2 = "PID=" + this.getNextWord(string, n + string4.length());
                }
            }
            return string2.trim();
        }

        private String getNextWord(String string, int n) {
            StringTokenizer stringTokenizer = new StringTokenizer(string = string.substring(n));
            if (stringTokenizer.hasMoreTokens()) {
                int n2;
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("(")) {
                    string2 = string2.substring(1);
                }
                if ((n2 = string2.indexOf(41)) > 0) {
                    string2 = string2.substring(0, n2);
                }
                return string2;
            }
            return "";
        }

        private String getDate(String string) {
            int n = 0;
            for (int i = 0; n >= 0 && i < 4; ++i) {
                n = string.indexOf(58, n + 1);
            }
            if (n < 0) {
                return "";
            }
            return string.substring(0, n).trim();
        }

        private String getCodeLine(int n) {
            if (this.filter == null) {
                return this.code.get(n);
            }
            if (n < 0 || n > this.filtered_code.size() - 1) {
                return "row = " + n + "???";
            }
            return this.filtered_code.get(n);
        }

        public String toString(int n, int n2) {
            if (n < 0 || n2 < 0) {
                return "";
            }
            if (this.filter == null) {
                return (String)((ArrayList)this.get(n)).get(n2);
            }
            return this.filtered.get(n).get(n2);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (ArrayList arrayList : this) {
                for (String string : arrayList) {
                    stringBuilder.append(string).append('\t');
                }
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
    }

    private class Column {
        String name;
        int width;

        Column(String string, int n) {
            this.name = string;
            this.width = n;
        }
    }
}

