/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import admin.astor.AstorUtil;
import admin.astor.tango_release.TangoClassRelease;
import admin.astor.tango_release.TangoServerRelease;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TangoServerReleaseList
extends ArrayList<TangoServerRelease> {
    private List<TangoServerRelease> onErrors = new ArrayList<TangoServerRelease>();
    private static final int idlMin = 2;
    private static final int idlMax = 10;

    public TangoServerReleaseList(List<String> list) {
        Collections.sort(list, new StringComparator());
        int n = 0;
        for (String string : list) {
            double d = (double)n / (double)list.size();
            AstorUtil.increaseSplashProgress(d, "Check " + ++n + "/" + list.size() + " - " + string);
            TangoServerRelease tangoServerRelease = new TangoServerRelease(string);
            if (tangoServerRelease.releaseNumber > 0.0) {
                this.add(tangoServerRelease);
            } else {
                this.onErrors.add(tangoServerRelease);
            }
            if (!AstorUtil.osIsUnix() || n % 920 != 0) continue;
            for (int i = 180; i > 0; --i) {
                AstorUtil.setSplashMessage("Waiting " + i + " sec.");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public int nbClasses() {
        int n = 0;
        for (int i = 2; i <= 10; ++i) {
            List<TangoClassRelease> list = this.getClassesForIdlRelease(i);
            n += list.size();
        }
        return n;
    }

    public List<TangoServerRelease> getServersForTangoRelease(double d) {
        ArrayList<TangoServerRelease> arrayList = new ArrayList<TangoServerRelease>();
        for (TangoServerRelease tangoServerRelease : this) {
            int n = (int)(10.0 * tangoServerRelease.releaseNumber);
            int n2 = (int)(10.0 * d);
            if (n != n2) continue;
            arrayList.add(tangoServerRelease);
        }
        return arrayList;
    }

    public List<TangoServerRelease> getServersForIdlRelease(int n) {
        ArrayList<TangoServerRelease> arrayList = new ArrayList<TangoServerRelease>();
        for (TangoServerRelease tangoServerRelease : this) {
            if (!tangoServerRelease.hasIDL(n)) continue;
            arrayList.add(tangoServerRelease);
        }
        return arrayList;
    }

    public List<TangoClassRelease> getClassesForIdlRelease(int n) {
        ArrayList<TangoClassRelease> arrayList = new ArrayList<TangoClassRelease>();
        for (TangoServerRelease tangoServerRelease : this) {
            List<TangoClassRelease> list = tangoServerRelease.getIdlClasses(n);
            for (TangoClassRelease tangoClassRelease : list) {
                boolean bl = false;
                for (TangoClassRelease tangoClassRelease2 : arrayList) {
                    if (!tangoClassRelease2.className.equals(tangoClassRelease.className)) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(tangoClassRelease);
            }
        }
        Collections.sort(arrayList, new ClassComparator());
        return arrayList;
    }

    public List<TangoServerRelease> getServersOnError() {
        return this.onErrors;
    }

    public String toString(List<TangoServerRelease> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TangoServerRelease tangoServerRelease : list) {
            stringBuilder.append(tangoServerRelease.toStringFull()).append("\n");
        }
        return stringBuilder.toString();
    }

    public String toString(double d) {
        return this.toString(this.getServersForTangoRelease(d));
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        List<TangoClassRelease> list = this.getClassesForIdlRelease(n);
        for (TangoClassRelease tangoClassRelease : list) {
            stringBuilder.append(tangoClassRelease).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.toString(this);
    }

    public static void main(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("VacGaugeServer/sr_c1-pen");
        arrayList.add("VacGaugeServer/sr_c1-ip");
        arrayList.add("PLCvacuumValve/sr_c01");
        arrayList.add("Starter/l-c01-1");
        try {
            TangoServerReleaseList tangoServerReleaseList = new TangoServerReleaseList((List<String>)arrayList);
            System.out.println(tangoServerReleaseList.toString(4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareTo(string2);
        }
    }

    class ClassComparator
    implements Comparator<TangoClassRelease> {
        ClassComparator() {
        }

        @Override
        public int compare(TangoClassRelease tangoClassRelease, TangoClassRelease tangoClassRelease2) {
            return tangoClassRelease.className.compareTo(tangoClassRelease2.className);
        }
    }

    class ServerComparator
    implements Comparator<TangoServerRelease> {
        ServerComparator() {
        }

        @Override
        public int compare(TangoServerRelease tangoServerRelease, TangoServerRelease tangoServerRelease2) {
            return tangoServerRelease.name.compareTo(tangoServerRelease2.name);
        }
    }
}

