/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.tango_release.TangoClassRelease;
import admin.astor.tango_release.TangoServerRelease;
import admin.astor.tango_release.TangoServerReleaseList;
import admin.astor.tools.PopupText;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TangoReleaseTree
extends JTree
implements TangoConst {
    private JFrame appli;
    private DefaultMutableTreeNode root;
    private TangoReleaseTreePopupMenu menu;
    private int mode;
    private TangoServerReleaseList serverReleaseList;
    private static JFileChooser fileChooser = null;
    private static final double[] tangoReleases = new double[]{1.0, 2.0, 5.0, 5.2, 7.0, 8.0, 8.1};
    private static final int[] idlReleases = new int[]{1, 2, 3, 4, 5};
    private static ImageIcon networkIcon;
    private static ImageIcon tangoIcon;
    private static ImageIcon serverIcon;
    private static ImageIcon classIcon;
    private static final int ROOT_OPTION = 0;
    private static final int IN_TEXT_AREA = 1;
    private static final int SAVE = 2;
    private static final int OPEN_PANEL = 3;
    private static final int OFFSET = 2;
    private static String[] menuLabels;

    public TangoReleaseTree(JFrame jFrame, String string, TangoServerReleaseList tangoServerReleaseList, int n) {
        this.appli = jFrame;
        this.mode = n;
        this.serverReleaseList = tangoServerReleaseList;
        networkIcon = Utils.getInstance().getIcon("TangoClass.gif", 0.33);
        tangoIcon = Utils.getInstance().getIcon("TangoClass.gif", 0.125);
        serverIcon = Utils.getInstance().getIcon("server.gif");
        classIcon = Utils.getInstance().getIcon("class.gif");
        this.buildTree(string);
        this.menu = new TangoReleaseTreePopupMenu(this);
        this.setSelectionPath(null);
        fileChooser = new JFileChooser(new File("").getAbsolutePath());
    }

    private void buildTree(String string) {
        this.root = new DefaultMutableTreeNode(string);
        this.createCollectionClassNodes();
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.root);
        this.setModel(defaultTreeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer tangoRenderer = new TangoRenderer();
        this.setCellRenderer(tangoRenderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TangoReleaseTree.this.expandedPerformed(treeExpansionEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TangoReleaseTree.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        if ((n & 4) != 0) {
            if (object instanceof ServerCollectionClass) {
                this.menu.showMenu(mouseEvent, (ServerCollectionClass)object);
            } else if (object instanceof IdlCollectionClass) {
                this.menu.showMenu(mouseEvent, (IdlCollectionClass)object);
            } else if (object instanceof Executable) {
                this.menu.showMenu(mouseEvent, (Executable)object);
            } else if (object instanceof Instance && this.appli instanceof Astor) {
                this.menu.showMenu(mouseEvent, (Instance)object);
            }
        }
    }

    public void expandedPerformed(TreeExpansionEvent treeExpansionEvent) {
    }

    private List<ServerCollectionClass> initCollectionsByTangoRelease() {
        ArrayList<ServerCollectionClass> arrayList = new ArrayList<ServerCollectionClass>();
        for (double d : tangoReleases) {
            List<TangoServerRelease> list = this.serverReleaseList.getServersForTangoRelease(d);
            if (list.size() <= 0) continue;
            String string = "Tango-" + d;
            if (d == 7.0) {
                string = "Tango-7.x";
            } else if (d == 5.2) {
                string = string + " or 6.x";
            }
            arrayList.add(new ServerCollectionClass(string, list));
        }
        for (int i = 90; i < 150; ++i) {
            double d = 0.1 * (double)i;
            List<TangoServerRelease> list = this.serverReleaseList.getServersForTangoRelease(d);
            if (list.size() <= 0) continue;
            String string = "Tango-" + d;
            arrayList.add(new ServerCollectionClass(string, list));
        }
        List<TangoServerRelease> list = this.serverReleaseList.getServersOnError();
        if (list.size() > 0) {
            arrayList.add(new ServerCollectionClass("Failed", list));
        }
        return arrayList;
    }

    private List<IdlCollectionClass> initCollectionsByIdlRelease() {
        ArrayList<IdlCollectionClass> arrayList = new ArrayList<IdlCollectionClass>();
        for (int n : idlReleases) {
            List<TangoClassRelease> list = this.serverReleaseList.getClassesForIdlRelease(n);
            if (list.size() <= 0) continue;
            arrayList.add(new IdlCollectionClass("Device_" + n + "Impl", list));
        }
        return arrayList;
    }

    private void createCollectionClassNodes() {
        switch (this.mode) {
            case 0: {
                List<ServerCollectionClass> list = this.initCollectionsByTangoRelease();
                for (ServerCollectionClass serverCollectionClass : list) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(serverCollectionClass);
                    this.root.add(defaultMutableTreeNode);
                    HashMap<String, DefaultMutableTreeNode> hashMap = new HashMap<String, DefaultMutableTreeNode>();
                    for (TangoServerRelease tangoServerRelease : serverCollectionClass.servers) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(tangoServerRelease.exeName);
                        if (defaultMutableTreeNode2 == null) {
                            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new Executable(tangoServerRelease.exeName));
                            hashMap.put(tangoServerRelease.exeName, defaultMutableTreeNode2);
                            defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        }
                        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new Instance(tangoServerRelease));
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                        for (TangoClassRelease tangoClassRelease : tangoServerRelease) {
                            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(tangoClassRelease));
                        }
                    }
                }
                break;
            }
            case 1: {
                List<IdlCollectionClass> list = this.initCollectionsByIdlRelease();
                for (IdlCollectionClass idlCollectionClass : list) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(idlCollectionClass);
                    this.root.add(defaultMutableTreeNode);
                    for (TangoClassRelease tangoClassRelease : idlCollectionClass.classes) {
                        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(tangoClassRelease);
                        defaultMutableTreeNode.add(defaultMutableTreeNode4);
                        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(tangoClassRelease.serverName));
                    }
                }
                break;
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode.getUserObject();
    }

    private void expandChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = false;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) {
                if (bl) continue;
                this.expandNode(defaultMutableTreeNode2);
                bl = true;
                continue;
            }
            this.expandChildren(defaultMutableTreeNode2);
        }
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        arrayList.add(defaultMutableTreeNode);
        while (defaultMutableTreeNode != this.root) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            arrayList.add(0, defaultMutableTreeNode);
        }
        Object[] objectArray = arrayList.toArray(new TreeNode[arrayList.size()]);
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void saveCollection() {
        File file;
        if (fileChooser.showOpenDialog(this) == 0 && (file = fileChooser.getSelectedFile()) != null && !file.isDirectory()) {
            String string = file.getAbsolutePath();
            if (new File(string).exists() && JOptionPane.showConfirmDialog(this, "The File " + string + "  Already Exists !\n\n" + "Would you like to overwrite ?", "information", 0) != 0) {
                return;
            }
            String string2 = this.getSelectedObject().toString();
            String string3 = string2 + "\n\n" + this.getCollectionText();
            try {
                AstorUtil.writeFile(string, string3);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    private void displayCollection() {
        String string = this.getSelectedObject().toString();
        String string2 = this.getCollectionText();
        PopupText popupText = new PopupText((Frame)this.appli, true);
        popupText.setTitle(string);
        popupText.addText(string2);
        popupText.setSize(400, 500);
        ATKGraphicsUtils.centerDialog((Dialog)popupText);
        popupText.setVisible(true);
    }

    private String getCollectionText() {
        StringBuilder stringBuilder;
        block5: {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode;
            block6: {
                block4: {
                    defaultMutableTreeNode = this.getSelectedNode();
                    stringBuilder = new StringBuilder();
                    object = defaultMutableTreeNode.getUserObject();
                    if (!(object instanceof ServerCollectionClass)) break block4;
                    for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                        for (int j = 0; j < defaultMutableTreeNode2.getChildCount(); ++j) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(j);
                            TangoServerRelease tangoServerRelease = ((Instance)defaultMutableTreeNode3.getUserObject()).server;
                            stringBuilder.append(tangoServerRelease.toStringFull()).append("\n");
                        }
                    }
                    break block5;
                }
                if (!(object instanceof IdlCollectionClass)) break block6;
                for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    stringBuilder.append(defaultMutableTreeNode4.toString()).append("\n");
                }
                break block5;
            }
            if (!(object instanceof Executable)) break block5;
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                TangoServerRelease tangoServerRelease = ((Instance)defaultMutableTreeNode5.getUserObject()).server;
                stringBuilder.append(tangoServerRelease.toStringFull()).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    static {
        menuLabels = new String[]{"Root Options", "Display in Text Area", "Save", "Open server panel"};
    }

    private class TangoReleaseTreePopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private TangoReleaseTreePopupMenu(JTree jTree) {
            this.tree = jTree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String string : menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TangoReleaseTreePopupMenu.this.hostActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        public void showMenu(MouseEvent mouseEvent, String string) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText(string);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(2).setVisible(true);
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        public void showMenu(MouseEvent mouseEvent, ServerCollectionClass serverCollectionClass) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText(serverCollectionClass.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(3).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        public void showMenu(MouseEvent mouseEvent, IdlCollectionClass idlCollectionClass) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText(idlCollectionClass.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(3).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        public void showMenu(MouseEvent mouseEvent, Executable executable) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText(executable.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(3).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        public void showMenu(MouseEvent mouseEvent, Instance instance) {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            this.tree.setSelectionPath(treePath);
            this.title.setText(instance.server.name);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(5).setVisible(true);
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        private void hostActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    TangoReleaseTree.this.displayCollection();
                    break;
                }
                case 2: {
                    TangoReleaseTree.this.saveCollection();
                    break;
                }
                case 3: {
                    Object object2 = TangoReleaseTree.this.getSelectedObject();
                    if (!(object2 instanceof Instance)) break;
                    String string = ((Instance)object2).server.name;
                    if (!(TangoReleaseTree.this.appli instanceof Astor)) break;
                    ((Astor)((TangoReleaseTree)TangoReleaseTree.this).appli).tree.displayHostInfo("dserver/" + string);
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts = new Font[4];
        private final int TITLE = 0;
        private final int COLLEC = 1;
        private final int SERVER = 2;
        private final int CLASS = 3;

        public TangoRenderer() {
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 14);
            this.fonts[2] = new Font("Dialog", 1, 12);
            this.fonts[3] = new Font("Dialog", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(Color.white);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (n == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(networkIcon);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof ServerCollectionClass || defaultMutableTreeNode.getUserObject() instanceof IdlCollectionClass) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(tangoIcon);
                } else if (defaultMutableTreeNode.getUserObject() instanceof Executable || defaultMutableTreeNode.getUserObject() instanceof Instance) {
                    this.setFont(this.fonts[2]);
                    this.setIcon(serverIcon);
                } else if (defaultMutableTreeNode.getUserObject() instanceof TangoClassRelease) {
                    this.setFont(this.fonts[3]);
                    this.setIcon(classIcon);
                }
            }
            return this;
        }
    }

    private class IdlCollectionClass {
        String name;
        List<TangoClassRelease> classes;

        private IdlCollectionClass(String string, List<TangoClassRelease> list) {
            this.name = string;
            this.classes = list;
        }

        public String toString() {
            return this.name + "  (" + this.classes.size() + ")";
        }
    }

    private class ServerCollectionClass {
        String name;
        List<TangoServerRelease> servers;

        private ServerCollectionClass(String string, List<TangoServerRelease> list) {
            this.name = string;
            this.servers = list;
        }

        public String toString() {
            return this.name + "  (" + this.servers.size() + ")";
        }
    }

    private class Instance {
        String name;
        TangoServerRelease server;

        private Instance(TangoServerRelease tangoServerRelease) {
            this.server = tangoServerRelease;
            this.name = tangoServerRelease.instanceName;
            this.name = tangoServerRelease.releaseNumber >= 1.0 ? this.name + "  (Tango-" + String.format("%1.1f", tangoServerRelease.releaseNumber) + ")" : this.name + "  (" + tangoServerRelease.error + ")";
        }

        public String toString() {
            return this.name;
        }
    }

    private class Executable {
        String name;

        private Executable(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

