/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import admin.astor.AstorUtil;
import admin.astor.tango_release.TangoReleaseTree;
import admin.astor.tango_release.TangoServerReleaseList;
import admin.astor.tools.PopupHtml;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class TangoReleaseDialog
extends JDialog {
    private JFrame parent;
    private int retVal = 0;
    static final int byTango = 0;
    static final int byIDL = 1;
    private JPanel idlPanel;
    private JPanel tangoPanel;
    private JLabel titleLabel;

    public TangoReleaseDialog(JFrame jFrame) throws DevFailed {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        String[] stringArray = AstorUtil.getInstance().getHostControlledList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            System.out.println("Reading " + string);
            List<String> list = this.getControlledServers(string);
            for (String string2 : list) {
                arrayList.add(string2);
            }
        }
        System.out.println(arrayList.size());
        String string = ApiUtil.getTangoHost();
        this.buildDialog(string, arrayList);
    }

    public TangoReleaseDialog(JFrame jFrame, String string) {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.buildDialog(string, this.getControlledServers(string));
    }

    public TangoReleaseDialog(JFrame jFrame, String string, List<String> list) {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.buildDialog(string, list);
    }

    private void buildDialog(String string, List<String> list) {
        AstorUtil.startSplash("Server Tango Releases");
        AstorUtil.increaseSplashProgress(5, "Initializing....");
        this.initComponents();
        this.initOwnComponents(string, list);
        this.titleLabel.setText("Tango Release for Servers");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        AstorUtil.stopSplash();
    }

    private List<String> getControlledServers(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Database database = ApiUtil.get_db_obj();
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = database.command_inout("DbGetHostServerList", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            Collections.addAll(arrayList, stringArray);
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return arrayList;
    }

    private void initOwnComponents(String string, List<String> list) {
        AstorUtil.increaseSplashProgress(1, "Check servers....");
        TangoServerReleaseList tangoServerReleaseList = new TangoServerReleaseList(list);
        string = string + "  (" + tangoServerReleaseList.size() + " servers - " + tangoServerReleaseList.nbClasses() + " classes)";
        AstorUtil.increaseSplashProgress(5, "Build trees....");
        TangoReleaseTree tangoReleaseTree = new TangoReleaseTree(this.parent, string, tangoServerReleaseList, 0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(tangoReleaseTree);
        jScrollPane.setPreferredSize(new Dimension(500, 500));
        this.tangoPanel.add((Component)jScrollPane, "Center");
        TangoReleaseTree tangoReleaseTree2 = new TangoReleaseTree(this.parent, string, tangoServerReleaseList, 1);
        jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(tangoReleaseTree2);
        jScrollPane.setPreferredSize(new Dimension(500, 500));
        this.idlPanel.add((Component)jScrollPane, "Center");
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel();
        JButton jButton2 = new JButton();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.tangoPanel = new JPanel();
        this.idlPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TangoReleaseDialog.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jButton.setText("Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TangoReleaseDialog.this.helpBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jLabel.setText("                       ");
        jPanel2.add(jLabel);
        jButton2.setText("Dismiss");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TangoReleaseDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.tangoPanel.setLayout(new BorderLayout());
        jTabbedPane.addTab("Tango Releases", this.tangoPanel);
        this.idlPanel.setLayout(new BorderLayout());
        jTabbedPane.addTab("IDL Releases", this.idlPanel);
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void helpBtnActionPerformed(ActionEvent actionEvent) {
        URL uRL = this.getClass().getResource("TangoRelease.html");
        PopupHtml popupHtml = new PopupHtml(null);
        popupHtml.setLocation(this.getLocation());
        popupHtml.show(uRL, 900, 600);
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                if (stringArray[0].equals("-test")) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("FirstPipe/pv");
                    arrayList.add("Starter/debian7-devel");
                    new TangoReleaseDialog(null, "My Test", arrayList).setVisible(true);
                } else {
                    TangoReleaseDialog tangoReleaseDialog = new TangoReleaseDialog(null, stringArray[0]);
                    tangoReleaseDialog.setVisible(true);
                }
            } else {
                new TangoReleaseDialog(null).setVisible(true);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)devFailed);
        }
    }
}

