/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class JTangoVersion {
    private List<ManifestModule> modules = new ArrayList<ManifestModule>();
    private static String jarFileName;
    private static int jarFileType;
    private static final String nameHeader = "artifactId=";
    private static final String versionHeader = "version=";
    private static final String packageHeader = "/META-INF/maven/";
    private static final String manifestName = "pom.properties";
    private static final String[] packages;
    public static final int ERR = 0;
    public static final int JTANGO = 0;
    public static final int TANGORB = 1;
    public static final String[] JarUsed;
    private static JTangoVersion instance;

    private JTangoVersion() {
        jarFileType = this.getTangoJarUsed();
        jarFileName = this.getRealFileName(jarFileName);
        if (jarFileType == 0) {
            for (String string : packages) {
                String string2 = packageHeader + string + "/" + manifestName;
                ManifestModule manifestModule = this.getManifestModule(string2);
                if (manifestModule == null) continue;
                this.modules.add(manifestModule);
            }
        }
    }

    public static JTangoVersion getInstance() {
        if (instance == null) {
            instance = new JTangoVersion();
        }
        return instance;
    }

    public String getJarFileName() {
        return jarFileName;
    }

    public int getJarFileType() {
        return jarFileType;
    }

    private String getRealFileName(String string) {
        try {
            return new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    private ManifestModule getManifestModule(String string) {
        ManifestModule manifestModule = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                System.err.println("Failed to get the inputStream for file resource :\t  pom.properties");
                return null;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[256];
            int n = inputStreamReader.read(cArray);
            if (n > 0) {
                String string2 = new String(cArray);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
                String string3 = null;
                String string4 = null;
                String string5 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken().trim();
                    if (string6.startsWith(nameHeader)) {
                        string4 = string6.substring(nameHeader.length());
                        continue;
                    }
                    if (string6.startsWith(versionHeader)) {
                        string3 = string6.substring(versionHeader.length());
                        continue;
                    }
                    if (!string6.startsWith("#") || string6.startsWith("#Gen")) continue;
                    string5 = string6.substring(1);
                }
                if (string4 != null && string3 != null) {
                    manifestModule = new ManifestModule(string4, string3, string5);
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return manifestModule;
    }

    private int getTangoJarUsed() {
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("path.separator");
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (JTangoVersion.isJarUsed(arrayList, JarUsed[0])) {
            return 0;
        }
        if (JTangoVersion.isJarUsed(arrayList, JarUsed[1])) {
            return 1;
        }
        return 0;
    }

    private static boolean isJarUsed(List<String> list, String string) {
        for (String string2 : list) {
            if (string2.contains(string + ".jar")) {
                jarFileName = string2;
                return true;
            }
            if (!string2.contains(string + "-")) continue;
            jarFileName = string2;
            return true;
        }
        return false;
    }

    private String addTabulation(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2 + 2; ++i) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public String toString() {
        if (jarFileType == 1) {
            return this.getJarFileName();
        }
        StringBuilder stringBuilder = new StringBuilder(this.getJarFileName() + "\n\n");
        int n = 0;
        int n2 = 0;
        for (ManifestModule manifestModule : this.modules) {
            if (manifestModule.name.length() > n) {
                n = manifestModule.name.length();
            }
            if (manifestModule.version.length() <= n2) continue;
            n2 = manifestModule.version.length();
        }
        for (ManifestModule manifestModule : this.modules) {
            stringBuilder.append(manifestModule.name).append(":").append(this.addTabulation(manifestModule.version, manifestModule.name.length(), n)).append(this.addTabulation(manifestModule.date, manifestModule.version.length(), n2)).append('\n');
        }
        return stringBuilder.toString().trim();
    }

    public static void main(String[] stringArray) {
        JTangoVersion jTangoVersion = new JTangoVersion();
        System.out.println(jTangoVersion);
    }

    static {
        packages = new String[]{"org.tango/JavaTangoIDL", "org.tango/TangORB", "org.tango/JTangoServer", "org.zeromq/jeromq", "org.slf4j/slf4j-api"};
        JarUsed = new String[]{"JTango", "TangORB"};
        instance = null;
    }

    private class ManifestModule {
        String name;
        String version;
        String date = "";

        private ManifestModule(String string, String string2, String string3) {
            this.name = string;
            this.version = string2;
            if (string3 != null) {
                this.date = this.splitDate(string3);
            }
        }

        private String splitDate(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return (String)arrayList.get(2) + " " + (String)arrayList.get(1) + " " + (String)arrayList.get(5);
        }

        public String toString() {
            return this.name + ":  " + this.version;
        }
    }
}

