/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.AstorUtil;
import admin.astor.statistics.StarterStat;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class Utils {
    private static final String percentageFormat = "%7.4f";

    public static String formatDuration(long l) {
        double d = (double)l / 1000.0;
        return Utils.formatDuration(d);
    }

    public static String formatDuration(double d) {
        if (d < 10.0) {
            String string = "" + d;
            int n = string.indexOf(46);
            if (n > 0 && string.length() > n + 3) {
                string = string.substring(0, n + 3);
            }
            return string + " sec.";
        }
        int n = (int)d;
        if (d < 60.0) {
            return "" + n + " sec.";
        }
        if (n < 3600) {
            int n2 = n / 60;
            int n3 = n - 60 * n2;
            return "" + n2 + " mn " + (n3 < 10 ? "0" : "") + n3 + " sec.";
        }
        if (n < 86400) {
            int n4 = n / 3600;
            int n5 = (n -= n4 * 3600) / 60;
            int n6 = n - 60 * n5;
            return "" + n4 + " h " + (n5 < 10 ? "0" : "") + n5 + " mn " + (n6 < 10 ? "0" : "") + n6 + " sec.";
        }
        int n7 = n / 86400;
        return "" + n7 + " day" + (n7 > 1 ? "s " : " ") + Utils.formatDuration((double)n - (double)(n7 * 24 * 3600));
    }

    public static String formatPercentage(double d) {
        double d2 = 100.0 * d;
        return String.format(percentageFormat, d2) + " %";
    }

    public static String formatDate(long l) {
        StringTokenizer stringTokenizer = new StringTokenizer(new Date(l).toString());
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String string = (String)arrayList.get(1);
        String string2 = (String)arrayList.get(2);
        String string3 = (String)arrayList.get(3);
        String string4 = (String)arrayList.get(arrayList.size() - 1);
        if (string4.indexOf(41) > 0) {
            string4 = string4.substring(0, string4.indexOf(41));
        }
        return string2 + " " + string + " " + string4 + "  " + string3;
    }

    public static StarterStat readHostStatistics(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        List<StarterStat> list = Utils.readHostStatistics(arrayList);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static List<StarterStat> readHostStatistics(List<String> list) {
        if (list == null || list.size() == 0) {
            list = Utils.getHostControlledList(false, true);
        }
        int n = 80 / list.size();
        ArrayList<StarterStat> arrayList = new ArrayList<StarterStat>();
        for (String string : list) {
            AstorUtil.increaseSplashProgress(n, "Get statistics for " + string);
            arrayList.add(new StarterStat(string));
        }
        return arrayList;
    }

    public static List<String> getHostControlledList(boolean bl, boolean bl2) {
        if (bl2) {
            AstorUtil.increaseSplashProgress(5, "Get Controlled host list....");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = AstorUtil.getInstance().getHostControlledList();
            if (bl) {
                Collections.addAll(arrayList, stringArray);
            } else {
                Database database = ApiUtil.get_db_obj();
                String[] stringArray2 = new String[]{};
                DbDatum dbDatum = database.get_property("Astor", "ExcludedCollectionsForStatistics");
                if (!dbDatum.is_empty()) {
                    stringArray2 = dbDatum.extractStringArray();
                }
                for (String string : stringArray2) {
                    System.out.println("Exclude " + string);
                }
                for (String string : stringArray) {
                    DbDatum dbDatum2 = new DeviceProxy(AstorUtil.getStarterDeviceHeader() + string).get_property("HostCollection");
                    if (dbDatum2.is_empty()) continue;
                    String string2 = dbDatum2.extractString().toLowerCase();
                    boolean bl3 = false;
                    for (String string3 : stringArray2) {
                        if (!string3.toLowerCase().equals(string2)) continue;
                        bl3 = true;
                    }
                    if (bl3) continue;
                    arrayList.add(string);
                }
            }
        }
        catch (DevFailed devFailed) {
            if (bl2) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
            }
            Except.print_exception((Exception)((Object)devFailed));
        }
        return arrayList;
    }

    public static String readFile(String string) throws DevFailed {
        String string2 = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            n = fileInputStream.read(byArray);
            fileInputStream.close();
            if (n > 0) {
                string2 = Utils.takeOffWindowsChar(byArray);
            }
        }
        catch (Exception exception) {
            Except.throw_exception((String)"READ_FAILED", (String)exception.toString(), (String)"ParserTool.readFile()");
        }
        return string2;
    }

    public static boolean osIsUnix() {
        String string = System.getProperty("os.name");
        return !string.toLowerCase().startsWith("windows");
    }

    private static String takeOffWindowsChar(byte[] byArray) {
        int n = 0;
        for (byte by : byArray) {
            if (by == 13) continue;
            ++n;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 13) continue;
            byArray2[n2++] = byArray[i];
        }
        return new String(byArray2);
    }

    private static String checkOsFormat(String string) {
        if (!Utils.osIsUnix()) {
            return Utils.setWindowsFileFormat(string);
        }
        return string;
    }

    public static String setWindowsFileFormat(String string) {
        byte[] byArray = new byte[]{13, 10};
        String string2 = new String(byArray);
        string = string.replaceAll("\n", string2);
        return string;
    }

    public static void writeFile(String string, String string2) throws DevFailed {
        try {
            string2 = Utils.checkOsFormat(string2);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            System.out.println(string + "  written");
        }
        catch (Exception exception) {
            Except.throw_exception((String)"WRITE_FAILED", (String)exception.toString(), (String)"ParserTool.readFile()");
        }
    }

    public static String parseXmlProperty(String string, String string2) throws DevFailed {
        int n;
        String string3 = string2 + "=\"";
        int n2 = string.indexOf(string3);
        if (n2 < 0) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)("Cannot parse '" + string2 + "'  in:\n" + string), (String)"Utils.parseProperty()");
        }
        if ((n = string.indexOf(34, n2 += string3.length())) < 0) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)("Cannot parse '" + string2 + "'  in:\n" + string), (String)"Utils.parseProperty()");
        }
        return string.substring(n2, n);
    }

    public static String strReplace(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        int n = 0;
        while ((n = string.indexOf(string2, n)) >= 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
            n += string3.length();
        }
        return string;
    }
}

