/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class StatisticsFileFilter
extends FileFilter {
    private ArrayList<String> filters = new ArrayList();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public StatisticsFileFilter() {
    }

    public StatisticsFileFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public StatisticsFileFilter(String[] stringArray, String string) {
        this();
        for (String string2 : stringArray) {
            this.addExtension(string2);
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = StatisticsFileFilter.getExtension(file);
            if (string != null) {
                for (String string2 : this.filters) {
                    if (!string2.equals(string)) continue;
                    return this.isStatisticsGeneratedFile(file.toString());
                }
            }
        }
        return false;
    }

    public static String getExtension(File file) {
        if (file != null) {
            String string = file.getName();
            return StatisticsFileFilter.getExtension(string);
        }
        return null;
    }

    public static String getExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        this.filters.add(string.toLowerCase());
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "" : this.description + "  (";
                for (int i = 0; i < this.filters.size(); ++i) {
                    this.fullDescription = this.fullDescription + "*." + this.filters.get(i);
                    if (i >= this.filters.size() - 1) continue;
                    this.fullDescription = this.fullDescription + ", ";
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    private boolean isStatisticsGeneratedFile(String string) {
        String string2;
        try {
            string2 = Utils.readFile(string);
        }
        catch (DevFailed devFailed) {
            return false;
        }
        return string2.contains("<?xml version=\"1.0\" encoding=\"ASCII\"?>\n<ctrlStatDsl:CtrlStatSystem xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ctrlStatDsl=\"http://www.esrf.fr/tango/starter/CtrlStatDslDsl\">");
    }
}

