/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.LogRecord;
import admin.astor.statistics.ServerRecord;
import admin.astor.statistics.StarterStat;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;
import java.util.List;

public class ServerStat
extends ArrayList<ServerRecord> {
    public String name;
    public StarterStat starterStat;
    public int nbFailures = 0;
    public long failedDuration = 0L;
    public long runDuration = 0L;
    public long oldestTime = 0L;
    private List<LogRecord> logs = new ArrayList<LogRecord>();
    public static final String className = "ServerStat";
    private static final String nameStr = "server";
    private static final String nbFailStr = "nbFailures";
    private static final String tFailStr = "failedDuration";
    private static final String tRunStr = "runDuration";
    private static final String resetStr = "reset";
    private static final String description = "<ServerStat server=\"SERVER\" nbFailures=\"NB_FAILURES\" failedDuration=\"FAILED_DURATION\" runDuration=\"RUN_DURATION\"reset=\"RESET\">";
    private static final String tab = "\t\t\t";

    public ServerStat(List<String> list) throws DevFailed {
        this.parseXmlStatistics(list);
    }

    private void parseXmlStatistics(List<String> list) throws DevFailed {
        if (list.size() >= 0) {
            this.parseXmlProperties(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                this.add(new ServerRecord(list.get(i)));
            }
        }
    }

    private void parseXmlProperties(String string) throws DevFailed {
        this.name = Utils.parseXmlProperty(string, nameStr);
        try {
            this.nbFailures = Integer.parseInt(Utils.parseXmlProperty(string, nbFailStr));
            this.failedDuration = Long.parseLong(Utils.parseXmlProperty(string, tFailStr));
            this.runDuration = Long.parseLong(Utils.parseXmlProperty(string, tRunStr));
            this.oldestTime = Long.parseLong(Utils.parseXmlProperty(string, resetStr));
        }
        catch (NumberFormatException numberFormatException) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)numberFormatException.toString(), (String)"ServerStat.parseLine()");
        }
    }

    public ServerStat(String string) {
        this.name = string;
    }

    public ServerStat(String string, StarterStat starterStat) {
        this.name = string;
        this.starterStat = starterStat;
    }

    public void addLog(LogRecord logRecord) {
        this.logs.add(logRecord);
    }

    public void computeStatistics() {
        this.nbFailures = 0;
        this.failedDuration = 0L;
        this.runDuration = 0L;
        this.oldestTime = System.currentTimeMillis();
        ArrayList<ServerRecord> arrayList = new ArrayList<ServerRecord>();
        for (int i = this.logs.size() - 1; i >= 0; --i) {
            int n;
            long l;
            LogRecord object = this.logs.get(i);
            DevState devState = object.newState;
            long l2 = 0L;
            if (devState == DevState.FAULT) {
                ++this.nbFailures;
                l = object.failedTime;
                if (i == 0) {
                    l2 = System.currentTimeMillis();
                } else {
                    n = this.getNextRestartIndex(i);
                    if (n >= 0) {
                        l2 = this.logs.get((int)n).startedTime;
                        i = n + 1;
                    } else {
                        n = this.getNextFailureIndex(i);
                        if (n >= 0) {
                            l2 = this.logs.get((int)n).failedTime;
                            i = n + 1;
                        }
                    }
                }
                this.failedDuration += l2 - l;
            } else {
                l = object.startedTime;
                if (i == 0) {
                    l2 = System.currentTimeMillis();
                } else {
                    n = this.getNextFailureIndex(i);
                    if (n >= 0) {
                        l2 = this.logs.get((int)n).failedTime;
                        i = n + 1;
                    } else {
                        n = this.getNextRestartIndex(i);
                        if (n >= 0) {
                            l2 = this.logs.get((int)n).startedTime;
                            i = n + 1;
                        }
                    }
                }
                this.runDuration += l2 - l;
            }
            ServerRecord serverRecord = new ServerRecord(object.newState, l, l2, object.autoRestart);
            arrayList.add(serverRecord);
            if (this.oldestTime <= l) continue;
            this.oldestTime = l;
        }
        for (ServerRecord serverRecord : arrayList) {
            this.add(0, serverRecord);
        }
    }

    private int getNextRestartIndex(int n) {
        --n;
        while (n >= 0) {
            LogRecord logRecord = this.logs.get(n);
            if (logRecord.newState == DevState.ON) {
                return n;
            }
            --n;
        }
        return -1;
    }

    private int getNextFailureIndex(int n) {
        --n;
        while (n >= 0) {
            LogRecord logRecord = this.logs.get(n);
            if (logRecord.newState == DevState.FAULT) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public String recordsToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append(":\n");
        for (ServerRecord serverRecord : this) {
            stringBuilder.append(serverRecord).append("\n");
        }
        return stringBuilder.toString();
    }

    public double getAvailability() {
        return (double)this.runDuration / (double)(this.runDuration + this.failedDuration);
    }

    public long getLastFailure() {
        for (ServerRecord serverRecord : this) {
            if (serverRecord.state != DevState.FAULT || serverRecord.startTime <= 0L) continue;
            return serverRecord.startTime;
        }
        return 0L;
    }

    private String toXmlLine() {
        String string = description;
        string = Utils.strReplace(string, "SERVER", this.name);
        string = Utils.strReplace(string, "NB_FAILURES", Integer.toString(this.nbFailures));
        string = Utils.strReplace(string, "FAILED_DURATION", Long.toString(this.failedDuration));
        string = Utils.strReplace(string, "RUN_DURATION", Long.toString(this.runDuration));
        string = Utils.strReplace(string, "RESET", Long.toString(this.oldestTime));
        return string;
    }

    public String toXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tab).append("").append(this.toXmlLine()).append(">\n");
        for (ServerRecord serverRecord : this) {
            stringBuilder.append(serverRecord.toXml()).append("\n");
        }
        stringBuilder.append(tab).append("</ServerStat>");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append(":\thas run ").append(Utils.formatDuration(this.runDuration));
        if (this.nbFailures > 0) {
            stringBuilder.append("   has failed ").append(this.nbFailures).append(" times  (total time: ").append(Utils.formatDuration(this.failedDuration)).append(") - ").append(this.size()).append(" records");
        }
        return stringBuilder.toString();
    }
}

