/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoDs.Except;

public class ServerRecord {
    DevState state;
    String stateName;
    long startTime = -1L;
    long endTime = -1L;
    long duration = 0L;
    int autoRestart = 0;
    public static final int START_UNKNOWN = 0;
    public static final int START_REQUEST = 1;
    public static final int START_AUTO = 2;
    public static final String className = "ServerRecord";
    private static final String stateStr = "state";
    private static final String startTimeStr = "startTime";
    private static final String endTimeStr = "endTime";
    private static final String durationStr = "duration";
    private static final String autoStartStr = "started";
    private static final String description = "<ServerRecord state=\"STATE\" startTime=\"START_TIME\" endTime=\"END_TIME\" duration=\"DURATION\"started=\"STARTED\">";
    private static final String tab = "\t\t\t\t";

    public ServerRecord(String string) throws DevFailed {
        String string2;
        this.stateName = Utils.parseXmlProperty(string, stateStr);
        this.state = this.stateName.equals("Start") ? DevState.ON : DevState.FAULT;
        try {
            this.startTime = Long.parseLong(Utils.parseXmlProperty(string, startTimeStr));
            this.endTime = Long.parseLong(Utils.parseXmlProperty(string, endTimeStr));
            this.duration = this.endTime - this.startTime;
        }
        catch (NumberFormatException numberFormatException) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)numberFormatException.toString(), (String)"ServerRecord.ServerRecord()");
        }
        switch (string2 = Utils.parseXmlProperty(string, autoStartStr)) {
            case "auto": {
                this.autoRestart = 2;
                break;
            }
            case "request": {
                this.autoRestart = 1;
                break;
            }
            default: {
                this.autoRestart = 0;
            }
        }
    }

    public ServerRecord(DevState devState, long l, long l2, int n) {
        this.state = devState;
        this.stateName = devState == DevState.ON ? "Start" : "Failed";
        this.startTime = l;
        this.endTime = l2;
        this.duration = l2 - l;
        this.autoRestart = n;
    }

    public String toXml() {
        String string = description;
        string = Utils.strReplace(string, "STATE", this.stateName);
        string = Utils.strReplace(string, "START_TIME", Long.toString(this.startTime));
        string = Utils.strReplace(string, "END_TIME", Long.toString(this.endTime));
        string = Utils.strReplace(string, "DURATION", Long.toString(this.duration));
        string = this.state == DevState.ON ? (this.autoRestart == 2 ? Utils.strReplace(string, "STARTED", "auto") : (this.autoRestart == 1 ? Utils.strReplace(string, "STARTED", "request") : Utils.strReplace(string, "STARTED", ""))) : Utils.strReplace(string, "STARTED", "");
        return tab + string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.state == DevState.ON) {
            stringBuilder.append("Start");
        } else {
            stringBuilder.append("Failed");
        }
        stringBuilder.append("\t").append(Utils.formatDate(this.startTime)).append("\t").append(Utils.formatDate(this.endTime)).append("\t").append(Utils.formatDuration(this.duration));
        return stringBuilder.toString();
    }
}

