/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.AstorUtil;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ResetStatistics {
    private int nbHosts = 0;
    private int done = 0;
    private JFrame parent;

    public ResetStatistics(JFrame jFrame) {
        this.parent = jFrame;
        List<String> list = Utils.getHostControlledList(true, false);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getConfirm(list)) {
            this.nbHosts = list.size();
            if (jFrame != null) {
                AstorUtil.startSplash("Statistics ");
            }
            for (String string : list) {
                if (jFrame != null) {
                    int n = 100 / this.nbHosts;
                    if (n < 1) {
                        n = 1;
                    }
                    AstorUtil.increaseSplashProgress(n, "Resetting " + string);
                }
                try {
                    String string2 = string;
                    if (string.indexOf(47) < 0) {
                        string2 = AstorUtil.getStarterDeviceHeader() + string;
                    }
                    System.out.println("Resetting " + string);
                    DeviceProxy deviceProxy = new DeviceProxy(string2);
                    deviceProxy.command_inout("ResetStatistics");
                    ++this.done;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (DevFailed devFailed) {
                    stringBuffer.append(string).append(":    ").append(devFailed.errors[0].desc).append("\n");
                }
            }
        }
        if (jFrame != null) {
            AstorUtil.stopSplash();
        }
        if (stringBuffer.length() > 0) {
            if (jFrame == null) {
                System.err.println(stringBuffer);
            } else {
                JOptionPane.showMessageDialog(jFrame, stringBuffer.toString(), "error", 0);
            }
        }
        if (jFrame != null) {
            JOptionPane.showMessageDialog(jFrame, this, "Command done", 1);
        } else {
            System.out.println(this);
        }
    }

    private boolean getConfirm(List<String> list) {
        if (this.parent != null) {
            return JOptionPane.showConfirmDialog(this.parent, "Reset Statistics on " + list.size() + " hosts ?", "Confirm Dialog", 0) == 0;
        }
        try {
            System.out.println("OK to reset statistics on " + list.size() + " (y/n) ?");
            byte[] byArray = new byte[100];
            if (System.in.read(byArray) > 0 && byArray[0] == 121) {
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        return false;
    }

    public String toString() {
        return "ResetStatistics done for " + this.done + " hosts / " + this.nbHosts;
    }

    public static void main(String[] stringArray) {
        new ResetStatistics(null);
    }
}

