/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevState;
import java.util.StringTokenizer;

public class LogRecord {
    String name;
    DevState newState;
    long startedTime = -1L;
    long failedTime = -1L;
    long failedDuration = 0L;
    long runDuration = 0L;
    int autoRestart = 0;

    public LogRecord(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        if (stringTokenizer.countTokens() < 3) {
            if (stringTokenizer.hasMoreTokens()) {
                System.err.println(stringTokenizer.nextElement() + ": ");
            }
            System.err.println("Log cannot be parsed ! ");
            return;
        }
        this.name = stringTokenizer.nextToken();
        this.newState = this.getState(stringTokenizer.nextToken());
        this.startedTime = this.getValue(stringTokenizer.nextToken()) * 1000L;
        this.failedTime = stringTokenizer.hasMoreTokens() ? this.getValue(stringTokenizer.nextToken()) * 1000L : -1L;
        if (this.failedTime > 0L) {
            if (this.startedTime > this.failedTime) {
                this.failedDuration = this.startedTime - this.failedTime;
            } else if (this.newState == DevState.ON) {
                this.runDuration = this.failedTime - this.startedTime;
            }
        }
        if (this.newState == DevState.ON && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.autoRestart = string2.equals("true") ? 2 : 1;
        }
    }

    private long getValue(String string) {
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException.getMessage());
        }
        return l;
    }

    private DevState getState(String string) {
        if (string.equals("ON")) {
            return DevState.ON;
        }
        return DevState.FAULT;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append(":\t");
        if (this.newState == DevState.FAULT) {
            stringBuilder.append("Failed at   ").append(Utils.formatDate(this.failedTime));
        } else {
            stringBuilder.append("Start  at   ").append(Utils.formatDate(this.startedTime));
        }
        if (this.failedDuration > 0L) {
            stringBuilder.append("\tFailure ").append(Utils.formatDuration(this.failedDuration));
        }
        if (this.runDuration > 0L) {
            stringBuilder.append("\tAvailable ").append(Utils.formatDuration(this.runDuration));
        }
        return stringBuilder.toString();
    }
}

