/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.ctrl_system_info;

import admin.astor.AstorUtil;
import admin.astor.ctrl_system_info.HostCollection;
import admin.astor.ctrl_system_info.Monitor;
import admin.astor.ctrl_system_info.ScanningThread;
import admin.astor.ctrl_system_info.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CtrlSystemInfo
extends JDialog {
    private JFrame parent;
    private List<JRadioButton> buttons = new ArrayList<JRadioButton>();
    private List<HostCollection> collectionList;
    private ScanningThread scanningThread;
    private Monitor monitor;
    private String controlSystemName;
    private JPanel collectionPanel;
    private JLabel separatorLabel;
    private JButton startButton;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JLabel titleLabel;

    public CtrlSystemInfo(JFrame parent) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.controlSystemName = Utils.getControlSystemName();
        if (this.controlSystemName == null) {
            this.controlSystemName = Utils.getTangoHost();
        }
        this.titleLabel.setText(this.controlSystemName + " Control System");
        this.textScrollPane.setVisible(false);
        this.buildCollectionButtons();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.setVisible(true);
    }

    private void buildCollectionButtons() throws DevFailed {
        this.collectionList = this.getCollectionList();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        int y = 5;
        for (HostCollection collection : this.collectionList) {
            gbc.gridy = y++;
            JRadioButton button = new JRadioButton(collection.getName());
            button.setSelected(true);
            this.collectionPanel.add((Component)button, gbc);
            this.buttons.add(button);
        }
        gbc.gridy = y;
        this.collectionPanel.add((Component)new JLabel("   "), gbc);
    }

    private List<HostCollection> getCollectionList() throws DevFailed {
        String[] hostNames = Utils.getHostControlledList();
        ArrayList<HostCollection> list = new ArrayList<HostCollection>();
        for (String hostName : hostNames) {
            DbDatum datum = new DeviceProxy(AstorUtil.getStarterDeviceHeader() + hostName).get_property("HostCollection");
            String name = datum.is_empty() ? "Miscellaneous" : datum.extractString();
            ArrayList hostCollection = null;
            for (HostCollection collection : list) {
                if (!collection.getName().equals(name)) continue;
                hostCollection = collection;
            }
            if (hostCollection == null) {
                hostCollection = new HostCollection(name);
                list.add((HostCollection)hostCollection);
            }
            hostCollection.add(hostName);
        }
        Collections.sort(list, new HostCollectionComparator());
        String[] lastNames = Utils.getLastCollectionList();
        if (lastNames != null && lastNames.length > 0) {
            ArrayList<HostCollection> lastCollections = new ArrayList<HostCollection>();
            for (HostCollection hostCollection : list) {
                for (String lastName : lastNames) {
                    if (!hostCollection.getName().equals(lastName)) continue;
                    lastCollections.add(hostCollection);
                }
            }
            for (HostCollection hostCollection : lastCollections) {
                list.remove(hostCollection);
                list.add(hostCollection);
            }
        }
        return list;
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        this.startButton = new JButton();
        this.separatorLabel = new JLabel();
        JButton cancelBtn = new JButton();
        JPanel centerPanel = new JPanel();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.collectionPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CtrlSystemInfo.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        this.startButton.setText("Start ");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CtrlSystemInfo.this.startButtonActionPerformed(evt);
            }
        });
        bottomPanel.add(this.startButton);
        this.separatorLabel.setText("              ");
        bottomPanel.add(this.separatorLabel);
        cancelBtn.setText("Dissmiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CtrlSystemInfo.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        centerPanel.setLayout(new BorderLayout());
        this.textScrollPane.setPreferredSize(new Dimension(400, 260));
        this.textArea.setEditable(false);
        this.textArea.setColumns(20);
        this.textArea.setFont(new Font("Times New Roman", 1, 14));
        this.textArea.setRows(5);
        this.textArea.setTabSize(2);
        this.textScrollPane.setViewportView(this.textArea);
        centerPanel.add((Component)this.textScrollPane, "Center");
        this.collectionPanel.setLayout(new GridBagLayout());
        jLabel1.setFont(new Font("Tahoma", 1, 14));
        jLabel1.setText("Collections to be checked");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.collectionPanel.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.collectionPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.collectionPanel.add((Component)jLabel3, gridBagConstraints);
        centerPanel.add((Component)this.collectionPanel, "South");
        this.getContentPane().add((Component)centerPanel, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        ArrayList<String> hostList = new ArrayList<String>();
        for (JRadioButton button : this.buttons) {
            if (!button.isSelected()) continue;
            String collectionName = button.getText();
            for (HostCollection hostCollection : this.collectionList) {
                if (!hostCollection.getName().equals(collectionName)) continue;
                for (String hostName : hostCollection) {
                    hostList.add(hostName);
                }
            }
        }
        this.monitor = new Monitor(this, "Browsing " + this.controlSystemName + " database for Servers....");
        this.scanningThread = new ScanningThread(hostList, this.monitor);
        this.scanningThread.start();
        new DisplayResults().start();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            new CtrlSystemInfo(null);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
        }
    }

    class HostCollectionComparator
    implements Comparator<HostCollection> {
        HostCollectionComparator() {
        }

        @Override
        public int compare(HostCollection hostCollection1, HostCollection hostCollection2) {
            return hostCollection1.getName().compareTo(hostCollection2.getName());
        }
    }

    private class DisplayResults
    extends Thread {
        private DisplayResults() {
        }

        @Override
        public void run() {
            CtrlSystemInfo.this.setVisible(false);
            try {
                CtrlSystemInfo.this.scanningThread.join();
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
            }
            if (!CtrlSystemInfo.this.monitor.isCanceled()) {
                CtrlSystemInfo.this.collectionPanel.setVisible(false);
                CtrlSystemInfo.this.separatorLabel.setVisible(false);
                CtrlSystemInfo.this.startButton.setVisible(false);
                CtrlSystemInfo.this.textArea.setText(CtrlSystemInfo.this.scanningThread.getResults());
                CtrlSystemInfo.this.textScrollPane.setVisible(true);
                CtrlSystemInfo.this.pack();
            }
            CtrlSystemInfo.this.setVisible(true);
        }
    }
}

