/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.AstorUtil;
import admin.astor.access.AccessProxy;
import admin.astor.access.ChooseGroupDialog;
import admin.astor.access.EditDialog;
import admin.astor.access.EditTreeItem;
import admin.astor.access.TangoAccess;
import admin.astor.access.UserGroup;
import admin.astor.access.UsersTreePopupMenu;
import admin.astor.access.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UsersTree
extends JTree
implements TangoConst {
    static final int USER_NODE = -2;
    static final int COLLECTION = -1;
    static final int ADDRESS = 0;
    static final int DEVICE = 1;
    static final String[] collecStr = new String[]{"Allowed Addresses", "Devices"};
    static final int WRITE = 0;
    static final int READ = 1;
    static final String[] rightsStr = new String[]{"write", "read"};
    static ImageIcon tango_icon;
    static ImageIcon all_users_icon;
    static ImageIcon group_icon;
    static ImageIcon user_icon;
    static ImageIcon add_icon;
    static ImageIcon dev_icon;
    static ImageIcon write_icon;
    static ImageIcon read_icon;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private UsersTreePopupMenu menu;
    private JFrame parent;
    private AccessProxy accessProxy;
    CopiedAddresses copied_addresses = new CopiedAddresses();
    CopiedDevices copied_devices = new CopiedDevices();
    private static final Color background;
    private List<UserGroup> groups = new ArrayList<UserGroup>();
    private boolean manage_expand = true;
    EditTreeItem edit_item;

    public UsersTree(JFrame jFrame, AccessProxy accessProxy) throws DevFailed {
        this.parent = jFrame;
        this.accessProxy = accessProxy;
        this.setBackground(background);
        this.buildTree();
        this.menu = new UsersTreePopupMenu(this);
    }

    private void buildTree() throws DevFailed {
        String string = "Tango Control Access";
        try {
            string = "Access to  " + ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        this.root = new DefaultMutableTreeNode(string);
        this.createUserNodes();
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                UsersTree.this.expandedPerformed(treeExpansionEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                UsersTree.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        if (this.accessProxy.getAccessControl() == 0) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getClickCount() == 2 && (n & 0x10) != 0) {
            if (object instanceof AccessAddress || object instanceof AccessDevice) {
                this.editItem();
            }
        } else if ((n & 4) != 0) {
            if (defaultMutableTreeNode == this.root) {
                this.menu.showMenu(mouseEvent, object.toString());
            } else if (object instanceof UserGroup) {
                this.menu.showMenu(mouseEvent, object.toString());
            } else if (object instanceof AccessAddress) {
                this.menu.showMenu(mouseEvent, 0, object);
            } else if (object instanceof AccessDevice) {
                this.menu.showMenu(mouseEvent, 1, object);
            } else if (object instanceof AccessUser) {
                this.menu.showMenu(mouseEvent, -2, object);
            } else if (object instanceof String) {
                this.menu.showMenu(mouseEvent, -1, object);
            }
        }
    }

    public void expandedPerformed(TreeExpansionEvent treeExpansionEvent) {
        if (!this.manage_expand) {
            return;
        }
        TreePath treePath = treeExpansionEvent.getPath();
        Object[] objectArray = treePath.getPath();
        if (objectArray.length < 2) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(objectArray.length - 1);
        if (defaultMutableTreeNode.getUserObject() instanceof AccessUser) {
            this.expendUserNode(defaultMutableTreeNode.toString());
        } else if (defaultMutableTreeNode.toString().equals(collecStr[0])) {
            this.createAddressNodes(defaultMutableTreeNode);
        } else if (defaultMutableTreeNode.toString().equals(collecStr[1])) {
            this.createDeviceNodes(defaultMutableTreeNode);
        }
    }

    private void createDeviceNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            Object object = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            String string = ((AccessUser)object).getName();
            AccessDevice[] accessDeviceArray = this.getDevices(string);
            for (int i = 0; i < accessDeviceArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(accessDeviceArray[i]);
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
            }
            this.removePreviousNode(defaultMutableTreeNode, accessDeviceArray.length);
        }
        catch (DevFailed devFailed) {
            this.removePreviousNode(defaultMutableTreeNode, 0);
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Cannot read devices", (DevFailed)devFailed);
        }
    }

    private void createAddressNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            Object object = ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            String string = ((AccessUser)object).getName();
            AccessAddress[] accessAddressArray = this.getAddresses(string);
            if (!this.createChildNodes(defaultMutableTreeNode, accessAddressArray)) {
                return;
            }
            for (int i = 0; i < accessAddressArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(accessAddressArray[i]);
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
            }
            this.removePreviousNode(defaultMutableTreeNode, accessAddressArray.length);
        }
        catch (DevFailed devFailed) {
            this.removePreviousNode(defaultMutableTreeNode, 0);
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Cannot read addresses", (DevFailed)devFailed);
        }
    }

    private void createUserNode(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new AccessUser(string));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(collecStr[0]);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(collecStr[1]);
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new Dummy()));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new Dummy()));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
        if (defaultMutableTreeNode == null) {
            this.root.add(defaultMutableTreeNode2);
        } else {
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private void createUserNodes() throws DevFailed {
        String[] stringArray = this.accessProxy.getUsers();
        this.buildGroups(stringArray);
        int n = 80 / stringArray.length;
        this.createUserNode(stringArray[0], null);
        for (UserGroup userGroup : this.groups) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(userGroup);
            for (String string : userGroup) {
                AstorUtil.increaseSplashProgress(n, "building tree for " + string);
                this.createUserNode(string, defaultMutableTreeNode);
            }
            this.root.add(defaultMutableTreeNode);
        }
    }

    private void buildGroups(String[] stringArray) {
        this.groups = UserGroup.getUserGroupsFromDatabase(stringArray);
        UserGroup userGroup = new UserGroup("Unsorted Users");
        for (String string : stringArray) {
            boolean bl = false;
            if (string.equals("*")) continue;
            for (UserGroup userGroup2 : this.groups) {
                for (String string2 : userGroup2) {
                    if (!string.equals(string2)) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            userGroup.add(string);
        }
        if (userGroup.size() > 0) {
            userGroup.sortMembers();
            this.groups.add(userGroup);
        }
    }

    private boolean createChildNodes(DefaultMutableTreeNode defaultMutableTreeNode, AccessAddress[] accessAddressArray) {
        boolean bl = false;
        if (defaultMutableTreeNode.getChildCount() != accessAddressArray.length) {
            bl = true;
        } else {
            for (int i = 0; i < accessAddressArray.length; ++i) {
                if (defaultMutableTreeNode.getChildAt(i).toString().equals(accessAddressArray[i].toString())) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void removePreviousNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        while (defaultMutableTreeNode.getChildCount() > n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    private AccessDevice[] getDevices(String string) throws DevFailed {
        String[] stringArray = this.accessProxy.getDevicesByUser(string);
        AccessDevice[] accessDeviceArray = new AccessDevice[stringArray.length / 2];
        for (int i = 0; i < stringArray.length / 2; ++i) {
            accessDeviceArray[i] = new AccessDevice(stringArray[2 * i], stringArray[2 * i + 1]);
        }
        return accessDeviceArray;
    }

    private AccessAddress[] getAddresses(String string) throws DevFailed {
        String[] stringArray = this.accessProxy.getAddressesByUser(string);
        AccessAddress[] accessAddressArray = new AccessAddress[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            accessAddressArray[i] = new AccessAddress(stringArray[i]);
        }
        return accessAddressArray;
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode.getUserObject();
    }

    private boolean checkUserName(String string) {
        boolean bl = true;
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase());
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + stringTokenizer.nextToken();
            }
            if (string2.equals("allusers")) {
                TangoAccess.popupError(this, string + " is reserved !");
                bl = false;
            }
        } else {
            bl = false;
        }
        if (string.length() > 0) {
            if (this.userExists(string)) {
                bl = false;
                this.expendUserNode(string);
                TangoAccess.popupError(this, "User  " + string + "  Already exists !");
            }
        } else {
            bl = false;
        }
        return bl;
    }

    void addUser() {
        Object object;
        Serializable serializable;
        String string = "";
        String string2 = "";
        String string3 = "*/*/*";
        Object object2 = this.getSelectedObject();
        UserGroup userGroup = null;
        if (object2 instanceof UserGroup) {
            userGroup = (UserGroup)object2;
        }
        boolean bl = false;
        while (!bl) {
            serializable = new EditDialog(this.parent, string, string2, this.groups, userGroup);
            if (((EditDialog)serializable).showDialog() != 0) {
                return;
            }
            userGroup = ((EditDialog)serializable).getUserGroup();
            if (userGroup == null) continue;
            object = ((EditDialog)serializable).getInputs();
            string = object[0];
            string2 = object[1];
            bl = this.checkUserName(string);
        }
        try {
            this.accessProxy.addAddress(string, string2);
            this.accessProxy.addDevice(string, string3, rightsStr[0]);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
            return;
        }
        serializable = this.getGroupNode(userGroup.getName());
        if (serializable == null) {
            this.groups.add(userGroup);
            Collections.sort(this.groups, new GroupComparator());
            serializable = new DefaultMutableTreeNode(userGroup);
            this.treeModel.insertNodeInto((MutableTreeNode)((Object)serializable), this.root, this.root.getChildCount());
        }
        userGroup.add(string);
        UserGroup.setUserGroupsToDatabase(this, this.groups);
        object = new DefaultMutableTreeNode(new AccessUser(string));
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(collecStr[0]);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(collecStr[1]);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new AccessAddress(string2));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new AccessDevice(string3, 0));
        this.treeModel.insertNodeInto((MutableTreeNode)object, (MutableTreeNode)((Object)serializable), ((DefaultMutableTreeNode)serializable).getChildCount());
        this.treeModel.insertNodeInto(defaultMutableTreeNode, (MutableTreeNode)object, 0);
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, (MutableTreeNode)object, 1);
        this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, 0);
        this.treeModel.insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode2, 0);
        Object[] objectArray = new TreeNode[]{this.root, serializable, object, defaultMutableTreeNode, defaultMutableTreeNode3};
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        objectArray[3] = defaultMutableTreeNode2;
        objectArray[4] = defaultMutableTreeNode4;
        treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private DefaultMutableTreeNode getGroupNode(String string) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            if (!this.root.getChildAt(i).toString().equals(string)) continue;
            return (DefaultMutableTreeNode)this.root.getChildAt(i);
        }
        return null;
    }

    void addItem() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getSelectedNode();
        Object object = defaultMutableTreeNode2.getUserObject();
        if (object.toString().equals(collecStr[0])) {
            n = 0;
        } else if (object.toString().equals(collecStr[1])) {
            n = 1;
        } else {
            return;
        }
        int n2 = 0;
        Object[] objectArray = new DefaultMutableTreeNode[5];
        objectArray[n2++] = this.root;
        objectArray[n2++] = defaultMutableTreeNode2.getParent().getParent();
        objectArray[n2++] = defaultMutableTreeNode2.getParent();
        objectArray[n2++] = defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        if (defaultMutableTreeNode2.getChildCount() > 0) {
            objectArray[n2] = defaultMutableTreeNode2.getChildAt(0);
        } else {
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(new Dummy());
            this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            objectArray[n2] = defaultMutableTreeNode3;
            this.manage_expand = false;
        }
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        switch (n) {
            case 0: {
                defaultMutableTreeNode = new DefaultMutableTreeNode(new AccessAddress("*.*.*.*"));
                this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                objectArray[n2] = defaultMutableTreeNode;
                treePath = new TreePath(objectArray);
                this.setSelectionPath(treePath);
                this.scrollPathToVisible(treePath);
                break;
            }
            case 1: {
                defaultMutableTreeNode = new DefaultMutableTreeNode(new AccessDevice("*/*/*", 0));
                this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                objectArray[n2] = defaultMutableTreeNode;
                treePath = new TreePath(objectArray);
                this.setSelectionPath(treePath);
                this.scrollPathToVisible(treePath);
                break;
            }
            default: {
                return;
            }
        }
        if (defaultMutableTreeNode3 != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode3);
        }
        this.manage_expand = true;
        if (!this.editItem()) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    boolean editItem() {
        String string;
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return true;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof AccessDevice) {
            n = 1;
            string = ((AccessDevice)object).name;
        } else if (object instanceof AccessAddress) {
            n = 0;
            string = ((AccessAddress)object).name;
        } else {
            return false;
        }
        this.edit_item = new EditTreeItem((Frame)this.parent, this, string, n);
        if (this.edit_item.showDlg()) {
            String string2 = defaultMutableTreeNode.getParent().getParent().toString();
            String string3 = this.edit_item.getInputs();
            try {
                switch (n) {
                    case 0: {
                        AccessAddress accessAddress = (AccessAddress)object;
                        this.accessProxy.removeAddress(string2, accessAddress.name);
                        this.accessProxy.addAddress(string2, string3);
                        accessAddress.setName(string3);
                        this.rebuildNode(defaultMutableTreeNode, accessAddress);
                        break;
                    }
                    case 1: {
                        AccessDevice accessDevice = (AccessDevice)object;
                        this.accessProxy.removeDevice(string2, accessDevice.name, rightsStr[accessDevice.right]);
                        this.accessProxy.addDevice(string2, string3, rightsStr[accessDevice.right]);
                        accessDevice.name = string3;
                        this.rebuildNode(defaultMutableTreeNode, accessDevice);
                    }
                }
                return true;
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)devFailed);
            }
        }
        return false;
    }

    private void rebuildNode(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(object);
        int n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
        this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, n);
        this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    private boolean isAllUsersNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof AccessUser) {
            String string = ((AccessUser)object).getName();
            return string.equals("*");
        }
        return false;
    }

    private boolean isLastOneForAllUsers(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
        return this.isAllUsersNode(defaultMutableTreeNode3) && defaultMutableTreeNode2.getChildCount() == 1;
    }

    void removeItem() {
        int n;
        String string;
        String string2;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof AccessDevice) {
            if (this.isLastOneForAllUsers(defaultMutableTreeNode)) {
                admin.astor.tools.Utils.popupError(this.parent, "Cannot remove last device for all users");
                return;
            }
            string2 = defaultMutableTreeNode.getParent().getParent().toString();
            string = "Are you sure to want to remove :  " + object;
            n = 1;
        } else if (object instanceof AccessAddress) {
            if (this.isLastOneForAllUsers(defaultMutableTreeNode)) {
                admin.astor.tools.Utils.popupError(this.parent, "Cannot remove last address for all users");
                return;
            }
            string2 = defaultMutableTreeNode.getParent().getParent().toString();
            string = "Are you sure to want to remove :  " + object;
            n = 0;
        } else if (object instanceof AccessUser) {
            if (this.isAllUsersNode(defaultMutableTreeNode)) {
                admin.astor.tools.Utils.popupError(this.parent, "Cannot remove rights for all users");
                return;
            }
            string2 = ((AccessUser)object).getName();
            n = -2;
            string = "Are you sure to want to remove all records for " + object;
        } else {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, string, "Confirm Dialog", 0) != 0) {
            return;
        }
        try {
            switch (n) {
                case 0: {
                    AccessAddress accessAddress = (AccessAddress)object;
                    this.accessProxy.removeAddress(string2, accessAddress.name);
                    this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                    break;
                }
                case 1: {
                    AccessDevice accessDevice = (AccessDevice)object;
                    this.accessProxy.removeDevice(string2, accessDevice.name, rightsStr[accessDevice.right]);
                    this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                    break;
                }
                case -2: {
                    this.accessProxy.removeUser(string2);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    for (UserGroup userGroup : this.groups) {
                        if (!userGroup.getName().equals(defaultMutableTreeNode2.toString())) continue;
                        userGroup.remove(string2);
                        if (userGroup.isEmpty()) {
                            this.groups.remove(userGroup);
                            this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
                        } else {
                            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                        }
                        UserGroup.setUserGroupsToDatabase(this, this.groups);
                        return;
                    }
                    break;
                }
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)devFailed);
        }
    }

    private String[] getDefinedUsers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UserGroup userGroup : this.groups) {
            for (String string : userGroup) {
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void expendUserNode(String string) {
        TreePath treePath;
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getUserNode(string);
        int n = defaultMutableTreeNode.getPath().length;
        Object[] objectArray = new TreeNode[n + 2];
        int n2 = 0;
        objectArray[n2++] = this.root;
        if (n > 2) {
            objectArray[n2++] = defaultMutableTreeNode.getParent();
        }
        objectArray[n2++] = defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        if (defaultMutableTreeNode2.getChildCount() > 0) {
            objectArray[n2] = defaultMutableTreeNode2;
            objectArray[n2 + 1] = defaultMutableTreeNode2.getChildAt(0);
            serializable = new TreePath(objectArray);
            this.setSelectionPath((TreePath)serializable);
        }
        serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
        if (defaultMutableTreeNode2.getChildCount() > 0) {
            objectArray[n2] = serializable;
            objectArray[n2 + 1] = ((DefaultMutableTreeNode)serializable).getChildAt(0);
            treePath = new TreePath(objectArray);
            this.setSelectionPath(treePath);
        }
        objectArray = new TreeNode[n];
        n2 = 0;
        objectArray[n2++] = this.root;
        if (n > 2) {
            objectArray[n2++] = defaultMutableTreeNode.getParent();
        }
        objectArray[n2] = defaultMutableTreeNode;
        treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
    }

    private DefaultMutableTreeNode getUserNode(String string) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            Object object = defaultMutableTreeNode.getUserObject();
            if (object.toString().equals(string)) {
                return defaultMutableTreeNode;
            }
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                object = defaultMutableTreeNode2.getUserObject();
                if (!object.toString().equals(string)) continue;
                return defaultMutableTreeNode2;
            }
        }
        return new DefaultMutableTreeNode(string);
    }

    private boolean userExists(String string) {
        String[] stringArray;
        for (String string2 : stringArray = this.getDefinedUsers()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    void changeGroup() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        Object object = defaultMutableTreeNode2.getUserObject();
        if (!(object instanceof UserGroup)) {
            return;
        }
        UserGroup userGroup = (UserGroup)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof AccessUser) {
            String string = ((AccessUser)object2).getName();
            String string2 = "Move " + string + " from " + userGroup + "  to ";
            ChooseGroupDialog chooseGroupDialog = new ChooseGroupDialog(this.parent, string2, this.groups);
            if (chooseGroupDialog.showDialog() != 2) {
                UserGroup userGroup2 = chooseGroupDialog.getUserGroup();
                if (userGroup2 == userGroup) {
                    return;
                }
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                defaultMutableTreeNode2 = this.getGroupNode(userGroup2.getName());
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(userGroup2);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode2, this.root, this.root.getChildCount());
                    this.groups.add(userGroup2);
                }
                this.treeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                userGroup.remove(string);
                userGroup2.add(string);
                UserGroup.setUserGroupsToDatabase(this, this.groups);
                Object[] objectArray = new TreeNode[]{this.root, defaultMutableTreeNode2, defaultMutableTreeNode};
                TreePath treePath = new TreePath(objectArray);
                this.setSelectionPath(treePath);
                treePath = new TreePath(objectArray);
                this.setSelectionPath(treePath);
                this.scrollPathToVisible(treePath);
            }
        }
    }

    void cloneUser() {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        UserGroup userGroup = null;
        Object object2 = defaultMutableTreeNode2.getUserObject();
        if (object2 instanceof UserGroup) {
            userGroup = (UserGroup)object2;
        }
        if ((object = defaultMutableTreeNode.getUserObject()) instanceof AccessUser) {
            Serializable serializable;
            String string = ((AccessUser)object).getName();
            String[] stringArray = new String[]{""};
            boolean bl = false;
            while (!bl) {
                serializable = new EditDialog(this.parent, "", null, this.groups, userGroup);
                if (serializable.showDialog() != 0) {
                    return;
                }
                stringArray = serializable.getInputs();
                bl = this.checkUserName(stringArray[0]);
                userGroup = serializable.getUserGroup();
            }
            String string2 = stringArray[0];
            defaultMutableTreeNode2 = this.getGroupNode(userGroup.getName());
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(userGroup);
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, this.root, this.root.getChildCount());
                this.groups.add(userGroup);
                Collections.sort(this.groups, new GroupComparator());
            }
            try {
                this.accessProxy.cloneUser(string, string2);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)devFailed);
                return;
            }
            userGroup.add(string2);
            serializable = new DefaultMutableTreeNode(new AccessUser(string2));
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(collecStr[0]);
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(collecStr[1]);
            this.treeModel.insertNodeInto(defaultMutableTreeNode3, (MutableTreeNode)((Object)serializable), 0);
            this.treeModel.insertNodeInto(defaultMutableTreeNode4, (MutableTreeNode)((Object)serializable), 1);
            this.treeModel.insertNodeInto((MutableTreeNode)((Object)serializable), defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(new Dummy()), defaultMutableTreeNode3, 0);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(new Dummy()), defaultMutableTreeNode4, 0);
            UserGroup.setUserGroupsToDatabase(this, this.groups);
            Object[] objectArray = new DefaultMutableTreeNode[]{this.root, serializable, defaultMutableTreeNode3};
            TreePath treePath = new TreePath(objectArray);
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pasteItem() {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof String)) return;
        if (object.toString().equals(collecStr[1])) {
            n = 1;
        } else {
            if (!object.toString().equals(collecStr[0])) return;
            n = 0;
        }
        String string = defaultMutableTreeNode.getParent().toString();
        try {
            Object object2;
            Object[] objectArray;
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            switch (n) {
                case 0: {
                    objectArray = this.copied_addresses.addressAt((int)0).name;
                    this.accessProxy.addAddress(string, (String)objectArray);
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(new AccessAddress((String)objectArray));
                    this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    break;
                }
                case 1: {
                    object2 = this.copied_devices.deviceAt((int)0).name;
                    int n2 = this.copied_devices.deviceAt((int)0).right;
                    this.accessProxy.addDevice(string, (String)object2, rightsStr[n2]);
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(new AccessDevice((String)object2, n2));
                    this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                }
            }
            objectArray = new DefaultMutableTreeNode[]{this.root, defaultMutableTreeNode.getParent(), defaultMutableTreeNode, defaultMutableTreeNode2};
            object2 = new TreePath(objectArray);
            this.setSelectionPath((TreePath)object2);
            this.scrollPathToVisible((TreePath)object2);
            return;
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)devFailed);
        }
    }

    void copyItem() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        int n = object instanceof AccessDevice ? 1 : 0;
        switch (n) {
            case 0: {
                this.copied_addresses.clear();
                this.copied_addresses.add((AccessAddress)object);
                break;
            }
            case 1: {
                this.copied_devices.clear();
                this.copied_devices.add((AccessDevice)object);
            }
        }
    }

    void toggleRight() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent().getParent();
        Object object2 = defaultMutableTreeNode.getUserObject();
        String string = ((AccessUser)object2).getName();
        try {
            AccessDevice accessDevice = (AccessDevice)object;
            int n = accessDevice.right == 1 ? 0 : 1;
            this.accessProxy.removeDevice(string, accessDevice.name, rightsStr[accessDevice.right]);
            this.accessProxy.addDevice(string, accessDevice.name, rightsStr[n]);
            accessDevice.right = n;
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)devFailed);
        }
    }

    private List<String> getUserList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof AccessUser)) continue;
            AccessUser accessUser = (AccessUser)object;
            arrayList.add(accessUser.toString());
        }
        return arrayList;
    }

    public void findUser(String string) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            this.findUser(string, (DefaultMutableTreeNode)this.root.getChildAt(i));
        }
    }

    public void findUser(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            AccessUser accessUser;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object = defaultMutableTreeNode2.getUserObject();
            if (!(object instanceof AccessUser) || !(accessUser = (AccessUser)object).toString().equals(string)) continue;
            this.expandChildren(defaultMutableTreeNode2);
        }
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        arrayList.add(defaultMutableTreeNode);
        while (defaultMutableTreeNode != this.root) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            arrayList.add(0, defaultMutableTreeNode);
        }
        Object[] objectArray = arrayList.toArray(new TreeNode[arrayList.size()]);
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private void expandChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = false;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) {
                if (bl) continue;
                this.expandNode(defaultMutableTreeNode2);
                bl = true;
                continue;
            }
            this.expandChildren(defaultMutableTreeNode2);
        }
    }

    static {
        background = Color.WHITE;
    }

    private class GroupComparator
    implements Comparator<UserGroup> {
        private GroupComparator() {
        }

        @Override
        public int compare(UserGroup userGroup, UserGroup userGroup2) {
            if (userGroup.getName().equals("Unsorted Users")) {
                return 1;
            }
            if (userGroup.getName().equals("Unsorted Users")) {
                return -1;
            }
            return userGroup.getName().compareTo(userGroup2.getName());
        }
    }

    class CopiedAddresses
    extends ArrayList<AccessAddress> {
        CopiedAddresses() {
        }

        AccessAddress addressAt(int n) {
            return (AccessAddress)this.get(n);
        }
    }

    class CopiedDevices
    extends ArrayList<AccessDevice> {
        CopiedDevices() {
        }

        AccessDevice deviceAt(int n) {
            return (AccessDevice)this.get(n);
        }
    }

    private class Dummy {
        private Dummy() {
        }

        public String toString() {
            return "";
        }
    }

    class AccessDevice {
        String name;
        int right = 1;

        private AccessDevice(String string, String string2) {
            this.name = string;
            for (int i = 0; i < rightsStr.length; ++i) {
                if (!rightsStr[i].equals(string2)) continue;
                this.right = i;
            }
        }

        private AccessDevice(String string, int n) {
            this.name = string;
            this.right = n;
        }

        public String toString() {
            return this.name;
        }
    }

    class AccessAddress {
        String name;
        private String hostname = null;

        private AccessAddress(String string) {
            this.name = string;
            this.checkHostname(string);
        }

        private void checkHostname(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            byte[] byArray = new byte[4];
            for (int i = 0; i < 4 && i < arrayList.size(); ++i) {
                try {
                    byArray[i] = (byte)Integer.parseInt((String)arrayList.get(i));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.hostname = null;
                    return;
                }
            }
            try {
                InetAddress inetAddress = InetAddress.getByAddress(byArray);
                this.hostname = inetAddress.getHostName();
                int n = this.hostname.indexOf(46);
                if (n > 0) {
                    this.hostname = this.hostname.substring(0, n);
                }
            }
            catch (Exception exception) {
                this.hostname = null;
            }
        }

        private void setName(String string) {
            this.name = string;
            this.checkHostname(string);
        }

        public String toString() {
            if (this.hostname == null) {
                return this.name;
            }
            return this.name + "  (" + this.hostname + ")";
        }
    }

    class AccessUser {
        private String name;

        private AccessUser(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name.equals("*") ? "All Users" : this.name;
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int ALL_USERS = 1;
        private final int USER = 2;
        private final int COLLEC = 3;
        private final int LEAF = 4;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            tango_icon = utils.getIcon("TangoClass.gif", 0.33);
            all_users_icon = utils.getIcon("user.gif", 1.0);
            group_icon = utils.getIcon("user.gif", 0.8);
            user_icon = utils.getIcon("user.gif", 0.6);
            add_icon = utils.getIcon("server.gif");
            dev_icon = utils.getIcon("device.gif");
            write_icon = utils.getIcon("greenbal.gif");
            read_icon = utils.getIcon("redball.gif");
            this.fonts = new Font[5];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 16);
            this.fonts[2] = new Font("Dialog", 1, 12);
            this.fonts[3] = new Font("Dialog", 1, 12);
            this.fonts[4] = new Font("Monospaced", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (n == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(tango_icon);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof UserGroup) {
                    UserGroup userGroup = (UserGroup)defaultMutableTreeNode.getUserObject();
                    this.setFont(userGroup.getFont());
                    this.setIcon(group_icon);
                } else if (defaultMutableTreeNode.getUserObject() instanceof AccessUser) {
                    String string = ((AccessUser)defaultMutableTreeNode.getUserObject()).getName();
                    if (string.equals("*")) {
                        this.setFont(this.fonts[1]);
                        this.setIcon(all_users_icon);
                    } else {
                        this.setFont(this.fonts[2]);
                        this.setIcon(user_icon);
                    }
                } else if (defaultMutableTreeNode.getUserObject() instanceof String) {
                    this.setFont(this.fonts[3]);
                    if (object.toString().equals(collecStr[0])) {
                        this.setIcon(add_icon);
                    } else {
                        this.setIcon(dev_icon);
                    }
                } else if (defaultMutableTreeNode.getUserObject() instanceof AccessAddress) {
                    this.setFont(this.fonts[4]);
                    this.setIcon(add_icon);
                } else if (defaultMutableTreeNode.getUserObject() instanceof AccessDevice) {
                    this.setFont(this.fonts[4]);
                    AccessDevice accessDevice = (AccessDevice)defaultMutableTreeNode.getUserObject();
                    if (accessDevice.right == 0) {
                        this.setIcon(write_icon);
                    } else {
                        this.setIcon(read_icon);
                    }
                }
            }
            return this;
        }
    }
}

