/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.AstorUtil;
import admin.astor.access.AccessProxy;
import admin.astor.access.AllowedCmdTree;
import admin.astor.access.EditDialog;
import admin.astor.access.PasswordDialog;
import admin.astor.access.UsersTree;
import admin.astor.access.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class TangoAccess
extends JFrame {
    String accessDeviceName;
    UsersTree usersTree;
    private AccessProxy accessProxy;
    private EditDialog checkDialog = null;
    private JFrame parent;
    private static final Dimension pane_size = new Dimension(350, 500);
    private String userName;
    private JMenu actionMenu;
    private JMenuItem checkAccessBtn;
    private JPanel cmdClassPanel;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JMenuItem findItem;
    private JMenu helpMenu;
    private JMenuItem principleItem;
    private JRadioButtonMenuItem registerItem;
    private JLabel superUserLabel;
    private JTabbedPane tabbedPane;
    private JPanel usersPanel;

    public TangoAccess(JFrame jFrame) throws DevFailed {
        this.parent = jFrame;
        try {
            AstorUtil.startSplash("TangoAccess ");
            AstorUtil.increaseSplashProgress(5, "Reading database");
            String string = System.getenv("AccessControl");
            if (string == null) {
                this.getTangoService();
            } else {
                this.accessDeviceName = string;
            }
            this.initComponents();
            this.initOwnComponents();
            AstorUtil.increaseSplashProgress(5, "Finalize GUI");
            ImageIcon imageIcon = Utils.getInstance().getIcon("TangoClass.gif");
            this.setIconImage(imageIcon.getImage());
            this.setTitle("Tango Access Control Manager");
            if (TangoAccess.isSuperUser()) {
                this.superUserLabel.setVisible(true);
            } else if (this.accessProxy.getAccessControl() == 0) {
                this.superUserLabel.setVisible(true);
                this.superUserLabel.setText("Read Only Mode !");
                this.superUserLabel.setForeground(Color.red);
            } else {
                this.superUserLabel.setVisible(false);
            }
            this.pack();
            if (jFrame.getWidth() > 0) {
                Point point = jFrame.getLocationOnScreen();
                point.x += 100;
                point.y += 100;
                this.setLocation(point);
            } else {
                ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
            }
            AstorUtil.stopSplash();
        }
        catch (DevFailed devFailed) {
            AstorUtil.stopSplash();
            throw devFailed;
        }
    }

    private static boolean isSuperUser() {
        boolean bl = false;
        String string = System.getProperty("SUPER_TANGO");
        if (string != null) {
            if (string.toLowerCase().equals("true")) {
                bl = true;
            }
        } else {
            string = System.getenv("SUPER_TANGO");
            if (string != null && string.toLowerCase().equals("true")) {
                bl = true;
            }
        }
        return bl;
    }

    private void getTangoService() throws DevFailed {
        String[] stringArray = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
        if (stringArray.length == 0) {
            Except.throw_communication_failed((String)"Service_DoesNotExist", (String)"There is no AccessControl service defined !", (String)"TangoAccess.TangoAccess()");
        }
        this.accessDeviceName = stringArray[0];
    }

    private void initOwnComponents() throws DevFailed {
        this.fileMenu.setMnemonic('F');
        this.checkAccessBtn.setMnemonic('T');
        this.checkAccessBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.actionMenu.setMnemonic('A');
        this.registerItem.setMnemonic('R');
        this.findItem.setMnemonic('R');
        this.findItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.helpMenu.setMnemonic('H');
        this.principleItem.setMnemonic('P');
        this.principleItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.accessProxy = new AccessProxy(this.accessDeviceName);
        if (this.accessProxy.getAccessControl() == 0) {
            this.checkAccessBtn.setEnabled(false);
            this.actionMenu.setEnabled(false);
        }
        this.tabbedPane.setTitleAt(0, "Users");
        this.tabbedPane.setTitleAt(1, "Allowed Cmd");
        this.usersTree = new UsersTree(this, this.accessProxy);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.usersTree);
        this.usersPanel.add((Component)jScrollPane, "Center");
        AllowedCmdTree allowedCmdTree = new AllowedCmdTree(this, this.accessProxy);
        jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(allowedCmdTree);
        this.cmdClassPanel.add((Component)jScrollPane, "Center");
        JLabel jLabel = new JLabel("Devices: ");
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jLabel = new JLabel("Read/Write");
        jLabel.setIcon(Utils.getInstance().getIcon("greenbal.gif"));
        jPanel.add(jLabel);
        jLabel = new JLabel("Read Only");
        jLabel.setIcon(Utils.getInstance().getIcon("redball.gif"));
        jPanel.add(jLabel);
        this.usersPanel.add((Component)jPanel, "South");
        this.tabbedPane.setPreferredSize(pane_size);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.usersPanel = new JPanel();
        this.cmdClassPanel = new JPanel();
        JPanel jPanel = new JPanel();
        this.superUserLabel = new JLabel();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.checkAccessBtn = new JMenuItem();
        JMenuItem jMenuItem = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.actionMenu = new JMenu();
        this.findItem = new JMenuItem();
        this.registerItem = new JRadioButtonMenuItem();
        this.helpMenu = new JMenu();
        this.principleItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TangoAccess.this.exitForm(windowEvent);
            }
        });
        this.usersPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("tab1", this.usersPanel);
        this.cmdClassPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("tab2", this.cmdClassPanel);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.superUserLabel.setFont(new Font("Tahoma", 1, 12));
        this.superUserLabel.setText("You are Super User !");
        jPanel.add(this.superUserLabel);
        this.getContentPane().add((Component)jPanel, "First");
        this.fileMenu.setText("File");
        this.checkAccessBtn.setText("Test Tango Acces");
        this.checkAccessBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.checkAccessBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.checkAccessBtn);
        jMenuItem.setText("Change Password");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.passwordItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(jMenuItem);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.exitBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar.add(this.fileMenu);
        this.actionMenu.setText("Action");
        this.actionMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TangoAccess.this.actionMenuItemStateChanged(itemEvent);
            }
        });
        this.findItem.setText("Find User");
        this.findItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.findItemActionPerformed(actionEvent);
            }
        });
        this.actionMenu.add(this.findItem);
        this.registerItem.setText("Register Service");
        this.registerItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.registerItemActionPerformed(actionEvent);
            }
        });
        this.actionMenu.add(this.registerItem);
        jMenuBar.add(this.actionMenu);
        this.helpMenu.setText("help");
        this.principleItem.setText("On Principle");
        this.principleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TangoAccess.this.principleItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.principleItem);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void actionMenuItemStateChanged(ItemEvent itemEvent) {
        if (!this.actionMenu.isSelected()) {
            return;
        }
        try {
            String[] stringArray = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
            this.registerItem.setSelected(stringArray.length != 0);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)devFailed);
        }
    }

    private void registerItemActionPerformed(ActionEvent actionEvent) {
        try {
            boolean bl = this.registerItem.getSelectedObjects() != null;
            this.accessProxy.registerService(bl);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)devFailed);
        }
    }

    private void checkAccessBtnActionPerformed(ActionEvent actionEvent) {
        if (this.checkDialog == null) {
            this.checkDialog = new EditDialog(this, this.accessProxy);
            this.checkDialog.showDialog();
        } else {
            this.checkDialog.setVisible(true);
        }
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.doClose();
    }

    private void principleItemActionPerformed(ActionEvent actionEvent) {
        admin.astor.tools.Utils.popupMessage(this, "This access management is necessary only if the\n    \"AccessControl/tango\"\n    Tango service has been installed.\n\nBy default all devices are forbiden for all users.\nAnd the rights will be opened for [user, address, device].\n\nThis tool is able to define WRITE access \n    on devices for a TANGO control system\n\nYou can define for a specified user:\n    - Allowed addresses to write devices\n    - Set devices acces to  READ_WRITE or READ_ONLY");
    }

    private void passwordItemActionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        while (!bl) {
            PasswordDialog passwordDialog = new PasswordDialog((JFrame)this, "New Password ?");
            if (passwordDialog.showDialog() == 0) {
                String string = passwordDialog.getPassword();
                passwordDialog = new PasswordDialog((JFrame)this, "Confirm New Passsword:");
                if (passwordDialog.showDialog() == 0) {
                    String string2 = passwordDialog.getPassword();
                    if (string.equals(string2)) {
                        try {
                            TangoAccess.savePassword(string);
                        }
                        catch (DevFailed devFailed) {
                            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
                        }
                        bl = true;
                        continue;
                    }
                    TangoAccess.popupError(this, "Passwords are not equals !");
                    continue;
                }
                return;
            }
            return;
        }
    }

    private void findItemActionPerformed(ActionEvent actionEvent) {
        String string = (String)JOptionPane.showInputDialog(this, "Host Name ?", "Input Dialog", 1, null, null, this.userName);
        if (string != null) {
            this.userName = string;
            this.usersTree.findUser(this.userName);
        }
    }

    private static String getPasswordFromDatabase() throws DevFailed {
        DbDatum dbDatum = ApiUtil.get_db_obj().get_property("Astor", "access");
        String string = "???";
        if (!dbDatum.is_empty()) {
            string = dbDatum.extractString();
        }
        return PasswordDialog.decryptPassword(string);
    }

    private static void savePassword(String string) throws DevFailed {
        DbDatum dbDatum = new DbDatum("access");
        dbDatum.insert(PasswordDialog.cryptPassword(string));
        ApiUtil.get_db_obj().put_property("Astor", new DbDatum[]{dbDatum});
    }

    public static int checkPassword(JFrame jFrame) throws DevFailed {
        if (TangoAccess.isSuperUser()) {
            return 0;
        }
        String string = TangoAccess.getPasswordFromDatabase();
        PasswordDialog passwordDialog = new PasswordDialog(jFrame, string.getBytes());
        return passwordDialog.showDialog();
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0 && stringArray[0].equals("-???")) {
                System.out.println(TangoAccess.getPasswordFromDatabase());
                System.exit(0);
            }
            if (TangoAccess.checkPassword(new JFrame()) == 0) {
                new TangoAccess(new JFrame()).setVisible(true);
            } else {
                System.exit(0);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)"Cannot start TangoAccess class", (DevFailed)devFailed);
            System.exit(0);
        }
        catch (HeadlessException | InternalError throwable) {
            System.out.println(throwable);
            System.exit(0);
        }
    }

    public static void popupError(Component component, String string) {
        try {
            throw new Exception(string);
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)component, null, (Exception)exception);
            return;
        }
    }
}

