/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import admin.astor.access.UserGroup;
import admin.astor.access.UsersTree;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditDialog
extends JDialog {
    private int retVal = 0;
    static final int CHECK_ACCESS = 0;
    static final int EDIT_USER = 1;
    static final int CLONE_USER = 2;
    private int mode = 1;
    private static String[] titles;
    private static final String[] check_titles;
    private static final String[] edit_titles;
    private static final String[] clone_titles;
    static final int USER = 0;
    static final int ADDRESS = 1;
    static final int DEVICE = 2;
    private AccessProxy accessProxy;
    private JTextField[] textFields;
    private JLabel checkResultLabel;
    private JLabel[] labels;
    private JComboBox<UserGroup> groupBox;
    private JPanel centerPanel;
    private JButton okBtn;

    public EditDialog(JFrame jFrame, String string, String string2, List<UserGroup> list, UserGroup userGroup) {
        super((Frame)jFrame, true);
        this.mode = string2 == null ? 2 : 1;
        titles = string2 == null ? clone_titles : edit_titles;
        this.initComponents();
        this.initOwnComponents(titles);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.groupBox = new JComboBox();
        for (UserGroup userGroup2 : list) {
            this.groupBox.addItem(userGroup2);
        }
        this.groupBox.setEditable(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.centerPanel.add(this.groupBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        this.centerPanel.add((Component)new JLabel("Group:"), gridBagConstraints);
        if (userGroup != null) {
            this.groupBox.setSelectedItem(userGroup);
        } else {
            this.groupBox.setSelectedItem("");
        }
        if (this.mode != 2) {
            this.labels[2].setVisible(false);
            this.textFields[2].setVisible(false);
            this.textFields[0].setText(string);
            this.textFields[1].setText(string2);
        }
        this.centerDialog(jFrame);
        this.textFields[0].requestFocus();
    }

    public EditDialog(JFrame jFrame, AccessProxy accessProxy) {
        super((Frame)jFrame, true);
        this.mode = 0;
        titles = check_titles;
        this.accessProxy = accessProxy;
        this.initComponents();
        this.initOwnComponents(titles);
        this.centerDialog(jFrame);
    }

    private void centerDialog(JFrame jFrame) {
        this.pack();
        Point point = jFrame.getLocationOnScreen();
        point.x += (jFrame.getWidth() - this.getWidth()) / 2;
        point.y += (jFrame.getHeight() - this.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        this.setLocation(point);
    }

    private void initOwnComponents(String[] stringArray) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.textFields = new JTextField[stringArray.length];
        this.labels = new JLabel[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.labels[i] = new JLabel(stringArray[i] + ":  ");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i + 1;
            gridBagConstraints.fill = 2;
            this.centerPanel.add((Component)this.labels[i], gridBagConstraints);
            this.textFields[i] = new JTextField();
            this.textFields[i].setColumns(20);
            this.textFields[i].addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    EditDialog.this.textKeyPressed(keyEvent);
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i + 1;
            gridBagConstraints.fill = 2;
            this.centerPanel.add((Component)this.textFields[i], gridBagConstraints);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.okBtn = new JButton();
        JButton jButton = new JButton();
        this.centerPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EditDialog.this.closeDialog(windowEvent);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.okBtn);
        jButton.setText("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.pack();
    }

    private boolean checkInputs() {
        String string;
        String string2 = this.textFields[0].getText().trim().toLowerCase();
        this.textFields[0].setText(string2);
        if (this.mode != 0) {
            string = this.groupBox.getSelectedItem().toString();
            if (string.startsWith("All") || string.endsWith("Users")) {
                Utils.popupError(this, "Incoherent group name !");
                return false;
            }
            if (this.mode == 1 && string.length() == 0) {
                Utils.popupError(this, "Group name ?");
                return false;
            }
        }
        if (string2.length() == 0) {
            Utils.popupError(this, "User name NOT defined !");
            return false;
        }
        if (this.mode != 2) {
            StringTokenizer stringTokenizer;
            Serializable serializable;
            string = this.textFields[1].getText().trim();
            String string3 = this.textFields[2].getText().trim().toLowerCase();
            if (string.length() == 0 || this.mode == 0 && string3.length() == 0) {
                Utils.popupError(this, "Please fill all fields !");
                return false;
            }
            this.textFields[2].setText(string3);
            this.textFields[1].setText(string);
            try {
                serializable = InetAddress.getByName(string);
                string = ((InetAddress)serializable).getHostAddress();
                this.textFields[1].setText(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializable = new ArrayList();
            if (this.mode == 0) {
                stringTokenizer = new StringTokenizer(string3, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    serializable.add(stringTokenizer.nextToken());
                }
                if (serializable.size() > 3) {
                    Utils.popupError(this, "Incorrect device name  (too many members)");
                    return false;
                }
                if (serializable.size() < 3) {
                    Utils.popupError(this, "Incorrect device name  (not enough members)");
                    return false;
                }
            }
            stringTokenizer = new StringTokenizer(string, ".");
            serializable.clear();
            while (stringTokenizer.hasMoreTokens()) {
                serializable.add(stringTokenizer.nextToken());
            }
            if (serializable.size() > 4) {
                Utils.popupError(this, "Incorrect IP address  (Too many members)");
                return false;
            }
            if (serializable.size() < 4) {
                Utils.popupError(this, "Incorrect IP address  (not enougth members)");
                return false;
            }
            string = (String)serializable.get(0) + "." + (String)serializable.get(1) + "." + (String)serializable.get(2) + "." + (String)serializable.get(3);
            this.textFields[1].setText(string);
            for (int i = 0; i < serializable.size(); ++i) {
                try {
                    Short.parseShort((String)serializable.get(i));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    if (((String)serializable.get(i)).equals("*")) continue;
                    Utils.popupError(this, "Incorrect IP address  (member #" + (i + 1) + " (" + (String)serializable.get(i) + ") is not a number)");
                    return false;
                }
            }
        }
        return true;
    }

    private void checkAccess() {
        try {
            String string = this.accessProxy.getAccess(this.getInputs());
            this.checkResultLabel.setText(string);
            if (string.equals("read")) {
                this.checkResultLabel.setIcon(UsersTree.read_icon);
            } else {
                this.checkResultLabel.setIcon(UsersTree.write_icon);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot check TANGO Access", (DevFailed)devFailed);
        }
    }

    private void textKeyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\u001b': {
                this.retVal = 2;
                this.doClose();
                break;
            }
            case '\n': {
                switch (this.mode) {
                    case 1: 
                    case 2: {
                        if (!this.checkInputs()) break;
                        this.retVal = 0;
                        this.doClose();
                        break;
                    }
                    case 0: {
                        if (!this.checkInputs()) break;
                        this.checkAccess();
                    }
                }
                break;
            }
            default: {
                if (this.mode != 0) break;
                this.checkResultLabel.setText("...");
                this.checkResultLabel.setIcon(null);
            }
        }
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (this.checkInputs()) {
            this.retVal = 0;
            if (this.mode == 0) {
                this.checkAccess();
            } else {
                this.doClose();
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public String[] getInputs() {
        String[] stringArray = new String[this.textFields.length];
        for (int i = 0; i < this.textFields.length; ++i) {
            stringArray[i] = this.textFields[i].getText().trim();
        }
        return stringArray;
    }

    public UserGroup getUserGroup() {
        Object object = this.groupBox.getSelectedItem();
        if (object instanceof UserGroup) {
            return (UserGroup)object;
        }
        String string = object.toString();
        if (string.length() == 0) {
            return null;
        }
        return new UserGroup(string);
    }

    public int showDialog() {
        if (this.mode == 0) {
            try {
                this.textFields[0].setText(System.getProperty("user.name").toLowerCase());
                this.textFields[1].setText(InetAddress.getLocalHost().getHostAddress());
                this.okBtn.setText("Check");
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.checkResultLabel = new JLabel("...");
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = titles.length + 1;
                gridBagConstraints.fill = 2;
                this.centerPanel.add((Component)this.checkResultLabel, gridBagConstraints);
                this.pack();
            }
            catch (UnknownHostException unknownHostException) {
                Utils.popupError(this, null, unknownHostException);
            }
        }
        this.setVisible(true);
        return this.retVal;
    }

    static {
        check_titles = new String[]{"User Name", "IP Address", "Device"};
        edit_titles = new String[]{"User Name", "Allowed Address", "Device"};
        clone_titles = new String[]{"User Name"};
    }
}

