/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.HostStateThread;
import admin.astor.TangoServer;
import admin.astor.tools.BlackBoxTable;
import admin.astor.tools.PopupTable;
import admin.astor.tools.PopupText;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TangoHost
extends DeviceProxy {
    private TangoServer starter = null;
    private String name;
    private List<TangoServer> servers = new ArrayList<TangoServer>();
    public String usage = null;
    public int state;
    public DevFailed except;
    public boolean poll_serv_lists = false;
    public String collection = null;
    public HostStateThread thread = null;
    public int notifydState;
    public boolean onEvents = true;
    public boolean manageNotifd;
    public HostInfoDialog info_dialog = null;
    public TangoEventsAdapter supplier = null;
    public String eventSource = "";
    private String adm_name;

    public TangoHost(String string, boolean bl) throws DevFailed {
        super(AstorUtil.getStarterDeviceHeader() + string);
        this.adm_name = "dserver/starter/" + string;
        this.set_transparency_reconnection(true);
        this.notifydState = 0;
        int n = string.indexOf(".");
        this.name = n < 0 ? string : string.substring(0, n);
        if (bl) {
            DbDatum dbDatum;
            DbDatum dbDatum2 = this.get_property("HostCollection");
            if (!dbDatum2.is_empty()) {
                this.collection = dbDatum2.extractString();
            }
            if (!(dbDatum = this.get_property("HostUsage")).is_empty()) {
                this.usage = dbDatum.extractString();
                if (this.usage.length() == 0) {
                    this.usage = null;
                }
            }
            this.manageNotifd = false;
            try {
                dbDatum2 = this.get_property("UseEvents");
                if (!dbDatum2.is_empty()) {
                    this.manageNotifd = dbDatum2.extractShort() != 0;
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }

    static String controlMethod(boolean bl) {
        return bl ? "on events" : "on polling";
    }

    public TangoHost(DbDevImportInfo dbDevImportInfo, DbDevImportInfo dbDevImportInfo2) throws DevFailed {
        super(dbDevImportInfo);
        this.adm_name = dbDevImportInfo2.name;
        this.set_transparency_reconnection(true);
        this.notifydState = 0;
        int n = dbDevImportInfo.name.indexOf(".");
        this.name = n < 0 ? dbDevImportInfo.name : dbDevImportInfo.name.substring(0, n);
        int n2 = this.name.indexOf(47);
        if (n2 > 0) {
            n2 = this.name.indexOf(47, n2 + 1);
        }
        if (n2 > 0) {
            this.name = this.name.substring(n2 + 1);
        }
    }

    public void addServer(TangoServer tangoServer) {
        this.servers.add(tangoServer);
    }

    public TangoServer getServer(String string) {
        string = string.trim();
        for (int i = 0; i < this.nbServers(); ++i) {
            TangoServer tangoServer = this.getServer(i);
            if (!tangoServer.getName().equals(string)) continue;
            return tangoServer;
        }
        return null;
    }

    public TangoServer getServer(int n) {
        return this.servers.get(n);
    }

    public List<String> getServerNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray;
            DeviceAttribute deviceAttribute = this.read_attribute("Servers");
            for (String string : stringArray = deviceAttribute.extractStringArray()) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                arrayList.add(string2);
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return arrayList;
    }

    public void removeServer(int n) {
        this.servers.remove(n);
    }

    public void removeServer(String string) {
        for (int i = 0; i < this.nbServers(); ++i) {
            TangoServer tangoServer = this.getServer(i);
            if (!tangoServer.getName().equals(string)) continue;
            this.removeServer(i);
            return;
        }
    }

    public int nbServers() {
        if (this.servers == null) {
            return 0;
        }
        return this.servers.size();
    }

    public String[] getServerAttribute() {
        try {
            DeviceAttribute deviceAttribute = this.read_attribute("Servers");
            return deviceAttribute.extractStringArray();
        }
        catch (DevFailed devFailed) {
            System.out.println(this.name);
            Except.print_exception((Exception)((Object)devFailed));
            return new String[0];
        }
    }

    public String readLogFile(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DevReadLog", deviceData);
        return deviceData2.extractString();
    }

    public void registerServer(String string) throws DevFailed {
        IORdump iORdump;
        String string2 = "dserver/" + string;
        boolean bl = false;
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string2);
            deviceProxy.ping();
            bl = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (bl) {
            iORdump = new IORdump(string2);
            Except.throw_exception((String)"StartServerFailed", (String)(string + " is already running on " + iORdump.get_host()), (String)"DevWizard.startServer()");
        }
        iORdump = new DbDevExportInfo(string2, "null", this.name, "null");
        ApiUtil.get_db_obj().export_device((DbDevExportInfo)iORdump);
        ApiUtil.get_db_obj().unexport_device(string2);
    }

    public void startOneServer(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        System.out.println("command_inout(DevStart, " + string + ") on " + this.get_name());
        this.command_inout("DevStart", deviceData);
    }

    public void startServer(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DevStart", deviceData);
    }

    public void stopServer(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DevStop", deviceData);
    }

    public void hardKillServer(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("HardKillServer", deviceData);
    }

    public void startServers(int n) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert((short)n);
        this.command_inout("DevStartAll", deviceData);
    }

    public void stopServers(int n) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert((short)n);
        this.command_inout("DevStopAll", deviceData);
    }

    public void displayUptimes(JFrame jFrame) {
        try {
            Database database = ApiUtil.get_db_obj();
            DeviceData deviceData = new DeviceData();
            deviceData.insert(this.name);
            DeviceData deviceData2 = database.command_inout("DbGetHostServerList", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            for (String string : stringArray) {
                String[] stringArray2 = new TangoServer("dserver/" + string).getServerUptime();
                arrayList.add(new String[]{string, stringArray2[0], stringArray2[1]});
            }
            String[] stringArray3 = new String[]{"Server", "Last   exported", "Last unexported"};
            PopupTable popupTable = new PopupTable(jFrame, this.name, stringArray3, arrayList, new Dimension(650, 250));
            popupTable.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)jFrame, null, (DevFailed)devFailed);
        }
    }

    public void displayLogging(JFrame jFrame) {
        this.displayLogging(jFrame, null);
    }

    public void displayLogging(Component component, String string) {
        try {
            String[] stringArray;
            DeviceData deviceData = new DeviceData();
            deviceData.insert("Starter");
            DeviceData deviceData2 = this.command_inout("DevReadLog", deviceData);
            String string2 = deviceData2.extractString();
            String[] stringArray2 = AstorUtil.string2array(string2, "\n");
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            String string3 = null;
            for (String string4 : stringArray2) {
                String[] stringArray3 = AstorUtil.string2array(string4);
                String string5 = stringArray3[2];
                stringArray3[2] = stringArray3[3];
                stringArray3[3] = string5;
                if (string != null && !string5.equals(string)) continue;
                if (string3 != null && !stringArray3[0].equals(string3)) {
                    arrayList.add(new String[]{"-", "-", "-", "-"});
                }
                string3 = stringArray3[0];
                arrayList.add(stringArray3);
            }
            if (arrayList.size() > 0) {
                stringArray = new String[]{"Date", "Time", "Action", "Server"};
                PopupTable popupTable = component instanceof JFrame ? new PopupTable((JFrame)component, "Starter on " + this.name, stringArray, arrayList) : new PopupTable((JDialog)component, "Starter on " + this.name, stringArray, arrayList);
                popupTable.setColumnWidth(new int[]{70, 70, 70, 250});
                popupTable.setSortAvailable(false);
                popupTable.setVisible(true);
            } else {
                stringArray = "no record found";
                if (string != null) {
                    stringArray = (String)stringArray + "  for  " + string;
                }
                Except.throw_exception((String)"", (String)stringArray, (String)"");
            }
        }
        catch (DevFailed devFailed) {
            Utils.popupError(component, devFailed.errors[0].desc);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void displayInfo(Component component) {
        String string = "";
        try {
            String[] stringArray;
            if (this.starter == null) {
                this.starter = new TangoServer(this.adm_name);
            }
            string = string + this.starter.getServerInfo(component, this.state == 4);
            string = string + "\n\n----------- Controlled servers -----------\n";
            Database database = ApiUtil.get_db_obj();
            DeviceData deviceData = new DeviceData();
            deviceData.insert(this.name);
            DeviceData deviceData2 = database.command_inout("DbGetHostServerList", deviceData);
            for (String string2 : stringArray = deviceData2.extractStringArray()) {
                DbServInfo dbServInfo = database.get_server_info(string2);
                if (!dbServInfo.controlled) continue;
                string = string + dbServInfo.name + "\n";
            }
            String string3 = "";
            try {
                String string2;
                DevInfo devInfo = this.info();
                String string4 = devInfo.doc_url;
                string2 = "CVS Tag = ";
                int n = string4.indexOf(string2);
                if (n > 0) {
                    void var7_11;
                    int n2 = string4.indexOf(10, n += string2.length());
                    if (n2 > n) {
                        String string5 = string4.substring(n, n2);
                    }
                    string = string + "\n----------- Tag Release -----------\n        " + (String)var7_11;
                }
            }
            catch (DevFailed devFailed) {}
        }
        catch (DevFailed devFailed) {
            string = string + devFailed.errors[0].desc;
            ErrorPane.showErrorMessage((Component)component, (String)string, (DevFailed)devFailed);
            return;
        }
        string = string + "\n\n";
        Utils.popupMessage(component, string);
    }

    public void testStarter(Component component) {
        try {
            if (this.starter == null) {
                this.starter = new TangoServer(this.adm_name);
            }
            this.starter.testDevice(component);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, (String)"", (DevFailed)devFailed);
        }
    }

    public void unExportStarter(Component component) {
        try {
            DbDevImportInfo dbDevImportInfo = this.import_device();
            if (!dbDevImportInfo.exported) {
                Utils.popupError(component, this.get_name() + "  NOT  exported !");
                return;
            }
            this.unexport_device();
            String string = "dserver/Starter/" + this.name;
            new DeviceProxy(string).unexport_device();
            Utils.popupMessage(component, string + "   and    " + this.get_name() + "\n\n       have been unexported !");
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, (String)"", (DevFailed)devFailed);
        }
    }

    public void setCollection(String string) throws DevFailed {
        DbDatum[] dbDatumArray = new DbDatum[]{new DbDatum("HostCollection", string)};
        this.put_property(dbDatumArray);
        this.collection = string;
    }

    public String getName() {
        return this.name;
    }

    public void startServer(Component component, String string) {
        try {
            this.startServer(string);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, (String)"", (DevFailed)devFailed);
        }
    }

    void readStdErrorFile(Frame frame, String string) {
        try {
            String string2 = this.readLogFile(string);
            PopupText popupText = new PopupText(frame, true);
            popupText.show(string2, 700, 500);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)frame, (String)"", (DevFailed)devFailed);
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)frame, (String)"", (Exception)exception);
            exception.printStackTrace();
        }
    }

    void updateServersList(JFrame jFrame) {
        try {
            this.command_inout("UpdateServersInfo");
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)jFrame, (String)"", (DevFailed)devFailed);
        }
    }

    void updateData() {
        this.thread.updateData();
    }

    void stopThread() {
        this.thread.stop_it = true;
        this.thread.updateData();
    }

    String[] getPath() {
        String[] stringArray = new String[]{""};
        try {
            DbDatum dbDatum = this.get_property("StartDsPath");
            if (!dbDatum.is_empty()) {
                stringArray = dbDatum.extractStringArray();
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        return stringArray;
    }

    String getFamily() {
        String string = "";
        try {
            DbDatum dbDatum = this.get_property("HostCollection");
            if (!dbDatum.is_empty()) {
                string = dbDatum.extractString();
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        return string;
    }

    public void displayBlackBox(JFrame jFrame) {
        Object[] objectArray = new String[]{this.get_name(), this.adm_name};
        String string = (String)JOptionPane.showInputDialog(jFrame, "Device selection :", "", 1, null, objectArray, objectArray[0]);
        if (string != null) {
            try {
                new BlackBoxTable(jFrame, string).setVisible(true);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)jFrame, null, (DevFailed)devFailed);
            }
        }
    }

    public String hostStatus() {
        String string = this.name + ":";
        try {
            if (this.state == 1) {
                string = string + "     is faulty\n";
            } else {
                DeviceAttribute deviceAttribute = this.read_attribute("Servers");
                if (deviceAttribute.hasFailed()) {
                    string = string + "     " + deviceAttribute.getErrStack()[0].desc + "\n";
                } else {
                    String[] stringArray;
                    string = string + "\n";
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    block10: for (String string2 : stringArray = deviceAttribute.extractStringArray()) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2);
                        String string3 = stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        if (!string5.equals("1")) continue;
                        switch (string4) {
                            case "FAULT": {
                                arrayList3.add(string3);
                                continue block10;
                            }
                            case "MOVING": {
                                arrayList2.add(string3);
                                continue block10;
                            }
                            default: {
                                arrayList.add(string3);
                            }
                        }
                    }
                    if (arrayList3.size() > 0) {
                        string = string + "     " + arrayList3.size() + "  servers stopped\n";
                    }
                    if (arrayList2.size() > 0) {
                        string = string + "     " + arrayList2.size() + " servers moving\n";
                    }
                    if (arrayList.size() > 0) {
                        string = string + "     " + arrayList.size() + " servers running\n";
                    }
                }
            }
        }
        catch (DevFailed devFailed) {
            string = string + "     " + devFailed.errors[0].desc;
        }
        return string;
    }

    public String hostName() {
        return this.name;
    }

    public String toString() {
        if (this.usage == null || this.usage.length() == 0) {
            return this.name;
        }
        return this.name + "  ( " + this.usage + " )";
    }
}

