/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PropListDialog
extends JDialog {
    private JFrame parent;
    private String selectedItem = null;
    private JTextArea pathText = null;
    private String[] props;
    private JList<String> jList;

    private void setList() {
        this.jList.setListData((String[])this.props);
    }

    public PropListDialog(JFrame jFrame, String[] stringArray) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.props = stringArray;
        this.initComponents();
        this.buildList();
    }

    public PropListDialog(JFrame jFrame, List<String> list) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.props = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.props[i] = list.get(i);
        }
        this.initComponents();
        this.buildList();
    }

    public PropListDialog(JFrame jFrame, JTextArea jTextArea, TangoHost[] tangoHostArray) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.pathText = jTextArea;
        this.initComponents();
        this.hosts2path(tangoHostArray);
        this.buildList();
    }

    private boolean alreadyIn(List<String> list, String string) {
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private void hosts2path(TangoHost[] tangoHostArray) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TangoHost tangoHost : tangoHostArray) {
                String[] stringArray;
                String string = AstorUtil.getStarterDeviceHeader() + tangoHost.getName();
                DeviceProxy deviceProxy = new DeviceProxy(string);
                DbDatum dbDatum = deviceProxy.get_property("StartDsPath");
                if (dbDatum.is_empty()) continue;
                for (String string2 : stringArray = dbDatum.extractStringArray()) {
                    if (this.alreadyIn(arrayList, string2)) continue;
                    arrayList.add(string2);
                }
            }
            this.props = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.props[i] = (String)arrayList.get(i);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    private void buildList() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PropListDialog.this.listSelectionPerformed(mouseEvent);
            }
        };
        this.jList.addMouseListener(mouseAdapter);
        this.pack();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.jList = new JList();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PropListDialog.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("Add");
        jButton.setHorizontalAlignment(4);
        jButton.setFont(new Font("Dialog", 0, 12));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropListDialog.this.addBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setHorizontalTextPosition(4);
        if (this.pathText == null) {
            jButton2.setText("Cancel");
        } else {
            jButton2.setText("Dismiss");
        }
        jButton2.setHorizontalAlignment(4);
        jButton2.setFont(new Font("Dialog", 0, 12));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropListDialog.this.dismissBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.jList.setFont(new Font("Courier", 1, 12));
        jScrollPane.setPreferredSize(new Dimension(450, 300));
        jScrollPane.setMinimumSize(new Dimension(450, 300));
        jScrollPane.setViewportView(this.jList);
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    private void dismissBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        this.retrieveSelectedItem();
    }

    private void listSelectionPerformed(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.retrieveSelectedItem();
        }
    }

    private void retrieveSelectedItem() {
        this.selectedItem = this.jList.getSelectedValue();
        if (this.pathText != null) {
            this.pathText.append(this.selectedItem + "\n");
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        this.setList();
        Point point = this.parent.getLocationOnScreen();
        point.x += (this.parent.getWidth() - this.getWidth()) / 2 + 50;
        point.y += (this.parent.getHeight() - this.getHeight()) / 2 + 50;
        this.setLocation(point);
        this.setVisible(true);
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }
}

