/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.GetTextDialog;
import admin.astor.tools.LastBranchesListDialog;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class PreferenceDialog
extends JDialog {
    private JFrame parent;
    private String csName = "";
    private String[] lastCollections = new String[0];
    private String[] known_tango_hosts = new String[0];
    private String[] tools = new String[0];
    private String[] pages = new String[]{"Device Servers", "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/index.html"};
    private boolean jiveReadOnly = false;
    private boolean starterStart = true;
    private JTextField hostDlgHeighttTxt;
    private JTextField hostDlgWidthtTxt;
    private JRadioButton jiveRObtn;
    private JTextField nameText;
    private JTextField rshCmdTxt;
    private JTextField rshUserTxt;
    private JRadioButton starterStartupBtn;
    private JLabel titleLabel;
    private JTextField treeHeighttTxt;
    private JTextField treeWidthtTxt;

    PreferenceDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initComponents();
        this.initialize();
        try {
            this.csName = AstorUtil.getControlSystemName();
            if (this.csName != null) {
                this.nameText.setText(this.csName);
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        this.titleLabel.setText(AstorUtil.getTangoHost() + "  preferences");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void storePreferences() {
        String string = this.rshUserTxt.getText();
        String string2 = this.rshCmdTxt.getText();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.tools == null) {
            this.tools = new String[0];
        }
        if (this.lastCollections == null) {
            this.lastCollections = new String[0];
        }
        if (this.known_tango_hosts == null) {
            this.known_tango_hosts = new String[0];
        }
        if (this.pages == null) {
            this.pages = new String[0];
        }
        AstorUtil astorUtil = AstorUtil.getInstance();
        astorUtil.setJiveReadOnly(this.jiveReadOnly);
        astorUtil.setStarterStartup(this.starterStart);
        AstorUtil.setRloginUser(string);
        AstorUtil.setRloginCmd(string2);
        astorUtil.setLastCollectionList(this.lastCollections);
        AstorUtil.setKnownTangoHosts(this.known_tango_hosts);
        AstorUtil.setTools(this.tools);
        AstorUtil.setHtmlHelps(this.pages);
        if (this.parent instanceof Astor) {
            try {
                int n = Integer.parseInt(this.treeWidthtTxt.getText());
                int n2 = Integer.parseInt(this.treeHeighttTxt.getText());
                Dimension dimension = new Dimension(n, n2);
                ((Astor)this.parent).setTreeSize(dimension);
                AstorUtil.setPreferredSize(dimension);
                n = Integer.parseInt(this.hostDlgWidthtTxt.getText());
                n2 = Integer.parseInt(this.hostDlgHeighttTxt.getText());
                dimension = new Dimension(n, n2);
                AstorUtil.setHostDialogPreferredSize(dimension);
                ((Astor)this.parent).tree.hostDialogs.setDialogPreferredSize(dimension);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorPane.showErrorMessage((Component)this, null, (Exception)numberFormatException);
            }
        }
        try {
            AstorUtil.putAstorProperties();
            Utils.popupMessage(this, "The preferences have been saved for " + AstorUtil.getTangoHost());
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot put Astor properties", (DevFailed)devFailed);
        }
        try {
            String string3 = this.nameText.getText();
            if (!string3.equals(this.csName)) {
                AstorUtil.setControlSystemName(string3);
                this.csName = string3;
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void initialize() {
        String string;
        AstorUtil astorUtil = AstorUtil.getInstance();
        this.lastCollections = astorUtil.getLastCollectionList();
        this.known_tango_hosts = AstorUtil.getDbaseKnownTangoHosts();
        this.tools = AstorUtil.getTools();
        this.pages = AstorUtil.getHtmlHelps();
        this.jiveReadOnly = astorUtil.jiveIsReadOnly();
        this.manageToggleBtn(this.jiveRObtn, this.jiveReadOnly);
        this.starterStart = astorUtil.getStarterStartup();
        this.manageToggleBtn(this.starterStartupBtn, this.starterStart);
        String string2 = AstorUtil.getRloginUser();
        if (string2 != null) {
            this.rshUserTxt.setText(string2);
        }
        if ((string = AstorUtil.getRloginCmd()) != null) {
            this.rshCmdTxt.setText(string);
        }
        if (this.parent instanceof Astor) {
            Dimension dimension = ((Astor)this.parent).getTreeSize();
            this.treeWidthtTxt.setText(Integer.toString(dimension.width));
            this.treeHeighttTxt.setText(Integer.toString(dimension.height));
            dimension = AstorUtil.getHostDialogPreferredSize();
            this.hostDlgWidthtTxt.setText(Integer.toString(dimension.width));
            this.hostDlgHeighttTxt.setText(Integer.toString(dimension.height));
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel();
        this.nameText = new JTextField();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.treeWidthtTxt = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.treeHeighttTxt = new JTextField();
        JSeparator jSeparator = new JSeparator();
        JLabel jLabel4 = new JLabel();
        this.rshUserTxt = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.rshCmdTxt = new JTextField();
        JSeparator jSeparator2 = new JSeparator();
        JSeparator jSeparator3 = new JSeparator();
        JLabel jLabel6 = new JLabel();
        this.jiveRObtn = new JRadioButton();
        JSeparator jSeparator4 = new JSeparator();
        JSeparator jSeparator5 = new JSeparator();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        JButton jButton4 = new JButton();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        this.hostDlgWidthtTxt = new JTextField();
        this.hostDlgHeighttTxt = new JTextField();
        JLabel jLabel9 = new JLabel();
        this.starterStartupBtn = new JRadioButton();
        JPanel jPanel5 = new JPanel();
        JButton jButton5 = new JButton();
        JButton jButton6 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PreferenceDialog.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        jPanel.add((Component)jPanel2, "North");
        jLabel.setFont(new Font("Dialog", 1, 14));
        jLabel.setText("name:");
        jPanel3.add(jLabel);
        this.nameText.setColumns(20);
        this.nameText.setFont(new Font("Dialog", 1, 12));
        jPanel3.add(this.nameText);
        jPanel.add((Component)jPanel3, "South");
        this.getContentPane().add((Component)jPanel, "North");
        jPanel4.setLayout(new GridBagLayout());
        jLabel2.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText("Hosts Tree Width:  ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jLabel2, gridBagConstraints);
        this.treeWidthtTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)this.treeWidthtTxt, gridBagConstraints);
        jLabel3.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText("Hosts Tree Height:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jLabel3, gridBagConstraints);
        this.treeHeighttTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)this.treeHeighttTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel4.add((Component)jSeparator, gridBagConstraints);
        jLabel4.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setText("Remote login user :  ");
        jLabel4.setToolTipText("Default user name used for remote login on a host.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jLabel4, gridBagConstraints);
        this.rshUserTxt.setColumns(12);
        this.rshUserTxt.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.rshUserTxt.setToolTipText("Default user name used for remote login on a host.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)this.rshUserTxt, gridBagConstraints);
        jLabel5.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel5.setHorizontalAlignment(4);
        jLabel5.setText("Remote login command :  ");
        jLabel5.setToolTipText("Command used for remote login on a host (rlogin, ssh, ...).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jLabel5, gridBagConstraints);
        this.rshCmdTxt.setColumns(12);
        this.rshCmdTxt.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.rshCmdTxt.setText("rlogin");
        this.rshCmdTxt.setToolTipText("Command used for remote login on a host (rlogin, ssh, ...).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)this.rshCmdTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel4.add((Component)jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel4.add((Component)jSeparator3, gridBagConstraints);
        jLabel6.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel6.setText("Start Jive in READ_ONLY mode :");
        jLabel6.setToolTipText("Mode to start jive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        jPanel4.add((Component)jLabel6, gridBagConstraints);
        this.jiveRObtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jiveRObtn.setText("false");
        this.jiveRObtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jiveRObtn.setMargin(new Insets(0, 0, 0, 0));
        this.jiveRObtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.jiveRObtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        jPanel4.add((Component)this.jiveRObtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel4.add((Component)jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel4.add((Component)jSeparator5, gridBagConstraints);
        jButton.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jButton.setText("Last Collections :");
        jButton.setToolTipText("List of collections (families) displayed at the end of the control system tree.");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.lastCollectionBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jButton, gridBagConstraints);
        jButton2.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jButton2.setText("Known Tango Hosts");
        jButton2.setToolTipText("List of   TANGO_HOST known (used to change during execution).");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.tangoHostsBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jButton2, gridBagConstraints);
        jButton3.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jButton3.setText("Additional tools :");
        jButton3.setToolTipText("List of  additiannal tools (see  Astor pages).");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.toolsBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jButton3, gridBagConstraints);
        jButton4.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jButton4.setText("Help pages");
        jButton4.setToolTipText("List of   help  pages (as tools see Astor pages).");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.helpPagesBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jButton4, gridBagConstraints);
        jLabel7.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel7.setHorizontalAlignment(4);
        jLabel7.setText("Host Panel Width:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jLabel7, gridBagConstraints);
        jLabel8.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel8.setHorizontalAlignment(4);
        jLabel8.setText("Host Panel Height:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)jLabel8, gridBagConstraints);
        this.hostDlgWidthtTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)this.hostDlgWidthtTxt, gridBagConstraints);
        this.hostDlgHeighttTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)this.hostDlgHeighttTxt, gridBagConstraints);
        jLabel9.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel9.setText("Starter starts servers at startup:");
        jLabel9.setToolTipText("Mode to start jive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        jPanel4.add((Component)jLabel9, gridBagConstraints);
        this.starterStartupBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.starterStartupBtn.setSelected(true);
        this.starterStartupBtn.setText("true");
        this.starterStartupBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.starterStartupBtn.setMargin(new Insets(0, 0, 0, 0));
        this.starterStartupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.starterStartupBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        jPanel4.add((Component)this.starterStartupBtn, gridBagConstraints);
        this.getContentPane().add((Component)jPanel4, "Center");
        jButton5.setText("OK");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel5.add(jButton5);
        jButton6.setText("Cancel");
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel5.add(jButton6);
        this.getContentPane().add((Component)jPanel5, "South");
        this.pack();
    }

    private void helpPagesBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        GetTextDialog getTextDialog = new GetTextDialog(this, jButton.getText(), jButton.getToolTipText(), this.pages);
        if (getTextDialog.showDialog() == 0) {
            this.pages = getTextDialog.getTextLinesAsArray();
        }
    }

    private void toolsBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        GetTextDialog getTextDialog = new GetTextDialog(this, jButton.getText(), jButton.getToolTipText(), this.tools);
        if (getTextDialog.showDialog() == 0) {
            this.tools = getTextDialog.getTextLinesAsArray();
        }
    }

    private void tangoHostsBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        GetTextDialog getTextDialog = new GetTextDialog(this, jButton.getText(), jButton.getToolTipText(), this.known_tango_hosts);
        if (getTextDialog.showDialog() == 0) {
            this.known_tango_hosts = getTextDialog.getTextLinesAsArray();
        }
    }

    private void lastCollectionBtnActionPerformed(ActionEvent actionEvent) {
        try {
            LastBranchesListDialog lastBranchesListDialog = new LastBranchesListDialog(this.parent, AstorUtil.getInstance().getCollectionList(), this.lastCollections);
            if (lastBranchesListDialog.showDialog() == 0) {
                this.lastCollections = lastBranchesListDialog.getLastBranches();
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void manageToggleBtn(JToggleButton jToggleButton, boolean bl) {
        jToggleButton.setSelected(bl);
        jToggleButton.setText("" + bl);
    }

    private void jiveRObtnActionPerformed(ActionEvent actionEvent) {
        this.jiveReadOnly = this.jiveRObtn.getSelectedObjects() != null;
        this.manageToggleBtn(this.jiveRObtn, this.jiveReadOnly);
    }

    private void starterStartupBtnActionPerformed(ActionEvent actionEvent) {
        this.starterStart = this.starterStartupBtn.getSelectedObjects() != null;
        this.manageToggleBtn(this.starterStartupBtn, this.starterStart);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.storePreferences();
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.parent instanceof Astor) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        new PreferenceDialog(new JFrame()).setVisible(true);
    }
}

