/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.PutServerInfoDialog;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.PopupTable;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

class LevelTree
extends JTree
implements AstorDefs {
    private HostInfoDialog parent;
    private DefaultTreeModel treeModel;
    private ServerPopupMenu serverMenu;
    private ServerPopupMenu levelMenu;
    private TangoHost host;
    private Color bg;
    private Level level;
    private DefaultMutableTreeNode root;

    LevelTree(JFrame jFrame, HostInfoDialog hostInfoDialog, TangoHost tangoHost, int n) {
        this.parent = hostInfoDialog;
        this.host = tangoHost;
        this.bg = hostInfoDialog.getBackgroundColor();
        this.setBackground(this.bg);
        this.serverMenu = new ServerPopupMenu(jFrame, hostInfoDialog, tangoHost, 0);
        this.levelMenu = new ServerPopupMenu(jFrame, hostInfoDialog, tangoHost, 1);
        this.level = new Level(n);
        this.initComponent();
        this.manageVisibility();
    }

    boolean hasRunningServer() {
        return this.level.hasRunningServer();
    }

    DevState getState() {
        return this.level.getState();
    }

    int getNbServers() {
        return this.level.size();
    }

    private void manageVisibility() {
        this.setVisible(this.level.size() > 0);
    }

    TangoServer getServer(String string) {
        return this.level.getServer(string);
    }

    int getLevelRow() {
        return this.level.row;
    }

    private void initComponent() {
        this.root = new DefaultMutableTreeNode(this.level);
        for (TangoServer tangoServer : this.level) {
            this.root.add(new DefaultMutableTreeNode(tangoServer));
        }
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                LevelTree.this.treeMouseClicked(mouseEvent);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                LevelTree.this.parent.packTheDialog();
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                LevelTree.this.parent.packTheDialog();
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                LevelTree.this.selectionChanged(treeSelectionEvent);
            }
        });
        if (this.level.row == 0) {
            this.collapseTree();
        }
    }

    private void selectionChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    void checkUpdate() {
        int n;
        int n2;
        Object object;
        this.level.updateServerList();
        this.manageVisibility();
        for (int i = 0; i < this.level.size(); ++i) {
            TangoServer tangoServer = (TangoServer)this.level.get(i);
            object = this.root;
            n2 = this.root.getChildCount();
            n = 0;
            for (int j = 0; n == 0 && j < n2; ++j) {
                TangoServer tangoServer2 = (TangoServer)((DefaultMutableTreeNode)(object = ((DefaultMutableTreeNode)object).getNextNode())).getUserObject();
                n = tangoServer2 == tangoServer ? 1 : 0;
            }
            if (n != 0) continue;
            object = new DefaultMutableTreeNode(tangoServer);
            this.treeModel.insertNodeInto((MutableTreeNode)object, this.root, i);
            this.setSelectionPath(new TreePath(((DefaultMutableTreeNode)object).getPath()));
            this.expandRow(i);
        }
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            object = (TangoServer)defaultMutableTreeNode.getUserObject();
            n2 = 0;
            for (n = 0; n2 == 0 && n < this.level.size(); ++n) {
                n2 = object == this.level.get(n) ? 1 : 0;
            }
            if (n2 != 0) continue;
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            --i;
        }
    }

    void changeChangeLevel(int n) {
        try {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(0);
            TangoServer tangoServer = (TangoServer)defaultMutableTreeNode.getUserObject();
            DbServer dbServer = new DbServer(tangoServer.getName());
            DbServInfo dbServInfo = dbServer.get_info();
            PutServerInfoDialog putServerInfoDialog = new PutServerInfoDialog(this.parent, true);
            putServerInfoDialog.setLocation(this.getLocationOnScreen());
            String string = dbServInfo.host;
            if (putServerInfoDialog.showDialog(dbServInfo, n) == 0) {
                System.out.println("Do it !");
                dbServInfo = putServerInfoDialog.getSelection();
                if (dbServInfo != null) {
                    dbServInfo.host = string;
                    for (int i = 0; i < this.root.getChildCount(); ++i) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
                        tangoServer = (TangoServer)defaultMutableTreeNode.getUserObject();
                        dbServInfo.name = tangoServer.getName();
                        tangoServer.putStartupInfo(dbServInfo);
                        try {
                            Thread.sleep(20L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.parent.updateData();
                }
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    void changeServerLevels() {
        ArrayList<TangoServer> arrayList = new ArrayList<TangoServer>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            arrayList.add((TangoServer)defaultMutableTreeNode.getUserObject());
        }
        for (TangoServer tangoServer : arrayList) {
            tangoServer.startupLevel(this.parent, this.host.getName(), this.getLocationOnScreen());
        }
        this.parent.updateData();
    }

    void resetSelection() {
        this.manageVisibility();
        this.setSelectionPath(new TreePath(this.root.getPath()));
    }

    void setSelection(TangoServer tangoServer) {
        this.manageVisibility();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            TangoServer tangoServer2 = (TangoServer)defaultMutableTreeNode.getUserObject();
            if (tangoServer2 != tangoServer) continue;
            this.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    void expandTree() {
        this.expandRow(0);
    }

    void collapseTree() {
        this.collapseRow(0);
    }

    void toggleExpandCollapse() {
        if (this.isExpanded(0)) {
            this.collapseTree();
        } else {
            this.expandTree();
        }
    }

    void displayUptime() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            String[][] stringArray;
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                stringArray = (String[][])this.root.getChildAt(i);
                TangoServer tangoServer = (TangoServer)stringArray.getUserObject();
                String[] stringArray2 = tangoServer.getServerUptime();
                arrayList.add(new String[]{tangoServer.getName(), stringArray2[0], stringArray2[1]});
            }
            String[] stringArray3 = new String[]{"Server", "Last   exported", "Last unexported"};
            stringArray = new String[arrayList.size()][];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = (String[])arrayList.get(i);
            }
            PopupTable popupTable = new PopupTable((JDialog)this.parent, this.level.toString(), stringArray3, stringArray, new Dimension(650, 250));
            popupTable.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) < 0) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        this.parent.fireNewTreeSelection(this);
        if ((n & 4) != 0) {
            if (object instanceof TangoServer) {
                this.serverMenu.showMenu(mouseEvent, (JTree)this, (TangoServer)object);
            } else {
                this.levelMenu.showMenu(mouseEvent, this, this.isExpanded(0));
            }
        }
    }

    @Override
    public String toString() {
        return this.level.toString();
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts = new Font[3];

        public TangoRenderer() {
            this.fonts[0] = new Font("Dialog", 1, 16);
            this.fonts[1] = new Font("Dialog", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(LevelTree.this.bg);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            this.setFont(this.fonts[defaultMutableTreeNode.getLevel()]);
            if (n == 0) {
                this.setIcon(this.getStateIcon(LevelTree.this.level.getState()));
                this.setBackgroundSelectionColor(LevelTree.this.bg);
            } else if (object2 instanceof TangoServer) {
                TangoServer tangoServer = (TangoServer)object2;
                this.setIcon(this.getStateIcon(tangoServer.getState()));
                this.setBackgroundSelectionColor(Color.lightGray);
            }
            return this;
        }

        private ImageIcon getStateIcon(DevState devState) {
            int n = devState == DevState.MOVING ? 5 : (devState == DevState.ON ? 4 : (devState == DevState.ALARM ? 2 : 1));
            return AstorUtil.state_icons[n];
        }
    }

    private class Level
    extends ArrayList<TangoServer> {
        public int row;

        public Level(int n) {
            this.row = n;
            this.updateServerList();
        }

        private void updateServerList() {
            this.clear();
            for (int i = 0; i < LevelTree.this.host.nbServers(); ++i) {
                try {
                    TangoServer tangoServer = LevelTree.this.host.getServer(i);
                    if (tangoServer.startup_level != this.row) continue;
                    this.add(tangoServer);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    ErrorPane.showErrorMessage((Component)LevelTree.this.parent, null, (Exception)nullPointerException);
                }
            }
            AstorUtil.getInstance().sortTangoServer(this);
        }

        TangoServer getServer(String string) {
            for (TangoServer tangoServer : this) {
                if (!tangoServer.getName().equals(string)) continue;
                return tangoServer;
            }
            return null;
        }

        boolean hasRunningServer() {
            for (TangoServer tangoServer : this) {
                if (tangoServer.getState() != DevState.ON) continue;
                return true;
            }
            return false;
        }

        DevState getState() {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (TangoServer tangoServer : this) {
                if (tangoServer.getState() == DevState.UNKNOWN) {
                    return DevState.UNKNOWN;
                }
                if (tangoServer.getState() == DevState.FAULT) {
                    bl = true;
                    continue;
                }
                if (tangoServer.getState() == DevState.ALARM) {
                    bl2 = true;
                    continue;
                }
                if (tangoServer.getState() != DevState.MOVING) continue;
                bl3 = true;
            }
            if (bl) {
                return DevState.FAULT;
            }
            if (bl3) {
                return DevState.MOVING;
            }
            if (bl2) {
                return DevState.ALARM;
            }
            return DevState.ON;
        }

        @Override
        public String toString() {
            String string = this.row != 0 ? "Level " + this.row : "Not Controlled";
            return string;
        }
    }
}

