/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DbPollPanel
extends JDialog {
    private Component parent;
    private DeviceProxy selected_dev;
    private DeviceProxy[] devices;
    private PolledAttribute[] attlist;
    private static final String PollAttProp = "polled_attr";
    private JPanel panel = null;
    private JComboBox<String> devComboBox;
    private JScrollPane scrollPane;
    private JLabel titleLabel;

    public DbPollPanel(JFrame jFrame, String string) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initialize(string);
    }

    public DbPollPanel(JDialog jDialog, String string) throws DevFailed {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.initialize(string);
    }

    private void initialize(String string) throws DevFailed {
        this.initComponents();
        this.titleLabel.setText("Polled Attributes For ");
        this.devices = this.getDeviceList(string);
        if (this.devices.length == 0) {
            Except.throw_exception((String)"NO_DEVICES", (String)("No device found for " + string), (String)("DbPollPanel.initialize(" + string + ")"));
        }
        this.buildPanel(this.devices.length - 1);
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private DeviceProxy[] getDeviceList(String string) {
        try {
            String[] stringArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            DbServer dbServer = new DbServer(string);
            for (String string2 : stringArray = dbServer.get_class_list()) {
                String[] stringArray2 = dbServer.get_device_name(string2);
                arrayList.addAll(Arrays.asList(stringArray2));
            }
            String[] stringArray3 = new DeviceProxy[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.devComboBox.addItem((String)arrayList.get(i));
                stringArray3[i] = new DeviceProxy((String)arrayList.get(i));
            }
            this.devComboBox.setSelectedIndex(arrayList.size() - 1);
            return stringArray3;
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
            return new DeviceProxy[0];
        }
    }

    private void buildPanel(int n) {
        this.selected_dev = this.devices[n];
        if (this.panel != null) {
            this.getContentPane().remove(this.panel);
        }
        try {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            int n2 = 0;
            for (PolledAttribute polledAttribute : this.attlist = this.getPolledAttributes(this.selected_dev)) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n2;
                gridBagConstraints.fill = 2;
                jPanel.add((Component)polledAttribute.radioButton, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n2;
                gridBagConstraints.fill = 2;
                jPanel.add((Component)polledAttribute.textField, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.fill = 2;
                jPanel.add((Component)new JLabel("ms"), gridBagConstraints);
            }
            this.scrollPane.setViewportView(jPanel);
            this.getContentPane().add((Component)this.scrollPane, "Center");
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
        this.pack();
        if (this.scrollPane.getHeight() > 800) {
            this.scrollPane.setPreferredSize(new Dimension(this.scrollPane.getWidth(), 800));
        }
    }

    public PolledAttribute[] getPolledAttributes(DeviceProxy deviceProxy) throws DevFailed {
        DbDatum dbDatum = deviceProxy.get_property(PollAttProp);
        String[] stringArray = dbDatum.extractStringArray();
        if (stringArray == null || stringArray.length < 2) {
            return new PolledAttribute[0];
        }
        ArrayList<PolledAttribute> arrayList = new ArrayList<PolledAttribute>();
        for (int i = 0; i < stringArray.length; i += 2) {
            arrayList.add(new PolledAttribute(stringArray[i], stringArray[i + 1]));
        }
        PolledAttribute[] polledAttributeArray = new PolledAttribute[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            polledAttributeArray[i] = (PolledAttribute)arrayList.get(i);
        }
        return polledAttributeArray;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.devComboBox = new JComboBox();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.scrollPane = new JScrollPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DbPollPanel.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.devComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbPollPanel.this.devComboBoxActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.devComboBox);
        this.getContentPane().add((Component)jPanel, "North");
        jButton.setText("Apply");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbPollPanel.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jButton2.setText("Dismiss");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbPollPanel.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void devComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.buildPanel(this.devComboBox.getSelectedIndex());
        }
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        String string = "Remove polling for :\n";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PolledAttribute polledAttribute : this.attlist) {
            if (polledAttribute.radioButton.getSelectedObjects() == null) {
                string = string + polledAttribute.name + "\n";
                continue;
            }
            arrayList.add(polledAttribute.name);
            try {
                polledAttribute.period = Integer.parseInt(polledAttribute.textField.getText());
                arrayList.add(polledAttribute.textField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                ErrorPane.showErrorMessage((Component)this, (String)("NumberFormatException on  attribute " + polledAttribute.name), (Exception)numberFormatException);
                return;
            }
        }
        System.out.println(arrayList.size());
        if (arrayList.size() < this.attlist.length * 2 && JOptionPane.showConfirmDialog(this, string, "Question", 0) != 0) {
            return;
        }
        Object[] objectArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i] = (String)arrayList.get(i);
        }
        try {
            DbDatum dbDatum = new DbDatum(PollAttProp);
            dbDatum.insert((String[])objectArray);
            this.selected_dev.put_property(dbDatum);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
        JOptionPane.showMessageDialog(this, "Database Updated", "", 1);
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            if (string == null) {
                Except.throw_exception((String)"NO_SERVER_NAME", (String)"Server's name ????", (String)"PollPanel.main()");
            }
            new DbPollPanel((JFrame)null, string).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
            System.exit(0);
        }
    }

    class PolledAttribute {
        String name;
        int period;
        JRadioButton radioButton;
        JTextField textField;

        public PolledAttribute(String string, String string2) {
            this.name = string;
            try {
                this.period = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.period = -1;
            }
            this.radioButton = new JRadioButton(string);
            this.radioButton.setSelected(true);
            this.textField = new JTextField(Integer.toString(this.period));
            this.textField.setColumns(6);
        }
    }
}

