/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AttMemoDialog
extends JDialog {
    private JDialog parent;
    private DbServer server;
    private boolean from_appli = true;
    private Memorized[] memorized;
    private static final String unknown = " ? ";
    private JLabel[] attLbl;
    private JTextField[] attVal;
    private JLabel titleLabel;
    private JPanel valuePanel;

    public AttMemoDialog(JDialog jDialog, DbServer dbServer) throws DevFailed {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.server = dbServer;
        this.initComponents();
        this.buildMemorizedPanel();
        this.titleLabel.setText("Memorized attributes found for " + dbServer.name());
        this.pack();
        if (jDialog.getWidth() == 0) {
            this.from_appli = false;
        }
        if (this.from_appli) {
            AstorUtil.centerDialog((JDialog)this, jDialog);
        }
    }

    private void buildMemorizedPanel() throws DevFailed {
        this.readAttributes();
        this.attLbl = new JLabel[this.memorized.length];
        this.attVal = new JTextField[this.memorized.length];
        for (int i = 0; i < this.memorized.length; ++i) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 0;
            int n2 = i + 1;
            this.attLbl[i] = new JLabel(this.memorized[i].attname);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            this.valuePanel.add((Component)this.attLbl[i], gridBagConstraints);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            this.valuePanel.add((Component)new JLabel("  :    "), gridBagConstraints);
            this.attVal[i] = new JTextField(this.memorized[i].value);
            this.attVal[i].setColumns(15);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            this.valuePanel.add((Component)this.attVal[i], gridBagConstraints);
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 2;
            this.valuePanel.add((Component)new JLabel("     " + this.memorized[i].min + " < .... < " + this.memorized[i].max), gridBagConstraints);
        }
    }

    private void readAttributes() throws DevFailed {
        DeviceProxy[] deviceProxyArray = this.getDevices();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DeviceProxy deviceProxy : deviceProxyArray) {
            String[] stringArray;
            String string = deviceProxy.get_name();
            DeviceData deviceData = new DeviceData();
            String[] stringArray2 = new String[]{string, "*"};
            deviceData.insert(stringArray2);
            DeviceData deviceData2 = ApiUtil.get_db_obj().command_inout("DbGetDeviceAttributeList", deviceData);
            for (String string2 : stringArray = deviceData2.extractStringArray()) {
                DbAttribute dbAttribute = deviceProxy.get_attribute_property(string2);
                String[] stringArray3 = dbAttribute.get_property_list();
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (!stringArray3[i].equals("__value")) continue;
                    String string3 = unknown;
                    if (!dbAttribute.is_empty("min_value")) {
                        string3 = dbAttribute.get_value("min_value")[0];
                    }
                    String string4 = unknown;
                    if (!dbAttribute.is_empty("max_value")) {
                        string4 = dbAttribute.get_value("max_value")[0];
                    }
                    arrayList.add(string + "/" + string2);
                    arrayList.add(dbAttribute.get_string_value(i));
                    arrayList.add(string3);
                    arrayList.add(string4);
                }
            }
        }
        this.memorized = new Memorized[arrayList.size() / 4];
        for (int i = 0; i < arrayList.size(); i += 4) {
            this.memorized[i / 4] = new Memorized((String)arrayList.get(i), (String)arrayList.get(i + 1), (String)arrayList.get(i + 2), (String)arrayList.get(i + 3));
        }
    }

    private DeviceProxy[] getDevices() throws DevFailed {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray = this.server.get_class_list()) {
            String[] stringArray2 = this.server.get_device_name(string);
            arrayList.addAll(Arrays.asList(stringArray2));
        }
        String[] stringArray3 = new DeviceProxy[arrayList.size()];
        int n = 0;
        for (String string : arrayList) {
            stringArray3[n++] = new DeviceProxy(string);
        }
        return stringArray3;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.valuePanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AttMemoDialog.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttMemoDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttMemoDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.valuePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.valuePanel, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private boolean writeValues() {
        String string = "";
        for (int i = 0; i < this.attVal.length; ++i) {
            double d;
            String string2 = this.attVal[i].getText();
            Memorized memorized = this.memorized[i];
            if (string2.equals(memorized.value)) continue;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Utils.popupError(this.parent, string2 + " is not a number !");
                return false;
            }
            if (!memorized.min.equals(unknown)) {
                double d2;
                try {
                    d2 = Double.parseDouble(memorized.min);
                }
                catch (NumberFormatException numberFormatException) {
                    Utils.popupError(this.parent, memorized.min + " is not a number !");
                    return false;
                }
                if (d < d2) {
                    Utils.popupError(this.parent, "Incorrect value:\n" + string2 + " is less than " + memorized.min);
                    return false;
                }
            }
            if (!memorized.max.equals(unknown)) {
                double d3;
                try {
                    d3 = Double.parseDouble(memorized.max);
                }
                catch (NumberFormatException numberFormatException) {
                    Utils.popupError(this.parent, memorized.max + " is not a number !");
                    return false;
                }
                if (d > d3) {
                    Utils.popupError(this.parent, "Incorrect value:\n" + string2 + " is greater than " + memorized.max);
                    return false;
                }
            }
            try {
                DbDatum dbDatum = new DbDatum("__value");
                dbDatum.insert(string2);
                AttributeProxy attributeProxy = new AttributeProxy(this.attLbl[i].getText());
                attributeProxy.put_property(dbDatum);
                memorized.value = string2;
                string = string + this.attLbl[i].getText() + "  set to  " + string2 + "\n";
                continue;
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                return false;
            }
        }
        if (string.length() > 0) {
            Utils.popupMessage(this.parent, string);
        }
        return true;
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (this.writeValues()) {
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (!this.from_appli) {
            System.exit(0);
        }
    }

    public void showDialog() {
        if (this.memorized.length == 0) {
            Utils.popupError(this.parent, "No memorized attribute found for " + this.server.name());
        } else {
            this.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttMemoDialog attMemoDialog = new AttMemoDialog(new JDialog(), new DbServer("PowerSupply/pv"));
            attMemoDialog.showDialog();
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
    }

    class Memorized {
        String attname;
        String value;
        String min;
        String max;

        Memorized(String string, String string2, String string3, String string4) {
            this.attname = string;
            this.value = string2;
            this.min = string3;
            this.max = string4;
        }
    }
}

