/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.MySqlUtil;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import jive.ExecDev;

public class AstorUtil
implements AstorDefs {
    private static DbClass _class = null;
    private static AstorUtil instance = null;
    private static String starterDeviceHeader = "tango/admin/";
    private static boolean superTango = false;
    private static short readInfoPeriod = (short)5;
    private static short nbStartupLevels = (short)5;
    private static String rloginCmd = null;
    private static String rloginUser = null;
    private static String[] tools = null;
    private static String[] known_tango_hosts = null;
    private static Dimension preferred_size = new Dimension(400, 600);
    private static Dimension host_dlg_preferred_size = new Dimension(800, 500);
    private static String[] lastCollections = null;
    private static boolean jiveReadOnly = false;
    private static boolean starterStartup = true;
    private static boolean properties_read = false;
    private static String[] helps;
    private static final String starterStartupPropName = "StartServersAtStartup";
    private static final String[] astorPropertyNames;
    public static ImageIcon[] state_icons;
    private static String hostInfoClassName;
    private static Splash splash;
    private static int splash_progress;
    private static ImageIcon tango_icon;
    private static RGB rgb;

    private AstorUtil() {
        String string = System.getenv("SUPER_TANGO");
        if (string != null) {
            superTango = string.equals("true");
        } else {
            string = System.getProperty("SUPER_TANGO");
            if (string != null) {
                superTango = string.equals("true");
            }
        }
        try {
            DbDatum dbDatum = ApiUtil.get_db_obj().get_class_property("Starter", "Domain");
            if (!dbDatum.is_empty()) {
                starterDeviceHeader = dbDatum.extractString() + "/admin/";
            }
        }
        catch (DevFailed devFailed) {
            System.err.println(devFailed.errors[0].desc);
        }
    }

    public static AstorUtil getInstance() {
        if (instance == null) {
            instance = new AstorUtil();
        }
        return instance;
    }

    public static String getStarterDeviceHeader() {
        return starterDeviceHeader;
    }

    public static String getControlSystemName() throws DevFailed {
        DbDatum dbDatum = ApiUtil.get_db_obj().get_property("CtrlSystem", "Name");
        if (!dbDatum.is_empty()) {
            return dbDatum.extractString();
        }
        return null;
    }

    public static void setControlSystemName(String string) throws DevFailed {
        DbDatum dbDatum = new DbDatum("Name");
        dbDatum.insert(string);
        ApiUtil.get_db_obj().put_property("CtrlSystem", new DbDatum[]{dbDatum});
    }

    public void initIcons() {
        AstorUtil.state_icons[0] = Utils.getInstance().getIcon("greyball.gif");
        AstorUtil.state_icons[1] = Utils.getInstance().getIcon("redball.gif");
        AstorUtil.state_icons[2] = Utils.getInstance().getIcon("orangebal.gif");
        AstorUtil.state_icons[4] = Utils.getInstance().getIcon("greenbal.gif");
        AstorUtil.state_icons[3] = Utils.getInstance().getIcon("whiteball.gif");
        AstorUtil.state_icons[5] = Utils.getInstance().getIcon("blueball.gif");
        AstorUtil.state_icons[6] = Utils.getInstance().getIcon("failed.gif");
    }

    public boolean isSuperTango() {
        return superTango;
    }

    static String[] string2array(String string) {
        return AstorUtil.string2array(string, null);
    }

    static String[] string2array(String string, String string2) {
        StringTokenizer stringTokenizer = string2 == null ? new StringTokenizer(string) : new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getRloginCmd() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return rloginCmd;
    }

    public static void setRloginCmd(String string) {
        rloginCmd = string;
    }

    public static String getRloginUser() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return rloginUser;
    }

    public static void setRloginUser(String string) {
        rloginUser = string;
    }

    public static void setTools(String[] stringArray) {
        tools = stringArray;
    }

    public static String[] getTools() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return tools;
    }

    public static void setHtmlHelps(String[] stringArray) {
        helps = stringArray;
    }

    public static String[] getHtmlHelps() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return helps;
    }

    public static String[] getDbaseKnownTangoHosts() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return known_tango_hosts;
    }

    public static List<String> getUserKnownTangoHosts() {
        String string = AstorUtil.getAstorRC();
        return AstorUtil.getFromEnvFile("KnownTangoHosts", string);
    }

    public static List<String> getAllKnownTangoHosts() {
        String[] stringArray = AstorUtil.getDbaseKnownTangoHosts();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            Collections.addAll(arrayList, stringArray);
        }
        List<String> list = AstorUtil.getUserKnownTangoHosts();
        for (String string : list) {
            boolean bl = false;
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (!string2.equals(string)) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static String getAstorRC() {
        String string = System.getProperty("user.home");
        String string2 = AstorUtil.osIsUnix() ? string + "/." + "astorrc" : string + "/" + "astorrc";
        return string2;
    }

    public static void saveUserKnownTangoHost(List<String> list) throws DevFailed {
        int n;
        String string;
        String string22;
        StringBuilder stringBuilder = new StringBuilder("KnownTangoHosts:  ");
        for (String string22 : list) {
            stringBuilder.append(string22).append(", ");
        }
        String string3 = stringBuilder.substring(0, stringBuilder.length() - 2) + '\n';
        string22 = AstorUtil.getAstorRC();
        try {
            string = AstorUtil.readFile(string22);
        }
        catch (DevFailed devFailed) {
            string = "#\n#  Astor (TANGO Manager) configuration file\n#\n#\n";
        }
        int n2 = string.indexOf("KnownTangoHosts:");
        string = n2 < 0 ? string + (String)string3 : ((n = string.indexOf(10, n2)) < 0 ? string.substring(0, n2) + (String)string3 : string.substring(0, n2) + (String)string3 + string.substring(n));
        AstorUtil.writeFile(string22, string);
    }

    private static List<String> getFromEnvFile(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = AstorUtil.readFile(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (string4.startsWith("#")) continue;
                arrayList2.add(string4);
            }
            for (String string5 : arrayList2) {
                if (!string5.startsWith(string + ":")) continue;
                String string6 = string5.substring(string.length() + 1).trim();
                stringTokenizer = new StringTokenizer(string6, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken().trim());
                }
                return arrayList;
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return arrayList;
    }

    public static String getHostInfoClassName() {
        if (hostInfoClassName == null) {
            hostInfoClassName = "";
            try {
                DbDatum dbDatum = ApiUtil.get_db_obj().get_property("Astor", "_HostInfo");
                if (!dbDatum.is_empty()) {
                    hostInfoClassName = dbDatum.extractString();
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        return hostInfoClassName;
    }

    public static String readFile(String string) throws DevFailed {
        String string2 = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            n = fileInputStream.read(byArray);
            fileInputStream.close();
            if (n > 0) {
                string2 = new String(byArray);
            }
        }
        catch (Exception exception) {
            Except.throw_exception((String)"READ_FAILED", (String)exception.toString());
        }
        return string2;
    }

    public static List<String> readFileLines(String string) throws DevFailed {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2 = AstorUtil.readFile(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            Except.throw_exception((String)"READ_FAILED", (String)exception.toString());
        }
        return arrayList;
    }

    public static void writeFile(String string, String string2) throws DevFailed {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Except.throw_exception((String)"WRITE_FAILED", (String)exception.toString());
        }
    }

    public static Dimension getPreferredSize() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return preferred_size;
    }

    public static void setPreferredSize(Dimension dimension) {
        preferred_size = dimension;
    }

    public static Dimension getHostDialogPreferredSize() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return host_dlg_preferred_size;
    }

    public static void setHostDialogPreferredSize(Dimension dimension) {
        host_dlg_preferred_size = dimension;
    }

    public static void setKnownTangoHosts(String[] stringArray) {
        known_tango_hosts = stringArray;
    }

    private static String getStringProperty(DbDatum dbDatum) {
        if (dbDatum.is_empty()) {
            return null;
        }
        return dbDatum.extractString();
    }

    private static String[] getStringArrayProperty(DbDatum dbDatum) {
        if (dbDatum.is_empty()) {
            return null;
        }
        return dbDatum.extractStringArray();
    }

    public static void readAstorProperties() {
        try {
            int n;
            int n2;
            DbDatum[] dbDatumArray = ApiUtil.get_db_obj().get_property("Astor", astorPropertyNames);
            int n3 = 0;
            rloginCmd = AstorUtil.getStringProperty(dbDatumArray[n3++]);
            rloginUser = AstorUtil.getStringProperty(dbDatumArray[n3++]);
            String string = AstorUtil.getStringProperty(dbDatumArray[n3++]);
            if (string != null) {
                jiveReadOnly = string.equals("true") || string.equals("1");
            }
            lastCollections = AstorUtil.getStringArrayProperty(dbDatumArray[n3++]);
            known_tango_hosts = AstorUtil.getStringArrayProperty(dbDatumArray[n3++]);
            String[] stringArray = AstorUtil.getStringArrayProperty(dbDatumArray[n3++]);
            try {
                if (stringArray != null && stringArray.length >= 2) {
                    n2 = Integer.parseInt(stringArray[0]);
                    n = Integer.parseInt(stringArray[1]);
                    preferred_size = new Dimension(n2, n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringArray = AstorUtil.getStringArrayProperty(dbDatumArray[n3++]);
            try {
                if (stringArray != null && stringArray.length >= 2) {
                    n2 = Integer.parseInt(stringArray[0]);
                    n = Integer.parseInt(stringArray[1]);
                    host_dlg_preferred_size = new Dimension(n2, n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            tools = AstorUtil.getStringArrayProperty(dbDatumArray[n3++]);
            helps = AstorUtil.getStringArrayProperty(dbDatumArray[n3]);
            DbClass dbClass = new DbClass("Starter");
            DbDatum dbDatum = dbClass.get_property(starterStartupPropName);
            if (!dbDatum.is_empty()) {
                starterStartup = dbDatum.extractBoolean();
            }
            properties_read = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    static void putAstorProperties() throws DevFailed {
        DbDatum[] dbDatumArray = new DbDatum[astorPropertyNames.length];
        int n = 0;
        dbDatumArray[n] = new DbDatum(astorPropertyNames[n], rloginCmd);
        dbDatumArray[++n] = new DbDatum(astorPropertyNames[n], rloginUser);
        dbDatumArray[++n] = new DbDatum(astorPropertyNames[n], jiveReadOnly);
        dbDatumArray[++n] = new DbDatum(astorPropertyNames[n], lastCollections);
        dbDatumArray[++n] = new DbDatum(astorPropertyNames[n], known_tango_hosts);
        dbDatumArray[++n] = new DbDatum(astorPropertyNames[n], new String[]{Integer.toString(AstorUtil.preferred_size.width), Integer.toString(AstorUtil.preferred_size.height)});
        dbDatumArray[++n] = new DbDatum(astorPropertyNames[n], new String[]{Integer.toString(AstorUtil.host_dlg_preferred_size.width), Integer.toString(AstorUtil.host_dlg_preferred_size.height)});
        dbDatumArray[++n] = new DbDatum(astorPropertyNames[n], tools);
        dbDatumArray[++n] = new DbDatum(astorPropertyNames[n], helps);
        ApiUtil.get_db_obj().put_property("Astor", dbDatumArray);
        DbDatum dbDatum = new DbDatum(starterStartupPropName);
        dbDatum.insert(starterStartup);
        DbClass dbClass = new DbClass("Starter");
        dbClass.put_property(new DbDatum[]{dbDatum});
    }

    void setJiveReadOnly(boolean bl) {
        jiveReadOnly = bl;
    }

    void setStarterStartup(boolean bl) {
        starterStartup = bl;
    }

    boolean jiveIsReadOnly() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return jiveReadOnly;
    }

    boolean getStarterStartup() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return starterStartup;
    }

    public String[] getLastCollectionList() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return lastCollections;
    }

    public void setLastCollectionList(String[] stringArray) {
        lastCollections = stringArray;
    }

    public List<String> getCollectionList() throws DevFailed {
        return this.getCollectionList(this.getTangoHostList());
    }

    public List<String> getCollectionList(TangoHost[] tangoHostArray) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TangoHost tangoHost : tangoHostArray) {
            if (tangoHost.collection == null) {
                tangoHost.collection = "Miscellaneous";
            }
            boolean bl = false;
            for (n = 0; n < arrayList.size() && !bl; ++n) {
                bl = tangoHost.collection.equals(arrayList.get(n));
            }
            if (bl) continue;
            arrayList.add(tangoHost.collection);
        }
        Collections.sort(arrayList, new StringComparator());
        arrayList.add(0, "Tango Database");
        String[] stringArray = this.getLastCollectionList();
        if (stringArray != null) {
            for (String string : stringArray) {
                n = 0;
                for (int i = 0; n == 0 && i < arrayList.size(); ++i) {
                    boolean bl = string.equals(arrayList.get(i));
                    n = bl ? 1 : 0;
                    if (!bl) continue;
                    String string2 = (String)arrayList.get(i);
                    arrayList.remove(i);
                    arrayList.add(string2);
                }
            }
        }
        return arrayList;
    }

    public TangoHost[] getTangoHostList() throws DevFailed {
        TangoHost[] tangoHostArray;
        String[] stringArray = this.getHostControlledList();
        boolean bl = ApiUtil.get_db_obj().get_idl_version() >= 4;
        DbDevImportInfo[] dbDevImportInfoArray = null;
        DbDevImportInfo[] dbDevImportInfoArray2 = null;
        if (bl) {
            tangoHostArray = MySqlUtil.getInstance();
            dbDevImportInfoArray = tangoHostArray.getHostDevImportInfo(starterDeviceHeader + "%");
            dbDevImportInfoArray2 = tangoHostArray.getHostDevImportInfo("dserver/starter/%");
        }
        tangoHostArray = new TangoHost[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            if (bl) {
                DbDevImportInfo dbDevImportInfo = this.getDevImportInfo(string, dbDevImportInfoArray);
                DbDevImportInfo dbDevImportInfo2 = this.getDevImportInfo(string, dbDevImportInfoArray2);
                if (dbDevImportInfo == null) continue;
                if (!dbDevImportInfo.exported || dbDevImportInfo2 == null) {
                    tangoHostArray[n++] = new TangoHost(string, false);
                    continue;
                }
                tangoHostArray[n++] = new TangoHost(dbDevImportInfo, dbDevImportInfo2);
                continue;
            }
            tangoHostArray[n++] = new TangoHost(string, true);
        }
        if (bl) {
            MySqlUtil.getInstance().manageTangoHostProperties(tangoHostArray);
        }
        return tangoHostArray;
    }

    private DbDevImportInfo getDevImportInfo(String string, DbDevImportInfo[] dbDevImportInfoArray) {
        for (DbDevImportInfo dbDevImportInfo : dbDevImportInfoArray) {
            int n = dbDevImportInfo.name.lastIndexOf(47);
            String string2 = dbDevImportInfo.name.substring(n + 1);
            if ((n = string2.indexOf(46)) > 0) {
                string2 = string2.substring(0, n);
            }
            if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
            return dbDevImportInfo;
        }
        return null;
    }

    public String[] getHostControlledList() throws DevFailed {
        return ApiUtil.get_db_obj().get_device_member(starterDeviceHeader + "*");
    }

    public static String getTangoHost() {
        String string;
        block3: {
            try {
                string = ApiUtil.getTangoHost();
            }
            catch (DevFailed devFailed) {
                return null;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                string = System.getProperty("TANGO_HOST");
                if (string != null) break block3;
                string = System.getenv("TANGO_HOST");
            }
        }
        return string;
    }

    public static short getStarterReadPeriod() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return readInfoPeriod;
    }

    public static short getStarterNbStartupLevels() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return nbStartupLevels;
    }

    private static void getStarterClassProperties() {
        try {
            _class = new DbClass("Starter");
            String[] stringArray = new String[]{"NbStartupLevels", "ReadInfoDbPeriod", "doc_url", "appli_doc_url"};
            DbDatum[] dbDatumArray = _class.get_property(stringArray);
            int n = 0;
            if (!dbDatumArray[n].is_empty()) {
                nbStartupLevels = dbDatumArray[n].extractShort();
            }
            if (!dbDatumArray[++n].is_empty()) {
                readInfoPeriod = dbDatumArray[n].extractShort();
            }
            readInfoPeriod = (short)(readInfoPeriod * 1000);
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
    }

    static String[] getServerClassProperties(String string) {
        String[] stringArray = new String[3];
        try {
            DbClass dbClass = new DbClass(string);
            String[] stringArray2 = new String[]{"ProjectTitle", "Description", "doc_url"};
            DbDatum[] dbDatumArray = dbClass.get_property(stringArray2);
            if (!dbDatumArray[0].is_empty()) {
                stringArray[0] = dbDatumArray[0].extractString();
            }
            if (!dbDatumArray[1].is_empty()) {
                String[] stringArray3 = dbDatumArray[1].extractStringArray();
                stringArray[1] = "";
                for (int i = 0; i < stringArray3.length; ++i) {
                    stringArray[1] = stringArray[1] + stringArray3[i];
                    if (i >= stringArray3.length - 1) continue;
                    stringArray[1] = stringArray[1] + "\n";
                }
            }
            stringArray[2] = dbDatumArray[2].is_empty() ? "Doc location unknown...." : dbDatumArray[2].extractString();
        }
        catch (DevFailed devFailed) {
            stringArray[2] = null;
            stringArray[1] = null;
            stringArray[0] = null;
        }
        return stringArray;
    }

    public static String strException(Exception exception) {
        String string = "";
        if (exception instanceof ConnectionFailed) {
            string = string + ((ConnectionFailed)exception).getStack();
        } else if (exception instanceof CommunicationFailed) {
            string = string + ((CommunicationFailed)exception).getStack();
        } else if (exception instanceof WrongNameSyntax) {
            string = string + ((WrongNameSyntax)exception).getStack();
        } else if (exception instanceof WrongData) {
            string = string + ((WrongData)exception).getStack();
        } else if (exception instanceof NonDbDevice) {
            string = string + ((NonDbDevice)exception).getStack();
        } else if (exception instanceof NonSupportedFeature) {
            string = string + ((NonSupportedFeature)exception).getStack();
        } else if (exception instanceof EventSystemFailed) {
            string = string + ((EventSystemFailed)exception).getStack();
        } else if (exception instanceof AsynReplyNotArrived) {
            string = string + ((AsynReplyNotArrived)exception).getStack();
        } else if (exception instanceof DevFailed) {
            DevFailed devFailed = (DevFailed)((Object)exception);
            string = string + "Tango exception  " + devFailed.toString() + "\n";
            for (int i = 0; i < devFailed.errors.length; ++i) {
                string = string + "Severity -> ";
                switch (devFailed.errors[i].severity.value()) {
                    case 0: {
                        string = string + "WARNING \n";
                        break;
                    }
                    case 1: {
                        string = string + "ERROR \n";
                        break;
                    }
                    case 2: {
                        string = string + "PANIC \n";
                        break;
                    }
                    default: {
                        string = string + "Unknown severity code";
                    }
                }
                string = string + "Desc   -> " + devFailed.errors[i].desc + "\n";
                string = string + "Reason -> " + devFailed.errors[i].reason + "\n";
                string = string + "Origin -> " + devFailed.errors[i].origin + "\n";
                if (i >= devFailed.errors.length - 1) continue;
                string = string + "-------------------------------------------------------------\n";
            }
        } else {
            string = exception.toString();
        }
        return string;
    }

    public static void centerDialog(JDialog jDialog, JFrame jFrame) {
        Point point = jFrame.getLocationOnScreen();
        point.x += (jFrame.getWidth() - jDialog.getWidth()) / 2;
        point.y += (jFrame.getHeight() - jDialog.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        jDialog.setLocation(point);
    }

    public static void centerDialog(JDialog jDialog, JDialog jDialog2) {
        Point point = jDialog2.getLocationOnScreen();
        point.x += (jDialog2.getWidth() - jDialog.getWidth()) / 2;
        point.y += (jDialog2.getHeight() - jDialog.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        jDialog.setLocation(point);
    }

    public static void rightShiftDialog(JDialog jDialog, JFrame jFrame) {
        Point point = jFrame.getLocationOnScreen();
        point.x += jFrame.getWidth();
        point.y += (jFrame.getHeight() - jDialog.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        jDialog.setLocation(point);
    }

    public static void cascadeDialog(JDialog jDialog, JDialog jDialog2) {
        Point point = jDialog2.getLocationOnScreen();
        point.x += 20;
        point.y += 20;
        jDialog.setLocation(point);
    }

    static String[] string2StringArray(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n = string.indexOf("\n")) > 0) {
            arrayList.add(string.substring(0, n));
            string = string.substring(n + 1);
        }
        arrayList.add(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void executeShellCmdAndReturn(String string) throws IOException {
        System.out.println(string);
        Process process = Runtime.getRuntime().exec(string);
        InputStream inputStream = process.getInputStream();
        new BufferedReader(new InputStreamReader(inputStream));
    }

    public static String executeShellCmd(String string) throws IOException, InterruptedException, DevFailed {
        String string2;
        Process process = Runtime.getRuntime().exec(string);
        InputStream inputStream = process.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string3 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string3 + string2 + "\n";
        }
        process.waitFor();
        int n = process.exitValue();
        if (n != 0) {
            InputStream inputStream2 = process.getErrorStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
            while ((string2 = bufferedReader.readLine()) != null) {
                System.out.println(string2);
                string3 = string3 + string2 + "\n";
            }
            Except.throw_exception((String)"ExecFailed", (String)("the shell command\n" + string + "\nreturns : " + n + " !\n\n" + string3));
        }
        return string3;
    }

    public static boolean osIsUnix() {
        return !System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static void testDevice(Component component, String string) {
        JDialog jDialog = component instanceof JDialog ? new JDialog((Dialog)((JDialog)component), false) : new JDialog((Frame)((JFrame)component), false);
        jDialog.setTitle(string + " Device Panel");
        try {
            jDialog.setContentPane((Container)new ExecDev(string));
            ATKGraphicsUtils.centerDialog((Dialog)jDialog);
            jDialog.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, null, (DevFailed)devFailed);
        }
    }

    public static void showInHtmBrowser(String string) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(new URI(string));
                }
                catch (Exception exception) {
                    ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)exception);
                }
            }
        } else {
            String string2 = AstorUtil.osIsUnix() ? "firefox - turbo" : "explorer";
            String string3 = string2 + " " + string;
            try {
                AstorUtil.executeShellCmdAndReturn(string3);
            }
            catch (Exception exception) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)exception);
            }
        }
    }

    public static String getAccessControlDeviceName() {
        String string;
        try {
            String[] stringArray = ApiUtil.get_db_obj().getServices("AccessControl", "*");
            string = stringArray.length > 0 ? stringArray[0] : null;
        }
        catch (DevFailed devFailed) {
            string = null;
        }
        return string;
    }

    public static void startSplash(String string) {
        String string2 = System.getenv("UseSplash");
        if (string2 != null && string2.equals("false")) {
            return;
        }
        JSmoothProgressBar jSmoothProgressBar = new JSmoothProgressBar();
        jSmoothProgressBar.setStringPainted(true);
        jSmoothProgressBar.setBackground(Color.lightGray);
        jSmoothProgressBar.setProgressBarColors(Color.gray, Color.lightGray, Color.darkGray);
        if (tango_icon == null) {
            tango_icon = Utils.getInstance().getIcon("TangoLogo.gif");
        }
        splash = new Splash(tango_icon, Color.black, jSmoothProgressBar);
        splash.setTitle(string);
        splash.setMessage("Starting....");
        splash_progress = 0;
        splash.setAlwaysOnTop(true);
        splash.setVisible(true);
        splash.repaint();
    }

    public static void stopSplash() {
        if (splash != null) {
            splash_progress = 100;
            splash.progress(splash_progress);
            splash.setVisible(false);
        }
    }

    public static void increaseSplashProgress(int n, String string) {
        if (splash != null) {
            if ((splash_progress += n) > 99) {
                splash_progress = 10;
            }
            splash.progress(splash_progress);
            splash.setMessage(string);
        }
    }

    public static void increaseSplashProgress(double d, String string) {
        if (splash != null) {
            splash_progress = (int)(100.0 * d);
            if (splash_progress > 99) {
                splash_progress = 10;
            }
            splash.progress(splash_progress);
            splash.setMessage(string);
        }
    }

    public static void setSplashMessage(String string) {
        if (splash != null) {
            splash.setMessage(string);
        }
    }

    public void initColors(int n) {
        if (rgb == null) {
            rgb = new RGB(n);
        } else {
            rgb.initColor(n);
        }
    }

    public Color getNewColor() {
        if (rgb == null) {
            rgb = new RGB();
        }
        return rgb.getNewColor();
    }

    public void sortTangoServer(ArrayList<TangoServer> arrayList) {
        Collections.sort(arrayList, new TangoServerComparator());
    }

    public void sort(ArrayList<String> arrayList) {
        Collections.sort(arrayList, new StringComparator());
    }

    public void startExternalApplication(String string, String string2) throws DevFailed {
        try {
            Constructor<?>[] constructorArray;
            Class<?> clazz = Class.forName(string);
            boolean bl = false;
            for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length != 2 || classArray[0] != JFrame.class || classArray[1] != String.class) continue;
                ((Component)constructor.newInstance(new JFrame(), string2)).setVisible(true);
                bl = true;
            }
            if (!bl) {
                throw new Exception("Cannot find constructor for " + string);
            }
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
                Throwable throwable = invocationTargetException.getTargetException();
                System.out.println(throwable.getMessage());
                if (throwable instanceof DevFailed) {
                    throw (DevFailed)throwable;
                }
            }
            Except.throw_exception((String)exception.toString(), (String)exception.toString(), (String)"AstorUtil.startExternalApplication()");
        }
    }

    public void startExternalApplication(String string, String[] stringArray) throws DevFailed {
        try {
            Constructor<?>[] constructorArray;
            Class<?> clazz = Class.forName(string);
            boolean bl = false;
            for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length != 2 || classArray[0] != JFrame.class || classArray[1] != String[].class) continue;
                ((Component)constructor.newInstance(new JFrame(), stringArray)).setVisible(true);
                bl = true;
            }
            if (!bl) {
                throw new Exception("Cannot find constructor for " + string);
            }
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
                Throwable throwable = invocationTargetException.getTargetException();
                System.out.println(throwable.getMessage());
                if (throwable instanceof DevFailed) {
                    throw (DevFailed)throwable;
                }
            }
            Except.throw_exception((String)exception.toString(), (String)exception.toString(), (String)"AstorUtil.startExternalApplication()");
        }
    }

    public static void main(String[] stringArray) {
        try {
            AstorUtil.getInstance().startExternalApplication("host_info.HostStatus", "l-c01-1");
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
    }

    static {
        astorPropertyNames = new String[]{"RloginCmd", "RloginUser", "JiveReadOnly", "LastCollections", "KnownTangoHosts", "PreferredSize", "HostDialogPreferredSize", "Tools", "HtmlHelps"};
        state_icons = new ImageIcon[7];
        hostInfoClassName = null;
        tango_icon = null;
        rgb = null;
    }

    class TangoServerComparator
    implements Comparator<TangoServer> {
        TangoServerComparator() {
        }

        @Override
        public int compare(TangoServer tangoServer, TangoServer tangoServer2) {
            if (tangoServer == null) {
                return 1;
            }
            if (tangoServer2 == null) {
                return -1;
            }
            return tangoServer.getName().compareTo(tangoServer2.getName());
        }
    }

    class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string == null) {
                return 1;
            }
            if (string2 == null) {
                return -1;
            }
            return string.compareTo(string2);
        }
    }

    class RGB {
        int r = 0;
        int g = 0;
        int b = 0;
        int step = 10;
        private boolean red = true;
        private boolean green = false;
        private boolean blue = false;

        RGB() {
        }

        RGB(int n) {
            this.initColor(n);
        }

        void initColor(int n) {
            this.step = 1020 / n;
            if (this.step == 255) {
                this.step = 128;
            }
            this.red = true;
            this.green = false;
            this.blue = false;
            this.b = 0;
            this.g = 0;
            this.r = 0;
        }

        void increase() {
            if (this.red) {
                if (this.r + this.step < 255) {
                    this.r += this.step;
                } else {
                    this.r = 255;
                    this.red = false;
                    this.green = true;
                }
            } else if (this.green) {
                if (this.g + this.step < 255) {
                    if (this.r - this.step > 0) {
                        this.r -= this.step;
                    }
                    this.g += this.step;
                } else {
                    this.g = 255;
                    this.green = false;
                    this.blue = true;
                }
            } else if (this.blue) {
                if (this.b + this.step < 255) {
                    if (this.g - this.step > 0) {
                        this.g -= this.step;
                    }
                    this.b += this.step;
                } else {
                    this.b = 255;
                    this.r = 255;
                    this.blue = false;
                }
            } else if (this.r - this.step > 0) {
                this.r -= this.step;
                this.b -= this.step;
            }
        }

        Color getNewColor() {
            this.increase();
            return new Color(this.r, this.g, this.b);
        }
    }
}

