/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorCmdLine;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.DeviceTreeDialog;
import admin.astor.GetTextDialog;
import admin.astor.Monitor;
import admin.astor.MultiServerCommand;
import admin.astor.NewStarterDialog;
import admin.astor.OneTool;
import admin.astor.PreferenceDialog;
import admin.astor.Selector;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import admin.astor.statistics.StatisticsPanel;
import admin.astor.tango_release.JTangoVersion;
import admin.astor.tools.DevBrowser;
import admin.astor.tools.PopupHtml;
import admin.astor.tools.PopupTable;
import admin.astor.tools.PopupText;
import admin.astor.tools.ServerUsageDialog;
import admin.astor.tools.Utils;
import admin.astor.tools.WideSearchDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangORBversion;
import fr.esrf.TangoDs.Except;
import fr.esrf.logviewer.Main;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Astor
extends JFrame
implements AstorDefs {
    private static String revNumber = "7.0.0  -  26-08-2016  14:14:06";
    public AstorTree tree = null;
    private boolean expanded = false;
    private JScrollPane scrollPane;
    private static DevBrowser devBrowser = null;
    static long t0;
    private String tango_host = "";
    private MultiServerCommand multiServerCommand = null;
    private static int jarUsed;
    public static int rwMode;
    private String[] htmlHelps = null;
    private int nb_def_tools = 1;
    private List<OneTool> app_tools = new ArrayList<OneTool>();
    private List<ActionListener> tools_al = new ArrayList<ActionListener>();
    private Main logviewer = null;
    private static String searched_host;
    private WideSearchDialog wide_search_dlg = null;
    private JMenuItem aboutBtn;
    private JMenuItem accessControlBtn;
    private JPanel bottomPanel;
    private JMenuItem changeTgHostBtn;
    private JMenu cmdMenu;
    private JMenuItem ctrlPreferenceBtn;
    private JMenuItem deviceBrowserBtn;
    private JMenuItem distributionBtn;
    private JMenuItem exitBtn;
    private JMenuItem expandBtn;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem jiveMenuItem;
    private JMenuItem logviewerMenuItem;
    private JLabel modeLabel;
    private JMenuItem multiServersCmdItem;
    private JMenuItem newBranchBtn;
    private JMenuItem newHostBtn;
    private JMenuItem principleBtn;
    private JMenuItem releaseNoteBtn;
    private JMenuItem starterEventsItem;
    private JMenuItem starterNoEventsItem;
    private JMenuItem stateIconsBtn;
    private JMenuItem tangorbBtn;
    private JLabel titleLabel;
    private JMenu toolsMenu;
    private JPanel topPanel;
    private JMenuItem usePreferenceBtn;
    private JMenu viewMenu;

    public Astor() throws DevFailed {
        t0 = System.currentTimeMillis();
        this.initComponents();
        AstorUtil.getInstance().initIcons();
        this.customizeMenu();
        this.setTitle("TANGO Manager - " + revNumber);
        this.setControlSystemTitle();
        this.buildTree();
        ImageIcon imageIcon = Utils.getInstance().getIcon("TangoClass.gif");
        this.setIconImage(imageIcon.getImage());
        jarUsed = JTangoVersion.getInstance().getJarFileType();
        this.tangorbBtn.setText(JTangoVersion.JarUsed[jarUsed] + " Version");
        this.centerWindow();
        try {
            this.tango_host = ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    private void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.getSize();
        Point point = new Point();
        point.x = (dimension.width - dimension2.width) / 2;
        point.y = (dimension.height - dimension2.height) / 2;
        this.setLocation(point);
    }

    private void setControlSystemTitle() throws DevFailed {
        String string = AstorUtil.getControlSystemName();
        if (string != null && string.length() > 0) {
            this.titleLabel.setText(string);
            this.topPanel.setVisible(true);
        } else {
            this.topPanel.setVisible(false);
        }
    }

    private void buildTree() throws DevFailed {
        String string = "Astor (TANGO Manager)";
        int n = revNumber.indexOf("-");
        if (n > 0) {
            string = string + " - " + revNumber.substring(0, n).trim();
        }
        JSmoothProgressBar jSmoothProgressBar = new JSmoothProgressBar();
        jSmoothProgressBar.setStringPainted(true);
        jSmoothProgressBar.setBackground(Color.lightGray);
        jSmoothProgressBar.setProgressBarColors(Color.gray, Color.gray, Color.gray);
        ImageIcon imageIcon = Utils.getInstance().getIcon("TangoLogo.gif");
        Splash splash = new Splash(imageIcon, Color.black, jSmoothProgressBar);
        splash.setTitle(string);
        splash.setMessage("Starting....");
        splash.setVisible(true);
        try {
            if (this.tree != null) {
                this.tree.stopThreads();
                this.scrollPane.remove(this.tree);
                this.remove(this.scrollPane);
            }
            this.tree = new AstorTree(this, splash);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setPreferredSize(AstorUtil.getPreferredSize());
            this.scrollPane.setViewportView(this.tree);
            this.getContentPane().add((Component)this.scrollPane, "Center");
            this.expanded = false;
            this.pack();
            this.manageAccessControlMenu(this.tree.isAccessControlled());
        }
        catch (DevFailed devFailed) {
            splash.setVisible(false);
            throw devFailed;
        }
    }

    Dimension getTreeSize() {
        return this.scrollPane.getPreferredSize();
    }

    void setTreeSize(Dimension dimension) {
        this.scrollPane.setPreferredSize(dimension);
        this.pack();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.ctrlPreferenceBtn.setMnemonic('P');
        this.ctrlPreferenceBtn.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        String string = System.getProperty("NO_PREF");
        if (string != null && string.toLowerCase().equals("true")) {
            this.ctrlPreferenceBtn.setEnabled(false);
        }
        this.ctrlPreferenceBtn.setEnabled(rwMode == 0);
        this.usePreferenceBtn.setEnabled(rwMode == 0);
        this.changeTgHostBtn.setMnemonic('T');
        this.changeTgHostBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.viewMenu.setMnemonic('V');
        this.newBranchBtn.setMnemonic('N');
        this.newBranchBtn.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.deviceBrowserBtn.setMnemonic('B');
        this.deviceBrowserBtn.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.expandBtn.setMnemonic('E');
        this.expandBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.toolsMenu.setMnemonic('T');
        this.multiServersCmdItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.jiveMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.logviewerMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.multiServersCmdItem.setEnabled(rwMode == 0);
        this.jiveMenuItem.setEnabled(rwMode != 2);
        this.accessControlBtn.setEnabled(rwMode != 2);
        this.cmdMenu.setMnemonic('C');
        this.cmdMenu.setEnabled(rwMode != 2);
        this.newHostBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.nb_def_tools = this.toolsMenu.getItemCount();
        this.buildToolsItems();
        this.buildAdditionnalHelps();
        this.expandBtn.setVisible(false);
        this.modeLabel.setText(strMode[rwMode]);
        this.bottomPanel.setVisible(rwMode != 0);
    }

    private void manageAccessControlMenu(boolean bl) {
        if (bl) {
            this.accessControlBtn.setMnemonic('A');
            this.accessControlBtn.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.accessControlBtn.setVisible(true);
            System.out.println("AccessControl is active");
        } else {
            this.accessControlBtn.setVisible(false);
        }
    }

    private void buildAdditionnalHelps() {
        this.htmlHelps = AstorUtil.getHtmlHelps();
        if (this.htmlHelps == null) {
            return;
        }
        if (this.htmlHelps.length == 0) {
            return;
        }
        this.helpMenu.add(new JSeparator());
        for (int i = 0; i < this.htmlHelps.length / 2; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setText(this.htmlHelps[2 * i]);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Astor.this.htmlHelpsItemActionPerformed(actionEvent);
                }
            });
            this.helpMenu.add(jMenuItem);
        }
    }

    private void htmlHelpsItemActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = null;
        for (int i = 0; i < this.htmlHelps.length; ++i) {
            if (!string.equals(this.htmlHelps[i]) || i >= this.htmlHelps.length - 1) continue;
            string2 = this.htmlHelps[i + 1];
        }
        if (string2 == null) {
            Utils.popupError(this, "No command found for item  '" + string + "'");
        }
        System.out.println(string2);
        AstorUtil.showInHtmBrowser(string2);
    }

    private void buildToolsItems() {
        for (int i = this.toolsMenu.getItemCount(); i > this.nb_def_tools; --i) {
            JMenuItem jMenuItem = this.toolsMenu.getItem(i - 1);
            jMenuItem.removeActionListener(this.tools_al.get(i - this.nb_def_tools - 1));
            this.toolsMenu.remove(i - 1);
        }
        this.app_tools.clear();
        this.tools_al.clear();
        String[] stringArray = AstorUtil.getTools();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                OneTool oneTool = new OneTool(stringArray[i], stringArray[i + 1]);
                this.app_tools.add(oneTool);
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.setText(oneTool.name);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Astor.this.toolsItemActionPerformed(actionEvent);
                    }
                };
                jMenuItem.addActionListener(actionListener);
                this.tools_al.add(actionListener);
                this.toolsMenu.add(jMenuItem);
            }
        }
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.modeLabel = new JLabel();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.changeTgHostBtn = new JMenuItem();
        this.ctrlPreferenceBtn = new JMenuItem();
        this.usePreferenceBtn = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.deviceBrowserBtn = new JMenuItem();
        JMenuItem jMenuItem = new JMenuItem();
        this.expandBtn = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        this.cmdMenu = new JMenu();
        JMenuItem jMenuItem3 = new JMenuItem();
        JMenuItem jMenuItem4 = new JMenuItem();
        this.newHostBtn = new JMenuItem();
        this.newBranchBtn = new JMenuItem();
        this.toolsMenu = new JMenu();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem5 = new JMenuItem();
        JMenuItem jMenuItem6 = new JMenuItem();
        JMenuItem jMenuItem7 = new JMenuItem();
        this.multiServersCmdItem = new JMenuItem();
        JMenuItem jMenuItem8 = new JMenuItem();
        this.jiveMenuItem = new JMenuItem();
        this.accessControlBtn = new JMenuItem();
        JMenuItem jMenuItem9 = new JMenuItem();
        this.logviewerMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.principleBtn = new JMenuItem();
        this.distributionBtn = new JMenuItem();
        this.stateIconsBtn = new JMenuItem();
        this.tangorbBtn = new JMenuItem();
        this.starterEventsItem = new JMenuItem();
        this.starterNoEventsItem = new JMenuItem();
        JMenuItem jMenuItem10 = new JMenuItem();
        this.releaseNoteBtn = new JMenuItem();
        this.aboutBtn = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Astor.this.exitForm(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Tahoma", 1, 18));
        this.topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.modeLabel.setFont(new Font("Tahoma", 1, 12));
        this.bottomPanel.add(this.modeLabel);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.fileMenu.setText("File");
        this.changeTgHostBtn.setText("Change Tango Host");
        this.changeTgHostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.changeTgHostBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.changeTgHostBtn);
        this.ctrlPreferenceBtn.setText("Ctrl System Preferences");
        this.ctrlPreferenceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.ctrlPreferenceBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.ctrlPreferenceBtn);
        this.usePreferenceBtn.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.usePreferenceBtn.setMnemonic('U');
        this.usePreferenceBtn.setText("User Preferences");
        this.usePreferenceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.usePreferenceBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.usePreferenceBtn);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.exitBtnActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.deviceBrowserBtn.setText("Event Manager");
        this.deviceBrowserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.deviceBrowserBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.deviceBrowserBtn);
        jMenuItem.setText("Update Tree from database");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.refreshBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(jMenuItem);
        this.expandBtn.setText("Expand Tree");
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.expandBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.expandBtn);
        jMenuItem2.setText("Startup Errors");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.startupErrorBtnActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(jMenuItem2);
        jMenuBar.add(this.viewMenu);
        this.cmdMenu.setText("Command");
        jMenuItem3.setText("Start All Controlled Servers");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.startServersBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(jMenuItem3);
        jMenuItem4.setText("Stop All Controlled Servers");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.stopServersBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(jMenuItem4);
        this.newHostBtn.setText("Add a New Host");
        this.newHostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.newHostBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(this.newHostBtn);
        this.newBranchBtn.setText("Add a New Branch");
        this.newBranchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.newBranchBtnActionPerformed(actionEvent);
            }
        });
        this.cmdMenu.add(this.newBranchBtn);
        jMenuBar.add(this.cmdMenu);
        this.toolsMenu.setText("Tools");
        jMenu.setText("Find");
        jMenuItem5.setText("Host by Name");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.findHostItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem5);
        jMenuItem6.setText("Device/Server/Class by Filter");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.findObjectByFilterItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem6);
        this.toolsMenu.add(jMenu);
        jMenuItem7.setText("Ctrl System Info");
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.tangoStatBtnActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(jMenuItem7);
        this.multiServersCmdItem.setText("Multi Servers Command");
        this.multiServersCmdItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.multiServersCmdItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.multiServersCmdItem);
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        jMenuItem8.setText("Server Usage");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.serverUsageMenuItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(jMenuItem8);
        this.jiveMenuItem.setText("Jive");
        this.jiveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.jiveMenuItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.jiveMenuItem);
        this.accessControlBtn.setText("Access Control");
        this.accessControlBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.accessControlBtnActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.accessControlBtn);
        jMenuItem9.setText("Server Statistics");
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.statisticsBtnActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(jMenuItem9);
        this.logviewerMenuItem.setText("LogViewer");
        this.logviewerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.logviewerMenuItemActionPerformed(actionEvent);
            }
        });
        this.toolsMenu.add(this.logviewerMenuItem);
        jMenuBar.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.principleBtn.setText("Principle");
        this.principleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.principleBtn);
        this.distributionBtn.setText("Servers Distribution");
        this.distributionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.distributionBtn);
        this.stateIconsBtn.setText("State Icons");
        this.stateIconsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.stateIconsBtn);
        this.tangorbBtn.setText("TangORB revision");
        this.tangorbBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.tangorbBtn);
        this.starterEventsItem.setText("Hosts Controlled on Events");
        this.starterEventsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.starterEventsItem);
        this.starterNoEventsItem.setText("Hosts Controlled on Polling");
        this.starterNoEventsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.starterNoEventsItem);
        jMenuItem10.setText("Faulty Host List");
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.faultyListItemhelpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(jMenuItem10);
        this.releaseNoteBtn.setText("Release Note");
        this.releaseNoteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.releaseNoteBtn);
        this.aboutBtn.setText("About");
        this.aboutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Astor.this.helpActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutBtn);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void ctrlPreferenceBtnActionPerformed(ActionEvent actionEvent) {
        new PreferenceDialog(this).setVisible(true);
        try {
            this.setControlSystemTitle();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    private void usePreferenceBtnActionPerformed(ActionEvent actionEvent) {
        List<String> list = AstorUtil.getAllKnownTangoHosts();
        GetTextDialog getTextDialog = new GetTextDialog(this, "List of User Tango Hosts", null, list);
        if (getTextDialog.showDialog() == 0) {
            list = getTextDialog.getTextLines();
            try {
                AstorUtil.saveUserKnownTangoHost(list);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    private void startupErrorBtnActionPerformed(ActionEvent actionEvent) {
        if (this.tree.subscribeErrWindow == null) {
            Utils.popupMessage(this, "No error at startup.");
        } else {
            this.tree.subscribeErrWindow.setVisible(true);
        }
    }

    private void accessControlBtnActionPerformed(ActionEvent actionEvent) {
        this.tree.startTACpanel();
    }

    private void changeTgHostBtnActionPerformed(ActionEvent actionEvent) {
        try {
            List<String> list = AstorUtil.getAllKnownTangoHosts();
            Selector selector = new Selector((JFrame)this, "Tango Host  (e.g.  hal:2001)", list, this.tango_host);
            ATKGraphicsUtils.centerDialog((Dialog)selector);
            String string = selector.showDialog();
            if (string == null || string.length() == 0) {
                return;
            }
            String[] stringArray = string.split(":");
            if (stringArray.length != 2) {
                Utils.popupError(this, "Input syntax error\n" + string + "\n is not a valid TANGO_HOST");
                return;
            }
            ApiUtil.get_db_obj((String)stringArray[0], (String)stringArray[1]);
            if (this.tango_host.equals(string)) {
                return;
            }
            String string2 = rwMode == 0 ? "-rw" : (rwMode == 1 ? "-db_ro" : "-ro");
            String string3 = "java -DTANGO_HOST=" + string + " admin.astor.Astor " + string2;
            AstorUtil.executeShellCmd(string3);
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot change TANGO_HOST", (Exception)exception);
        }
    }

    private void logviewerMenuItemActionPerformed(ActionEvent actionEvent) {
        if (this.logviewer == null) {
            this.logviewer = new Main((JFrame)this);
        }
        this.logviewer.setVisible(true);
        this.logviewer.toFront();
    }

    private void jiveMenuItemActionPerformed(ActionEvent actionEvent) {
        this.tree.displayJiveAppli();
    }

    private void findHostItemActionPerformed(ActionEvent actionEvent) {
        String string = (String)JOptionPane.showInputDialog(this, "Host Name ?", "Input Dialog", 1, null, null, searched_host);
        if (string != null) {
            try {
                this.tree.setSelectionRoot();
                this.tree.setSelectionPath(string);
                this.tree.displayHostInfo();
                searched_host = string;
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    private void tangoStatBtnActionPerformed(ActionEvent actionEvent) {
        if (JOptionPane.showConfirmDialog(this, "The System Information needs to browse Database\n        and it could take a long time !\n\nStart it any way ?", "Confirm Dialog", 0) == 0) {
            new DeviceTreeDialog(this);
        }
    }

    private void toolsItemActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            OneTool oneTool = this.getToolApplication(string);
            System.out.println("Starting " + oneTool.classname);
            if (oneTool.jframe != null) {
                oneTool.jframe.setVisible(true);
            } else {
                Constructor<?>[] constructorArray;
                Class<?> clazz = Class.forName(oneTool.classname);
                boolean bl = false;
                for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
                    Class<?>[] classArray = constructor.getParameterTypes();
                    if (classArray.length != 1 || classArray[0] != JFrame.class) continue;
                    oneTool.setJFrame((JFrame)constructor.newInstance(this));
                    oneTool.jframe.setVisible(true);
                    bl = true;
                }
                if (!bl) {
                    throw new Exception("Cannot find constructor for " + oneTool.classname);
                }
            }
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)exception);
        }
    }

    private OneTool getToolApplication(String string) throws Exception {
        for (OneTool oneTool : this.app_tools) {
            if (!oneTool.name.equals(string)) continue;
            return oneTool;
        }
        throw new Exception(string + " tool not found");
    }

    void removeHost(String string) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure to want to remove " + string, "Confirm Dialog", 0) != 0) {
            return;
        }
        String string2 = "Starter/" + string;
        String string3 = "dserver/" + string2;
        String string4 = AstorUtil.getStarterDeviceHeader() + string;
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string4);
            deviceProxy.delete_property("StartDsPath");
            deviceProxy.delete_property("HostCollection");
            deviceProxy.delete_property("HostUsage");
            deviceProxy.delete_property("UseEvents");
            Database database = ApiUtil.get_db_obj((String)AstorUtil.getTangoHost());
            database.delete_server(string2);
            database.delete_device(string4);
            database.delete_device(string3);
            JOptionPane.showMessageDialog(this, string + " has been removed !", "Command Done", 1);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot remove host", (DevFailed)devFailed);
        }
        try {
            this.buildTree();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void newHostBtnActionPerformed(ActionEvent actionEvent) {
        this.addNewHost(null);
    }

    void addNewHost(TangoHost tangoHost) {
        NewStarterDialog newStarterDialog = new NewStarterDialog(this, tangoHost, this.tree.getCollectionList(), this.tree.hosts, true);
        newStarterDialog.setVisible(true);
        if (newStarterDialog.getValue() == 0) {
            try {
                this.buildTree();
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    void editHostProperties(TangoHost tangoHost) {
        NewStarterDialog newStarterDialog = new NewStarterDialog(this, tangoHost, this.tree.getCollectionList(), this.tree.hosts, false);
        newStarterDialog.setVisible(true);
    }

    private void stopServersBtnActionPerformed(ActionEvent actionEvent) {
        new ServerCmdThread(this, this.tree.hosts, 1).start();
    }

    private void startServersBtnActionPerformed(ActionEvent actionEvent) {
        new ServerCmdThread(this, this.tree.hosts, 0).start();
    }

    private void newBranchBtnActionPerformed(ActionEvent actionEvent) {
        String string = (String)JOptionPane.showInputDialog(this, "New Branch Name", "Input Dialog", 1, null, null, "");
        if (string != null) {
            this.tree.addBranch(string);
        }
    }

    private void helpActionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem == this.principleBtn) {
            Utils.popupMessage(this, "", "principle.gif");
        } else if (jMenuItem == this.distributionBtn) {
            new HostsScanThread(this, this.tree.hosts).start();
        } else if (jMenuItem == this.stateIconsBtn) {
            Utils.popupMessage(this, "", "astor_state_icons.gif");
        } else if (jMenuItem == this.releaseNoteBtn) {
            new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<html>\n<head>\n<title> Release Note </title>\n</head>\n<body text=\"#000000\" bgColor=\"#FFFFFF\" link=\"#0000FF\" vLink=\"#7F00FF\" aLink=\"#FF0000\">\n<p><!-------TITLE------></p>\n<center>\t<h2>Astor Release Notes </h2>\n\t(Generated 26-08-2016  14:14:06)</center><br>\n<li><b>Astor-7.0.0 -  26/08/16:</b><br>&nbsp; &nbsp; &nbsp; Java-7 syntax compatibility.<br><li><b>Astor-6.7.1 -  28/06/16:</b><br>&nbsp; &nbsp; &nbsp; Fix a little bug in startup level management.<br><li><b>Astor-6.7.0 -  27/01/16:</b><br>&nbsp; &nbsp; &nbsp; Starter domain name could be set with a class property.<br>&nbsp; &nbsp; &nbsp; Improve &rdquo;Tango release for servers&rdquo; feature<br><li><b>Astor-6.6.6 -  30/06/15:</b><br>&nbsp; &nbsp; &nbsp; Java-7 compatibility.<br>&nbsp; &nbsp; &nbsp; Manage polling for Tango-9 feature.<br>&nbsp; &nbsp; &nbsp; Improve Tango release for servers.<br>&nbsp; &nbsp; &nbsp; Add a compatibility to read JTango release.<br>&nbsp; &nbsp; &nbsp; Update file headers.<br><li><b>Astor-6.6.5 -  08/01/15:</b><br>&nbsp; &nbsp; &nbsp; Improve Server Usage utility<br><li><b>Astor-6.6.4 -  08/01/15:</b><br>&nbsp; &nbsp; &nbsp; Improve the statup level change.<br><li><b>Astor-6.6.3 -  17/12/14:</b><br>&nbsp; &nbsp; &nbsp; Several invokeLater() methods added.<br><li><b>Astor-6.6.2 -  18/11/14:</b><br>&nbsp; &nbsp; &nbsp; ULong management added to event tester.<br><li><b>Astor-6.6.1 -  04/11/14:</b><br>&nbsp; &nbsp; &nbsp; Faulty host list added to help menu.<br><li><b>Astor-6.6.0 -  01/10/14:</b><br>&nbsp; &nbsp; &nbsp; Server Tango release manage Tango-9 and IDL5<br><li><b>Astor-6.5.1 -  05/08/14:</b><br>&nbsp; &nbsp; &nbsp; Improve Last Branches management.<br><li><b>Astor-6.5.0 -  19/04/14:</b><br>&nbsp; &nbsp; &nbsp; Manage OFF state for Starter devices.<br>&nbsp; &nbsp; &nbsp; Improve DbPollPanel class.<br><li><b>Astor-6.4.6 -  29/01/14:</b><br>&nbsp; &nbsp; &nbsp; Package ctrl_system_info added to the jar file.<br><li><b>Astor-6.4.5 -  10/01/14:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem on starter properties (HostUsage and Family)<br>&nbsp; &nbsp; &nbsp; Clean compilation warnings.<br><li><b>Astor-6.4.3 -  07/01/14:</b><br>&nbsp; &nbsp; &nbsp; Remove warning on tools launch.<br><li><b>Astor-6.4.2 -  29/10/13:</b><br>&nbsp; &nbsp; &nbsp; Try to fix infinite ping loop.<br><li><b>Astor-6.4.1 -  25/10/13:</b><br>&nbsp; &nbsp; &nbsp; Replace dancers by official Tango logo.<br>&nbsp; &nbsp; &nbsp; Cleanup part of code.<br><li><b>Astor-6.4.0 -  24/09/13:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem in Tango releases help.<br>&nbsp; &nbsp; &nbsp; fix a problem on resize with java-7<br><li><b>Astor-6.3.9 -  30/08/13:</b><br>&nbsp; &nbsp; &nbsp; Fix problem in pool threads management using new syntax.<br>&nbsp; &nbsp; &nbsp; Improve sort methods.<br>&nbsp; &nbsp; &nbsp; ServerStatePanel is now an astor.tools class (not from tool_panels package)<br><li><b>Astor-6.3.7 -  09/08/13:</b><br>&nbsp; &nbsp; &nbsp; Improve UnAvailableHostsDialog class.<br><li><b>Astor-6.3.6 -  12/06/13:</b><br>&nbsp; &nbsp; &nbsp; Server list to be started can now be taken from another host.<br><li><b>Astor-6.3.5 -  28/05/13:</b><br>&nbsp; &nbsp; &nbsp; Update splash screen with new logos.<br><li><b>Astor-6.3.4 -  16/05/13:</b><br>&nbsp; &nbsp; &nbsp; Minor changes.<br><li><b>Astor-6.3.3 -  30/04/13:</b><br>&nbsp; &nbsp; &nbsp; Add a tool to export server from database to another one.<br><li><b>Astor-6.3.2 -  03/04/13:</b><br>&nbsp; &nbsp; &nbsp; Add a display for statistics reset by host.<br><li><b>Astor-6.3.1 -  19/03/13:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem when starter is killed.<br><li><b>Astor-6.3.0 -  06/03/13:</b><br>&nbsp; &nbsp; &nbsp; implement READ_ONLY, DB_READ_ONLY, READ_WRITE modes.<br><li><b>Astor-6.2.2 -  21/01/13:</b><br>&nbsp; &nbsp; &nbsp; Fix a bug in adding item on TAC<br><li><b>Astor-6.2.1 -  14/01/13:</b><br>&nbsp; &nbsp; &nbsp; Pb on notif icon fixed.<br><li><b>Astor-6.2.0 -  07/01/13:</b><br>&nbsp; &nbsp; &nbsp; Group management added on TAC panel.<br><li><b>Astor-6.1.2 -  26/10/12:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem when too much devices in SubDevices.<br><li><b>Astor-6.1.1 -  26/10/12:</b><br>&nbsp; &nbsp; &nbsp; HostInfoDialog can be run in stand alone.<br><li><b>Astor-6.1.0 -  24/10/12:</b><br>&nbsp; &nbsp; &nbsp; Tango release for servers tool added.<br><li><b>Astor-6.0.6 -  09/10/12:</b><br>&nbsp; &nbsp; &nbsp; Pb with back slash fixed (?)<br><li><b>Astor-6.0.5 -  21/08/12:</b><br>&nbsp; &nbsp; &nbsp; Open Jive on a selected server.<br><li><b>Astor-6.0.4 -  24/05/12:</b><br>&nbsp; &nbsp; &nbsp; Distribution release.<br><li><b>Astor-6.0.3 -  05/04/12:</b><br>&nbsp; &nbsp; &nbsp; Add a control system name management.<br>&nbsp; &nbsp; &nbsp; User preferences for tango host list added.<br><li><b>Astor-6.0.1 -  02/04/12:</b><br>&nbsp; &nbsp; &nbsp; Problem when removing server info fixed.<br><li><b>Astor-6.0.0 -  08/02/12:</b><br>&nbsp; &nbsp; &nbsp; Comptibility with TangORB-8.x (ZMQ event system or supposed to be).<br><li><b>Astor-5.5.4 -  06/12/11:</b><br>&nbsp; &nbsp; &nbsp; Create a Thread to update splash screen (to boost startup).<br><li><b>Astor-5.5.3 -  07/09/11:</b><br>&nbsp; &nbsp; &nbsp; ServerUsage tool added.<br><li><b>Astor-5.5.2 -  26/07/11:</b><br>&nbsp; &nbsp; &nbsp; Statistics on one host added.<br><li><b>Astor-5.5.1 -  12/04/11:</b><br>&nbsp; &nbsp; &nbsp; Auto start info added to statistics tool.<br><li><b>Astor-5.5.0 -  01/04/11:</b><br>&nbsp; &nbsp; &nbsp; Statistics tools added.<br><li><b>Astor-5.4.1 -  14/03/11:</b><br>&nbsp; &nbsp; &nbsp; Pb on TangoHost.getFamily() (if not defined) fixed.<br><li><b>Astor-5.4.0 -  11/02/11:</b><br>&nbsp; &nbsp; &nbsp; Pb with TAC when adding addresses on &rdquo;All Users&rdquo; fixed.<br>&nbsp; &nbsp; &nbsp; No reference on app_util classes any more.<br>&nbsp; &nbsp; &nbsp; Change splash screen image.<br><li><b>Astor-5.3.7 -  24/01/11:</b><br>&nbsp; &nbsp; &nbsp; Constructor added.<br><li><b>Astor-5.3.6 -  13/01/11:</b><br>&nbsp; &nbsp; &nbsp; Pb on black box reader thread fixed.<br><li><b>Astor-5.3.5 -  10/01/11:</b><br>&nbsp; &nbsp; &nbsp; TAC is now displayed as database servers.<br>&nbsp; &nbsp; &nbsp; StartServersAtStarteup starter class property management added.<br>&nbsp; &nbsp; &nbsp; Display access mode in Tango Access panel.<br><li><b>Astor-5.3.4 -  04/01/11:</b><br>&nbsp; &nbsp; &nbsp; Do not try to subscribe on Starter events if starter device not exported.<br><li><b>Astor-5.3.3 -  21/12/10:</b><br>&nbsp; &nbsp; &nbsp; Little tool to un-export devices registred on unreachable hosts added.<br><li><b>Astor-5.3.2 -  16/12/10:</b><br>&nbsp; &nbsp; &nbsp; Add a password for AccessControl tool.<br><li><b>Astor-5.3.1 -  02/12/10:</b><br>&nbsp; &nbsp; &nbsp; Constructors added in  PoolThreadsManager to be launched from Jive.<br><li><b>Astor-5.3.0 -  30/11/10:</b><br>&nbsp; &nbsp; &nbsp; For multi servers command, if the command is done through the starter,<br>&nbsp; &nbsp; &nbsp; it is done by a thread and a delay has been added between servers.<br><li><b>Astor-5.2.11 -  29/11/10:</b><br>&nbsp; &nbsp; &nbsp; Multi servers command added.<br>&nbsp; &nbsp; &nbsp; Uptime for servers added.<br><li><b>Astor-5.2.10 -  08/10/10:</b><br>&nbsp; &nbsp; &nbsp; Change default view in Polling Profiler.<br><li><b>Astor-5.2.9 -  01/09/10:</b><br>&nbsp; &nbsp; &nbsp; Minor change (traces removed and added).<br><li><b>Astor-5.2.8 -  17/06/10:</b><br>&nbsp; &nbsp; &nbsp; Pb on display startup level dialog in case of many devices fixed.<br><li><b>Astor-5.2.7 -  17/06/10:</b><br>&nbsp; &nbsp; &nbsp; Start new server can take several servers (multiple selection).<br><li><b>Astor-5.2.6 -  04/06/10:</b><br>&nbsp; &nbsp; &nbsp; Global command to change startup level added.<br><li><b>Astor-5.2.5 -  08/04/10:</b><br>&nbsp; &nbsp; &nbsp; Minor bugs fixed.<br><li><b>Astor-5.2.4 -  05/01/10:</b><br>&nbsp; &nbsp; &nbsp; Best management of subscribe error window at startup.<br><li><b>Astor-5.2.3 -  18/08/09:</b><br>&nbsp; &nbsp; &nbsp; Bug in Device Dependencies fixed (infinite loop)<br><li><b>Astor-5.2.2 -  02/06/09:</b><br>&nbsp; &nbsp; &nbsp; Bug on host.check_notifyd fixed.<br><li><b>Astor-5.2.1 -  15/05/09:</b><br>&nbsp; &nbsp; &nbsp; Remove serialization between HostStateThread and HostInfoDialogVector.<br><li><b>Astor-5.2.0 -  18/04/09:</b><br>&nbsp; &nbsp; &nbsp; Tango-7 tools accessible.<br>&nbsp; &nbsp; &nbsp; Device dependencies (sub-devices) tool added.<br>&nbsp; &nbsp; &nbsp; MySqlUtil feature added.<br><li><b>Astor-5.1.3 -  30/01/09:</b><br>&nbsp; &nbsp; &nbsp; Black box management added for database.<br>&nbsp; &nbsp; &nbsp; Black box management tool improved.<br>&nbsp; &nbsp; &nbsp; Find TANGO object by filter added.<br><li><b>Astor-5.1.2 -  16/01/09:</b><br>&nbsp; &nbsp; &nbsp; Black box management added for host and Server.<br>&nbsp; &nbsp; &nbsp; Starter logging display added for host and server.<br>&nbsp; &nbsp; &nbsp; Splash screen use ATK one.<br><li><b>Astor-5.1.1 -  17/12/08:</b><br>&nbsp; &nbsp; &nbsp; Add a scroll pane in HostInfoDialog in case of too big dialog.<br><li><b>Astor-5.1.0 -  09/10/08:</b><br>&nbsp; &nbsp; &nbsp; Pool thread management added but not accessible.<br>&nbsp; &nbsp; &nbsp; New version and tests for access.<br><li><b>Astor-5.0.5 -  12/09/08:</b><br>&nbsp; &nbsp; &nbsp; Bug in server info (if not running) fixed.<br><li><b>Astor-5.0.4 -  16/06/08:</b><br>&nbsp; &nbsp; &nbsp; Level trees are now displayed on 2 rows.<br><li><b>Astor-5.0.3 -  22/05/08:</b><br>&nbsp; &nbsp; &nbsp; Host info dialog servers are managed in a jtree.<br><li><b>Astor-5.0.2 -  07/05/08:</b><br>&nbsp; &nbsp; &nbsp; Host info dialog line management changed.<br>&nbsp; &nbsp; &nbsp; Browse Database option added in DB popup menu.<br><li><b>Astor-5.0.1 -  10/04/08:</b><br>&nbsp; &nbsp; &nbsp; Branch info modified.<br>&nbsp; &nbsp; &nbsp; Table of hosts and servers added.<br><li><b>Astor-5.0.0 -  27/03/08:</b><br>&nbsp; &nbsp; &nbsp; Compatibility with Starter 4.0 and after only !<br>&nbsp; &nbsp; &nbsp; Better management of server list.<br>&nbsp; &nbsp; &nbsp; Server state MOVING managed.<br>&nbsp; &nbsp; &nbsp; Hard kill added on servers.<br>&nbsp; &nbsp; &nbsp; New features on polling profiler.<br><li><b>Astor-4.5.7 -  12/12/07:</b><br>&nbsp; &nbsp; &nbsp; Reset buttons added in event configuration panel.<br><li><b>Astor-4.5.6 -  07/11/07:</b><br>&nbsp; &nbsp; &nbsp; Display host info if OSManage DS  is running on host.<br>&nbsp; &nbsp; &nbsp; Display host's state on HotInfoDialog.<br><li><b>Astor-4.5.5 -  11/09/07:</b><br>&nbsp; &nbsp; &nbsp; Db attribute polling panel added.<br>&nbsp; &nbsp; &nbsp; Bug on repeate error window when refresh tree fixed.<br><li><b>Astor-4.5.4  -  04/09/07:</b><br>&nbsp; &nbsp; &nbsp; Set attribute polled names in lower case in new starter creation.<br><li><b>Astor-4.5.3  -  20/08/07:</b><br>&nbsp; &nbsp; &nbsp; ServStatePanel added on HostInfoDialog (Check states option).<br><li><b>Astor-4.5.2  -  27/04/07:</b><br>&nbsp; &nbsp; &nbsp; Display host panel available for stopped server from Device Browser.<br><li><b>Astor-4.5.1  -  04/04/07:</b><br>&nbsp; &nbsp; &nbsp; Database attribute properties editor added.<br><li><b>Astor-4.5.0  -  27/03/07:</b><br>&nbsp; &nbsp; &nbsp; Preferences dialog added.<br><li><b>Astor-4.4.4  -  08/03/07:</b><br>&nbsp; &nbsp; &nbsp; LastCollections property is managed.<br><li><b>Astor-4.4.3  -  22/01/07:</b><br>&nbsp; &nbsp; &nbsp; Remove watch dog on host thread.<br><li><b>Astor-4.4.2  -  17/01/07:</b><br>&nbsp; &nbsp; &nbsp; Html helps added.<br>&nbsp; &nbsp; &nbsp; Startup error message added in view menu.<br><li><b>Astor-4.4.1  -  08/01/07:</b><br>&nbsp; &nbsp; &nbsp; Disable Start Server button if Starter is MOVING.<br><li><b>Astor-4.4.0  -  25/09/06:</b><br>&nbsp; &nbsp; &nbsp; Access control tool added.<br><li><b>Astor-4.3.2:</b><br>&nbsp; &nbsp; &nbsp; Bug fixed in miscellaneous host collection.<br><li><b>Astor-4.3.1:</b><br>&nbsp; &nbsp; &nbsp; Moving state added for collection.<br>&nbsp; &nbsp; &nbsp; In StartAll command a sleep(500) has been added between two hosts.<br><li><b>Astor-4.3.0:</b><br>&nbsp; &nbsp; &nbsp; Moving state added for startup phase.<br><li><b>Astor-4.2.3:</b><br>&nbsp; &nbsp; &nbsp; Host info panel modified to use icons.<br><li><b>Astor-4.2.2:</b><br>&nbsp; &nbsp; &nbsp; Backward compatibilty for jive fixed.<br><li><b>Astor-4.2.1:</b><br>&nbsp; &nbsp; &nbsp; Icons have been changed.<br>&nbsp; &nbsp; &nbsp; Some minor changes.<br><li><b>Astor-4.2.0:</b><br>&nbsp; &nbsp; &nbsp; Polling profiler added.<br><li><b>Astor-4.1.4:</b><br>&nbsp; &nbsp; &nbsp; Open/Save menu added on event tester window.<br><li><b>Astor-4.1.3:</b><br>&nbsp; &nbsp; &nbsp; History added on event management.<br>&nbsp; &nbsp; &nbsp; The maximum servers displayed in horizontal on HostInfoDialog window has been set to 5.<br><li><b>Astor-4.1.2:</b><br>&nbsp; &nbsp; &nbsp; Bug fixed in Device browser in member device name.<br><li><b>Astor-4.1.1:</b><br>&nbsp; &nbsp; &nbsp; Change TANGO_HOST added (needs TangORB-4.7.7 or later).<br><li><b>Astor-4.1.0:</b><br>&nbsp; &nbsp; &nbsp; DevBrowser and MkStarter utilities added.<br><li><b>Astor-4.0.9:</b><br>&nbsp; &nbsp; &nbsp; Minor changes for EventTester compatibility<br><li><b>Astor-4.0.8:</b><br>&nbsp; &nbsp; &nbsp; Screen position modified for dialogs.<br><li><b>Astor-4.0.7:</b><br>&nbsp; &nbsp; &nbsp; Search if host already exist before creation.<br><li><b>Astor-4.0.6:</b><br>&nbsp; &nbsp; &nbsp; Search by host name added.<br><li><b>Astor-4.0.5:</b><br>&nbsp; &nbsp; &nbsp; Can change memorized attribute value.<br><li><b>Astor-4.0.4:</b><br>&nbsp; &nbsp; &nbsp; Bug in server architecture fixed.<br><li><b>Astor-4.0.3:</b><br>&nbsp; &nbsp; &nbsp; Minor changes, RemoteCmd property added.<br><li><b>Astor-4.0.2:</b><br>&nbsp; &nbsp; &nbsp; Server architecture display addded.<br><li><b>Astor-4.0.1:</b><br>&nbsp; &nbsp; &nbsp; DevWizard calls addded.<br><li><b>Astor-4.0.0:</b><br>&nbsp; &nbsp; &nbsp; Possibility to controle two database servers added.<br></body>\n</html>\n");
        } else if (jMenuItem == this.tangorbBtn) {
            this.displayTangORBversion();
        } else if (jMenuItem == this.aboutBtn) {
            this.displayAboutAstor();
        } else if (jMenuItem == this.starterEventsItem) {
            this.displaySubscribedHostList(true);
        } else if (jMenuItem == this.starterNoEventsItem) {
            this.displaySubscribedHostList(false);
        } else {
            Utils.popupMessage(this, "Not implemented yet !");
        }
    }

    private void displayTangORBversion() {
        Object object;
        String string;
        int n = 400;
        int n2 = 200;
        if (jarUsed == 0) {
            string = JTangoVersion.getInstance().toString();
            object = JTangoVersion.getInstance().getJarFileName();
            int n3 = ((String)object).length() * 9;
            if (n3 > n) {
                n = n3;
            }
        } else {
            try {
                object = new TangORBversion();
            }
            catch (Exception exception) {
                ErrorPane.showErrorMessage((Component)this, (String)"Cannot check TangORB revision", (Exception)exception);
                return;
            }
            string = ((TangORBversion)object).jarfile + ":\n\n" + object;
        }
        object = new PopupText((Frame)this, true);
        ((PopupText)object).setFont(new Font("Courier", 1, 14));
        ((PopupText)object).show(string, n, n2);
        AstorUtil.centerDialog((JDialog)object, this);
    }

    private void displayAboutAstor() {
        String string = "           Astor  (Tango Manager) \n\nThis programme is used to control, start and stop\n           the TANGO device servers. \n\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF";
        Utils.popupMessage(this, string, "TangoClass.gif");
    }

    /*
     * WARNING - void declaration
     */
    private void displaySubscribedHostList(boolean bl) {
        void var3_7;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TangoHost tangoHost : this.tree.hosts) {
            if (bl) {
                if (!tangoHost.onEvents) continue;
                arrayList.add(tangoHost.getName() + " " + tangoHost.eventSource);
                continue;
            }
            if (tangoHost.onEvents) continue;
            arrayList.add(tangoHost.getName());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (arrayList.size() == 0) {
            String string = "There is no host controlled " + TangoHost.controlMethod(bl);
        } else if (arrayList.size() == this.tree.hosts.length) {
            String string = "All hosts are controlled " + TangoHost.controlMethod(bl);
        } else {
            String string = "On " + this.tree.hosts.length + " hosts,\n" + arrayList.size() + "  are controlled " + TangoHost.controlMethod(bl);
            for (String string2 : arrayList) {
                stringBuilder.append(string2).append('\n');
            }
        }
        if (stringBuilder.length() == 0) {
            Utils.popupMessage(this, (String)var3_7);
        } else {
            PopupText popupText = new PopupText((Frame)this, true);
            popupText.setTitle((String)var3_7);
            popupText.addText(stringBuilder.toString());
            popupText.setSize(360, 400);
            popupText.setVisible(true);
        }
    }

    private void expandBtnActionPerformed(ActionEvent actionEvent) {
        this.expanded = !this.expanded;
        this.tree.expand(this.expanded);
        if (this.expanded) {
            this.expandBtn.setText("Collapse Tree");
        } else {
            this.expandBtn.setText("Expand Tree");
        }
    }

    private void deviceBrowserBtnActionPerformed(ActionEvent actionEvent) {
        if (devBrowser == null) {
            devBrowser = new DevBrowser(this);
        }
        devBrowser.setVisible(true);
    }

    private void refreshBtnActionPerformed(ActionEvent actionEvent) {
        try {
            this.buildTree();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        this.doExit();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.doExit();
    }

    private void findObjectByFilterItemActionPerformed(ActionEvent actionEvent) {
        if (this.wide_search_dlg == null) {
            this.wide_search_dlg = new WideSearchDialog(this);
        }
        this.wide_search_dlg.setVisible(true);
    }

    private void multiServersCmdItemActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.multiServerCommand == null) {
                this.multiServerCommand = new MultiServerCommand(this);
            }
            this.multiServerCommand.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void statisticsBtnActionPerformed(ActionEvent actionEvent) {
        StatisticsPanel statisticsPanel = new StatisticsPanel(this);
        statisticsPanel.readAndDisplayStatistics(null);
        statisticsPanel.setVisible(true);
    }

    private void serverUsageMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            new ServerUsageDialog(this).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void faultyListItemhelpActionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TangoHost tangoHost : this.tree.hosts) {
            if (tangoHost.state != 1) continue;
            stringBuilder.append(tangoHost.getName()).append('\n');
        }
        PopupText popupText = new PopupText((Frame)this, true);
        popupText.setTitle("Faulty host list");
        popupText.addText(stringBuilder.toString());
        popupText.setSize(360, 400);
        popupText.setVisible(true);
    }

    private void stopThreads() {
        System.out.println("Astor exiting....");
        if (this.tree != null && this.tree.hosts != null) {
            for (TangoHost tangoHost : this.tree.hosts) {
                tangoHost.stopThread();
                if (!tangoHost.onEvents) continue;
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        System.out.println(" ");
    }

    public void doExit() {
        if (devBrowser != null && devBrowser.isVisible()) {
            this.setVisible(false);
        } else {
            this.setVisible(false);
            this.stopThreads();
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            switch (stringArray[0]) {
                case "-ro": {
                    System.out.println("Astor is in READ_ONLY mode !!!");
                    rwMode = 2;
                    break;
                }
                case "-db_ro": {
                    System.out.println("Astor is in DB_READ_ONLY mode !!!");
                    rwMode = 1;
                    break;
                }
                case "-rw": {
                    System.out.println("Astor is in READ_WRITE mode !!!");
                    rwMode = 0;
                    break;
                }
                default: {
                    try {
                        new AstorCmdLine(stringArray);
                    }
                    catch (DevFailed devFailed) {
                        Except.print_exception((Exception)((Object)devFailed));
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        exception.printStackTrace();
                    }
                    System.exit(0);
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                try {
                    Astor astor = new Astor();
                    astor.setVisible(true);
                }
                catch (DevFailed devFailed) {
                    System.err.println(devFailed.errors[0].desc);
                    if (devFailed.errors[0].desc.indexOf("Controlled access service defined in Db but unreachable") > 0) {
                        devFailed.errors[0].desc = "Controlled access service defined in Db but unreachable\nAstor cannot be configured from database !";
                    }
                    ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
                    System.exit(-1);
                }
                catch (HeadlessException | InternalError throwable) {
                    System.err.println(throwable.getMessage());
                }
                long l2 = System.currentTimeMillis();
                System.out.println("Build  GUI :" + (l2 - l) + " ms");
            }
        });
    }

    static {
        rwMode = 0;
        searched_host = "";
    }

    private class HostsScanThread
    extends Thread {
        private JFrame parent;
        private TangoHost[] hosts;

        HostsScanThread(JFrame jFrame, TangoHost[] tangoHostArray) {
            this.parent = jFrame;
            this.hosts = tangoHostArray;
        }

        @Override
        public void run() {
            String[][] stringArray = new String[this.hosts.length][];
            String string = "Scanning hosts...";
            Monitor monitor = new Monitor(this.parent, string);
            double d = 0.01;
            monitor.setProgressValue(d, "Starting...");
            try {
                HostsScanThread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                String[] stringArray2;
                int n = 0;
                for (int i = 0; i < this.hosts.length; ++i) {
                    d = (1.0 + 1.0 * (double)i) / (double)this.hosts.length;
                    monitor.setProgressValue(d, "Reading " + this.hosts[i].getName());
                    stringArray2 = this.hosts[i].getServerAttribute();
                    stringArray[i] = new String[2];
                    stringArray[i][0] = this.hosts[i].getName();
                    stringArray[i][1] = "" + stringArray2.length;
                    n += stringArray2.length;
                }
                String string2 = n + " servers   on " + this.hosts.length + " hosts";
                stringArray2 = new String[]{"Names", "Nb Servers"};
                PopupTable popupTable = new PopupTable(this.parent, string2, stringArray2, stringArray);
                popupTable.setColumnWidth(new int[]{200, 100});
                popupTable.setVisible(true);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"", (DevFailed)devFailed);
            }
        }
    }
}

