/*PROTECTED REGION ID(Starter::main.cpp) ENABLED START*/
static const char *RcsId = "$Id: main.cpp 28168 2015-06-30 07:27:09Z pascal_verdier $";
//=============================================================================
//
// file :        main.cpp
//
// description :  C++ source for a TANGO device server main.
//               The main rule is to initialise (and create) the Tango
//               system and to create the DServerClass singleton.
//               The main should be the same for every Tango device server.
//
// project :     Starter for Tango Administration.
//
// $Author: pascal_verdier $
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision: 28168 $
// $Date: 2015-06-30 09:27:09 +0200 (Tue, 30 Jun 2015) $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <tango.h>
#ifdef _TG_WINDOWS_
//#define USE_SERVICE
#endif

#ifndef _TG_WINDOWS_
#	include <signal.h>
#endif


#include <string.h>
#include <Starter.h>


#ifdef USE_SERVICE
#include <StarterService.h>
using namespace std;
#endif

#ifdef _TG_WINDOWS__DBG
#include	"Stackwalker.h"
#endif

int main(int argc,char *argv[])
{
	//	First time set SIGINT to default to do not block
	//	signal handling for child proceeses
	//---------------------------------------------------
#ifndef _TG_WINDOWS_
	//sigset(SIGINT, SIG_DFL);
	struct sigaction sa;
	
	sa.sa_flags = 0;
	sa.sa_handler = SIG_DFL;
	sigemptyset(&sa.sa_mask);
	
	if (sigaction(SIGINT,&sa,NULL) == -1)
		cerr << "Starter main() --> Can't reset default action for SIGINT to SIG_DFL" << endl;
#endif
	//	Check for hostname
	//---------------------------------
	if (argc>1)
	{
		char *p;
		for (p=argv[1] ; *p ; p++)
			if (*p=='.')
				*p = '\0';	//	Take off extention (eg:.esrf.fr)
	}

	//	Set an automatic retry on database connection
	//---------------------------------------------------
	Tango::Util::_daemon = true;
	Tango::Util::_sleep_between_connect = 5;

#ifdef USE_SERVICE

	StarterService	service(argv[0]);
	int	ret;

	if ((ret=service.options(argc, argv))<=0)
		return ret;
	service.run(argc, argv);
	return 0;

#else

	try
	{
		// Initialise the device server
		//----------------------------------------
		Tango::Util *tg = Tango::Util::init(argc,argv);

		// Create the device server singleton 
		//	which will create everything
		//----------------------------------------
		tg->server_init();
		cout << "Ready to accept request" << endl;

		// Run the endless loop
		//----------------------------------------
#ifdef WIN32_DBG
  InitAllocCheck(ACOutput_XML);
#endif
		tg->server_run();
	}
	catch (bad_alloc)
	{
		cerr << "Can't allocate memory to store device object !!!" << endl;
		cerr << "Exiting" << endl;
	}
	catch (CORBA::Exception &e)
	{
		Tango::Except::print_exception(e);
		
		cerr << "Received a CORBA_Exception" << endl;
		cerr << "Exiting" << endl;
	}
	Tango::Util::instance()->server_cleanup();
#ifdef WIN32_DBG
  DeInitAllocCheck();
#endif
	return(0);
#endif
}


/*PROTECTED REGION END*/	//	Starter::main.cpp
