/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Variable;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.ImageCalculator;
import ij.plugin.JpegWriter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Info;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.process.FloodFiller;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.StringSorter;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class Functions
implements MacroConstants,
Measurements {
    Interpreter interp;
    Program pgm;
    boolean updateNeeded;
    boolean autoUpdate = true;
    ImagePlus defaultImp;
    ImageProcessor defaultIP;
    int imageType;
    boolean colorSet;
    boolean fontSet;
    Color defaultColor;
    double defaultValue = Double.NaN;
    Plot plot;
    static int plotID;
    int justification = 0;
    Font font;
    GenericDialog gd;
    PrintWriter writer;
    boolean altKeyDown;
    boolean shiftKeyDown;
    boolean antialiasedText;
    StringBuffer buffer;
    boolean saveSettingsCalled;
    boolean usePointerCursor;
    boolean hideProcessStackDialog;
    float divideByZeroValue;
    int jpegQuality;
    int lineWidth;
    boolean doScaling;
    boolean weightedColor;
    double[] weights;
    boolean interpolateScaledImages;
    boolean open100Percent;
    boolean blackCanvas;
    boolean useJFileChooser;
    boolean debugMode;
    Color foregroundColor;
    Color backgroundColor;
    Color roiColor;
    boolean pointAutoMeasure;
    boolean requireControlKey;
    boolean useInvertingLut;
    boolean doubleBuffer;
    boolean disablePopup;
    int measurements;
    int decimalPlaces;
    boolean blackBackground;
    Random ran;

    Functions(Interpreter interp, Program pgm) {
        this.interp = interp;
        this.pgm = pgm;
    }

    void doFunction(int type) {
        switch (type) {
            case 300: {
                this.doRun();
                break;
            }
            case 302: {
                IJ.selectWindow(this.getStringArg());
                this.resetImage();
                break;
            }
            case 303: {
                IJ.wait((int)this.getArg());
                break;
            }
            case 304: {
                this.interp.getParens();
                IJ.beep();
                break;
            }
            case 305: {
                this.interp.getParens();
                IJ.resetMinAndMax();
                this.resetImage();
                break;
            }
            case 306: {
                this.interp.getParens();
                IJ.resetThreshold();
                this.resetImage();
                break;
            }
            case 307: {
                this.print();
                break;
            }
            case 308: {
                IJ.write(this.getStringArg());
                break;
            }
            case 309: {
                IJ.doWand((int)this.getFirstArg(), (int)this.getLastArg());
                this.resetImage();
                break;
            }
            case 310: {
                IJ.setMinAndMax(this.getFirstArg(), this.getLastArg());
                this.resetImage();
                break;
            }
            case 311: {
                this.setThreshold();
                break;
            }
            case 312: {
                IJ.setTool((int)this.getArg());
                break;
            }
            case 313: {
                this.setForegroundColor();
                break;
            }
            case 314: {
                this.setBackgroundColor();
                break;
            }
            case 336: {
                this.setColor();
                break;
            }
            case 315: {
                this.makeLine();
                break;
            }
            case 316: {
                this.makeOval();
                break;
            }
            case 317: {
                this.makeRectangle();
                break;
            }
            case 318: {
                this.interp.dump();
                break;
            }
            case 320: {
                this.lineTo();
                break;
            }
            case 319: {
                this.moveTo();
                break;
            }
            case 321: {
                this.drawLine();
                break;
            }
            case 322: {
                this.requires();
                break;
            }
            case 323: {
                this.autoUpdate = this.getBooleanArg();
                break;
            }
            case 324: {
                this.interp.getParens();
                this.updateDisplay();
                break;
            }
            case 325: {
                this.drawString();
                break;
            }
            case 326: {
                IJ.setPasteMode(this.getStringArg());
                break;
            }
            case 327: {
                this.doCommand();
                break;
            }
            case 328: {
                IJ.showStatus(this.getStringArg());
                this.interp.statusUpdated = true;
                break;
            }
            case 329: {
                this.showProgress();
                break;
            }
            case 330: {
                this.showMessage(false);
                break;
            }
            case 351: {
                this.showMessage(true);
                break;
            }
            case 331: 
            case 332: {
                this.setPixel();
                break;
            }
            case 333: 
            case 334: 
            case 335: {
                this.doIPMethod(type);
                break;
            }
            case 337: {
                this.getProcessor().setLineWidth((int)this.getArg());
                break;
            }
            case 338: {
                this.changeValues();
                break;
            }
            case 339: {
                this.selectImage();
                break;
            }
            case 340: {
                this.exit();
                break;
            }
            case 341: {
                this.setLocation();
                break;
            }
            case 342: {
                this.getCursorLoc();
                break;
            }
            case 343: {
                this.getLine();
                break;
            }
            case 344: {
                this.getVoxelSize();
                break;
            }
            case 345: {
                this.getHistogram();
                break;
            }
            case 347: 
            case 375: {
                this.getBounds();
                break;
            }
            case 348: {
                this.getLut();
                break;
            }
            case 349: {
                this.setLut();
                break;
            }
            case 350: {
                this.getCoordinates();
                break;
            }
            case 352: {
                this.makeSelection();
                break;
            }
            case 353: {
                this.setResult();
                break;
            }
            case 354: {
                this.updateResults();
                break;
            }
            case 355: {
                this.setBatchMode();
                break;
            }
            case 356: {
                this.doPlot();
                break;
            }
            case 357: {
                this.setJustification();
                break;
            }
            case 358: {
                this.setZCoordinate();
                break;
            }
            case 359: {
                this.getThreshold();
                break;
            }
            case 360: {
                this.getPixelSize();
                break;
            }
            case 361: {
                this.interp.getParens();
                Undo.setup(6, this.getImage());
                break;
            }
            case 362: {
                this.saveSettings();
                break;
            }
            case 363: {
                this.restoreSettings();
                break;
            }
            case 364: {
                this.setKeyDown();
                break;
            }
            case 365: {
                this.open();
                break;
            }
            case 366: {
                this.setFont();
                break;
            }
            case 367: {
                this.getMinAndMax();
                break;
            }
            case 368: {
                this.close();
                break;
            }
            case 369: {
                this.setSlice();
                break;
            }
            case 370: {
                this.newImage();
                break;
            }
            case 372: {
                IJ.save(this.getStringArg());
                break;
            }
            case 371: {
                this.saveAs();
                break;
            }
            case 373: {
                this.setAutoThreshold();
                break;
            }
            case 374: {
                this.resetImage();
                this.getImage().setTitle(this.getStringArg());
                break;
            }
            case 346: {
                this.getStatistics(true);
                break;
            }
            case 377: {
                this.getStatistics(false);
                break;
            }
            case 378: {
                this.floodFill();
                break;
            }
            case 379: {
                this.restorePreviousTool();
                break;
            }
            case 380: {
                this.setVoxelSize();
                break;
            }
            case 381: {
                this.getLocationAndSize();
                break;
            }
            case 382: {
                this.getDateAndTime();
                break;
            }
            case 383: {
                this.setMetadata();
                break;
            }
            case 384: {
                this.imageCalculator();
                break;
            }
            case 385: {
                this.setRGBWeights();
                break;
            }
            case 386: {
                this.makePolygon();
                break;
            }
            case 387: {
                this.setSelectionName();
                break;
            }
            case 376: 
            case 388: 
            case 389: 
            case 390: {
                this.drawOrFill(type);
                break;
            }
            case 391: {
                this.setOption();
                break;
            }
            case 392: {
                this.showText();
                break;
            }
            case 393: {
                this.setSelectionLocation();
                break;
            }
            case 394: {
                this.getDimensions();
            }
        }
    }

    final double getFunctionValue(int type) {
        double value = 0.0;
        switch (type) {
            case 1000: {
                value = this.getPixel();
                break;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1027: 
            case 1046: 
            case 1047: {
                value = this.math(type);
                break;
            }
            case 1006: 
            case 1007: 
            case 1008: 
            case 1036: {
                value = this.math2(type);
                break;
            }
            case 1013: {
                this.interp.getParens();
                value = System.currentTimeMillis();
                break;
            }
            case 1014: {
                this.interp.getParens();
                value = this.getImage().getWidth();
                break;
            }
            case 1015: {
                this.interp.getParens();
                value = this.getImage().getHeight();
                break;
            }
            case 1016: {
                value = this.random();
                break;
            }
            case 1018: 
            case 1023: {
                value = this.getResultsCount();
                break;
            }
            case 1017: {
                value = this.getResult();
                break;
            }
            case 1019: {
                value = this.getNumber();
                break;
            }
            case 1020: {
                value = this.getImageCount();
                break;
            }
            case 1021: {
                value = this.getStackSize();
                break;
            }
            case 1022: {
                value = this.lengthOf();
                break;
            }
            case 1024: {
                this.interp.getParens();
                this.resetImage();
                value = this.getImage().getID();
                break;
            }
            case 1025: {
                this.interp.getParens();
                value = this.getImage().getBitDepth();
                break;
            }
            case 1026: {
                value = this.getSelectionType();
                break;
            }
            case 1028: {
                value = this.isOpen();
                break;
            }
            case 1029: {
                value = this.isActive();
                break;
            }
            case 1030: {
                value = this.indexOf();
                break;
            }
            case 1031: {
                value = this.getFirstString().lastIndexOf(this.getLastString());
                break;
            }
            case 1032: {
                value = this.getFirstString().charAt((int)this.getLastArg());
                break;
            }
            case 1033: {
                value = this.getBoolean();
                break;
            }
            case 1034: 
            case 1035: {
                value = this.startsWithEndsWith(type);
                break;
            }
            case 1037: {
                value = Double.isNaN(this.getArg()) ? 1.0 : 0.0;
                break;
            }
            case 1038: {
                value = this.getZoom();
                break;
            }
            case 1040: {
                value = this.parseDouble(this.getStringArg());
                break;
            }
            case 1039: {
                value = this.parseInt();
                break;
            }
            case 1041: {
                value = this.isKeyDown();
                break;
            }
            case 1042: {
                this.interp.getParens();
                value = this.getImage().getCurrentSlice();
                break;
            }
            case 1043: 
            case 1044: {
                value = this.getScreenDimension(type);
                break;
            }
            case 1045: {
                value = this.getImage().getCalibration().getCValue(this.getArg());
                break;
            }
            case 1048: {
                value = this.roiManager();
                break;
            }
            case 1049: {
                this.interp.getParens();
                value = Toolbar.getToolId();
                break;
            }
            case 1050: {
                value = this.is();
                break;
            }
            default: {
                this.interp.error("Numeric function expected");
            }
        }
        return value;
    }

    String getStringFunction(int type) {
        String str;
        switch (type) {
            case 2000: {
                str = this.d2s();
                break;
            }
            case 2001: {
                str = this.toString(16);
                break;
            }
            case 2002: {
                str = this.toString(2);
                break;
            }
            case 2003: {
                this.interp.getParens();
                this.resetImage();
                str = this.getImage().getTitle();
                break;
            }
            case 2004: {
                str = this.getStringDialog();
                break;
            }
            case 2005: {
                str = this.substring();
                break;
            }
            case 2006: {
                str = this.fromCharCode();
                break;
            }
            case 2007: {
                str = this.getInfo();
                break;
            }
            case 2010: {
                this.interp.getParens();
                str = this.getImageInfo();
                break;
            }
            case 2008: {
                str = this.getDirectory();
                break;
            }
            case 2009: {
                this.interp.getParens();
                str = this.interp.argument != null ? this.interp.argument : "";
                break;
            }
            case 2011: {
                str = this.getStringArg().toLowerCase(Locale.US);
                break;
            }
            case 2012: {
                str = this.getStringArg().toUpperCase(Locale.US);
                break;
            }
            case 2013: {
                str = this.runMacro(false);
                break;
            }
            case 2014: {
                str = this.runMacro(true);
                break;
            }
            case 2015: {
                str = this.getStringArg();
                break;
            }
            case 2016: {
                str = this.replace();
                break;
            }
            case 2017: {
                str = this.doDialog();
                break;
            }
            case 2018: {
                str = this.getMetadata();
                break;
            }
            case 2019: {
                str = this.doFile();
                break;
            }
            case 2020: {
                str = this.selectionName();
                break;
            }
            case 2021: {
                this.interp.getParens();
                str = IJ.getVersion();
                break;
            }
            case 2022: {
                str = this.getResultLabel();
                break;
            }
            case 2023: {
                str = this.call();
                break;
            }
            case 2024: {
                str = this.doString();
                break;
            }
            default: {
                str = "";
                this.interp.error("String function expected");
            }
        }
        return str;
    }

    Variable[] getArrayFunction(int type) {
        Variable[] array;
        switch (type) {
            case 3000: {
                array = this.getProfile();
                break;
            }
            case 3001: {
                array = this.newArray();
                break;
            }
            case 3002: {
                array = this.split();
                break;
            }
            case 3003: {
                array = this.getFileList();
                break;
            }
            case 3004: {
                array = this.getFontList();
                break;
            }
            case 3005: {
                array = this.newMenu();
                break;
            }
            case 3006: {
                array = this.getList();
                break;
            }
            default: {
                array = null;
                this.interp.error("Array function expected");
            }
        }
        return array;
    }

    final double math(int type) {
        double arg = this.getArg();
        switch (type) {
            case 1001: {
                return Math.abs(arg);
            }
            case 1002: {
                return Math.cos(arg);
            }
            case 1003: {
                return Math.exp(arg);
            }
            case 1004: {
                return Math.floor(arg);
            }
            case 1005: {
                return Math.log(arg);
            }
            case 1009: {
                return Math.round(arg);
            }
            case 1010: {
                return Math.sin(arg);
            }
            case 1011: {
                return Math.sqrt(arg);
            }
            case 1012: {
                return Math.tan(arg);
            }
            case 1027: {
                return Math.atan(arg);
            }
            case 1046: {
                return Math.asin(arg);
            }
            case 1047: {
                return Math.acos(arg);
            }
        }
        return 0.0;
    }

    final double math2(int type) {
        double a1 = this.getFirstArg();
        double a2 = this.getLastArg();
        switch (type) {
            case 1007: {
                return Math.min(a1, a2);
            }
            case 1006: {
                return Math.max(a1, a2);
            }
            case 1008: {
                return Math.pow(a1, a2);
            }
            case 1036: {
                return Math.atan2(a1, a2);
            }
        }
        return 0.0;
    }

    final String getString() {
        String str = this.interp.getStringTerm();
        while (true) {
            this.interp.getToken();
            if (this.interp.token != 43) break;
            str = str + this.interp.getStringTerm();
        }
        this.interp.putTokenBack();
        return str;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.interp.tokenAddress];
        return symbol.type == 2000;
    }

    final double getArg() {
        this.interp.getLeftParen();
        double arg = this.interp.getExpression();
        this.interp.getRightParen();
        return arg;
    }

    final double getFirstArg() {
        this.interp.getLeftParen();
        return this.interp.getExpression();
    }

    final double getNextArg() {
        this.interp.getComma();
        return this.interp.getExpression();
    }

    final double getLastArg() {
        this.interp.getComma();
        double arg = this.interp.getExpression();
        this.interp.getRightParen();
        return arg;
    }

    String getStringArg() {
        this.interp.getLeftParen();
        String arg = this.getString();
        this.interp.getRightParen();
        return arg;
    }

    final String getFirstString() {
        this.interp.getLeftParen();
        return this.getString();
    }

    final String getNextString() {
        this.interp.getComma();
        return this.getString();
    }

    final String getLastString() {
        this.interp.getComma();
        String arg = this.getString();
        this.interp.getRightParen();
        return arg;
    }

    boolean getBooleanArg() {
        this.interp.getLeftParen();
        double arg = this.interp.getBooleanExpression();
        this.interp.checkBoolean(arg);
        this.interp.getRightParen();
        return arg != 0.0;
    }

    final Variable getFirstVariable() {
        this.interp.getLeftParen();
        return this.getVariable();
    }

    final Variable getNextVariable() {
        this.interp.getComma();
        return this.getVariable();
    }

    final Variable getLastVariable() {
        this.interp.getComma();
        Variable v = this.getVariable();
        this.interp.getRightParen();
        return v;
    }

    final Variable getVariable() {
        Variable[] array;
        Variable v;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((v = this.interp.lookupLocalVariable(this.interp.tokenAddress)) == null) {
            v = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        if ((array = v.getArray()) != null) {
            int index = this.interp.getIndex();
            this.checkIndex(index, 0, array.length - 1);
            v = array[index];
        }
        return v;
    }

    final Variable getFirstArrayVariable() {
        this.interp.getLeftParen();
        return this.getArrayVariable();
    }

    final Variable getNextArrayVariable() {
        this.interp.getComma();
        return this.getArrayVariable();
    }

    final Variable getLastArrayVariable() {
        this.interp.getComma();
        Variable v = this.getArrayVariable();
        this.interp.getRightParen();
        return v;
    }

    final Variable getArrayVariable() {
        Variable v;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((v = this.interp.lookupLocalVariable(this.interp.tokenAddress)) == null) {
            v = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        return v;
    }

    final double[] getFirstArray() {
        this.interp.getLeftParen();
        return this.getNumericArray();
    }

    final double[] getNextArray() {
        this.interp.getComma();
        return this.getNumericArray();
    }

    final double[] getLastArray() {
        this.interp.getComma();
        double[] a = this.getNumericArray();
        this.interp.getRightParen();
        return a;
    }

    double[] getNumericArray() {
        Variable[] a1 = this.getArray();
        double[] a2 = new double[a1.length];
        for (int i = 0; i < a1.length; ++i) {
            a2[i] = a1[i].getValue();
        }
        return a2;
    }

    String[] getStringArray() {
        Variable[] a1 = this.getArray();
        String[] a2 = new String[a1.length];
        for (int i = 0; i < a1.length; ++i) {
            String s = a1[i].getString();
            if (s == null) {
                s = "" + a1[i].getValue();
            }
            a2[i] = s;
        }
        return a2;
    }

    Variable[] getArray() {
        Variable[] a;
        boolean newArray;
        this.interp.getToken();
        boolean bl = newArray = this.interp.token == 137 && this.pgm.table[this.interp.tokenAddress].type == 3001;
        if (this.interp.token != 129 && !newArray) {
            this.interp.error("Array expected");
        }
        if (newArray) {
            a = this.getArrayFunction(3001);
        } else {
            Variable v = this.interp.lookupVariable();
            a = v.getArray();
        }
        if (a == null) {
            this.interp.error("Array expected");
        }
        return a;
    }

    Color getColor() {
        String color = this.getString();
        if ((color = color.toLowerCase(Locale.US)).equals("black")) {
            return Color.black;
        }
        if (color.equals("white")) {
            return Color.white;
        }
        if (color.equals("red")) {
            return Color.red;
        }
        if (color.equals("green")) {
            return Color.green;
        }
        if (color.equals("blue")) {
            return Color.blue;
        }
        if (color.equals("cyan")) {
            return Color.cyan;
        }
        if (color.equals("darkgray")) {
            return Color.darkGray;
        }
        if (color.equals("gray")) {
            return Color.gray;
        }
        if (color.equals("lightgray")) {
            return Color.lightGray;
        }
        if (color.equals("magenta")) {
            return Color.magenta;
        }
        if (color.equals("orange")) {
            return Color.orange;
        }
        if (color.equals("yellow")) {
            return Color.yellow;
        }
        if (color.equals("pink")) {
            return Color.pink;
        }
        this.interp.error("'red', 'green', etc. expected");
        return null;
    }

    void checkIndex(int index, int lower, int upper) {
        if (index < lower || index > upper) {
            this.interp.error("Index (" + index + ") is outside of the " + lower + "-" + upper + " range");
        }
    }

    void doRun() {
        this.interp.getLeftParen();
        String arg1 = this.getString();
        this.interp.getToken();
        if (this.interp.token != 41 && this.interp.token != 44) {
            this.interp.error("',' or ')'  expected");
        }
        String arg2 = null;
        if (this.interp.token == 44) {
            arg2 = this.getString();
            this.interp.getRightParen();
        }
        if (arg2 != null) {
            IJ.run(arg1, arg2);
        } else {
            IJ.run(arg1);
        }
        this.resetImage();
        IJ.setKeyUp(50);
        this.altKeyDown = false;
        this.shiftKeyDown = false;
    }

    void setForegroundColor() {
        IJ.setForegroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
        this.defaultColor = null;
        this.defaultValue = Double.NaN;
    }

    void setBackgroundColor() {
        IJ.setBackgroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setColor() {
        this.colorSet = true;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            this.defaultColor = this.getColor();
            this.getProcessor().setColor(this.defaultColor);
            this.defaultValue = Double.NaN;
            this.interp.getRightParen();
            return;
        }
        double arg1 = (int)this.interp.getExpression();
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            this.setColor(arg1);
            return;
        }
        int red = (int)arg1;
        int green = (int)this.getNextArg();
        int blue = (int)this.getLastArg();
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        this.defaultColor = new Color(red, green, blue);
        this.getProcessor().setColor(this.defaultColor);
        this.defaultValue = Double.NaN;
    }

    void setColor(double value) {
        ImageProcessor ip = this.getProcessor();
        ImagePlus imp = this.getImage();
        switch (imp.getBitDepth()) {
            case 8: {
                if (value < 0.0 || value > 255.0) {
                    this.interp.error("Argument out of 8-bit range (0-255)");
                }
                ip.setValue(value);
                break;
            }
            case 16: {
                if (imp.getLocalCalibration().isSigned16Bit()) {
                    value += 32768.0;
                }
                if (value < 0.0 || value > 65535.0) {
                    this.interp.error("Argument out of 16-bit range (0-65535)");
                }
                ip.setValue(value);
                break;
            }
            default: {
                ip.setValue(value);
            }
        }
        this.defaultValue = value;
        this.defaultColor = null;
    }

    void makeLine() {
        int x1 = (int)Math.round(this.getFirstArg());
        int y1 = (int)Math.round(this.getNextArg());
        int x2 = (int)Math.round(this.getNextArg());
        this.interp.getComma();
        int y2 = (int)Math.round(this.interp.getExpression());
        this.interp.getToken();
        if (this.interp.token == 41) {
            IJ.makeLine(x1, y1, x2, y2);
        } else {
            int n;
            int max = 200;
            int[] x = new int[max];
            int[] y = new int[max];
            x[0] = x1;
            y[0] = y1;
            x[1] = x2;
            y[1] = y2;
            for (n = 2; this.interp.token == 44 && n < max; ++n) {
                x[n] = (int)Math.round(this.interp.getExpression());
                if (n == 2 && this.interp.nextToken() == 41) {
                    this.interp.getRightParen();
                    Line.setWidth(x[n]);
                    IJ.makeLine(x1, y1, x2, y2);
                    return;
                }
                this.interp.getComma();
                y[n] = (int)Math.round(this.interp.getExpression());
                this.interp.getToken();
            }
            if (n == max && this.interp.token != 41) {
                this.interp.error("More than " + max + " points");
            }
            this.getImage().setRoi(new PolygonRoi(x, y, n, 6));
        }
        this.resetImage();
    }

    void makeOval() {
        Roi previousRoi = this.getImage().getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            this.getImage().saveRoi();
        }
        IJ.makeOval((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        Roi roi = this.getImage().getRoi();
        if (previousRoi != null && roi != null) {
            this.updateRoi(roi);
        }
        this.resetImage();
    }

    void makeRectangle() {
        Roi previousRoi = this.getImage().getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            this.getImage().saveRoi();
        }
        IJ.makeRectangle((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        Roi roi = this.getImage().getRoi();
        if (previousRoi != null && roi != null) {
            this.updateRoi(roi);
        }
        this.resetImage();
    }

    ImagePlus getImage() {
        if (this.defaultImp == null) {
            this.defaultImp = IJ.getImage();
        }
        if (this.defaultImp == null) {
            this.interp.error("No image");
            return null;
        }
        if (this.defaultImp.getWindow() == null && IJ.getInstance() != null) {
            Functions functions = this;
            if (!functions.interp.isBatchMode() && WindowManager.getTempCurrentImage() == null) {
                throw new RuntimeException("Macro canceled");
            }
        }
        return this.defaultImp;
    }

    void resetImage() {
        this.defaultImp = null;
        this.defaultIP = null;
        this.fontSet = false;
        this.colorSet = false;
    }

    ImageProcessor getProcessor() {
        if (this.defaultIP == null) {
            this.defaultImp = this.getImage();
            this.defaultIP = this.defaultImp.getProcessor();
        }
        return this.defaultIP;
    }

    int getType() {
        if (this.defaultImp == null) {
            this.defaultImp = IJ.getImage();
        }
        this.imageType = this.defaultImp.getType();
        return this.imageType;
    }

    double getPixel() {
        this.interp.getLeftParen();
        int a1 = (int)this.interp.getExpression();
        this.interp.getComma();
        int a2 = (int)this.interp.getExpression();
        this.interp.getRightParen();
        double value = 0.0;
        ImageProcessor ip = this.getProcessor();
        value = this.getType() == 2 ? (double)ip.getPixelValue(a1, a2) : (double)ip.getPixel(a1, a2);
        return value;
    }

    void setZCoordinate() {
        int z = (int)this.getArg();
        ImagePlus imp = this.getImage();
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (z < 0 || z >= size) {
            this.interp.error("Z coordinate (" + z + ") is out of 0-" + (size - 1) + " range");
        }
        this.defaultIP = stack.getProcessor(z + 1);
    }

    void setPixel() {
        this.interp.getLeftParen();
        int a1 = (int)this.interp.getExpression();
        this.interp.getComma();
        int a2 = (int)this.interp.getExpression();
        this.interp.getComma();
        double a3 = this.interp.getExpression();
        this.interp.getRightParen();
        if (this.getType() == 2) {
            this.getProcessor().putPixelValue(a1, a2, a3);
        } else {
            this.getProcessor().putPixel(a1, a2, (int)a3);
        }
        this.updateNeeded = true;
    }

    void moveTo() {
        this.interp.getLeftParen();
        int a1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        this.getProcessor().moveTo(a1, a2);
    }

    void lineTo() {
        this.interp.getLeftParen();
        int a1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int a2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.lineTo(a1, a2);
        this.updateAndDraw(this.defaultImp);
    }

    void drawLine() {
        this.interp.getLeftParen();
        int x1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int y1 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int x2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int y2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.drawLine(x1, y1, x2, y2);
        this.updateAndDraw(this.defaultImp);
    }

    void setForegroundColor(ImageProcessor ip) {
        if (this.defaultColor != null) {
            ip.setColor(this.defaultColor);
        } else if (!Double.isNaN(this.defaultValue)) {
            ip.setValue(this.defaultValue);
        } else {
            ip.setColor(Toolbar.getForegroundColor());
        }
        this.colorSet = true;
    }

    void doIPMethod(int type) {
        this.interp.getParens();
        ImageProcessor ip = this.getProcessor();
        switch (type) {
            case 333: {
                ip.snapshot();
                break;
            }
            case 334: {
                ip.reset();
                this.updateNeeded = true;
                break;
            }
            case 335: {
                ImagePlus imp = this.getImage();
                Roi roi = imp.getRoi();
                if (!this.colorSet) {
                    this.setForegroundColor(ip);
                }
                if (roi == null) {
                    ip.resetRoi();
                    ip.fill();
                } else {
                    ip.setRoi(roi);
                    ip.fill(ip.getMask());
                }
                this.updateAndDraw(imp);
            }
        }
    }

    void updateAndDraw(ImagePlus imp) {
        if (this.autoUpdate) {
            imp.updateChannelAndDraw();
        } else {
            this.updateNeeded = true;
        }
    }

    void updateDisplay() {
        if (this.updateNeeded && WindowManager.getImageCount() > 0) {
            ImagePlus imp = this.getImage();
            imp.updateAndDraw();
            this.updateNeeded = false;
        }
    }

    void drawString() {
        this.interp.getLeftParen();
        String str = this.getString();
        this.interp.getComma();
        int x = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int y = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        this.setFont(ip);
        ip.setJustification(this.justification);
        ip.setAntialiasedText(this.antialiasedText);
        ip.drawString(str, x, y);
        this.updateAndDraw(this.defaultImp);
    }

    void setFont(ImageProcessor ip) {
        if (this.font != null && !this.fontSet) {
            ip.setFont(this.font);
        }
        this.fontSet = true;
    }

    void setJustification() {
        String str = this.getStringArg().toLowerCase(Locale.US);
        int just = 0;
        if (str.equals("center")) {
            just = 1;
        } else if (str.equals("right")) {
            just = 2;
        }
        this.justification = just;
    }

    void changeValues() {
        boolean isFloat;
        double darg1 = this.getFirstArg();
        double darg2 = this.getNextArg();
        double darg3 = this.getLastArg();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = this.getProcessor();
        Roi roi = imp.getRoi();
        ImageProcessor mask = null;
        if (roi == null || !roi.isArea()) {
            ip.resetRoi();
            roi = null;
        } else {
            ip.setRoi(roi);
            mask = ip.getMask();
            if (mask != null) {
                ip.snapshot();
            }
        }
        int xmin = 0;
        int ymin = 0;
        int xmax = imp.getWidth();
        int ymax = imp.getHeight();
        if (roi != null) {
            Rectangle r = roi.getBounds();
            xmin = r.x;
            ymin = r.y;
            xmax = r.x + r.width;
            ymax = r.y + r.height;
        }
        boolean bl = isFloat = this.getType() == 2;
        if (imp.getBitDepth() == 24) {
            darg1 = (int)darg1 & 0xFFFFFF;
            darg2 = (int)darg2 & 0xFFFFFF;
        }
        for (int y = ymin; y < ymax; ++y) {
            for (int x = xmin; x < xmax; ++x) {
                double v;
                double d = v = isFloat ? (double)ip.getPixelValue(x, y) : (double)(ip.getPixel(x, y) & 0xFFFFFF);
                if (!(v >= darg1) || !(v <= darg2)) continue;
                if (isFloat) {
                    ip.putPixelValue(x, y, darg3);
                    continue;
                }
                ip.putPixel(x, y, (int)darg3);
            }
        }
        if (mask != null) {
            ip.reset(mask);
        }
        if (imp.getType() == 1 || imp.getType() == 2) {
            ip.resetMinAndMax();
        }
        imp.updateAndDraw();
        this.updateNeeded = false;
    }

    void requires() {
        if (IJ.versionLessThan(this.getStringArg())) {
            this.interp.done = true;
        }
    }

    double random() {
        this.interp.getParens();
        if (this.ran == null) {
            this.ran = new Random();
        }
        return this.ran.nextDouble();
    }

    double getResult() {
        int col;
        this.interp.getLeftParen();
        String column = this.getString();
        int row = -1;
        if (this.interp.nextNonEolToken() == 44) {
            this.interp.getComma();
            row = (int)this.interp.getExpression();
        }
        this.interp.getRightParen();
        ResultsTable rt = Analyzer.getResultsTable();
        int counter = rt.getCounter();
        if (counter == 0) {
            this.interp.error("\"Results\" table empty");
        }
        if (row == -1) {
            row = counter - 1;
        }
        if (row < 0 || row >= counter) {
            this.interp.error("Row (" + row + ") out of range");
        }
        if (!rt.columnExists(col = rt.getColumnIndex(column))) {
            return Double.NaN;
        }
        return rt.getValueAsDouble(col, row);
    }

    String getResultLabel() {
        String label;
        int row = (int)this.getArg();
        ResultsTable rt = Analyzer.getResultsTable();
        int counter = rt.getCounter();
        if (counter == 0) {
            this.interp.error("\"Results\" table empty");
        }
        if (row < 0 || row >= counter) {
            this.interp.error("Row (" + row + ") out of range");
        }
        return (label = rt.getLabel(row)) != null ? label : "";
    }

    void setResult() {
        this.interp.getLeftParen();
        String column = this.getString();
        this.interp.getComma();
        int row = (int)this.interp.getExpression();
        this.interp.getComma();
        double value = 0.0;
        String label = null;
        if (column.equals("Label")) {
            label = this.getString();
        } else {
            value = this.interp.getExpression();
        }
        this.interp.getRightParen();
        ResultsTable rt = Analyzer.getResultsTable();
        if (row < 0 || row > rt.getCounter()) {
            this.interp.error("Row (" + row + ") out of range");
        }
        if (row == rt.getCounter()) {
            rt.incrementCounter();
        }
        try {
            if (label != null) {
                rt.setLabel(label, row);
            } else {
                rt.setValue(column, row, value);
            }
        }
        catch (Exception e) {
            this.interp.error("" + e.getMessage());
        }
    }

    void updateResults() {
        this.interp.getParens();
        ResultsTable rt = Analyzer.getResultsTable();
        rt.show("Results");
    }

    double getNumber() {
        String title;
        String prompt = this.getFirstString();
        double defaultValue = this.getLastArg();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        int decimalPlaces = (double)((int)defaultValue) == defaultValue ? 0 : 2;
        gd.addNumericField(prompt, defaultValue, decimalPlaces);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.interp.done = true;
            return defaultValue;
        }
        double v = gd.getNextNumber();
        if (gd.invalidNumber()) {
            return defaultValue;
        }
        return v;
    }

    double getBoolean() {
        YesNoCancelDialog d;
        String title;
        String prompt = this.getStringArg();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        if ((d = new YesNoCancelDialog((Frame)IJ.getInstance(), title, prompt)).cancelPressed()) {
            this.interp.done = true;
            return 0.0;
        }
        if (d.yesPressed()) {
            return 1.0;
        }
        return 0.0;
    }

    double getBoolean2() {
        String title;
        String prompt = this.getFirstString();
        this.interp.getComma();
        double defaultValue = this.interp.getBooleanExpression();
        this.interp.checkBoolean(defaultValue);
        this.interp.getRightParen();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        gd.addCheckbox(prompt, defaultValue == 1.0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.interp.done = true;
            return 0.0;
        }
        return gd.getNextBoolean() ? 1.0 : 0.0;
    }

    String getStringDialog() {
        String title;
        this.interp.getLeftParen();
        String prompt = this.getString();
        this.interp.getComma();
        String defaultStr = this.getString();
        this.interp.getRightParen();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        gd.addStringField(prompt, defaultStr, 20);
        gd.showDialog();
        String str = "";
        if (gd.wasCanceled()) {
            this.interp.done = true;
        } else {
            str = gd.getNextString();
        }
        return str;
    }

    String d2s() {
        return IJ.d2s(this.getFirstArg(), (int)this.getLastArg());
    }

    String toString(int base) {
        int arg = (int)this.getArg();
        if (base == 2) {
            return Integer.toBinaryString(arg);
        }
        return Integer.toHexString(arg);
    }

    double getStackSize() {
        this.interp.getParens();
        return this.getImage().getStackSize();
    }

    double getImageCount() {
        this.interp.getParens();
        return WindowManager.getImageCount();
    }

    double getResultsCount() {
        this.interp.getParens();
        return Analyzer.getResultsTable().getCounter();
    }

    void getCoordinates() {
        Variable xCoordinates = this.getFirstArrayVariable();
        Variable yCoordinates = this.getLastArrayVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.interp.error("Selection required");
        }
        Polygon p = roi.getPolygon();
        Variable[] xa = new Variable[p.npoints];
        for (int i = 0; i < p.npoints; ++i) {
            xa[i] = new Variable(p.xpoints[i]);
        }
        xCoordinates.setArray(xa);
        Variable[] ya = new Variable[p.npoints];
        for (int i = 0; i < p.npoints; ++i) {
            ya[i] = new Variable(p.ypoints[i]);
        }
        yCoordinates.setArray(ya);
    }

    Variable[] getProfile() {
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ProfilePlot pp = new ProfilePlot(imp, IJ.altKeyDown());
        double[] array = pp.getProfile();
        if (array == null) {
            this.interp.done = true;
            return null;
        }
        return new Variable(array).getArray();
    }

    Variable[] newArray() {
        this.interp.getLeftParen();
        int next = this.interp.nextNonEolToken();
        if (next == 133 || this.interp.nextNextNonEolToken() == 44 || next == 45 || next == 211) {
            return this.initNewArray();
        }
        int size = (int)this.interp.getExpression();
        this.interp.getRightParen();
        Variable[] array = new Variable[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new Variable();
        }
        return array;
    }

    Variable[] split() {
        String s1 = this.getFirstString();
        String s2 = null;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
        } else {
            s2 = this.getLastString();
        }
        if (s1 == null) {
            return null;
        }
        String[] strings = s2 == null || s2.equals("") ? Tools.split(s1) : Tools.split(s1, s2);
        Variable[] array = new Variable[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            array[i] = new Variable(0, 0.0, strings[i]);
        }
        return array;
    }

    Variable[] getFileList() {
        String dir = this.getStringArg();
        File f = new File(dir);
        if (!f.exists() || !f.isDirectory()) {
            return new Variable[0];
        }
        String[] list = f.list();
        if (list == null) {
            return new Variable[0];
        }
        if (System.getProperty("os.name").indexOf("Linux") != -1) {
            StringSorter.sort(list);
        }
        int hidden = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].startsWith(".")) {
                list[i] = null;
                ++hidden;
                continue;
            }
            File f2 = new File(dir, list[i]);
            if (!f2.isDirectory()) continue;
            list[i] = list[i] + "/";
        }
        int n = list.length - hidden;
        if (n <= 0) {
            return new Variable[0];
        }
        if (hidden > 0) {
            String[] list2 = new String[n];
            int j = 0;
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == null) continue;
                list2[j++] = list[i];
            }
            list = list2;
        }
        Variable[] array = new Variable[n];
        for (int i = 0; i < n; ++i) {
            array[i] = new Variable(0, 0.0, list[i]);
        }
        return array;
    }

    Variable[] initNewArray() {
        Vector<Variable> vector = new Vector<Variable>();
        int size = 0;
        do {
            Variable v = new Variable();
            if (this.interp.nextNonEolToken() == 133) {
                v.setString(this.getString());
            } else {
                v.setValue(this.interp.getExpression());
            }
            vector.addElement(v);
            ++size;
            this.interp.getToken();
        } while (this.interp.token == 44);
        if (this.interp.token != 41) {
            this.interp.error("';' expected");
        }
        Object[] array = new Variable[size];
        vector.copyInto(array);
        return array;
    }

    String fromCharCode() {
        char[] chars = new char[100];
        int count = 0;
        this.interp.getLeftParen();
        while (this.interp.nextToken() != 41) {
            int value = (int)this.interp.getExpression();
            if (value < 0 || value > 65535) {
                this.interp.error("Value (" + value + ") out of 0-65535 range");
            }
            chars[count++] = (char)value;
            if (this.interp.nextToken() != 44) continue;
            this.interp.getToken();
        }
        this.interp.getRightParen();
        return new String(chars, 0, count);
    }

    String getInfo() {
        if (this.interp.nextNextNonEolToken() == 133 || this.interp.nextNonEolToken() == 40 && this.interp.nextNextNonEolToken() != 41) {
            return this.getInfo(this.getStringArg());
        }
        this.interp.getParens();
        return this.getWindowContents();
    }

    String getInfo(String key) {
        if (key.equals("image.subtitle")) {
            ImagePlus imp = this.getImage();
            ImageWindow win = imp.getWindow();
            return win != null ? win.createSubtitle() : "";
        }
        if (key.equals("slice.label")) {
            ImagePlus imp = this.getImage();
            if (imp.getStackSize() == 1) {
                return "";
            }
            String label = imp.getStack().getShortSliceLabel(imp.getCurrentSlice());
            return label != null ? label : "";
        }
        if (key.equals("window.contents")) {
            return this.getWindowContents();
        }
        String value = "";
        try {
            value = System.getProperty(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value != null ? value : "";
    }

    String getWindowContents() {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextPanel tp = ((TextWindow)frame).getTextPanel();
            return tp.getText();
        }
        if (frame != null && frame instanceof Editor) {
            return ((Editor)frame).getText();
        }
        return this.getImageInfo();
    }

    String getImageInfo() {
        ImagePlus imp = this.getImage();
        Info infoPlugin = new Info();
        return infoPlugin.getImageInfo(imp, this.getProcessor());
    }

    public String getDirectory() {
        String dir = IJ.getDirectory(this.getStringArg());
        if (dir == null) {
            dir = "";
        }
        return dir;
    }

    double getSelectionType() {
        this.interp.getParens();
        double type = -1.0;
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi != null) {
            type = roi.getType();
        }
        return type;
    }

    void showMessage(boolean withCancel) {
        String message;
        this.interp.getLeftParen();
        String title = this.getString();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            message = this.getString();
        } else {
            message = title;
            title = "";
        }
        this.interp.getRightParen();
        if (withCancel) {
            IJ.showMessageWithCancel(title, message);
        } else {
            IJ.showMessage(title, message);
        }
    }

    double lengthOf() {
        int length = 0;
        this.interp.getLeftParen();
        switch (this.interp.nextToken()) {
            case 133: 
            case 136: 
            case 138: {
                length = this.getString().length();
                break;
            }
            case 129: {
                if (this.pgm.code[this.interp.pc + 2] == 91) {
                    length = this.getString().length();
                    break;
                }
                this.interp.getToken();
                Variable v = this.interp.lookupVariable();
                if (v == null) {
                    return 0.0;
                }
                String s = v.getString();
                if (s != null) {
                    length = s.length();
                    break;
                }
                Variable[] array = v.getArray();
                if (array != null) {
                    length = array.length;
                    break;
                }
                this.interp.error("String or array expected");
                break;
            }
            default: {
                this.interp.error("String or array expected");
            }
        }
        this.interp.getRightParen();
        return length;
    }

    void getCursorLoc() {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable z = this.getNextVariable();
        Variable flags = this.getLastVariable();
        ImagePlus imp = this.getImage();
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            return;
        }
        Point p = ic.getCursorLoc();
        x.setValue(p.x);
        y.setValue(p.y);
        z.setValue(imp.getCurrentSlice() - 1);
        flags.setValue(ic.getModifiers());
    }

    void getLine() {
        Variable vx1 = this.getFirstVariable();
        Variable vy1 = this.getNextVariable();
        Variable vx2 = this.getNextVariable();
        Variable vy2 = this.getNextVariable();
        Variable lineWidth = this.getLastVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        double x1 = -1.0;
        double y1 = -1.0;
        double x2 = -1.0;
        double y2 = -1.0;
        Roi roi = imp.getRoi();
        if (roi != null && roi.getType() == 5) {
            Line line = (Line)roi;
            x1 = line.x1d;
            y1 = line.y1d;
            x2 = line.x2d;
            y2 = line.y2d;
        }
        vx1.setValue(x1);
        vy1.setValue(y1);
        vx2.setValue(x2);
        vy2.setValue(y2);
        lineWidth.setValue(Line.getWidth());
    }

    void getVoxelSize() {
        Variable width = this.getFirstVariable();
        Variable height = this.getNextVariable();
        Variable depth = this.getNextVariable();
        Variable unit = this.getLastVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        Calibration cal = imp.getCalibration();
        width.setValue(cal.pixelWidth);
        height.setValue(cal.pixelHeight);
        depth.setValue(cal.pixelDepth);
        unit.setString(cal.getUnits());
    }

    void getHistogram() {
        Variable[] array;
        this.interp.getLeftParen();
        Variable values = null;
        if (this.interp.nextToken() == 130) {
            this.interp.getExpression();
        } else {
            values = this.getArrayVariable();
        }
        Variable counts = this.getNextArrayVariable();
        this.interp.getComma();
        int nBins = (int)this.interp.getExpression();
        ImagePlus imp = this.getImage();
        double histMin = 0.0;
        double histMax = 0.0;
        boolean setMinMax = false;
        int bitDepth = imp.getBitDepth();
        if (this.interp.nextToken() == 44) {
            histMin = this.getNextArg();
            histMax = this.getLastArg();
            if (bitDepth == 8 || bitDepth == 24) {
                this.interp.error("16 or 32-bit image required to set histMin and histMax");
            }
            setMinMax = true;
        } else {
            this.interp.getRightParen();
        }
        if ((bitDepth == 8 || bitDepth == 24) && nBins != 256) {
            this.interp.error("Bin count (" + nBins + ") must be 256 for 8-bit and RGB images");
        }
        if (nBins == 65536 && bitDepth == 16) {
            Variable[] array2 = counts.getArray();
            int[] hist = this.getProcessor().getHistogram();
            if (array2 != null && array2.length == nBins) {
                for (int i = 0; i < nBins; ++i) {
                    array2[i].setValue(hist[i]);
                }
            } else {
                counts.setArray(new Variable(hist).getArray());
            }
            return;
        }
        ImageStatistics stats = setMinMax ? imp.getStatistics(27, nBins, histMin, histMax) : imp.getStatistics(27, nBins);
        if (values != null) {
            Calibration cal = imp.getCalibration();
            double[] array3 = new double[nBins];
            double value = cal.getCValue(stats.histMin);
            double inc = 1.0;
            if (bitDepth == 16 || bitDepth == 32 || cal.calibrated()) {
                inc = (cal.getCValue(stats.histMax) - cal.getCValue(stats.histMin)) / (double)stats.nBins;
            }
            for (int i = 0; i < nBins; ++i) {
                array3[i] = value;
                value += inc;
            }
            values.setArray(new Variable(array3).getArray());
        }
        if ((array = counts.getArray()) != null && array.length == nBins) {
            for (int i = 0; i < nBins; ++i) {
                array[i].setValue(stats.histogram[i]);
            }
        } else {
            counts.setArray(new Variable(stats.histogram).getArray());
        }
    }

    void getLut() {
        Variable reds = this.getFirstArrayVariable();
        Variable greens = this.getNextArrayVariable();
        Variable blues = this.getLastArrayVariable();
        this.resetImage();
        ImageProcessor ip = this.getProcessor();
        if (ip instanceof ColorProcessor) {
            this.interp.error("Non-RGB image expected");
        }
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        int mapSize = cm.getMapSize();
        byte[] rLUT = new byte[mapSize];
        byte[] gLUT = new byte[mapSize];
        byte[] bLUT = new byte[mapSize];
        cm.getReds(rLUT);
        cm.getGreens(gLUT);
        cm.getBlues(bLUT);
        reds.setArray(new Variable(rLUT).getArray());
        greens.setArray(new Variable(gLUT).getArray());
        blues.setArray(new Variable(bLUT).getArray());
    }

    void setLut() {
        double[] reds = this.getFirstArray();
        double[] greens = this.getNextArray();
        double[] blues = this.getLastArray();
        int length = reds.length;
        if (greens.length != length || blues.length != length) {
            this.interp.error("Arrays are not the same length");
        }
        this.resetImage();
        ImagePlus imp = this.getImage();
        if (imp.getBitDepth() == 24) {
            this.interp.error("Non-RGB image expected");
        }
        ImageProcessor ip = this.getProcessor();
        byte[] r = new byte[length];
        byte[] g = new byte[length];
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            r[i] = (byte)reds[i];
            g[i] = (byte)greens[i];
            b[i] = (byte)blues[i];
        }
        ip.setColorModel(new IndexColorModel(8, length, r, g, b));
        imp.updateAndDraw();
        this.updateNeeded = false;
    }

    void getThreshold() {
        Variable lower = this.getFirstVariable();
        Variable upper = this.getLastVariable();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = this.getProcessor();
        double t1 = ip.getMinThreshold();
        double t2 = ip.getMaxThreshold();
        if (t1 == -808080.0) {
            t1 = -1.0;
            t2 = -1.0;
        } else if (imp.getBitDepth() == 16) {
            Calibration cal = imp.getCalibration();
            t1 = cal.getCValue(t1);
            t2 = cal.getCValue(t2);
        }
        lower.setValue(t1);
        upper.setValue(t2);
    }

    void getPixelSize() {
        Variable unit = this.getFirstVariable();
        Variable width = this.getNextVariable();
        Variable height = this.getNextVariable();
        Variable depth = null;
        if (this.interp.nextToken() == 44) {
            depth = this.getNextVariable();
        }
        this.interp.getRightParen();
        Calibration cal = this.getImage().getCalibration();
        unit.setString(cal.getUnits());
        width.setValue(cal.pixelWidth);
        height.setValue(cal.pixelHeight);
        if (depth != null) {
            depth.setValue(cal.pixelDepth);
        }
    }

    void makeSelection() {
        int n;
        String type = null;
        int roiType = -1;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            type = this.getString().toLowerCase();
            roiType = 2;
            if (type.indexOf("free") != -1) {
                roiType = 3;
            }
            if (type.indexOf("traced") != -1) {
                roiType = 4;
            }
            if (type.indexOf("line") != -1) {
                roiType = type.indexOf("free") != -1 ? 7 : 6;
            }
            if (type.indexOf("angle") != -1) {
                roiType = 8;
            }
            if (type.indexOf("point") != -1) {
                roiType = 10;
            }
        } else {
            roiType = (int)this.interp.getExpression();
            if (roiType < 0 || roiType == 9) {
                this.interp.error("Invalid selection type (" + roiType + ")");
            }
            if (roiType == 0) {
                roiType = 2;
            }
            if (roiType == 1) {
                roiType = 3;
            }
        }
        double[] x = this.getNextArray();
        double[] y = this.getLastArray();
        if (y.length != (n = x.length)) {
            this.interp.error("Arrays are not the same length");
        }
        this.resetImage();
        ImagePlus imp = this.getImage();
        int[] xcoord = new int[n];
        int[] ycoord = new int[n];
        int height = imp.getHeight();
        for (int i = 0; i < n; ++i) {
            xcoord[i] = (int)Math.round(x[i]);
            ycoord[i] = (int)Math.round(y[i]);
        }
        Roi roi = null;
        if (roiType == 5) {
            if (xcoord.length != 2) {
                this.interp.error("2 element arrays expected");
            }
            roi = new Line(xcoord[0], ycoord[0], xcoord[1], ycoord[1]);
        } else {
            roi = roiType == 10 ? new PointRoi(xcoord, ycoord, n) : new PolygonRoi(xcoord, ycoord, n, roiType);
        }
        Roi previousRoi = imp.getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            imp.saveRoi();
        }
        imp.setRoi(roi);
        if (roiType == 2 || roiType == 3) {
            roi = imp.getRoi();
            if (previousRoi != null && roi != null) {
                this.updateRoi(roi);
            }
        }
        this.updateNeeded = false;
    }

    void doPlot() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("create")) {
            this.newPlot();
            return;
        }
        if (this.plot == null) {
            this.interp.error("No plot defined");
        }
        if (name.equals("show")) {
            this.showPlot();
            return;
        }
        if (name.equals("update")) {
            this.updatePlot();
            return;
        }
        if (name.equals("setLimits")) {
            this.plot.setLimits(this.getFirstArg(), this.getNextArg(), this.getNextArg(), this.getLastArg());
            return;
        }
        if (name.equals("addText") || name.equals("drawLabel")) {
            this.addPlotText();
            return;
        }
        if (name.equals("setColor")) {
            this.setPlotColor();
            return;
        }
        if (name.equals("add")) {
            String arg = this.getFirstString();
            arg = arg.toLowerCase(Locale.US);
            int what = 0;
            if (arg.indexOf("curve") != -1 || arg.indexOf("line") != -1) {
                what = 2;
            } else if (arg.indexOf("box") != -1) {
                what = 3;
            } else if (arg.indexOf("triangle") != -1) {
                what = 4;
            } else if (arg.indexOf("cross") != -1) {
                what = 5;
            } else if (arg.indexOf("dot") != -1) {
                what = 6;
            } else if (arg.indexOf("x") != -1) {
                what = 1;
            } else if (arg.indexOf("error") != -1) {
                what = -1;
            }
            this.addToPlot(what);
            return;
        }
        if (name.startsWith("setLineWidth")) {
            this.plot.setLineWidth((int)this.getArg());
            return;
        }
        if (name.startsWith("setJustification")) {
            this.doFunction(357);
            return;
        }
        this.interp.error("Unrecognized plot function");
    }

    void newPlot() {
        double[] x;
        double[] y;
        String title = this.getFirstString();
        String xLabel = this.getNextString();
        String yLabel = this.getNextString();
        if (this.interp.nextToken() == 41) {
            y = null;
            x = null;
        } else {
            x = this.getNextArray();
            if (this.interp.nextToken() == 41) {
                y = x;
                x = new double[y.length];
                for (int i = 0; i < y.length; ++i) {
                    x[i] = i;
                }
            } else {
                y = this.getNextArray();
            }
        }
        this.interp.getRightParen();
        this.plot = new Plot(title, xLabel, yLabel, x, y);
    }

    void showPlot() {
        PlotWindow plotWindow;
        if (this.plot != null && (plotWindow = this.plot.show()) != null) {
            plotID = plotWindow.getImagePlus().getID();
        }
        this.plot = null;
        this.interp.getParens();
    }

    void updatePlot() {
        if (this.plot != null) {
            ImageWindow win;
            ImagePlus plotImage = WindowManager.getImage(plotID);
            ImageWindow imageWindow = win = plotImage != null ? plotImage.getWindow() : null;
            if (win != null) {
                ((PlotWindow)win).drawPlot(this.plot);
            } else {
                PlotWindow plotWindow = this.plot.show();
                plotID = plotWindow.getImagePlus().getID();
            }
        }
        this.plot = null;
        this.interp.getParens();
    }

    void addPlotText() {
        String str = this.getFirstString();
        double x = this.getNextArg();
        double y = this.getLastArg();
        this.plot.setJustification(this.justification);
        this.plot.addLabel(x, y, str);
    }

    void setPlotColor() {
        this.interp.getLeftParen();
        this.plot.setColor(this.getColor());
        this.interp.getRightParen();
    }

    void addToPlot(int what) {
        double[] y;
        double[] x = this.getNextArray();
        if (this.interp.nextToken() == 41) {
            y = x;
            x = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                x[i] = i;
            }
        } else {
            this.interp.getComma();
            y = this.getNumericArray();
        }
        this.interp.getRightParen();
        if (what == -1) {
            this.plot.addErrorBars(y);
        } else {
            this.plot.addPoints(x, y, what);
        }
    }

    void getBounds() {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable width = this.getNextVariable();
        Variable height = this.getLastVariable();
        this.resetImage();
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi != null) {
            Rectangle r = roi.getBounds();
            x.setValue(r.x);
            y.setValue(r.y);
            width.setValue(r.width);
            height.setValue(r.height);
        } else {
            x.setValue(0.0);
            y.setValue(0.0);
            width.setValue(imp.getWidth());
            height.setValue(imp.getHeight());
        }
    }

    String substring() {
        int index2;
        String s = this.getFirstString();
        int index1 = (int)this.getNextArg();
        if (index1 > (index2 = (int)this.getLastArg())) {
            this.interp.error("beginIndex>endIndex");
        }
        this.checkIndex(index1, 0, s.length());
        this.checkIndex(index2, 0, s.length());
        return s.substring(index1, index2);
    }

    int indexOf() {
        String s1 = this.getFirstString();
        String s2 = this.getNextString();
        int fromIndex = 0;
        if (this.interp.nextToken() == 44) {
            fromIndex = (int)this.getLastArg();
            this.checkIndex(fromIndex, 0, s1.length() - 1);
        } else {
            this.interp.getRightParen();
        }
        if (fromIndex == 0) {
            return s1.indexOf(s2);
        }
        return s1.indexOf(s2, fromIndex);
    }

    int startsWithEndsWith(int type) {
        String s1 = this.getFirstString();
        String s2 = this.getLastString();
        if (type == 1034) {
            return s1.startsWith(s2) ? 1 : 0;
        }
        return s1.endsWith(s2) ? 1 : 0;
    }

    double isActive() {
        int id = (int)this.getArg();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getID() != id) {
            return 0.0;
        }
        return 1.0;
    }

    double isOpen() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            boolean open;
            String title = this.getString();
            this.interp.getRightParen();
            boolean bl = open = WindowManager.getFrame(title) != null;
            if (open) {
                return 1.0;
            }
            if (Interpreter.isBatchMode() && Interpreter.imageTable != null) {
                Enumeration en = Interpreter.imageTable.elements();
                while (en.hasMoreElements()) {
                    ImagePlus imp = (ImagePlus)en.nextElement();
                    if (imp == null || !imp.getTitle().equals(title)) continue;
                    return 1.0;
                }
            }
            return 0.0;
        }
        int id = (int)this.interp.getExpression();
        this.interp.getRightParen();
        return WindowManager.getImage(id) == null ? 0.0 : 1.0;
    }

    boolean isStringArg() {
        int nextToken = this.pgm.code[this.interp.pc + 1];
        int tok = nextToken & 0xFF;
        if (tok == 133 || tok == 136) {
            return true;
        }
        if (tok != 129) {
            return false;
        }
        Variable v = this.interp.lookupVariable(nextToken >> 12);
        if (v == null) {
            return false;
        }
        int type = v.getType();
        if (type != 1) {
            return v.getType() == 2;
        }
        Variable[] array = v.getArray();
        if (array.length == 0) {
            return false;
        }
        return array[0].getType() == 2;
    }

    void exit() {
        String msg = null;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.isStringArg()) {
                msg = this.getString();
            }
            this.interp.getRightParen();
        }
        this.interp.finishUp();
        if (msg != null) {
            IJ.showMessage("Macro", msg);
        }
        throw new RuntimeException("Macro canceled");
    }

    void showProgress() {
        ProgressBar progressBar = IJ.getInstance().getProgressBar();
        this.interp.getLeftParen();
        double arg1 = this.interp.getExpression();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            double arg2 = this.interp.getExpression();
            if (progressBar != null) {
                progressBar.show((arg1 + 1.0) / arg2, true);
            }
        } else if (progressBar != null) {
            progressBar.show(arg1, true);
        }
        this.interp.getRightParen();
        this.interp.showingProgress = true;
    }

    void saveSettings() {
        this.interp.getParens();
        this.usePointerCursor = Prefs.usePointerCursor;
        this.hideProcessStackDialog = IJ.hideProcessStackDialog;
        this.divideByZeroValue = FloatBlitter.divideByZeroValue;
        this.jpegQuality = JpegWriter.getQuality();
        this.lineWidth = Line.getWidth();
        this.doScaling = ImageConverter.getDoScaling();
        this.weightedColor = Prefs.weightedColor;
        this.weights = ColorProcessor.getWeightingFactors();
        this.interpolateScaledImages = Prefs.interpolateScaledImages;
        this.open100Percent = Prefs.open100Percent;
        this.blackCanvas = Prefs.blackCanvas;
        this.useJFileChooser = Prefs.useJFileChooser;
        this.debugMode = IJ.debugMode;
        this.foregroundColor = Toolbar.getForegroundColor();
        this.backgroundColor = Toolbar.getBackgroundColor();
        this.roiColor = Roi.getColor();
        this.pointAutoMeasure = Prefs.pointAutoMeasure;
        this.requireControlKey = Prefs.requireControlKey;
        this.useInvertingLut = Prefs.useInvertingLut;
        this.doubleBuffer = Prefs.doubleBuffer;
        this.saveSettingsCalled = true;
        this.measurements = Analyzer.getMeasurements();
        this.decimalPlaces = Analyzer.getPrecision();
        this.blackBackground = Prefs.blackBackground;
    }

    void restoreSettings() {
        this.interp.getParens();
        if (!this.saveSettingsCalled) {
            this.interp.error("saveSettings() not called");
        }
        Prefs.usePointerCursor = this.usePointerCursor;
        IJ.hideProcessStackDialog = this.hideProcessStackDialog;
        FloatBlitter.divideByZeroValue = this.divideByZeroValue;
        JpegWriter.setQuality(this.jpegQuality);
        Line.setWidth(this.lineWidth);
        ImageConverter.setDoScaling(this.doScaling);
        if (this.weightedColor != Prefs.weightedColor) {
            ColorProcessor.setWeightingFactors(this.weights[0], this.weights[1], this.weights[2]);
            Prefs.weightedColor = this.weights[0] != 0.3333333333333333 || this.weights[1] != 0.3333333333333333 || this.weights[2] != 0.3333333333333333;
        }
        Prefs.interpolateScaledImages = this.interpolateScaledImages;
        Prefs.open100Percent = this.open100Percent;
        Prefs.blackCanvas = this.blackCanvas;
        Prefs.useJFileChooser = this.useJFileChooser;
        Prefs.useInvertingLut = this.useInvertingLut;
        Prefs.doubleBuffer = this.doubleBuffer;
        IJ.debugMode = this.debugMode;
        Toolbar.setForegroundColor(this.foregroundColor);
        Toolbar.setBackgroundColor(this.backgroundColor);
        Roi.setColor(this.roiColor);
        Analyzer.setMeasurements(this.measurements);
        Analyzer.setPrecision(this.decimalPlaces);
        ColorProcessor.setWeightingFactors(this.weights[0], this.weights[1], this.weights[2]);
        Prefs.blackBackground = this.blackBackground;
    }

    void setKeyDown() {
        String keys = this.getStringArg();
        boolean bl = this.altKeyDown = (keys = keys.toLowerCase(Locale.US)).indexOf("alt") != -1;
        if (this.altKeyDown) {
            IJ.setKeyDown(18);
        } else {
            IJ.setKeyUp(18);
        }
        boolean bl2 = this.shiftKeyDown = keys.indexOf("shift") != -1;
        if (this.shiftKeyDown) {
            IJ.setKeyDown(16);
        } else {
            IJ.setKeyUp(16);
        }
        if (keys.equals("space")) {
            IJ.setKeyDown(32);
        } else {
            IJ.setKeyUp(32);
        }
        if (keys.indexOf("esc") != -1) {
            this.abortPluginOrMacro();
        } else {
            this.interp.keysSet = true;
        }
    }

    void abortPluginOrMacro() {
        ImageWindow win;
        Interpreter.abortPrevious();
        IJ.setKeyDown(27);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (win = imp.getWindow()) != null) {
            win.running = false;
            win.running2 = false;
        }
    }

    void open() {
        this.interp.getLeftParen();
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            IJ.open();
        } else {
            String path = this.getString();
            this.interp.getRightParen();
            IJ.open(path);
        }
        this.resetImage();
    }

    double roiManager() {
        RoiManager rm;
        String cmd = this.getFirstString();
        cmd = cmd.toLowerCase();
        String path = null;
        int index = 0;
        double countOrIndex = Double.NaN;
        boolean twoArgCommand = cmd.equals("open") || cmd.equals("save") || cmd.equals("rename");
        boolean select = cmd.equals("select");
        if (twoArgCommand) {
            path = this.getLastString();
        } else if (select) {
            index = (int)this.getLastArg();
        } else {
            this.interp.getRightParen();
        }
        if (RoiManager.getInstance() == null) {
            IJ.run("ROI Manager...");
        }
        if ((rm = RoiManager.getInstance()) == null) {
            this.interp.error("ROI Manager not found");
        }
        if (twoArgCommand) {
            rm.runCommand(cmd, path);
        } else if (select) {
            int n = rm.getList().getItemCount();
            this.checkIndex(index, 0, n - 1);
            if (this.shiftKeyDown || this.altKeyDown) {
                rm.select(index, this.shiftKeyDown, this.altKeyDown);
                this.altKeyDown = false;
                this.shiftKeyDown = false;
            } else {
                this.roiManagerSelect(rm, index);
            }
        } else if (cmd.equals("count")) {
            countOrIndex = rm.getList().getItemCount();
        } else if (cmd.equals("index")) {
            countOrIndex = rm.getList().getSelectedIndex();
        } else if (!rm.runCommand(cmd)) {
            this.interp.error("Invalid ROI Manager command");
        }
        return countOrIndex;
    }

    void roiManagerSelect(RoiManager rm, int index) {
        int delay = 1;
        long start = System.currentTimeMillis();
        while (true) {
            rm.select(index);
            if (delay > 1) {
                IJ.wait(delay);
            }
            if (rm.getList().isIndexSelected(index)) break;
            rm.select(-1);
            IJ.wait(delay);
            if ((delay *= 2) > 32) {
                delay = 32;
            }
            if (System.currentTimeMillis() - start <= 1000L) continue;
            this.interp.error("Failed to select");
        }
    }

    void setFont() {
        String name = this.getFirstString();
        int size = (int)this.getNextArg();
        int style = 0;
        this.antialiasedText = false;
        if (this.interp.nextToken() == 44) {
            String styles = this.getLastString().toLowerCase();
            if (styles.indexOf("bold") != -1) {
                ++style;
            }
            if (styles.indexOf("italic") != -1) {
                style += 2;
            }
            if (styles.indexOf("anti") != -1) {
                this.antialiasedText = true;
            }
        } else {
            this.interp.getRightParen();
        }
        this.font = new Font(name, style, size);
        this.fontSet = false;
    }

    void getMinAndMax() {
        Variable min = this.getFirstVariable();
        Variable max = this.getLastVariable();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = imp.getProcessor();
        double v1 = ip.getMin();
        double v2 = ip.getMax();
        if (imp.getBitDepth() == 16) {
            Calibration cal = imp.getCalibration();
            v1 = cal.getCValue(v1);
            v2 = cal.getCValue(v2);
        }
        min.setValue(v1);
        max.setValue(v2);
    }

    void selectImage() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            this.selectImage(this.getString());
            this.interp.getRightParen();
        } else {
            int id = (int)this.interp.getExpression();
            IJ.selectWindow(id);
            this.interp.getRightParen();
        }
        this.resetImage();
    }

    void selectImage(String title) {
        if (Interpreter.isBatchMode()) {
            if (Interpreter.imageTable != null) {
                Enumeration en = Interpreter.imageTable.elements();
                while (en.hasMoreElements()) {
                    ImagePlus imp = (ImagePlus)en.nextElement();
                    if (imp == null || !imp.getTitle().equals(title)) continue;
                    ImagePlus imp2 = WindowManager.getCurrentImage();
                    if (imp2 != null && imp2 != imp) {
                        imp2.saveRoi();
                    }
                    WindowManager.setTempCurrentImage(imp);
                    return;
                }
            }
            this.selectWindowManagerImage(title);
        } else {
            this.selectWindowManagerImage(title);
        }
    }

    void notFound(String title) {
        this.interp.error(title + " not found");
    }

    void selectWindowManagerImage(String title) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 4000L) {
            int[] wList = WindowManager.getIDList();
            int len = wList != null ? wList.length : 0;
            for (int i = 0; i < len; ++i) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                if (imp == null || !imp.getTitle().equals(title)) continue;
                IJ.selectWindow(imp.getID());
                return;
            }
            IJ.wait(10);
        }
        this.notFound(title);
    }

    void close() {
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ImageWindow win = imp.getWindow();
        if (win != null) {
            imp.changes = false;
            win.close();
        } else {
            imp.saveRoi();
            WindowManager.setTempCurrentImage(null);
            Interpreter.removeBatchModeImage(imp);
        }
        this.resetImage();
    }

    void setBatchMode() {
        boolean enterBatchMode = false;
        String sarg = null;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            sarg = this.getString();
        } else {
            double arg = this.interp.getBooleanExpression();
            this.interp.checkBoolean(arg);
            enterBatchMode = arg == 1.0;
        }
        this.interp.getRightParen();
        Functions functions = this;
        if (!functions.interp.isBatchMode()) {
            this.interp.calledMacro = false;
        }
        this.resetImage();
        if (enterBatchMode) {
            Interpreter.setBatchMode(true);
            ImagePlus tmp = WindowManager.getTempCurrentImage();
            if (tmp != null) {
                Interpreter.addBatchModeImage(tmp);
            }
            return;
        }
        IJ.showProgress(0, 0);
        ImagePlus imp2 = WindowManager.getCurrentImage();
        WindowManager.setTempCurrentImage(null);
        if (sarg == null) {
            Interpreter.setBatchMode(false);
            this.displayBatchModeImage(imp2);
        } else {
            Vector v = Interpreter.imageTable;
            if (v == null) {
                return;
            }
            Interpreter.setBatchMode(false);
            for (int i = 0; i < v.size(); ++i) {
                imp2 = (ImagePlus)v.elementAt(i);
                if (imp2 == null) continue;
                this.displayBatchModeImage(imp2);
            }
        }
    }

    void displayBatchModeImage(ImagePlus imp2) {
        if (imp2 != null) {
            ImageWindow win = imp2.getWindow();
            if (win == null) {
                imp2.show();
            } else {
                if (!win.isVisible()) {
                    win.show();
                }
                imp2.updateAndDraw();
            }
            Roi roi = imp2.getRoi();
            if (roi != null) {
                imp2.setRoi(roi);
            }
        }
    }

    void setLocation() {
        int x = (int)this.getFirstArg();
        int y = (int)this.getLastArg();
        ImagePlus imp = this.getImage();
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.setLocation(x, y);
        }
    }

    void setSlice() {
        int n = (int)this.getArg();
        ImagePlus imp = this.getImage();
        int nSlices = imp.getStackSize();
        if (n == 1 && nSlices == 1) {
            return;
        }
        if (n < 1 || n > nSlices) {
            this.interp.error("Argument must be >=1 and <=" + nSlices);
        } else {
            imp.setSlice(n);
        }
        this.resetImage();
    }

    void newImage() {
        String title = this.getFirstString();
        String type = this.getNextString();
        int width = (int)this.getNextArg();
        int height = (int)this.getNextArg();
        int depth = (int)this.getLastArg();
        IJ.newImage(title, type, width, height, depth);
        this.resetImage();
    }

    void saveAs() {
        String format = this.getFirstString();
        String path = null;
        if (this.interp.nextNonEolToken() == 44) {
            path = this.getLastString();
        } else {
            this.interp.getRightParen();
        }
        IJ.saveAs(format, path);
    }

    double getZoom() {
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            this.interp.error("Image not displayed");
            return 0.0;
        }
        return ic.getMagnification();
    }

    void setAutoThreshold() {
        double upper;
        double lower;
        boolean unbalanced;
        boolean notByteData;
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = this.getProcessor();
        double min = 0.0;
        double max = 0.0;
        boolean bl = notByteData = !(ip instanceof ByteProcessor);
        if (notByteData) {
            if (ip instanceof ColorProcessor) {
                this.interp.error("Non-RGB image expected");
            }
            ip.resetMinAndMax();
            min = ip.getMin();
            max = ip.getMax();
            ip = new ByteProcessor(ip.createImage());
        }
        ip.setRoi(imp.getRoi());
        ImageStatistics stats = ImageStatistics.getStatistics(ip, 25, null);
        int threshold = ip.getAutoThreshold(stats.histogram);
        int count1 = 0;
        int count2 = 0;
        for (int i = 0; i < 256; ++i) {
            if (i < threshold) {
                count1 += stats.histogram[i];
                continue;
            }
            count2 += stats.histogram[i];
        }
        boolean bl2 = unbalanced = (double)count1 / (double)count2 > 1.25 || (double)count2 / (double)count1 > 1.25;
        if (unbalanced) {
            if (stats.max - stats.dmode > stats.dmode - stats.min) {
                lower = threshold;
                upper = 255.0;
            } else {
                lower = 0.0;
                upper = threshold;
            }
        } else if (ip.isInvertedLut()) {
            lower = threshold;
            upper = 255.0;
        } else {
            lower = 0.0;
            upper = threshold;
        }
        if (notByteData) {
            if (max > min) {
                lower = min + lower / 255.0 * (max - min);
                upper = min + upper / 255.0 * (max - min);
            } else {
                lower = upper = min;
            }
        }
        if (imp.getBitDepth() == 16) {
            Calibration cal = imp.getCalibration();
            lower = cal.getCValue(lower);
            upper = cal.getCValue(upper);
        }
        IJ.setThreshold(lower, upper);
        this.resetImage();
    }

    double parseDouble(String s) {
        if (s == null) {
            return 0.0;
        }
        if ((s = s.trim()).indexOf(32) != -1) {
            s = s.substring(0, s.indexOf(32));
        }
        return Tools.parseDouble(s);
    }

    double parseInt() {
        double n;
        String s = this.getFirstString();
        int radix = 10;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            radix = (int)this.interp.getExpression();
            if (radix < 2 || radix > 36) {
                radix = 10;
            }
        }
        this.interp.getRightParen();
        try {
            if (radix == 10) {
                n = this.parseDouble(s);
                if (!Double.isNaN(n)) {
                    n = Math.round(n);
                }
            } else {
                n = Integer.parseInt(s, radix);
            }
        }
        catch (NumberFormatException e) {
            n = 212.0;
        }
        return n;
    }

    void print() {
        this.interp.inPrint = true;
        String s = this.getFirstString();
        if (this.interp.nextNonEolToken() == 44) {
            if (s.startsWith("[") && s.endsWith("]")) {
                this.printToWindow(s);
                return;
            }
            if (s.equals("~0~")) {
                String s2;
                if (this.writer == null) {
                    this.interp.error("File not open");
                }
                if ((s2 = this.getLastString()).endsWith("\n")) {
                    this.writer.print(s2);
                } else {
                    this.writer.println(s2);
                }
                this.interp.inPrint = false;
                return;
            }
            StringBuffer sb = new StringBuffer(s);
            do {
                sb.append(" ");
                sb.append(this.getNextString());
            } while (this.interp.nextNonEolToken() == 44);
            s = sb.toString();
        }
        this.interp.getRightParen();
        IJ.log(s);
        this.interp.inPrint = false;
    }

    void printToWindow(String s) {
        boolean isEditor;
        String title = s.substring(1, s.length() - 1);
        String s2 = this.getLastString();
        boolean isCommand = s2.startsWith("\\");
        Frame frame = WindowManager.getFrame(title);
        if (frame == null) {
            if (isCommand) {
                this.interp.done = true;
                return;
            }
            this.interp.error("Window not found");
        }
        if (!(isEditor = frame instanceof Editor) && !(frame instanceof TextWindow)) {
            this.interp.error("Window is not text window");
        }
        if (isEditor) {
            Editor ed = (Editor)frame;
            ed.setIsMacroWindow(true);
            if (isCommand) {
                this.handleEditorCommand(ed, s2);
            } else {
                ed.append(s2);
            }
        } else {
            TextWindow tw = (TextWindow)frame;
            if (isCommand) {
                this.handleTextWindowCommand(tw, s2);
            } else {
                tw.append(s2);
            }
        }
    }

    void handleEditorCommand(Editor ed, String s) {
        if (s.startsWith("\\Update:")) {
            TextArea ta = ed.getTextArea();
            ta.setText(s.substring(8, s.length()));
            ta.setEditable(false);
        } else if (s.equals("\\Close")) {
            ed.close();
        } else {
            ed.append(s);
        }
    }

    void handleTextWindowCommand(TextWindow tw, String s) {
        TextPanel tp = tw.getTextPanel();
        if (s.startsWith("\\Update:")) {
            int n = tp.getLineCount();
            String s2 = s.substring(8, s.length());
            if (n == 0) {
                tp.append(s2);
            } else {
                tp.setLine(n - 1, s2);
            }
        } else if (s.startsWith("\\Update")) {
            int cindex = s.indexOf(":");
            if (cindex == -1) {
                tp.append(s);
                return;
            }
            String nstr = s.substring(7, cindex);
            int line = (int)Tools.parseDouble(nstr, -1.0);
            if (line < 0 || line > 25) {
                tp.append(s);
                return;
            }
            for (int count = tp.getLineCount(); line >= count; ++count) {
                tp.append("");
            }
            String s2 = s.substring(cindex + 1, s.length());
            tp.setLine(line, s2);
        } else if (s.equals("\\Clear")) {
            tp.clear();
        } else if (s.equals("\\Close")) {
            tw.close();
        } else if (s.startsWith("\\Headings:")) {
            tp.setColumnHeadings(s.substring(10));
        } else {
            tp.append(s);
        }
    }

    double isKeyDown() {
        double value = 0.0;
        String key = this.getStringArg().toLowerCase(Locale.US);
        if (key.indexOf("alt") != -1) {
            value = IJ.altKeyDown() ? 1.0 : 0.0;
        } else if (key.indexOf("shift") != -1) {
            value = IJ.shiftKeyDown() ? 1.0 : 0.0;
        } else if (key.indexOf("space") != -1) {
            value = IJ.spaceBarDown() ? 1.0 : 0.0;
        } else {
            this.interp.error("Invalid key");
        }
        return value;
    }

    String runMacro(boolean eval) {
        this.interp.getLeftParen();
        String name = this.getString();
        String arg = null;
        if (this.interp.nextNonEolToken() == 44) {
            this.interp.getComma();
            arg = this.getString();
        }
        this.interp.getRightParen();
        if (eval) {
            return IJ.runMacro(name, arg);
        }
        return IJ.runMacroFile(name, arg);
    }

    void setThreshold() {
        double lower = this.getFirstArg();
        double upper = this.getNextArg();
        String mode = null;
        if (this.interp.nextNonEolToken() == 44) {
            this.interp.getComma();
            mode = this.getString();
        }
        this.interp.getRightParen();
        IJ.setThreshold(lower, upper, mode);
        this.resetImage();
    }

    void drawOrFill(int type) {
        int x = (int)this.getFirstArg();
        int y = (int)this.getNextArg();
        int width = (int)this.getNextArg();
        int height = (int)this.getLastArg();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        switch (type) {
            case 388: {
                ip.drawRect(x, y, width, height);
                break;
            }
            case 376: {
                ip.setRoi(x, y, width, height);
                ip.fill();
                break;
            }
            case 389: {
                ip.drawOval(x, y, width, height);
                break;
            }
            case 390: {
                ip.fillOval(x, y, width, height);
            }
        }
        this.updateAndDraw(this.defaultImp);
    }

    double getScreenDimension(int type) {
        this.interp.getParens();
        Dimension screen = IJ.getScreenSize();
        if (type == 1043) {
            return screen.width;
        }
        return screen.height;
    }

    void getStatistics(boolean calibrated) {
        Variable count = this.getFirstVariable();
        Variable mean = null;
        Variable min = null;
        Variable max = null;
        Variable std = null;
        Variable hist = null;
        int params = 19;
        this.interp.getToken();
        int arg = 1;
        while (this.interp.token == 44) {
            switch (++arg) {
                case 2: {
                    mean = this.getVariable();
                    break;
                }
                case 3: {
                    min = this.getVariable();
                    break;
                }
                case 4: {
                    max = this.getVariable();
                    break;
                }
                case 5: {
                    std = this.getVariable();
                    params += 4;
                    break;
                }
                case 6: {
                    hist = this.getArrayVariable();
                    break;
                }
                default: {
                    this.interp.error("')' expected");
                }
            }
            this.interp.getToken();
        }
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        this.resetImage();
        ImagePlus imp = this.getImage();
        Calibration cal = calibrated ? imp.getCalibration() : null;
        ImageProcessor ip = this.getProcessor();
        ip.setRoi(imp.getRoi());
        ImageStatistics stats = ImageStatistics.getStatistics(ip, params, cal);
        if (calibrated) {
            count.setValue(stats.area);
        } else {
            count.setValue(stats.pixelCount);
        }
        if (mean != null) {
            mean.setValue(stats.mean);
        }
        if (min != null) {
            min.setValue(stats.min);
        }
        if (max != null) {
            max.setValue(stats.max);
        }
        if (std != null) {
            std.setValue(stats.stdDev);
        }
        if (hist != null) {
            boolean is16bit = !calibrated && ip instanceof ShortProcessor;
            int[] histogram = is16bit ? stats.histogram16 : stats.histogram;
            int bins = is16bit ? (int)(stats.max + 1.0) : histogram.length;
            Variable[] array = new Variable[bins];
            int hmax = is16bit ? (int)stats.max : 255;
            for (int i = 0; i <= hmax; ++i) {
                array[i] = new Variable(histogram[i]);
            }
            hist.setArray(array);
        }
    }

    String replace() {
        String s1 = this.getFirstString();
        String s2 = this.getNextString();
        String s3 = this.getLastString();
        if (s2.length() == 1 && s3.length() == 1) {
            return s1.replace(s2.charAt(0), s3.charAt(0));
        }
        if (IJ.isJava14()) {
            try {
                Class<?> StringClass = s1.getClass();
                Method replaceAll = StringClass.getDeclaredMethod("replaceAll", String.class, String.class);
                Object[] arglist = new Object[]{s2, s3};
                return (String)replaceAll.invoke((Object)s1, arglist);
            }
            catch (Exception e) {
                this.interp.error("Regular expression error:\n \n" + e);
            }
        } else {
            this.interp.error("Java 1.4 or later required for multi-character replace");
        }
        return null;
    }

    void floodFill() {
        int x = (int)this.getFirstArg();
        int y = (int)this.getNextArg();
        boolean fourConnected = true;
        if (this.interp.nextNonEolToken() == 44) {
            String s = this.getLastString();
            if (s.indexOf("8") != -1) {
                fourConnected = false;
            }
        } else {
            this.interp.getRightParen();
        }
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        FloodFiller ff = new FloodFiller(ip);
        if (fourConnected) {
            ff.fill(x, y);
        } else {
            ff.fill8(x, y);
        }
        this.updateAndDraw(this.defaultImp);
        if (Recorder.record && this.pgm.hasVars) {
            Recorder.record("floodFill", x, y);
        }
    }

    void restorePreviousTool() {
        this.interp.getParens();
        Toolbar tb = Toolbar.getInstance();
        if (tb != null) {
            tb.restorePreviousTool();
        }
    }

    void setVoxelSize() {
        double width = this.getFirstArg();
        double height = this.getNextArg();
        double depth = this.getNextArg();
        String unit = this.getLastString();
        this.resetImage();
        ImagePlus imp = this.getImage();
        Calibration cal = imp.getCalibration();
        cal.pixelWidth = width;
        cal.pixelHeight = height;
        cal.pixelDepth = depth;
        cal.setUnit(unit);
        imp.repaintWindow();
    }

    void getLocationAndSize() {
        Variable v1 = this.getFirstVariable();
        Variable v2 = this.getNextVariable();
        Variable v3 = this.getNextVariable();
        Variable v4 = this.getLastVariable();
        ImagePlus imp = this.getImage();
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            Point loc = win.getLocation();
            Dimension size = win.getSize();
            x = loc.x;
            y = loc.y;
            w = size.width;
            h = size.height;
        }
        v1.setValue(x);
        v2.setValue(y);
        v3.setValue(w);
        v4.setValue(h);
    }

    String doDialog() {
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 136 && this.interp.token != 135) {
            this.interp.error("Function name expected: ");
        }
        String name = this.interp.tokenString;
        try {
            if (name.equals("create")) {
                this.gd = new GenericDialog(this.getStringArg());
                return null;
            }
            if (this.gd == null) {
                this.interp.error("No dialog created with Dialog.create()");
                return null;
            }
            if (name.equals("addString")) {
                String label = this.getFirstString();
                String defaultStr = this.getNextString();
                int columns = 8;
                if (this.interp.nextNonEolToken() == 44) {
                    columns = (int)this.getNextArg();
                }
                this.interp.getRightParen();
                this.gd.addStringField(label, defaultStr, columns);
            } else if (name.equals("addNumber")) {
                int decimalPlaces;
                int columns = 6;
                String units = null;
                String prompt = this.getFirstString();
                double defaultNumber = this.getNextArg();
                int n = decimalPlaces = (double)((int)defaultNumber) == defaultNumber ? 0 : 3;
                if (this.interp.nextNonEolToken() == 44) {
                    decimalPlaces = (int)this.getNextArg();
                    columns = (int)this.getNextArg();
                    units = this.getLastString();
                } else {
                    this.interp.getRightParen();
                }
                this.gd.addNumericField(prompt, defaultNumber, decimalPlaces, columns, units);
            } else if (name.equals("addCheckbox")) {
                this.gd.addCheckbox(this.getFirstString(), this.getLastArg() == 1.0);
            } else if (name.equals("addMessage")) {
                this.gd.addMessage(this.getStringArg());
            } else if (name.equals("addChoice")) {
                String prompt = this.getFirstString();
                this.interp.getComma();
                String[] choices = this.getStringArray();
                String defaultChoice = null;
                if (this.interp.nextNonEolToken() == 44) {
                    this.interp.getComma();
                    defaultChoice = this.getString();
                } else {
                    defaultChoice = choices[0];
                }
                this.interp.getRightParen();
                this.gd.addChoice(prompt, choices, defaultChoice);
            } else if (name.equals("show")) {
                this.interp.getParens();
                this.gd.showDialog();
                if (this.gd.wasCanceled()) {
                    this.interp.finishUp();
                    throw new RuntimeException("Macro canceled");
                }
            } else {
                if (name.equals("getString")) {
                    this.interp.getParens();
                    return this.gd.getNextString();
                }
                if (name.equals("getNumber")) {
                    this.interp.getParens();
                    return "" + this.gd.getNextNumber();
                }
                if (name.equals("getCheckbox")) {
                    this.interp.getParens();
                    return this.gd.getNextBoolean() ? "1" : "0";
                }
                if (name.equals("getChoice")) {
                    this.interp.getParens();
                    return this.gd.getNextChoice();
                }
                this.interp.error("Unrecognized Dialog function " + name);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.interp.error("Dialog error");
        }
        return null;
    }

    void getDateAndTime() {
        Variable year = this.getFirstVariable();
        Variable month = this.getNextVariable();
        Variable dayOfWeek = this.getNextVariable();
        Variable dayOfMonth = this.getNextVariable();
        Variable hour = this.getNextVariable();
        Variable minute = this.getNextVariable();
        Variable second = this.getNextVariable();
        Variable millisecond = this.getLastVariable();
        Calendar date = Calendar.getInstance();
        year.setValue(date.get(1));
        month.setValue(date.get(2));
        dayOfWeek.setValue(date.get(7) - 1);
        dayOfMonth.setValue(date.get(5));
        hour.setValue(date.get(11));
        minute.setValue(date.get(12));
        second.setValue(date.get(13));
        millisecond.setValue(date.get(14));
    }

    void setMetadata() {
        String metadata = this.getStringArg();
        ImagePlus imp = this.getImage();
        boolean isImageMetaData = false;
        if (metadata.startsWith("Info:")) {
            metadata = metadata.substring(5);
            isImageMetaData = true;
        }
        if (imp.getStackSize() == 1 || isImageMetaData) {
            imp.setProperty("Info", metadata);
        } else {
            imp.getStack().setSliceLabel(metadata, imp.getCurrentSlice());
            if (!Interpreter.isBatchMode()) {
                imp.repaintWindow();
            }
        }
    }

    String getMetadata() {
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        String metadata = imp.getStackSize() == 1 ? (String)imp.getProperty("Info") : imp.getStack().getSliceLabel(imp.getCurrentSlice());
        if (metadata == null) {
            metadata = "";
        }
        return metadata;
    }

    ImagePlus getImageArg() {
        ImagePlus img = null;
        if (this.isStringArg()) {
            String title = this.getString();
            img = WindowManager.getImage(title);
        } else {
            int id = (int)this.interp.getExpression();
            img = WindowManager.getImage(id);
        }
        if (img == null) {
            this.interp.error("Image not found");
        }
        return img;
    }

    void imageCalculator() {
        String operator = this.getFirstString();
        this.interp.getComma();
        ImagePlus img1 = this.getImageArg();
        this.interp.getComma();
        ImagePlus img2 = this.getImageArg();
        this.interp.getRightParen();
        ImageCalculator ic = new ImageCalculator();
        ic.calculate(operator, img1, img2);
    }

    void setRGBWeights() {
        double r = this.getFirstArg();
        double g = this.getNextArg();
        double b = this.getLastArg();
        if (this.interp.rgbWeights == null) {
            this.interp.rgbWeights = ColorProcessor.getWeightingFactors();
        }
        ColorProcessor.setWeightingFactors(r, g, b);
    }

    void makePolygon() {
        int n;
        int max = 200;
        int[] x = new int[max];
        int[] y = new int[max];
        x[0] = (int)Math.round(this.getFirstArg());
        y[0] = (int)Math.round(this.getNextArg());
        this.interp.getToken();
        for (n = 1; this.interp.token == 44 && n < max; ++n) {
            x[n] = (int)Math.round(this.interp.getExpression());
            this.interp.getComma();
            y[n] = (int)Math.round(this.interp.getExpression());
            this.interp.getToken();
        }
        if (n < 3) {
            this.interp.error("Fewer than 3 points");
        }
        if (n == max && this.interp.token != 41) {
            this.interp.error("More than " + max + " points");
        }
        ImagePlus imp = this.getImage();
        Roi previousRoi = imp.getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            imp.saveRoi();
        }
        imp.setRoi(new PolygonRoi(x, y, n, 2));
        Roi roi = imp.getRoi();
        if (previousRoi != null && roi != null) {
            this.updateRoi(roi);
        }
        this.resetImage();
    }

    void updateRoi(Roi roi) {
        if (this.shiftKeyDown || this.altKeyDown) {
            roi.update(this.shiftKeyDown, this.altKeyDown);
        }
        this.altKeyDown = false;
        this.shiftKeyDown = false;
    }

    String doFile() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 136 && this.interp.token != 135 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("open")) {
            return this.openFile();
        }
        if (name.equals("openAsString")) {
            return this.openAsString();
        }
        if (name.equals("openUrlAsString")) {
            return this.openUrlAsString();
        }
        if (name.equals("close")) {
            return this.closeFile();
        }
        if (name.equals("separator")) {
            this.interp.getParens();
            return File.separator;
        }
        if (name.equals("directory")) {
            this.interp.getParens();
            String lastDir = OpenDialog.getLastDirectory();
            return lastDir != null ? lastDir : "";
        }
        if (name.equals("name")) {
            this.interp.getParens();
            String lastName = OpenDialog.getLastName();
            return lastName != null ? lastName : "";
        }
        if (name.equals("rename")) {
            File f1 = new File(this.getFirstString());
            File f2 = new File(this.getLastString());
            if (this.isValid(f1) && this.isValid(f2)) {
                return f1.renameTo(f2) ? "1" : "0";
            }
            return "0";
        }
        File f = new File(this.getStringArg());
        if (name.equals("getLength") || name.equals("length")) {
            return "" + f.length();
        }
        if (name.equals("getName")) {
            return f.getName();
        }
        if (name.equals("getAbsolutePath")) {
            return f.getAbsolutePath();
        }
        if (name.equals("getParent")) {
            return f.getParent();
        }
        if (name.equals("exists")) {
            return f.exists() ? "1" : "0";
        }
        if (name.equals("isDirectory")) {
            return f.isDirectory() ? "1" : "0";
        }
        if (name.equals("makeDirectory") || name.equals("mkdir")) {
            f.mkdir();
            return null;
        }
        if (name.equals("lastModified")) {
            return "" + f.lastModified();
        }
        if (name.equals("dateLastModified")) {
            return new Date(f.lastModified()).toString();
        }
        if (name.equals("delete")) {
            if (this.isValid(f)) {
                f.delete();
            }
            return null;
        }
        this.interp.error("Unrecognized File function " + name);
        return null;
    }

    boolean isValid(File f) {
        String path = f.getPath();
        if (path.equals("0") || path.equals("NaN")) {
            this.interp.error("Invalid path");
        }
        if ((path = f.getAbsolutePath()).indexOf("ImageJ") == -1 && !path.startsWith(System.getProperty("java.io.tmpdir")) && !path.startsWith(System.getProperty("user.home"))) {
            this.interp.error("File must be in ImageJ, home or tmp directory");
            return false;
        }
        return true;
    }

    void setSelectionName() {
        Roi roi = this.getImage().getRoi();
        if (roi == null) {
            this.interp.error("No selection");
        } else {
            roi.setName(this.getStringArg());
        }
    }

    String selectionName() {
        Roi roi = this.getImage().getRoi();
        String name = null;
        if (roi == null) {
            this.interp.error("No selection");
        } else {
            name = roi.getName();
        }
        return name != null ? name : "";
    }

    String openFile() {
        String path = this.getFirstString();
        String defaultName = null;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
        } else {
            defaultName = this.getLastString();
        }
        if (path.equals("") || defaultName != null) {
            String title = defaultName != null ? path : "openFile";
            SaveDialog sd = new SaveDialog(title, defaultName = defaultName != null ? defaultName : "log.txt", ".txt");
            if (sd.getFileName() == null) {
                return "";
            }
            path = sd.getDirectory() + sd.getFileName();
        } else {
            File file = new File(path);
            if (!(!file.exists() || path.endsWith(".txt") || path.endsWith(".java") || path.endsWith(".xls") || path.endsWith(".ijm"))) {
                this.interp.error("File exists and suffix is not '.txt', '.java', etc.");
            }
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.writer = null;
        try {
            FileOutputStream fos = new FileOutputStream(path);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            this.writer = new PrintWriter(bos);
        }
        catch (IOException e) {
            this.interp.error("File open error \n\"" + e.getMessage() + "\"\n");
            return "";
        }
        return "~0~";
    }

    String openAsString() {
        String path = this.getStringArg();
        if (path.equals("")) {
            OpenDialog od = new OpenDialog("OpenAsString...", "");
            String directory = od.getDirectory();
            String name = od.getFileName();
            if (name == null) {
                return "";
            }
            path = directory + name;
        }
        String str = "";
        File file = new File(path);
        if (!file.exists()) {
            this.interp.error("File not found");
        }
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            str = new String(sb);
        }
        catch (Exception e) {
            this.interp.error("File open error \n\"" + e.getMessage() + "\"\n");
        }
        return str;
    }

    String closeFile() {
        String f = this.getStringArg();
        if (!f.equals("~0~")) {
            this.interp.error("Invalid file variable");
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        return null;
    }

    String call() {
        Method m;
        Class<?> c;
        String fullName = this.getFirstString();
        int dot = fullName.lastIndexOf(46);
        if (dot < 0) {
            this.interp.error("Expected 'classname.methodname'");
        }
        String className = fullName.substring(0, dot);
        String methodName = fullName.substring(dot + 1);
        Object[] args = null;
        if (this.interp.nextNonEolToken() == 44) {
            Vector<String> vargs = new Vector<String>();
            do {
                vargs.add(this.getNextString());
            } while (this.interp.nextNonEolToken() == 44);
            args = vargs.toArray();
        }
        this.interp.getRightParen();
        if (args == null) {
            args = new Object[]{};
        }
        try {
            c = IJ.getClassLoader().loadClass(className);
        }
        catch (Exception ex) {
            this.interp.error("Could not load class " + className);
            return null;
        }
        try {
            Class[] argClasses = null;
            if (args.length > 0) {
                argClasses = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argClasses[i] = args[i].getClass();
                }
            }
            m = c.getMethod(methodName, argClasses);
        }
        catch (Exception ex) {
            this.interp.error("Could not find the method " + methodName + " with " + args.length + " parameter(s) in class " + className);
            return null;
        }
        try {
            Object obj = m.invoke(null, args);
            return obj != null ? obj.toString() : null;
        }
        catch (Exception e) {
            IJ.log("Call error (" + e + ")");
            return null;
        }
    }

    Variable[] getFontList() {
        this.interp.getParens();
        String[] fonts = null;
        if (IJ.isJava2()) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fonts = ge.getAvailableFontFamilyNames();
        } else {
            fonts = Toolkit.getDefaultToolkit().getFontList();
        }
        if (fonts == null) {
            return null;
        }
        Variable[] array = new Variable[fonts.length];
        for (int i = 0; i < fonts.length; ++i) {
            array[i] = new Variable(0, 0.0, fonts[i]);
        }
        return array;
    }

    String openUrlAsString() {
        String urlString = this.getStringArg();
        StringBuffer sb = null;
        try {
            String line;
            URL url = new URL(urlString);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            String msg = "" + e;
            if (msg.indexOf("UnknownHost") != -1 || msg.indexOf("FileNotFound") != -1) {
                return "";
            }
            this.interp.error(msg);
            sb = null;
        }
        if (sb != null) {
            return new String(sb);
        }
        return null;
    }

    void setOption() {
        String arg1 = this.getFirstString();
        this.interp.getComma();
        double arg2 = this.interp.getBooleanExpression();
        this.interp.checkBoolean(arg2);
        this.interp.getRightParen();
        boolean state = arg2 != 0.0;
        arg1 = arg1.toLowerCase(Locale.US);
        if (arg1.equals("disablepopupmenu")) {
            ImageCanvas ic = this.getImage().getCanvas();
            if (ic != null) {
                ic.disablePopupMenu(state);
            }
        } else if (arg1.equals("show all")) {
            ImagePlus img = this.getImage();
            ImageCanvas ic = img.getCanvas();
            if (ic != null) {
                boolean previousState = ic.getShowAllROIs();
                ic.setShowAllROIs(state);
                if (state != previousState) {
                    img.draw();
                }
            }
        } else if (arg1.equals("changes")) {
            this.getImage().changes = state;
        } else if (arg1.equals("debugmode")) {
            IJ.debugMode = state;
        } else if (arg1.equals("openusingplugins")) {
            Opener.setOpenUsingPlugins(state);
        } else if (arg1.equals("queuemacros")) {
            this.pgm.queueCommands = state;
        } else if (arg1.equals("disableundo")) {
            Prefs.disableUndo = state;
        } else {
            this.interp.error("Invalid option");
        }
    }

    void showText() {
        String title = this.getFirstString();
        String text = this.getLastString();
        Editor ed = new Editor();
        ed.setSize(350, 300);
        ed.create(title, text);
    }

    Variable[] newMenu() {
        String name = this.getFirstString();
        this.interp.getComma();
        String[] commands = this.getStringArray();
        this.interp.getRightParen();
        if (this.pgm.menus == null) {
            this.pgm.menus = new Hashtable();
        }
        this.pgm.menus.put(name, commands);
        Variable[] commands2 = new Variable[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            commands2[i] = new Variable(0, 0.0, commands[i]);
        }
        return commands2;
    }

    void setSelectionLocation() {
        int x = (int)Math.round(this.getFirstArg());
        int y = (int)Math.round(this.getLastArg());
        this.resetImage();
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.interp.error("Selection required");
        }
        roi.setLocation(x, y);
        imp.draw();
    }

    double is() {
        double state = 0.0;
        String arg = this.getStringArg();
        if ((arg = arg.toLowerCase(Locale.US)).equals("locked")) {
            state = this.getImage().isLocked() ? 1.0 : 0.0;
        } else if (arg.indexOf("invert") != -1) {
            state = this.getImage().isInvertedLut() ? 1.0 : 0.0;
        } else {
            this.interp.error("Argument must be 'locked' or 'Inverted LUT'");
        }
        return state;
    }

    Variable[] getList() {
        String key = this.getStringArg();
        if (key.equals("java.properties")) {
            Properties props = System.getProperties();
            Vector<String> v = new Vector<String>();
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                v.addElement((String)en.nextElement());
            }
            Variable[] array = new Variable[v.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = new Variable(0, 0.0, (String)v.elementAt(i));
            }
            return array;
        }
        if (key.equals("window.titles")) {
            Frame[] list = WindowManager.getNonImageWindows();
            Variable[] array = new Variable[list.length];
            for (int i = 0; i < list.length; ++i) {
                Frame frame = list[i];
                array[i] = new Variable(0, 0.0, frame.getTitle());
            }
            return array;
        }
        this.interp.error("Unvalid key");
        return null;
    }

    String doString() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("append")) {
            return this.appendToBuffer();
        }
        if (name.equals("copy")) {
            return this.copyStringToClipboard();
        }
        if (name.equals("copyResults")) {
            return this.copyResults();
        }
        if (name.equals("paste")) {
            return this.getClipboardContents();
        }
        if (name.equals("resetBuffer")) {
            return this.resetBuffer();
        }
        if (name.equals("buffer")) {
            return this.getBuffer();
        }
        this.interp.error("Unrecognized String function");
        return null;
    }

    String appendToBuffer() {
        String text = this.getStringArg();
        if (this.buffer == null) {
            this.buffer = new StringBuffer(256);
        }
        this.buffer.append(text);
        return null;
    }

    String copyStringToClipboard() {
        String text = this.getStringArg();
        StringSelection ss = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(ss, null);
        return null;
    }

    String getClipboardContents() {
        this.interp.getParens();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable data = clipboard.getContents(null);
        String s = null;
        try {
            s = (String)data.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            s = data.toString();
        }
        return s;
    }

    String copyResults() {
        this.interp.getParens();
        if (!IJ.isResultsWindow()) {
            this.interp.error("No results");
        }
        TextPanel tp = IJ.getTextPanel();
        StringSelection ss = new StringSelection(tp.getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(ss, null);
        return null;
    }

    String resetBuffer() {
        this.interp.getParens();
        this.buffer = new StringBuffer(256);
        return null;
    }

    String getBuffer() {
        this.interp.getParens();
        if (this.buffer == null) {
            this.buffer = new StringBuffer(256);
        }
        return this.buffer.toString();
    }

    void doCommand() {
        String arg = this.getStringArg();
        if (arg.equals("Start Animation")) {
            arg = "Start Animation [\\]";
        }
        IJ.doCommand(arg);
    }

    void getDimensions() {
        Variable width = this.getFirstVariable();
        Variable height = this.getNextVariable();
        Variable channels = this.getNextVariable();
        Variable slices = this.getNextVariable();
        Variable frames = this.getLastVariable();
        ImagePlus imp = this.getImage();
        int[] dim = imp.getDimensions();
        width.setValue(dim[0]);
        height.setValue(dim[1]);
        channels.setValue(dim[2]);
        slices.setValue(dim[3]);
        frames.setValue(dim[4]);
    }
}

