/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.IllegalFormatException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;

public class BeanPropertyGenerator {
    int indentLevel = 4;
    PrintStream out;
    String name;
    Properties prop;
    String _package;
    String _packagePath;
    String color16;
    String color32;

    public BeanPropertyGenerator(InputStream inputStream, PrintStream printStream) throws IOException {
        int n = 0;
        this.out = printStream;
        this.prop = new Properties();
        this.prop.load(inputStream);
        this.name = this.prop.getProperty("name").trim();
        this._package = this.prop.getProperty("package").trim();
        this._packagePath = this._package.replace('.', '/');
        this.color16 = this.prop.getProperty("ICON_COLOR_16x16");
        this.color32 = this.prop.getProperty("ICON_COLOR_32x32");
        this.generateBeanHeader();
        if (this.color16 != null) {
            this.generateIconArray(this.color16, 16, 16);
        }
        if (this.color32 != null) {
            this.generateIconArray(this.color32, 32, 32);
        }
        this.generateConstructor();
        ++n;
        if (!"".equals(this.prop.getProperty("events", "").trim())) {
            this.generateEventSetDescriptor(n, new StringTokenizer(this.prop.getProperty("events").trim(), ","));
        }
        if (!"".equals(this.prop.getProperty("properties", "").trim())) {
            this.generatePropertyDescriptor(n, new StringTokenizer(this.prop.getProperty("properties").trim(), ","));
        }
        this.generateIcon(n);
        this.generateAdditionalBeanInfo(n);
        this.generateBeanFooter(--n);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(int n) {
        this.indentLevel = n;
    }

    int generateBeanHeader() {
        String string = this.name + "BeanInfo";
        this.out.println("// This class is autogenerated by the BeanPropertyGenerator");
        this.out.println("// Do not edit");
        this.out.println("// See " + string + ".info");
        this.out.println("");
        this.out.println("package " + this._package + ";");
        this.out.println();
        this.out.println("import java.beans.*;");
        this.out.println("import java.awt.image.BufferedImage;");
        this.out.println("");
        this.out.println("public class " + string + " extends SimpleBeanInfo {");
        this.out.println("");
        this.out.println("  private BufferedImage icon16x16 = null;");
        this.out.println("  private BufferedImage icon32x32 = null;");
        this.out.println("");
        return 1;
    }

    int generateConstructor() {
        String string = this.name + "BeanInfo";
        this.out.println("    public " + string + "() {");
        this.out.println("");
        if (this.color16 != null) {
            this.out.println("      icon16x16 = new BufferedImage(16,16,BufferedImage.TYPE_INT_ARGB);");
            this.out.println("      icon16x16.setRGB(0,0,16,16,icon16x16_data,0,16);");
        }
        if (this.color32 != null) {
            this.out.println("      icon32x32 = new BufferedImage(32,32,BufferedImage.TYPE_INT_ARGB);");
            this.out.println("      icon32x32.setRGB(0,0,32,32,icon32x32_data,0,32);");
        }
        this.out.println("");
        this.out.println("    }");
        return 1;
    }

    int generateIconArray(String string, int n, int n2) throws IOException {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(new File(string));
        }
        catch (IOException iOException) {
            System.err.println("Failed to read " + string);
            throw iOException;
        }
        if (bufferedImage.getWidth() != n) {
            throw new IOException(string + ":Invalid width dimension (must be " + n + ")");
        }
        if (bufferedImage.getHeight() != n2) {
            throw new IOException(string + ":Invalid height dimension (must be " + n2 + ")");
        }
        int n3 = n * n2;
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        String string2 = "icon" + n + "x" + n2 + "_data";
        this.out.print("  private int[] " + string2 + " = new int[]{");
        for (int i = 0; i < n3; ++i) {
            if (i % 8 == 0) {
                this.out.println("");
                this.out.print("    ");
            }
            this.out.print("0x" + this.format("%X", nArray[i]));
            if (i >= n3 - 1) continue;
            this.out.print(",");
        }
        this.out.println("};");
        this.out.println("");
        return 1;
    }

    int generateBeanFooter(int n) {
        this.out.print(this.generatePad(n));
        this.out.println("}");
        return 0;
    }

    String generatePad(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n * this.indentLevel; i >= 0; --i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    void generateHeader(String string, String string2, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(this.generatePad(n));
        stringBuffer.append("public ");
        stringBuffer.append(string);
        stringBuffer.append("[] get");
        stringBuffer.append(string2);
        stringBuffer.append("() {");
        this.out.println(stringBuffer);
        this.out.println("");
        if (bl) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.generatePad(++n));
            stringBuffer.append("try {");
            this.out.println(stringBuffer);
        }
    }

    void generateHeader(String string, int n) {
        this.generateHeader(string, string + "s", n, true);
    }

    void generateHeader(String string, int n, boolean bl) {
        this.generateHeader(string, string + "s", n, bl);
    }

    void generateFooter(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(this.generatePad(--n));
        stringBuffer.append("} catch (Exception e) {");
        this.out.println(stringBuffer);
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(this.generatePad(++n));
        stringBuffer.append("System.err.println(\"" + this.prop.getProperty("name").trim() + "\" + \":\");\n");
        stringBuffer.append(this.generatePad(n));
        stringBuffer.append("System.err.println(e);");
        this.out.println(stringBuffer);
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(this.generatePad(--n));
        stringBuffer.append("}");
        this.out.println(stringBuffer);
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(this.generatePad(n));
        stringBuffer.append("return null;");
        this.out.println(stringBuffer);
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(this.generatePad(--n));
        stringBuffer.append("}");
        this.out.println(stringBuffer);
        this.out.println();
        this.out.println();
    }

    void generateTry(int n) {
        this.printPad(n, "try {");
    }

    void generateCatch(int n, String string) {
        this.out.print(this.generatePad(--n));
        this.out.println("} catch (" + string + ") {");
    }

    void printPad(int n, String string) {
        this.out.print(this.generatePad(n));
        this.out.println(string);
    }

    void generateAdditionalBeanInfo(int n) {
        StringBuffer stringBuffer = new StringBuffer("return new BeanInfo[] { sbi };");
        this.generateHeader("BeanInfo", "AdditionalBeanInfo", n, true);
        ++n;
        this.printPad(++n, "Class s = " + this.getName() + ".class.getSuperclass();");
        this.printPad(++n, "BeanInfo sbi = Introspector.getBeanInfo(s);");
        this.printPad(n, stringBuffer.toString());
        this.generateCatch(--n, "IntrospectionException e");
        this.printPad(n, "System.out.println(e);");
        this.printPad(n, "return null;");
        this.printPad(--n, "}");
        this.printPad(--n, "}");
        this.out.println();
    }

    void generatePropertyDescriptor(int n, StringTokenizer stringTokenizer) {
        this.generateHeader("PropertyDescriptor", n, false);
        ++n;
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().trim());
        }
        this.printPad(n, "PropertyDescriptor [] propdesc = new PropertyDescriptor[" + vector.size() + "];");
        for (int i = 0; i < vector.size(); ++i) {
            this.generateTry(n++);
            String string = (String)vector.get(i);
            this.printPad(n, "propdesc[" + i + "] = new PropertyDescriptor(\"" + string + "\", " + this.name + ".class);");
            this.generateCatch(n, "Exception e");
            this.printPad(n, "System.out.println(\"\\n" + string + " not supported (please verify your code)\");");
            this.printPad(--n, "}");
        }
        this.printPad(n, "return propdesc;");
        this.printPad(--n, "}");
        this.out.println();
    }

    void generateEventSetDescriptor(int n, StringTokenizer stringTokenizer) {
        this.generateHeader("EventSetDescriptor", n);
        ++n;
        StringBuffer stringBuffer = new StringBuffer("return new EventSetDescriptor [] { ");
        while (stringTokenizer.hasMoreTokens()) {
            this.out.print(this.generatePad(++n));
            String string = stringTokenizer.nextToken().trim();
            stringBuffer.append(string);
            stringBuffer.append(", ");
            String string2 = this.prop.getProperty(string + ".listenerType").trim();
            String string3 = this.prop.getProperty(string + ".listenerMethodName").trim();
            String string4 = this.prop.getProperty(string + ".displayName").trim();
            this.out.print("EventSetDescriptor ");
            this.out.print(string);
            this.out.print(" = new EventSetDescriptor(");
            this.out.print(this.name);
            this.out.print(".class, \"");
            this.out.print(string);
            this.out.print("\", ");
            this.out.print(string2);
            this.out.print(".class, \"");
            this.out.print(string3);
            this.out.println("\");");
            this.out.print(string);
            this.out.print(".setDisplayName(\"");
            this.out.print(string4);
            this.out.println("\");");
        }
        stringBuffer.append(" };");
        this.out.println(stringBuffer);
        this.generateFooter("EventSetDescriptor", --n);
    }

    void generateIcon(int n) {
        if (this.color16 == null && this.color32 == null) {
            return;
        }
        this.out.print(this.generatePad(n));
        this.out.println("public java.awt.Image getIcon(int icon) {\n");
        ++n;
        if (this.color16 != null) {
            this.generateSingleIcon("icon16x16", "ICON_COLOR_16x16", n);
        }
        if (this.color32 != null) {
            this.generateSingleIcon("icon32x32", "ICON_COLOR_32x32", n);
        }
        this.out.print(this.generatePad(n));
        this.out.println("return null;");
        this.out.print(this.generatePad(--n));
        this.out.println("}");
        this.out.println();
    }

    void generateSingleIcon(String string, String string2, int n) {
        this.out.print(this.generatePad(n));
        this.out.println("if (icon == BeanInfo." + string2 + ") {");
        this.out.print(this.generatePad(++n));
        this.out.println("return " + string + ";");
        this.out.print(this.generatePad(--n));
        this.out.println("}");
    }

    private String format(String string, int n) {
        try {
            return String.format(string, n);
        }
        catch (IllegalFormatException illegalFormatException) {
            System.out.println("BeanPropertyGenerator.java: Warning, " + illegalFormatException.getMessage());
            return Integer.toHexString(n);
        }
    }

    private static String makeInfoName(String string) throws IOException {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            throw new IOException("Invalid filename " + string);
        }
        return string.substring(0, n) + ".info";
    }

    public static void main(String[] stringArray) {
        String string = "";
        if (stringArray.length == 0) {
            System.exit(0);
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                string = BeanPropertyGenerator.makeInfoName(stringArray[i]);
                new BeanPropertyGenerator(new FileInputStream(string), new PrintStream(new FileOutputStream(string2)));
            }
        }
        catch (IOException iOException) {
            System.err.println("BeanPropertyGenerator failed : " + iOException.getMessage());
            System.err.println(" Hint: check " + System.getProperty("user.dir") + "/" + string);
            System.exit(1);
        }
    }
}

