/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.StringSpectrumHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StringSpectrum
extends AAttribute
implements IStringSpectrum {
    StringSpectrumHelper stringSpectHelper = new StringSpectrumHelper(this);
    String[] spectrumValue = null;
    String[] spectrumSetPointValue = null;

    @Override
    public void setStringSpectrumValue(String[] stringArray) {
        try {
            this.stringSpectHelper.insert(stringArray);
            this.writeAtt();
            this.refresh();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    @Override
    public String[] getStringSpectrumValue() {
        return this.spectrumValue;
    }

    @Override
    public String[] getStringSpectrumSetPoint() {
        return this.spectrumSetPointValue;
    }

    @Override
    public void addListener(IStringSpectrumListener iStringSpectrumListener) {
        this.stringSpectHelper.addStringSpectrumListener(iStringSpectrumListener);
        this.addStateListener(iStringSpectrumListener);
    }

    @Override
    public void removeListener(IStringSpectrumListener iStringSpectrumListener) {
        this.stringSpectHelper.removeStringSpectrumListener(iStringSpectrumListener);
        this.removeStateListener(iStringSpectrumListener);
    }

    @Override
    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        ++this.refreshCount;
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                this.spectrumValue = this.stringSpectHelper.getStringSpectrumValue(deviceAttribute);
                this.spectrumSetPointValue = this.stringSpectHelper.getStringSpectrumSetPoint(deviceAttribute);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("StringSpectrum.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringSpectrum.refresh()------------------------------------------------");
        }
    }

    @Override
    public void dispatch(DeviceAttribute deviceAttribute) {
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.stringSpectHelper.getStringSpectrumValue(deviceAttribute);
                this.spectrumSetPointValue = this.stringSpectHelper.getStringSpectrumSetPoint(deviceAttribute);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("StringSpectrum.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringSpectrum.dispatch()------------------------------------------------");
        }
    }

    @Override
    public void dispatchError(DevFailed devFailed) {
        this.spectrumValue = null;
        this.spectrumSetPointValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        this.eventType = tangoPeriodicEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "StringSpectrum.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "StringSpectrum.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("StringSpectrum.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringSpectrum.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.stringSpectHelper.getStringSpectrumValue(deviceAttribute);
                this.spectrumSetPointValue = this.stringSpectHelper.getStringSpectrumSetPoint(deviceAttribute);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("StringSpectrum.periodic.extractStringArray() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringSpectrum.periodic.extractStringArray()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        this.eventType = tangoChangeEvent.isZmqEvent() ? 2 : 1;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "StringSpectrum.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "StringSpectrum.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            this.spectrumValue = null;
            this.spectrumSetPointValue = null;
            System.out.println("StringSpectrum.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringSpectrum.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.stringSpectHelper.getStringSpectrumValue(deviceAttribute);
                this.spectrumSetPointValue = this.stringSpectHelper.getStringSpectrumSetPoint(deviceAttribute);
                this.fireValueChanged(this.spectrumValue);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                this.spectrumSetPointValue = null;
                System.out.println("StringSpectrum.change.extractStringArray() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringSpectrum.change.extractStringArray()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    @Override
    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String[] stringArray) {
        this.propChanges.fireStringSpectrumEvent(this, stringArray, this.timeStamp);
    }

    @Override
    public String getVersion() {
        return "$Id: StringSpectrum.java 28694 2015-11-09 16:19:57Z poncet $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

